% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods_peakPantheRAnnotation.R
\docType{methods}
\name{resetAnnotation,peakPantheRAnnotation-method}
\alias{resetAnnotation,peakPantheRAnnotation-method}
\alias{resetAnnotation}
\title{Reset a peakPantheRAnnotation and alter samples and compounds information
Reset a peakPantheRAnnotation (remove results and set \code{isAnnotated=FALSE}). If a different number of samples (\code{spectraPaths}) or compounds (\code{targetFeatTable}) are passed, the object will be initialised to the new size. For input values left as NULL, the slots (\code{filepath} (from \code{spectraPaths}), \code{ROI}, \code{cpdID}, \code{cpdName} (from \code{targetFeatTable}), \code{uROI}, \code{FIR}, \code{cpdMetadata}, \code{spectraMetadata}, \code{uROIExist}, \code{useUROI} and \code{useFIR}) will be filled with values from \code{previousAnnotation}.}
\usage{
\S4method{resetAnnotation}{peakPantheRAnnotation}(previousAnnotation,
  spectraPaths = NULL, targetFeatTable = NULL, uROI = NULL, FIR = NULL,
  cpdMetadata = NULL, spectraMetadata = NULL, uROIExist = NULL,
  useUROI = NULL, useFIR = NULL, verbose = TRUE, ...)
}
\arguments{
\item{previousAnnotation}{(peakPantheRAnnotation) object to reset}

\item{spectraPaths}{NULL or a character vector of spectra file paths, to set samples to process}

\item{targetFeatTable}{NULL or a \code{\link{data.frame}} of compounds to target as rows and parameters as columns: \code{cpdID} (str), \code{cpdName} (str), \code{rtMin} (float in seconds), \code{rt} (float in seconds, or \emph{NA}), \code{rtMax} (float in seconds), \code{mzMin} (float), \code{mz} (float or \emph{NA}), \code{mzMax} (float). Set compounds to target.}

\item{uROI}{NULL or a data.frame of updated Regions Of Interest (uROI) with compounds as row and uROI parameters as columns: \code{rtMin} (float in seconds), \code{rt} (float in seconds, or \emph{NA}), \code{rtMax} (float in seconds), \code{mzMin} (float), \code{mz} (float or \emph{NA}), \code{mzMax} (float).}

\item{FIR}{NULL or a data.frame of Fallback Integration Regions (FIR) with compounds as row and FIR parameters as columns: \code{rtMin} (float in seconds), \code{rtMax} (float in seconds), \code{mzMin} (float), \code{mzMax} (float).}

\item{cpdMetadata}{NULL or a data.frame of compound metadata, with compounds as row and metadata as columns}

\item{spectraMetadata}{NULL or a data.frame of sample metadata, with samples as row and metadata as columns}

\item{uROIExist}{NULL or a logical stating if uROI have been set}

\item{useUROI}{NULL or a logical stating if uROI are to be used}

\item{useFIR}{NULL or a logical stating if FIR are to be used}

\item{verbose}{(bool) If TRUE message progress}

\item{...}{Additional slots and values to set when resetting the object (\code{cpdID}, \code{cpdName}, \code{ROI}, \code{filepath}, \code{TIC}, \code{acquisitionTime}, \code{peakTables}, \code{dataPoints}, \code{peakFit})}
}
\value{
(peakPantheRAnnotation) object reset with previous results removed and slots updated
}
\description{
Reset a peakPantheRAnnotation and alter samples and compounds information
Reset a peakPantheRAnnotation (remove results and set \code{isAnnotated=FALSE}). If a different number of samples (\code{spectraPaths}) or compounds (\code{targetFeatTable}) are passed, the object will be initialised to the new size. For input values left as NULL, the slots (\code{filepath} (from \code{spectraPaths}), \code{ROI}, \code{cpdID}, \code{cpdName} (from \code{targetFeatTable}), \code{uROI}, \code{FIR}, \code{cpdMetadata}, \code{spectraMetadata}, \code{uROIExist}, \code{useUROI} and \code{useFIR}) will be filled with values from \code{previousAnnotation}.
}
