% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/curveFit_utils.R
\name{fitCurve}
\alias{fitCurve}
\title{Curve fitting using minpack.lm}
\usage{
fitCurve(x, y, curveModel = "skewedGaussian", params = "guess")
}
\arguments{
\item{x}{(numeric) x values (e.g. retention time)}

\item{y}{(numeric) y observed values (e.g. spectra intensity)}

\item{curveModel}{(str) name of the curve model to fit (currently \code{skewedGaussian})}

\item{params}{(list or str) either 'guess' for automated parametrisation or list of initial parameters ($init_params), lower parameter bounds ($lower_bounds) and upper parameter bounds ($upper_bounds)}
}
\value{
A 'peakPantheR_curveFit': a list of fitted curve parameters, \code{fitStatus} from \code{nls.lm$info} and curve shape name \code{curveModel}. \code{fitStatus=0} unsuccessful completion: improper input parameters, \code{fitStatus=1} successful completion: first convergence test is successful, \code{fitStatus=2} successful completion: second convergence test is successful, \code{fitStatus=3} successful completion: both convergence test are successful, \code{fitStatus=4} questionable completion: third convergence test is successful but should be carefully examined (maximizers and saddle points might satisfy), \code{fitStatus=5} unsuccessful completion: excessive number of function evaluations/iterations
}
\description{
Fit different curve models using minpack. Fitting parameters can be passed or guessed.
}
\examples{
\dontrun{
## x is retention time, y corresponding intensity
input_x  <- c(3362.102, 3363.667, 3365.232, 3366.797, 3368.362, 3369.927, 3371.492, 3373.057,
             3374.622, 3376.187, 3377.752, 3379.317, 3380.882, 3382.447, 3384.012, 3385.577,
             3387.142, 3388.707, 3390.272, 3391.837, 3393.402, 3394.966, 3396.531, 3398.096,
             3399.661, 3401.226, 3402.791, 3404.356, 3405.921, 3407.486, 3409.051)
input_y  <- c(51048, 81568, 138288, 233920, 376448, 557288, 753216, 938048, 1091840, 1196992,
              1261056, 1308992, 1362752, 1406592, 1431360, 1432896, 1407808, 1345344, 1268480,
              1198592, 1126848, 1036544, 937600, 849792, 771456, 692416, 614528, 546088, 492752,
              446464, 400632)

## Fit
fitted_curve <- fitCurve(input_x, input_y, curveModel='skewedGaussian', params='guess')

## Returns the optimal fitting parameters
fitted_curve
#
# $amplitude
# [1] 275371.1
# 
# $center
# [1] 3382.577
# 
# $sigma
# [1] 0.07904697
# 
# $gamma
# [1] 0.001147647
# 
# $fitStatus
# [1] 2
# 
# $curveModel
# [1] "skewedGaussian"
#
# attr(,"class")
# [1] "peakPantheR_curveFit"
}
}
