% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{ucdp_acd}
\alias{ucdp_acd}
\title{UCDP Armed Conflict Data (ACD) (v. 20.1)}
\format{
A data frame with 4164 observations on the following 15 variables.
\describe{
\item{\code{conflict_id}}{a conflict identifier, not to be confused with an episode identifier (which I don't think UCDP offers)}
\item{\code{year}}{a numeric vector for the year}
\item{\code{gwno_a}}{the Gleditsch-Ward state code for the state on side A of the armed conflict}
\item{\code{gwno_a_2nd}}{the Gleditsch-Ward state code for the state that actively supported side A of the armed conflict with the use of troops}
\item{\code{gwno_b}}{the Gleditsch-Ward state code for the actor on side B of the armed conflict}
\item{\code{gwno_b_2nd}}{the Gleditsch-Ward state code for the state that actively supported side B of the armed conflict with the use of troops}
\item{\code{incompatibility}}{a character vector for the main conflict issue ("territory", "government", "both")}
\item{\code{intensity_level}}{a numeric vector for the intensity level in the calendar year (1 = minor (25-999 deaths), 2 = war (>1,000 deaths))}
\item{\code{type_of_conflict}}{a character vector for the type of conflict ("extrasystemic", "interstate", "intrastate", "II"). "II" is a simple abbreviation of "internationalized intrastate"}
\item{\code{start_date}}{a date of the first battle-related death in the conflict, not to be confused with the first battle-related death of the episode}
\item{\code{start_prec}}{the level of precision for \code{start_date}}
\item{\code{start_date2}}{a date of the first battle-related death in the episode, not to be confused with the first battle-related death of the conflict}
\item{\code{start_prec2}}{the level of precision for \code{start_date2}}
\item{\code{ep_end}}{a dummy variable for whether the conflict episode ended in the calendar year of observation}
\item{\code{ep_end_date}}{the episode end date, if applicable}
}
}
\usage{
ucdp_acd
}
\description{
These are (kind of) dyadic, but mostly state-level data, used internally for doing stuff with the UCDP armed conflict data
}
\details{
The \code{data-raw} directory on the project's Github will show how I processed the multiple strings for when there are multiple states on a given side.
}
\references{
Gleditsch, Nils Petter; Peter Wallensteen, Mikael Eriksson, Margareta Sollenberg & Havard Strand (2002)
Armed Conflict 1946–2001: A New Dataset. \emph{Journal of Peace Research} 39(5): 615–637.

Pettersson, Therese; Stina Hogbladh & Magnus Oberg (2019). Organized violence, 1989-2018 and peace
agreements. Journal of Peace Research 56(4): 589-603.
}
\keyword{datasets}
