% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_leaderyears.R
\name{create_leaderyears}
\alias{create_leaderyears}
\title{Create leader-years from leader data}
\usage{
create_leaderyears(system = "archigos")
}
\arguments{
\item{system}{a leader system with which to create leader-years. Right now, only "archigos" is supported.}
}
\value{
\code{create_leaderyears()} takes leader-level data available in \pkg{peacesciencer}
and returns a leader-year-level data frame.
}
\description{
\code{create_leaderyears()} allows you to generate leader-year data from
leader-level data provided in \pkg{peacesciencer}
}
\details{
\code{create_leaderyears()}, as of writing, only supports the Archigos data set of leaders. Importantly:
the absence of much leader-level covariates (of which I am aware) means, for now, the data that are returned are
treated as observationally equivalent to state-year data. Users should be careful here, but it does mean the data
will work with other functions in \pkg{peacesciencer} that have support for state-year data (e.g. \code{add_nmc()},
\code{add_rugged_terrain()}). This is declared in the attribute field.
}
\examples{
\donttest{
create_leaderyears()
}

}
\references{
Goemans, Henk E., Kristian Skrede Gleditsch, and Giacomo Chiozza. 2009. "Introducing Archigos: A Dataset of Political Leaders"
\emph{Journal of Peace Research} 46(2): 269--83.
}
\author{
Steven V. Miller
}
