% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pdqr-package.R
\docType{package}
\name{pdqr-package}
\alias{pdqr}
\alias{pdqr-package}
\title{pdqr: Work with Custom Distribution Functions}
\description{
Create, transform, and summarize custom random
    variables with distribution functions (analogues of 'p*()', 'd*()',
    'q*()', and 'r*()' functions from base R). Two types of distributions
    are supported: "discrete" (random variable has finite number of output
    values) and "continuous" (infinite number of values in the form of
    continuous random variable). Functions for distribution
    transformations and summaries are available. Implemented approaches
    often emphasize approximate and numerical solutions: all distributions
    assume finite support and finite values of density function; some
    methods implemented with simulation techniques.
}
\details{
Excerpt of important documentation:
\itemize{
\item README and vignettes provide overview of package functionality.
\item Documentation of \link[=meta_all]{meta_*()} functions describes implementation
details of pdqr-functions.
\itemize{
\item Documentation of \link[=methods-print]{print()} and \link[=methods-plot]{plot()}
methods describes how you can interactively explore properties of
pdqr-functions.
}
\item Documentation of \link[=new_p]{new_*()} functions describes the process of
creating pdqr-functions.
\item Documentation of \link[=as_p]{as_*()} functions describes the process of
updating class of pdqr-functions.
\item Documentation of \code{form_*()} functions describes how different
transformation functions work. Important pages are for \code{\link[=form_trans]{form_trans()}} and
\link[=methods-group-generic]{Pdqr methods for S3 group generic functions}.
\item Documentation of \code{summ_*()} functions describes how different summary
functions work. A good place to start is \code{\link[=summ_center]{summ_center()}}.
\item Documentation of \code{\link[=region]{region_*()}} functions describes functionality
to work with regions: data frames defining subset of one dimensional real
line.
}
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/echasnovski/pdqr}
  \item \url{https://echasnovski.github.io/pdqr}
  \item Report bugs at \url{https://github.com/echasnovski/pdqr/issues}
}

}
\author{
\strong{Maintainer}: Evgeni Chasnovski \email{evgeni.chasnovski@gmail.com}

}
