% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pdfbox.R
\name{read_chars}
\alias{read_chars}
\title{Read Characters from PDF}
\usage{
read_chars(
  file,
  pages = integer(),
  adjust = TRUE,
  size_pt = FALSE,
  digits = 2L,
  password = "",
  max_memory = -1L,
  temp_dir = tempdir()
)
}
\arguments{
\item{file}{path to PDF file (is auto-expanded with [path.expand()])}

\item{pages}{an \code{integer} vector giving the pages which should be extracted 
(default is \code{integer()}).}

\item{adjust}{a \code{logical} if \code{TRUE} the variables \code{"x0"}, \code{"y0"},
\code{"height"} and \code{"width"} are direction adjusted.}

\item{size_pt}{a \code{logical} giving if the font size should be returned in \code{pt}.}

\item{digits}{an \code{integer} (of length 1) giving to how many digits the
\code{double} variables (e.g. \code{"x0"}, \code{"y1"}) should be rounded
(the default is \code{2L} and this should be enough).}

\item{password}{a string providing the password of the file.}

\item{max_memory}{an integer giving the maximum number of main-memory in MB 
to be used by \pkg{pdfbox}. The default is \code{-1L} which means 
there is no limit. If a limit is set \pkg{pdfbox} will try to stay
below by performing out of memory computations.
Since the memory of the \code{Java} virtual machine
is already limited it is recommended to choose the value of \code{max\_memory}
below the memory limit of the virtual machine (\code{options("java.parameters")}).
If the memory of the \code{Java} virtual machine is big enough 
this options is never needed.}

\item{temp_dir}{a character string giving the path to a temporary directory.}
}
\value{
Returns a object of class \code{"pdf_document"}.
}
\description{
Extract all the characters of a PDF file with information about the position,
             font, rotation, ....
}
\examples{
pdf_file <- system.file("pdfs/cars.pdf", package = "pdfboxr")
pdf <- read_chars(pdf_file, 2L)
pdf
}
