% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{Expm}
\alias{Expm}
\title{Exponential map}
\usage{
Expm(P, H)
}
\arguments{
\item{P}{a Hermitian positive definite matrix.}

\item{H}{a Hermitian matrix (of equal dimension as \code{P}).}
}
\description{
\code{Expm(P, H)} computes the projection of a Hermitian matrix \code{H} from the tangent space at a Hermitian
PD matrix \code{P} to the Riemannian manifold of Hermitian PD matrices via the
exponential map as in (Pennec, 2006). This is the unique inverse of the logarithmic map \code{\link{Logm}}.
}
\examples{
 H <- matrix(complex(real = rnorm(9), imaginary = rnorm(9)), nrow = 3)
 diag(H) <- rnorm(3)
 H[lower.tri(H)] <- t(Conj(H))[lower.tri(H)]
 p <- matrix(complex(real = rnorm(9), imaginary = rnorm(9)), nrow = 3)
 P <- t(Conj(p)) \%*\% p
 Expm(P, H)

}
\references{
Pennec, X. (2006). Intrinsic statistics on Riemannian manifolds: Basic tools for geometric
measurements. \emph{Journal of Mathematical Imaging and Vision} 25(1), 127-154.
}
\seealso{
\code{\link{Logm}}
}
