% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eco_micro.R
\name{nst}
\alias{nst}
\title{Calculate NST for each group}
\usage{
nst(otutab, group_df, threads = 1, file = NULL, rep = 20, save = FALSE)
}
\arguments{
\item{otutab}{an otutab data.frame, samples are columns, taxs are rows.}

\item{group_df}{a dataframe with rowname and one group column}

\item{threads}{default:4}

\item{file}{filename to save}

\item{rep}{repeat numbers: suggest 999}

\item{save}{save the file}
}
\value{
a b_dist object, dis is MSTij
}
\description{
Calculate NST for each group
}
\examples{
\donttest{
if (requireNamespace("NST")) {
  library(ggplot2)
  data(otutab, package = "pcutils")
  nst(otutab, metadata["Group"]) -> nst_res
  plot(nst_res, c_group = "intra") + geom_hline(yintercept = 0.5, lty = 2) + ylab("NST")
}
}
}
\references{
Ning, D., Deng, Y., Tiedje, J. M. & Zhou, J. (2019) A general framework for quantitatively assessing ecological stochasticity. Proceedings of the National Academy of Sciences 116, 16892–16898.
}
