% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/b_analyse.R
\name{as.b_dist}
\alias{as.b_dist}
\alias{plot.dist}
\alias{plot.b_dist}
\title{Transfer dist to b_dist}
\usage{
as.b_dist(dist, group_df = NULL)

\method{plot}{dist}(x, group_df = NULL, ...)

\method{plot}{b_dist}(x, mode = 1, c_group = "inter", ...)
}
\arguments{
\item{dist}{a dist object}

\item{group_df}{a dataframe with rowname same to dist and one group column}

\item{x}{a b_dist}

\item{...}{additional}

\item{mode}{1~3}

\item{c_group}{"inter" or "intra" or both to plot}
}
\value{
a b_dist with annotation by group

a pheatmap

a ggplot or pheatmap
}
\description{
Transfer dist to b_dist

Plot dist

Plot b_dist
}
\examples{
data(otutab, package = "pcutils")
mat_dist(otutab) \%>\% as.b_dist(., group_df = metadata["Group"]) -> aa
plot(aa)
plot(aa, mode = 2)
}
