% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getParameter.r
\name{getParameter}
\alias{getParameter}
\title{Get Kit Parameters}
\usage{
getParameter(kit = NULL, what = NA, method = NA, show.messages = FALSE,
  .kit.param = NULL, debug = FALSE)
}
\arguments{
\item{kit}{string or integer specifying the kit.}

\item{what}{string to specify which information to return. Default is 'NA' which return all info.
Not case sensitive.}

\item{method}{string to specify which method to return. Default is 'NA' which return all info.
Not case sensitive.}

\item{show.messages}{logical, default TRUE for printing messages to the R promt.}

\item{.kit.param}{data frame, run function on a data frame instead of the parameters.txt file.}

\item{debug}{logical indicating printing debug information.}
}
\value{
vector of data frame with kit information.
}
\description{
Provides parameters for simulation for different STR kits and methods.
}
\details{
The function returns various information for kit and parameters specified
in parameters.txt.
}
\examples{

# Returns vector of available kits.
getParameter()

# Returns vector of all methods.
getParameter(what="methods")

# Returns methods for specified kit.
getParameter(kit="SGMPlus", what="methods")

# Returns vector of available options.
getParameter(what="options")

# Returns vector of markers for specified kit.
getParameter(kit="SGMPlus", what="Marker")

# Returns data frame of all information for specified kit and method.
getParameter(kit="SGMPlus", method = "Default")
}

