% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/posthocfuns.R
\name{concordScore.pcoxtime}
\alias{concordScore.pcoxtime}
\alias{concordScore}
\title{Compute the concordance statistic for the pcoxtime model}
\usage{
\method{concordScore}{pcoxtime}(fit, newdata = NULL, stats = FALSE)
}
\arguments{
\item{fit}{fitted \code{\link[pcoxtime]{pcoxtime}}.}

\item{newdata}{optional data frame containing the variables appearing on the right hand side of \code{\link[pcoxtime]{pcoxtime}} formula.}

\item{stats}{logical. If \code{TRUE} all the related concordance statistics are returned.}
}
\value{
an object containing the concordance, followed by the number of pairs that agree, disagree, are tied, and are not comparable.
}
\description{
The function computes the agreement between the observed response and the predictor.
}
\details{
Computes Harrell's C index for predictions for \code{\link[pcoxtime]{pcoxtime}} object and takes into account censoring. See \code{\link[survival]{survConcordance}}.
}
\examples{

data(veteran, package="survival")
# Penalized
lam <- 0.1
alp <- 0.5
pfit1 <- pcoxtime(Surv(time, status) ~ factor(trt) + karno + diagtime + age + prior
	, data = veteran
	, lambda = lam 
	, alpha = alp
)
c1 <- concordScore(pfit1)
c1

# Unpenalized
lam <- 0
alp <- 1
pfit2 <- pcoxtime(Surv(time, status) ~ factor(trt) + karno + diagtime + age + prior
	, data = veteran
	, lambda = lam 
	, alpha = alp
)
c2 <- concordScore(pfit2)
c2

}
