% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/posthocfuns.R
\name{predictSurvProb.pcoxtime}
\alias{predictSurvProb.pcoxtime}
\alias{predictSurvProb}
\title{Predict survival probabilities at various time points}
\usage{
\method{predictSurvProb}{pcoxtime}(object, newdata, times, ...)
}
\arguments{
\item{object}{fitted \code{\link[pcoxtime]{pcoxtime}}.}

\item{newdata}{a data frame containing the variables appearing on the right hand side of \code{\link[pcoxtime]{pcoxtime}} formula.}

\item{times}{a vector of times in the range of the response, at which to return the survival probabilities.}

\item{...}{for future implementations.}
}
\value{
a matrix of probabilities with as many rows as the rows of the \code{newdata} and as many columns as number of time points (\code{times}).
}
\description{
The function extracts the survival probability predictions from a \code{pcoxtime} model.
}
\examples{

if (packageVersion("survival")>="3.2.9") {
   data(cancer, package="survival")
} else {
   data(veteran, package="survival")
}
# Penalized
lam <- 0.1
alp <- 0.5
pfit1 <- pcoxtime(Surv(time, status) ~ factor(trt) + karno + diagtime + age + prior
	, data = veteran
	, lambda = lam 
	, alpha = alp
)
p1 <- predictSurvProb(pfit1, newdata = veteran[1:80,], times = 10)

# Unpenalized
lam <- 0
alp <- 1
pfit2 <- pcoxtime(Surv(time, status) ~ factor(trt) + karno + diagtime + age + prior
	, data = veteran
	, lambda = lam 
	, alpha = alp
)
p2 <- predictSurvProb(pfit2, newdata = veteran[1:80,], times = 10)
plot(p1, p2, xlim=c(0,1), ylim=c(0,1)
	, xlab = "Penalized predicted survival chance at 10"
	, ylab="Unpenalized predicted survival chance at 10"
)

}
