% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/C_p.R
\name{C_p}
\alias{C_p}
\title{\eqn{C_p}}
\usage{
C_p(sigma, lsl, usl, dl)
}
\arguments{
\item{sigma}{\code{numeric}.}

\item{lsl}{\code{numeric}.}

\item{usl}{\code{numeric}.}

\item{dl}{\code{numeric}. \eqn{L}, conventionally set to 6. Must be greater than
0.}
}
\value{
\code{double}.
}
\description{
\deqn{C_p = \frac{\text{USL} - \text{LSL}}{L \sigma}}

Only vectors of length 1 are recycled.

\code{NA}'s take precedence over \code{NaN}'s, e.g. \code{NaN + NA} will output \code{NA}.

Yields \code{NaN} if \code{sigma} equals 0.
}
\examples{
set.seed(1L)
data = rnorm(n = 30L, mean = 3., sd = 1.)
C_p(sigma = sd(data), lsl = 0., usl = 6., dl = 6.)
# [1] 1.08211

}
\references{
Montgomery, D. C. (2019). \emph{Introduction to statistical quality  control} (8th ed.). Wiley. ISBN: 978-1-119-39930-8
}
