% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCDFunctions.r
\name{cp2e.bastri}
\alias{cp2e.bastri}
\title{Projections of a point inside the basic triangle to its edges}
\usage{
cp2e.bastri(c1, c2, M)
}
\arguments{
\item{c1, c2}{Positive real numbers which constitute the vertex of the basic triangle
adjacent to the shorter edges; \eqn{c_1} must be in \eqn{[0,1/2]}, \eqn{c_2>0} and \eqn{(1-c_1)^2+c_2^2 \le 1}.}

\item{M}{A 2D point in Cartesian coordinates or a 3D point in barycentric coordinates
which serves as a center in the interior of the basic triangle.}
}
\value{
Three projection points (stacked row-wise) from a general center \eqn{M=(m_1,m_2)} in Cartesian coordinates
or \eqn{M=(\alpha,\beta,\gamma)} in barycentric coordinates in the interior of a basic triangle to the edges on
the extension of the lines joining \code{M} to the vertices;
row \eqn{i} is the projection  point into edge \eqn{i}, for \eqn{i=1,2,3}.
}
\description{
Returns the projections from a general center \eqn{M=(m_1,m_2)} in Cartesian coordinates or \eqn{M=(\alpha,\beta,\gamma)} in
barycentric coordinates in the interior of the basic triangle \eqn{T_b=T((0,0),(1,0),(c_1,c_2))}
to the edges on the extension of the lines joining \code{M} to the vertices (see the examples for an illustration).
In the basic triangle \eqn{T_b}, \eqn{c_1} is in \eqn{[0,1/2]}, \eqn{c_2>0} and \eqn{(1-c_1)^2+c_2^2 \le 1}.

Any given triangle can be mapped to the basic triangle by a combination of rigid body motions
(i.e., translation, rotation and reflection) and scaling, preserving uniformity of the points in the
original triangle. Hence basic triangle is useful for simulation studies under the uniformity hypothesis.

See also (\insertCite{ceyhan:Phd-thesis,ceyhan:comp-geo-2010;textual}{pcds}).
}
\examples{
c1<-.4; c2<-.6
A<-c(0,0); B<-c(1,0); C<-c(c1,c2);
Tb<-rbind(A,B,C);

M<-as.numeric(runif.bastri(1,c1,c2)$g)  #try also M<-c(.6,.2)

cp2e.bastri(c1,c2,M)

Ds<-cp2e.bastri(c1,c2,M)

Xlim<-range(Tb[,1])
Ylim<-range(Tb[,2])
xd<-Xlim[2]-Xlim[1]
yd<-Ylim[2]-Ylim[1]

if (dimension(M)==3) {M<-bary2cart(M,Tb)}
#need to run this when M is given in barycentric coordinates

plot(Tb,pch=".",xlab="",ylab="",axes=TRUE,
xlim=Xlim+xd*c(-.1,.1),ylim=Ylim+yd*c(-.05,.05))
polygon(Tb)
L<-rbind(M,M,M); R<-Ds
segments(L[,1], L[,2], R[,1], R[,2], lty=2)
L<-rbind(M,M,M); R<-Tb
segments(L[,1], L[,2], R[,1], R[,2], lty=3,col=2)

xc<-Tb[,1]+c(-.04,.05,.04)
yc<-Tb[,2]+c(.02,.02,.03)
txt.str<-c("rv=1","rv=2","rv=3")
text(xc,yc,txt.str)

txt<-rbind(M,Ds)
xc<-txt[,1]+c(-.02,.03,-.03,0)
yc<-txt[,2]+c(-.02,.02,.02,-.03)
txt.str<-c("M","D1","D2","D3")
text(xc,yc,txt.str)

cp2e.bastri(c1,c2,M)

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{cp2e.tri}} and \code{\link{cp2edges.nd}}
}
\author{
Elvan Ceyhan
}
