% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCDFunctions.r
\name{plotASregsTri}
\alias{plotASregsTri}
\title{The plot of the Arc Slice (AS) Proximity Regions for a 2D data set - one triangle case}
\usage{
plotASregsTri(
  Xp,
  tri,
  M = "CC",
  main = "",
  xlab = "",
  ylab = "",
  xlim = NULL,
  ylim = NULL,
  ...
)
}
\arguments{
\item{Xp}{A set of 2D points for which AS proximity regions are constructed}

\item{tri}{Three 2D points, stacked row-wise, each row representing a vertex of the triangle}

\item{M}{"CC" which stands for circumcenter of the triangle \code{tri} or a 2D point in Cartesian coordinates or a 3D point in
barycentric coordinates which serves as a center in the interior of the triangle \eqn{T_b};
default is \code{M}="CC" i.e. the circumcenter of \code{tri}}

\item{main}{An overall title for the plot (default="")}

\item{xlab, ylab}{Titles for the x and y axes, respectively (default="" for both).}

\item{xlim, ylim}{Numeric vectors of length 2, giving the x- and y-coordinate ranges (default=\code{NULL} for both)}

\item{\dots}{Additional \code{plot} parameters}
}
\value{
Plot of the AS proximity regions for points inside the triangle \code{tri} (and only the points outside \code{tri})
}
\description{
Plots the points in and outside of the triangle \code{tri} and also the AS proximity regions
for points in data set \code{Xp}.

AS proximity regions are defined with respect to the triangle \code{tri},
so AS proximity regions are defined only for points inside the triangle \code{tri} and
vertex regions are based on the center \code{M}="CC" for
circumcenter of \code{tri}; or \eqn{M=(m_1,m_2)} in Cartesian coordinates or \eqn{M=(\alpha,\beta,\gamma)} in barycentric
coordinates in the interior of the triangle \code{tri}; default is \code{M}="CC" the circumcenter of \code{tri}.

See also (\insertCite{ceyhan:Phd-thesis,ceyhan:comp-geo-2010,ceyhan:mcap2012;textual}{pcds}).
}
\examples{
A<-c(1,1); B<-c(2,0); C<-c(1.5,2);
Tr<-rbind(A,B,C);
n<-1

set.seed(1)
dat<-runif.tri(n,Tr)$g

M<-as.numeric(runif.tri(1,Tr)$g)  #try also  #M<-c(1.6,1.2);

dat<-matrix(dat,ncol=2)
Xlim<-range(Tr[,1],dat[,1])
Ylim<-range(Tr[,2],dat[,2])
xd<-Xlim[2]-Xlim[1]
yd<-Ylim[2]-Ylim[1]

plotASregsTri(dat,Tr,M,main="Proximity Regions for AS-PCD",
xlab="",ylab="",xlim=Xlim+xd*c(-.05,.05),ylim=Ylim+yd*c(-.05,.05))

plotASarcsTri(dat,Tr,main="arcs of AS-PCD", xlab="",ylab="",xlim=Xlim+c(-.05,.05),ylim=Ylim)

if (dimension(M)==3) {M<-bary2cart(M,Tr)}
#need to run this when M is given in barycentric coordinates

CC<-circ.cent.tri(Tr)
if (isTRUE(all.equal(M,CC)) || identical(M,"CC"))
{cent<-CC
D1<-(B+C)/2; D2<-(A+C)/2; D3<-(A+B)/2;
Ds<-rbind(D1,D2,D3)
cent.name<-"CC"
} else
{cent<-M
cent.name<-"M"
Ds<-cp2e.tri(Tr,M)
D1<-Ds[1,]; D2<-Ds[2,]; D3<-Ds[3,]
}

plotASregsTri(dat,Tr,M,main="Proximity Regions for AS-PCD",xlab="",ylab="")
L<-rbind(cent,cent,cent); R<-Ds
segments(L[,1], L[,2], R[,1], R[,2], lty=2)

txt<-rbind(Tr,cent,Ds)
xc<-txt[,1]+c(-.02,.03,.03,.03,.05,-0.03,-.01)
yc<-txt[,2]+c(.02,.02,.02,.07,.02,.05,-.06)
txt.str<-c("A","B","C",cent.name,"D1","D2","D3")
text(xc,yc,txt.str)

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{plotASregsMT}}, \code{\link{plotPEregsTri}}, \code{\link{plotPEregsMT}},
\code{\link{plotCSregsTri}}, and \code{\link{plotCSregsMT}}
}
