% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCDFunctions.r
\name{funsCartBary}
\alias{funsCartBary}
\alias{cart2bary}
\alias{bary2cart}
\title{Two functions: \code{cart2bary} and \code{bary2cart} ---

Converts of a point in Cartesian coordinates to Barycentric coordinates and vice versa.}
\usage{
cart2bary(P, tri)

bary2cart(P, tri)
}
\arguments{
\item{P}{A 2D point for \code{cart2bary}, and a vector of three numeric entries for \code{bary2cart}}

\item{tri}{Three 2D points, stacked row-wise, each row representing a vertex of the triangle}
}
\value{
cart2bary returns the barycentric coordinates of a given point \code{P}=\eqn{(x,y)} and
bary2cart returns the Cartesian coordinates of the point \code{P}=\eqn{(t_1,t_2,t_3)} (not necessarily normalized)
}
\description{
\code{cart2bary} converts Cartesian coordinates of a given point \code{P}=(x,y) to barycentric coordinates
(in the normalized form) with respect to the triangle \code{tri}=\eqn{(v_1,v_2,v_3)}
with vertex labeling done row-wise in \code{tri} (i.e., row \eqn{i} corresponds to vertex \eqn{v_i} for \eqn{i=1,2,3}).

\code{bary2cart} converts barycentric coordinates of the point \code{P}=\eqn{(t_1,t_2,t_3)} (not necessarily normalized) to
Cartesian coordinates according to the coordinates of the triangle, \code{tri}.
For information on barycentric coordinates, see (\insertCite{weisstein-barycentric;textual}{pcds}).
}
\examples{
#Examples for cart2bary
c1<-.4; c2<-.6
A<-c(0,0); B<-c(1,0); C<-c(c1,c2);
Tr<-rbind(A,B,C)

cart2bary(A,Tr)
cart2bary(c(.3,.2),Tr)
cart2bary(c(.4,.2),Tr)
cart2bary(c(.5,.2),Tr)
cart2bary(c(.6,.2),Tr)

P<-c(.8,.2)
round(cart2bary(P,Tr),2)

P<-c(.5,.61)
cart2bary(P,Tr)

CM<-(A+B+C)/3
cart2bary(CM,Tr)

A<-c(1,1); B<-c(2,0); C<-c(1.5,2);
Tr<-rbind(A,B,C);
cart2bary(c(1.4,1.2),Tr)

cart2bary(c(.8,.2),Tr)

cart2bary(c(1.5,1.61),Tr)

dat.fr<-data.frame(a=Tr)
cart2bary(c(.8,.2),dat.fr)

#Examples for bary2cart
c1<-.4; c2<-.6
A<-c(0,0); B<-c(1,0); C<-c(c1,c2);
Tr<-rbind(A,B,C)

bary2cart(c(.3,.2,.5),Tr)
bary2cart(c(.4,.2,.4),Tr)
bary2cart(c(.5,.2,.3),Tr)
bary2cart(c(6,2,4),Tr)

P<-c(.8,.2,.3)
bary2cart(P,Tr)

P<-c(-.5,.4,.2)
bary2cart(P,Tr)

CM<-(A+B+C)/3; CM
bary2cart(c(1,1,1),Tr)

A<-c(1,1); B<-c(2,0); C<-c(1.5,2);
Tr<-rbind(A,B,C);
bary2cart(c(1.4,1.2,1),Tr)

bary2cart(c(.8,.2,.6),Tr)

bary2cart(c(1,2,3),Tr)

dat.fr<-data.frame(a=Tr)
bary2cart(c(.8,.2,.3),dat.fr)

}
\references{
\insertAllCited{}
}
