% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCDFunctions.r
\name{IncMatASMT}
\alias{IncMatASMT}
\title{Incidence matrix for Arc Slice Proximity Catch Digraphs (AS-PCDs) - multiple triangle case}
\usage{
IncMatASMT(Xp, Yp, M = "CC")
}
\arguments{
\item{Xp}{A set of 2D points which constitute the vertices of the AS-PCD}

\item{Yp}{A set of 2D points which constitute the vertices of the Delaunay triangles}

\item{M}{"CC" which stands for circumcenter of each Delaunay triangle \code{tri} or 3D point in barycentric
coordinates which serves as a center in the interior of each Delaunay triangle;
default is \code{M}="CC" i.e. the circumcenter of each triangle}
}
\value{
Incidence matrix for the AS-PCD whose vertices are the 2D data set, \code{Xp},
and AS proximity regions are defined in the Delaunay triangles based on \code{Yp} points.
}
\description{
Returns the incidence matrix for the AS-PCD whose vertices are a given 2D numerical data set, \code{Xp},
in the convex hull of \code{Yp} which is partitioned by the Delaunay triangles based on \code{Yp} points.

AS proximity regions are defined with respect to the Delaunay triangles based on \code{Yp} points and vertex
regions are based on the center \code{M}="CC"
for circumcenter of each Delaunay triangle or \eqn{M=(\alpha,\beta,\gamma)} in barycentric coordinates in the
interior of each Delaunay triangle; default is \code{M}="CC" i.e. circumcenter of each triangle.
Loops are allowed, so the diagonal entries are all equal to 1.

See (\insertCite{ceyhan:Phd-thesis,ceyhan:comp-geo-2010,ceyhan:mcap2012;textual}{pcds}) for more on AS-PCDs.
Also see (\insertCite{okabe:2000,ceyhan:comp-geo-2010,sinclair:2016;textual}{pcds}) for more on Delaunay triangulation
and the corresponding algorithm.
}
\examples{
#nx is number of X points (target) and ny is number of Y points (nontarget)
nx<-20; ny<-4;  #try also nx<-40; ny<-10 or nx<-1000; ny<-10;

set.seed(1)
Xp<-cbind(runif(nx,0,1),runif(nx,0,1))
Yp<-cbind(runif(ny,0,1),runif(ny,0,1))

M<-"CC"  #try also M<-c(1,1,1)

IM<-IncMatASMT(Xp,Yp,M)
IM
dom.greedy(IM)  #try also dom.exact(IM)  #this might take a long time for large  nx

IM<-IncMatASMT(Xp,Yp[1:3,],M)

IncMatASMT(Xp,rbind(Yp,Yp))

dat.fr<-data.frame(a=Xp)
IncMatASMT(dat.fr,Yp,M)

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{IncMatAStri}}, \code{\link{IncMatPEMT}}, and \code{\link{IncMatCSMT}}
}
