% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ArcSliceUGFunctions.R
\name{IedgeAStri}
\alias{IedgeAStri}
\title{The indicator for the presence of an edge from a point to another
for the underlying or reflexivity graph of
Arc Slice Proximity Catch Digraphs (AS-PCDs) -
one triangle case}
\usage{
IedgeAStri(p1, p2, tri, M = "CC", ugraph = c("underlying", "reflexivity"))
}
\arguments{
\item{p1}{A 2D point whose AS proximity region is constructed.}

\item{p2}{A 2D point. The function determines
whether there is an edge from \code{p1} to \code{p1} or not
in the underlying or reflexivity graph of AS-PCDs.}

\item{tri}{A \eqn{3 \times 2} matrix with each row
representing a vertex of the triangle.}

\item{M}{The center of the triangle. \code{"CC"} stands for
circumcenter of the triangle \code{tri}
or a 2D point in Cartesian coordinates or
a 3D point in barycentric coordinates
which serves as a center in the interior of \code{tri};
default is \code{M="CC"}, i.e., the circumcenter of \code{tri}.}

\item{ugraph}{The type of the graph based on AS-PCDs,
\code{"underlying"} is for the underlying graph, and \code{"reflexivity"} is for
the reflexivity graph (default is \code{"underlying"}).}
}
\value{
Returns 1 if there is an edge between points \code{p1} and \code{p2}
in the underlying or reflexivity graph of AS-PCDs
in a given triangle \code{tri}, and 0 otherwise.
}
\description{
Returns \eqn{I(}\code{p1p2} is an edge
in the underlying or reflexivity graph of AS-PCDs \eqn{)}
for points \code{p1} and \code{p2} in a given triangle.

More specifically, when the argument \code{ugraph="underlying"},
it returns the edge indicator for the AS-PCD underlying graph,
that is, returns 1 if \code{p2} is
in \eqn{N_{AS}(p1)} **or** \code{p1} is in \eqn{N_{AS}(p2)},
returns 0 otherwise.
On the other hand,
when \code{ugraph="reflexivity"}, it returns
the edge indicator for the AS-PCD reflexivity graph,
that is, returns 1 if \code{p2} is
in \eqn{N_{AS}(p1)} **and** \code{p1} is in \eqn{N_{AS}(p2)},
returns 0 otherwise.

In both cases AS proximity region is constructed
with respect to the triangle \code{tri} and
vertex regions are based on the center, \eqn{M=(m_1,m_2)} in Cartesian coordinates
or \eqn{M=(\alpha,\beta,\gamma)} in barycentric coordinates
in the interior of the triangle \code{tri}
or based on circumcenter of  \code{tri};
default is \code{M="CC"}, i.e., circumcenter of \code{tri}.

If \code{p1} and \code{p2} are distinct
and either of them are outside \code{tri}, it returns 0,
but if they are identical,
then it returns 1 regardless of their locations
(i.e., it allows loops).

See also (\insertCite{ceyhan:Phd-thesis,ceyhan:stamet2016;textual}{pcds.ugraph}).
}
\examples{
#\donttest{
A<-c(1,1); B<-c(2,0); C<-c(1.5,2);
Tr<-rbind(A,B,C);
M<-as.numeric(pcds::runif.tri(1,Tr)$g)

n<-3
set.seed(1)
Xp<-pcds::runif.tri(n,Tr)$g

IedgeAStri(Xp[1,],Xp[3,],Tr,M)
IedgeAStri(Xp[1,],Xp[3,],Tr,M,ugraph = "reflexivity")

set.seed(1)
P1<-as.numeric(pcds::runif.tri(1,Tr)$g)
P2<-as.numeric(pcds::runif.tri(1,Tr)$g)
IedgeAStri(P1,P2,Tr,M)
IedgeAStri(P1,P2,Tr,M,ugraph="r")
#}

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{IedgeASbasic.tri}}, \code{\link{IedgePEtri}},
\code{\link{IedgeCStri}} and \code{\link[pcds]{IarcAStri}}
}
\author{
Elvan Ceyhan
}
