% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_get_dama_xml.R
\name{f_get_dama_xml}
\alias{f_get_dama_xml}
\title{Get '.xml' within 'DataMashup'}
\usage{
f_get_dama_xml(input_file_pbix, xml_start, xml_end)
}
\arguments{
\item{input_file_pbix}{Path of the input '.pbix'.}

\item{xml_start}{Start position of '.xml'}

\item{xml_end}{End position of '.xml'}
}
\value{
The '.xml' Within 'DataMashup'.
}
\description{
The byte sequence of 'DataMashup' within a '.pbix' is
retrieved and the '.xml' is extracted.
}
\examples{
\dontrun{
# Get dummy data ------------------------------------------------------------
# Create a temporary directory
temp_dir <- file.path(tempdir(),"functionTest")
if(!dir.exists(temp_dir)) {
	dir.create(temp_dir)
}
sample_file_name <- "OR_sample_func.pbix"
pathFileSample <- file.path(temp_dir, sample_file_name)

# See if dummy data already exists in temporary directory
parent_temp_dir <- dirname(temp_dir)
existing_file <- list.files(parent_temp_dir,
pattern = sample_file_name, recursive = TRUE, full.names = TRUE)

# Download the sample .pbix if it doesn't exist
if (length(existing_file) == 0) {
   url_pt1 <- "https://github.com/KoenVerbeeck/PowerBI-Course/blob/"
   url_pt2 <- "master/pbix/TopMovies.pbix?raw=true"
   url <- paste0(url_pt1, url_pt2)
   req <- download.file(url, destfile = pathFileSample, mode = "wb")
} else {
   pathFileSample <- existing_file[1]
}
# Do stuff ------------------------------------------------------------------

# Get the start and end positions
test <- f_get_dama_xml_details(pathFileSample)
xml_start <- (test[[1]][1]/2) + 1
xml_end <- test[[3]][1]
# Run the function
output <- f_get_dama_xml(pathFileSample, xml_start, xml_end)
  }
}
\seealso{
Uses: \code{\link{f_get_dama_index}},
\code{\link{f_get_dama_file}}.
}
\author{
Don Diproto
}
