% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ddmatrix_summary.r
\docType{methods}
\name{ddmatrix-summary}
\alias{ddmatrix-summary}
\alias{summary}
\alias{summary,ddmatrix-method}
\title{Distributed Matrix Summary}
\usage{
summary(object, ...)

\S4method{summary}{ddmatrix}(object)
}
\arguments{
\item{object}{numeric distributed matrix}

\item{...}{Additional arguments.}
}
\value{
A table on processor 0, \code{NULL} on all other processors.
}
\description{
Summarize a distributed matrix.  Gives min, max, mean, etc. by column.
}
\details{
The return is on process 0 only.
}
\examples{
\dontrun{
# Save code in a file "demo.r" and run with 2 processors by
# > mpiexec -np 2 Rscript demo.r

library(pbdDMAT, quiet = TRUE)
init.grid()

# don't do this in production code
x <- matrix(1:16, ncol=4)
dx <- as.ddmatrix(x) 

summary(dx)

finalize()
}

}
\keyword{Methods}

