% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paws.R
\name{ssmcontacts}
\alias{ssmcontacts}
\title{AWS Systems Manager Incident Manager Contacts}
\usage{
ssmcontacts(
  config = list(),
  credentials = list(),
  endpoint = NULL,
  region = NULL
)
}
\arguments{
\item{config}{Optional configuration of credentials, endpoint, and/or region.
\itemize{
\item{\strong{credentials}: \itemize{
\item{\strong{creds}: \itemize{
\item{\strong{access_key_id}: AWS access key ID}
\item{\strong{secret_access_key}: AWS secret access key}
\item{\strong{session_token}: AWS temporary session token}
}}
\item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
\item{\strong{anonymous}: Set anonymous credentials.}
}}
\item{\strong{endpoint}: The complete URL to use for the constructed client.}
\item{\strong{region}: The AWS Region used in instantiating the client.}
\item{\strong{close_connection}: Immediately close all HTTP connections.}
\item{\strong{timeout}: The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
\item{\strong{s3_force_path_style}: Set this to \code{true} to force the request to use path-style addressing, i.e. \verb{http://s3.amazonaws.com/BUCKET/KEY}.}
\item{\strong{sts_regional_endpoint}: Set sts regional endpoint resolver to regional or legacy \url{https://docs.aws.amazon.com/sdkref/latest/guide/feature-sts-regionalized-endpoints.html}}
}}

\item{credentials}{Optional credentials shorthand for the config parameter
\itemize{
\item{\strong{creds}: \itemize{
\item{\strong{access_key_id}: AWS access key ID}
\item{\strong{secret_access_key}: AWS secret access key}
\item{\strong{session_token}: AWS temporary session token}
}}
\item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
\item{\strong{anonymous}: Set anonymous credentials.}
}}

\item{endpoint}{Optional shorthand for complete URL to use for the constructed client.}

\item{region}{Optional shorthand for AWS Region used in instantiating the client.}
}
\value{
A client for the service. You can call the service's operations using
syntax like \code{svc$operation(...)}, where \code{svc} is the name you've assigned
to the client. The available operations are listed in the
Operations section.
}
\description{
Systems Manager Incident Manager is an incident management console
designed to help users mitigate and recover from incidents affecting
their Amazon Web Services-hosted applications. An incident is any
unplanned interruption or reduction in quality of services.

Incident Manager increases incident resolution by notifying responders
of impact, highlighting relevant troubleshooting data, and providing
collaboration tools to get services back up and running. To achieve the
primary goal of reducing the time-to-resolution of critical incidents,
Incident Manager automates response plans and enables responder team
escalation.
}
\section{Service syntax}{


\if{html}{\out{<div class="sourceCode">}}\preformatted{svc <- ssmcontacts(
  config = list(
    credentials = list(
      creds = list(
        access_key_id = "string",
        secret_access_key = "string",
        session_token = "string"
      ),
      profile = "string",
      anonymous = "logical"
    ),
    endpoint = "string",
    region = "string",
    close_connection = "logical",
    timeout = "numeric",
    s3_force_path_style = "logical",
    sts_regional_endpoint = "string"
  ),
  credentials = list(
    creds = list(
      access_key_id = "string",
      secret_access_key = "string",
      session_token = "string"
    ),
    profile = "string",
    anonymous = "logical"
  ),
  endpoint = "string",
  region = "string"
)
}\if{html}{\out{</div>}}
}

\section{Operations}{

\tabular{ll}{
\link[paws.management:ssmcontacts_accept_page]{accept_page} \tab Used to acknowledge an engagement to a contact channel during an incident\cr
\link[paws.management:ssmcontacts_activate_contact_channel]{activate_contact_channel} \tab Activates a contact's contact channel\cr
\link[paws.management:ssmcontacts_create_contact]{create_contact} \tab Contacts are either the contacts that Incident Manager engages during an incident or the escalation plans that Incident Manager uses to engage contacts in phases during an incident\cr
\link[paws.management:ssmcontacts_create_contact_channel]{create_contact_channel} \tab A contact channel is the method that Incident Manager uses to engage your contact\cr
\link[paws.management:ssmcontacts_create_rotation]{create_rotation} \tab Creates a rotation in an on-call schedule\cr
\link[paws.management:ssmcontacts_create_rotation_override]{create_rotation_override} \tab Creates an override for a rotation in an on-call schedule\cr
\link[paws.management:ssmcontacts_deactivate_contact_channel]{deactivate_contact_channel} \tab To no longer receive Incident Manager engagements to a contact channel, you can deactivate the channel\cr
\link[paws.management:ssmcontacts_delete_contact]{delete_contact} \tab To remove a contact from Incident Manager, you can delete the contact\cr
\link[paws.management:ssmcontacts_delete_contact_channel]{delete_contact_channel} \tab To no longer receive engagements on a contact channel, you can delete the channel from a contact\cr
\link[paws.management:ssmcontacts_delete_rotation]{delete_rotation} \tab Deletes a rotation from the system\cr
\link[paws.management:ssmcontacts_delete_rotation_override]{delete_rotation_override} \tab Deletes an existing override for an on-call rotation\cr
\link[paws.management:ssmcontacts_describe_engagement]{describe_engagement} \tab Incident Manager uses engagements to engage contacts and escalation plans during an incident\cr
\link[paws.management:ssmcontacts_describe_page]{describe_page} \tab Lists details of the engagement to a contact channel\cr
\link[paws.management:ssmcontacts_get_contact]{get_contact} \tab Retrieves information about the specified contact or escalation plan\cr
\link[paws.management:ssmcontacts_get_contact_channel]{get_contact_channel} \tab List details about a specific contact channel\cr
\link[paws.management:ssmcontacts_get_contact_policy]{get_contact_policy} \tab Retrieves the resource policies attached to the specified contact or escalation plan\cr
\link[paws.management:ssmcontacts_get_rotation]{get_rotation} \tab Retrieves information about an on-call rotation\cr
\link[paws.management:ssmcontacts_get_rotation_override]{get_rotation_override} \tab Retrieves information about an override to an on-call rotation\cr
\link[paws.management:ssmcontacts_list_contact_channels]{list_contact_channels} \tab Lists all contact channels for the specified contact\cr
\link[paws.management:ssmcontacts_list_contacts]{list_contacts} \tab Lists all contacts and escalation plans in Incident Manager\cr
\link[paws.management:ssmcontacts_list_engagements]{list_engagements} \tab Lists all engagements that have happened in an incident\cr
\link[paws.management:ssmcontacts_list_page_receipts]{list_page_receipts} \tab Lists all of the engagements to contact channels that have been acknowledged\cr
\link[paws.management:ssmcontacts_list_page_resolutions]{list_page_resolutions} \tab Returns the resolution path of an engagement\cr
\link[paws.management:ssmcontacts_list_pages_by_contact]{list_pages_by_contact} \tab Lists the engagements to a contact's contact channels\cr
\link[paws.management:ssmcontacts_list_pages_by_engagement]{list_pages_by_engagement} \tab Lists the engagements to contact channels that occurred by engaging a contact\cr
\link[paws.management:ssmcontacts_list_preview_rotation_shifts]{list_preview_rotation_shifts} \tab Returns a list of shifts based on rotation configuration parameters\cr
\link[paws.management:ssmcontacts_list_rotation_overrides]{list_rotation_overrides} \tab Retrieves a list of overrides currently specified for an on-call rotation\cr
\link[paws.management:ssmcontacts_list_rotations]{list_rotations} \tab Retrieves a list of on-call rotations\cr
\link[paws.management:ssmcontacts_list_rotation_shifts]{list_rotation_shifts} \tab Returns a list of shifts generated by an existing rotation in the system\cr
\link[paws.management:ssmcontacts_list_tags_for_resource]{list_tags_for_resource} \tab Lists the tags of an escalation plan or contact\cr
\link[paws.management:ssmcontacts_put_contact_policy]{put_contact_policy} \tab Adds a resource policy to the specified contact or escalation plan\cr
\link[paws.management:ssmcontacts_send_activation_code]{send_activation_code} \tab Sends an activation code to a contact channel\cr
\link[paws.management:ssmcontacts_start_engagement]{start_engagement} \tab Starts an engagement to a contact or escalation plan\cr
\link[paws.management:ssmcontacts_stop_engagement]{stop_engagement} \tab Stops an engagement before it finishes the final stage of the escalation plan or engagement plan\cr
\link[paws.management:ssmcontacts_tag_resource]{tag_resource} \tab Tags a contact or escalation plan\cr
\link[paws.management:ssmcontacts_untag_resource]{untag_resource} \tab Removes tags from the specified resource\cr
\link[paws.management:ssmcontacts_update_contact]{update_contact} \tab Updates the contact or escalation plan specified\cr
\link[paws.management:ssmcontacts_update_contact_channel]{update_contact_channel} \tab Updates a contact's contact channel\cr
\link[paws.management:ssmcontacts_update_rotation]{update_rotation} \tab Updates the information specified for an on-call rotation
}
}

\examples{
\dontrun{
svc <- ssmcontacts()
svc$accept_page(
  Foo = 123
)
}

}
