% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paws.R
\name{docdb}
\alias{docdb}
\title{Amazon DocumentDB with MongoDB compatibility}
\usage{
docdb(config = list())
}
\arguments{
\item{config}{Optional configuration of credentials, endpoint, and/or region.}
}
\description{
Amazon DocumentDB API documentation
}
\section{Service syntax}{
\preformatted{svc <- docdb(
  config = list(
    credentials = list(
      creds = list(
        access_key_id = "string",
        secret_access_key = "string",
        session_token = "string"
      ),
      profile = "string"
    ),
    endpoint = "string",
    region = "string"
  )
)
}
}

\section{Operations}{

\tabular{ll}{
\link[=docdb_add_tags_to_resource]{add_tags_to_resource} \tab Adds metadata tags to an Amazon DocumentDB resource \cr
\link[=docdb_apply_pending_maintenance_action]{apply_pending_maintenance_action} \tab Applies a pending maintenance action to a resource (for example, to a DB instance) \cr
\link[=docdb_copy_db_cluster_parameter_group]{copy_db_cluster_parameter_group} \tab Copies the specified cluster parameter group \cr
\link[=docdb_copy_db_cluster_snapshot]{copy_db_cluster_snapshot} \tab Copies a snapshot of a cluster \cr
\link[=docdb_create_db_cluster]{create_db_cluster} \tab Creates a new Amazon DocumentDB cluster \cr
\link[=docdb_create_db_cluster_parameter_group]{create_db_cluster_parameter_group} \tab Creates a new cluster parameter group \cr
\link[=docdb_create_db_cluster_snapshot]{create_db_cluster_snapshot} \tab Creates a snapshot of a cluster \cr
\link[=docdb_create_db_instance]{create_db_instance} \tab Creates a new instance \cr
\link[=docdb_create_db_subnet_group]{create_db_subnet_group} \tab Creates a new subnet group \cr
\link[=docdb_delete_db_cluster]{delete_db_cluster} \tab Deletes a previously provisioned cluster \cr
\link[=docdb_delete_db_cluster_parameter_group]{delete_db_cluster_parameter_group} \tab Deletes a specified cluster parameter group \cr
\link[=docdb_delete_db_cluster_snapshot]{delete_db_cluster_snapshot} \tab Deletes a cluster snapshot \cr
\link[=docdb_delete_db_instance]{delete_db_instance} \tab Deletes a previously provisioned instance \cr
\link[=docdb_delete_db_subnet_group]{delete_db_subnet_group} \tab Deletes a subnet group \cr
\link[=docdb_describe_certificates]{describe_certificates} \tab Returns a list of certificate authority (CA) certificates provided by Amazon DocumentDB for this AWS account \cr
\link[=docdb_describe_db_cluster_parameter_groups]{describe_db_cluster_parameter_groups} \tab Returns a list of DBClusterParameterGroup descriptions \cr
\link[=docdb_describe_db_cluster_parameters]{describe_db_cluster_parameters} \tab Returns the detailed parameter list for a particular cluster parameter group \cr
\link[=docdb_describe_db_clusters]{describe_db_clusters} \tab Returns information about provisioned Amazon DocumentDB clusters \cr
\link[=docdb_describe_db_cluster_snapshot_attributes]{describe_db_cluster_snapshot_attributes} \tab Returns a list of cluster snapshot attribute names and values for a manual DB cluster snapshot \cr
\link[=docdb_describe_db_cluster_snapshots]{describe_db_cluster_snapshots} \tab Returns information about cluster snapshots \cr
\link[=docdb_describe_db_engine_versions]{describe_db_engine_versions} \tab Returns a list of the available engines \cr
\link[=docdb_describe_db_instances]{describe_db_instances} \tab Returns information about provisioned Amazon DocumentDB instances \cr
\link[=docdb_describe_db_subnet_groups]{describe_db_subnet_groups} \tab Returns a list of DBSubnetGroup descriptions \cr
\link[=docdb_describe_engine_default_cluster_parameters]{describe_engine_default_cluster_parameters} \tab Returns the default engine and system parameter information for the cluster database engine \cr
\link[=docdb_describe_event_categories]{describe_event_categories} \tab Displays a list of categories for all event source types, or, if specified, for a specified source type \cr
\link[=docdb_describe_events]{describe_events} \tab Returns events related to instances, security groups, snapshots, and DB parameter groups for the past 14 days\cr
\link[=docdb_describe_orderable_db_instance_options]{describe_orderable_db_instance_options} \tab Returns a list of orderable instance options for the specified engine \cr
\link[=docdb_describe_pending_maintenance_actions]{describe_pending_maintenance_actions} \tab Returns a list of resources (for example, instances) that have at least one pending maintenance action \cr
\link[=docdb_failover_db_cluster]{failover_db_cluster} \tab Forces a failover for a cluster \cr
\link[=docdb_list_tags_for_resource]{list_tags_for_resource} \tab Lists all tags on an Amazon DocumentDB resource \cr
\link[=docdb_modify_db_cluster]{modify_db_cluster} \tab Modifies a setting for an Amazon DocumentDB cluster \cr
\link[=docdb_modify_db_cluster_parameter_group]{modify_db_cluster_parameter_group} \tab Modifies the parameters of a cluster parameter group \cr
\link[=docdb_modify_db_cluster_snapshot_attribute]{modify_db_cluster_snapshot_attribute} \tab Adds an attribute and values to, or removes an attribute and values from, a manual DB cluster snapshot \cr
\link[=docdb_modify_db_instance]{modify_db_instance} \tab Modifies settings for an instance \cr
\link[=docdb_modify_db_subnet_group]{modify_db_subnet_group} \tab Modifies an existing subnet group \cr
\link[=docdb_reboot_db_instance]{reboot_db_instance} \tab You might need to reboot your instance, usually for maintenance reasons \cr
\link[=docdb_remove_tags_from_resource]{remove_tags_from_resource} \tab Removes metadata tags from an Amazon DocumentDB resource \cr
\link[=docdb_reset_db_cluster_parameter_group]{reset_db_cluster_parameter_group} \tab Modifies the parameters of a cluster parameter group to the default value \cr
\link[=docdb_restore_db_cluster_from_snapshot]{restore_db_cluster_from_snapshot} \tab Creates a new cluster from a snapshot or cluster snapshot \cr
\link[=docdb_restore_db_cluster_to_point_in_time]{restore_db_cluster_to_point_in_time} \tab Restores a cluster to an arbitrary point in time \cr
\link[=docdb_start_db_cluster]{start_db_cluster} \tab Restarts the stopped cluster that is specified by DBClusterIdentifier \cr
\link[=docdb_stop_db_cluster]{stop_db_cluster} \tab Stops the running cluster that is specified by DBClusterIdentifier
}
}

\examples{
\dontrun{
svc <- docdb()
svc$add_tags_to_resource(
  Foo = 123
)
}

}
