% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paws.R
\name{inspector}
\alias{inspector}
\title{Amazon Inspector}
\usage{
inspector(config = list())
}
\arguments{
\item{config}{Optional configuration of credentials, endpoint, and/or region.}
}
\description{
Amazon Inspector enables you to analyze the behavior of your AWS
resources and to identify potential security issues. For more
information, see \href{https://docs.aws.amazon.com/inspector/latest/userguide/inspector_introduction.html}{Amazon Inspector User Guide}.
}
\section{Service syntax}{
\preformatted{svc <- inspector(
  config = list(
    credentials = list(
      creds = list(
        access_key_id = "string",
        secret_access_key = "string",
        session_token = "string"
      ),
      profile = "string"
    ),
    endpoint = "string",
    region = "string"
  )
)
}
}

\section{Operations}{

\tabular{ll}{
\link[=inspector_add_attributes_to_findings]{add_attributes_to_findings} \tab Assigns attributes (key and value pairs) to the findings that are specified by the ARNs of the findings \cr
\link[=inspector_create_assessment_target]{create_assessment_target} \tab Creates a new assessment target using the ARN of the resource group that is generated by CreateResourceGroup \cr
\link[=inspector_create_assessment_template]{create_assessment_template} \tab Creates an assessment template for the assessment target that is specified by the ARN of the assessment target \cr
\link[=inspector_create_exclusions_preview]{create_exclusions_preview} \tab Starts the generation of an exclusions preview for the specified assessment template \cr
\link[=inspector_create_resource_group]{create_resource_group} \tab Creates a resource group using the specified set of tags (key and value pairs) that are used to select the EC2 instances to be included in an Amazon Inspector assessment target\cr
\link[=inspector_delete_assessment_run]{delete_assessment_run} \tab Deletes the assessment run that is specified by the ARN of the assessment run \cr
\link[=inspector_delete_assessment_target]{delete_assessment_target} \tab Deletes the assessment target that is specified by the ARN of the assessment target \cr
\link[=inspector_delete_assessment_template]{delete_assessment_template} \tab Deletes the assessment template that is specified by the ARN of the assessment template \cr
\link[=inspector_describe_assessment_runs]{describe_assessment_runs} \tab Describes the assessment runs that are specified by the ARNs of the assessment runs \cr
\link[=inspector_describe_assessment_targets]{describe_assessment_targets} \tab Describes the assessment targets that are specified by the ARNs of the assessment targets \cr
\link[=inspector_describe_assessment_templates]{describe_assessment_templates} \tab Describes the assessment templates that are specified by the ARNs of the assessment templates \cr
\link[=inspector_describe_cross_account_access_role]{describe_cross_account_access_role} \tab Describes the IAM role that enables Amazon Inspector to access your AWS account \cr
\link[=inspector_describe_exclusions]{describe_exclusions} \tab Describes the exclusions that are specified by the exclusions' ARNs \cr
\link[=inspector_describe_findings]{describe_findings} \tab Describes the findings that are specified by the ARNs of the findings \cr
\link[=inspector_describe_resource_groups]{describe_resource_groups} \tab Describes the resource groups that are specified by the ARNs of the resource groups \cr
\link[=inspector_describe_rules_packages]{describe_rules_packages} \tab Describes the rules packages that are specified by the ARNs of the rules packages \cr
\link[=inspector_get_assessment_report]{get_assessment_report} \tab Produces an assessment report that includes detailed and comprehensive results of a specified assessment run \cr
\link[=inspector_get_exclusions_preview]{get_exclusions_preview} \tab Retrieves the exclusions preview (a list of ExclusionPreview objects) specified by the preview token \cr
\link[=inspector_get_telemetry_metadata]{get_telemetry_metadata} \tab Information about the data that is collected for the specified assessment run \cr
\link[=inspector_list_assessment_run_agents]{list_assessment_run_agents} \tab Lists the agents of the assessment runs that are specified by the ARNs of the assessment runs \cr
\link[=inspector_list_assessment_runs]{list_assessment_runs} \tab Lists the assessment runs that correspond to the assessment templates that are specified by the ARNs of the assessment templates \cr
\link[=inspector_list_assessment_targets]{list_assessment_targets} \tab Lists the ARNs of the assessment targets within this AWS account \cr
\link[=inspector_list_assessment_templates]{list_assessment_templates} \tab Lists the assessment templates that correspond to the assessment targets that are specified by the ARNs of the assessment targets \cr
\link[=inspector_list_event_subscriptions]{list_event_subscriptions} \tab Lists all the event subscriptions for the assessment template that is specified by the ARN of the assessment template \cr
\link[=inspector_list_exclusions]{list_exclusions} \tab List exclusions that are generated by the assessment run \cr
\link[=inspector_list_findings]{list_findings} \tab Lists findings that are generated by the assessment runs that are specified by the ARNs of the assessment runs \cr
\link[=inspector_list_rules_packages]{list_rules_packages} \tab Lists all available Amazon Inspector rules packages \cr
\link[=inspector_list_tags_for_resource]{list_tags_for_resource} \tab Lists all tags associated with an assessment template \cr
\link[=inspector_preview_agents]{preview_agents} \tab Previews the agents installed on the EC2 instances that are part of the specified assessment target \cr
\link[=inspector_register_cross_account_access_role]{register_cross_account_access_role} \tab Registers the IAM role that grants Amazon Inspector access to AWS Services needed to perform security assessments \cr
\link[=inspector_remove_attributes_from_findings]{remove_attributes_from_findings} \tab Removes entire attributes (key and value pairs) from the findings that are specified by the ARNs of the findings where an attribute with the specified key exists \cr
\link[=inspector_set_tags_for_resource]{set_tags_for_resource} \tab Sets tags (key and value pairs) to the assessment template that is specified by the ARN of the assessment template \cr
\link[=inspector_start_assessment_run]{start_assessment_run} \tab Starts the assessment run specified by the ARN of the assessment template \cr
\link[=inspector_stop_assessment_run]{stop_assessment_run} \tab Stops the assessment run that is specified by the ARN of the assessment run \cr
\link[=inspector_subscribe_to_event]{subscribe_to_event} \tab Enables the process of sending Amazon Simple Notification Service (SNS) notifications about a specified event to a specified SNS topic \cr
\link[=inspector_unsubscribe_from_event]{unsubscribe_from_event} \tab Disables the process of sending Amazon Simple Notification Service (SNS) notifications about a specified event to a specified SNS topic \cr
\link[=inspector_update_assessment_target]{update_assessment_target} \tab Updates the assessment target that is specified by the ARN of the assessment target
}
}

\examples{
# Assigns attributes (key and value pairs) to the findings that are
# specified by the ARNs of the findings.
\donttest{svc <- inspector()
svc$add_attributes_to_findings(
  attributes = list(
    list(
      key = "Example",
      value = "example"
    )
  ),
  findingArns = list(
    "arn:aws:inspector:us-west-2:123456789012:target/0-0kFIPusq/template/0-8l1VIE0D/run/0-Z0..."
  )
)}

}
