% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_operations.R
\name{s3_put_bucket_lifecycle_configuration}
\alias{s3_put_bucket_lifecycle_configuration}
\title{Creates a new lifecycle configuration for the bucket or replaces an
existing lifecycle configuration}
\usage{
s3_put_bucket_lifecycle_configuration(
  Bucket,
  ChecksumAlgorithm = NULL,
  LifecycleConfiguration = NULL,
  ExpectedBucketOwner = NULL,
  TransitionDefaultMinimumObjectSize = NULL
)
}
\arguments{
\item{Bucket}{[required] The name of the bucket for which to set the configuration.}

\item{ChecksumAlgorithm}{Indicates the algorithm used to create the checksum for the object when
you use the SDK. This header will not provide any additional
functionality if you don't use the SDK. When you send this header, there
must be a corresponding \code{x-amz-checksum} or \code{x-amz-trailer} header sent.
Otherwise, Amazon S3 fails the request with the HTTP status code
\verb{400 Bad Request}. For more information, see \href{https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html}{Checking object integrity}
in the \emph{Amazon S3 User Guide}.

If you provide an individual checksum, Amazon S3 ignores any provided
\code{ChecksumAlgorithm} parameter.}

\item{LifecycleConfiguration}{Container for lifecycle rules. You can add as many as 1,000 rules.}

\item{ExpectedBucketOwner}{The account ID of the expected bucket owner. If the account ID that you
provide does not match the actual owner of the bucket, the request fails
with the HTTP status code \verb{403 Forbidden} (access denied).

This parameter applies to general purpose buckets only. It is not
supported for directory bucket lifecycle configurations.}

\item{TransitionDefaultMinimumObjectSize}{Indicates which default minimum object size behavior is applied to the
lifecycle configuration.

This parameter applies to general purpose buckets only. It is not
supported for directory bucket lifecycle configurations.
\itemize{
\item \code{all_storage_classes_128K} - Objects smaller than 128 KB will not
transition to any storage class by default.
\item \code{varies_by_storage_class} - Objects smaller than 128 KB will
transition to Glacier Flexible Retrieval or Glacier Deep Archive
storage classes. By default, all other storage classes will prevent
transitions smaller than 128 KB.
}

To customize the minimum object size for any transition you can add a
filter that specifies a custom \code{ObjectSizeGreaterThan} or
\code{ObjectSizeLessThan} in the body of your transition rule. Custom filters
always take precedence over the default transition behavior.}
}
\description{
Creates a new lifecycle configuration for the bucket or replaces an existing lifecycle configuration. Keep in mind that this will overwrite an existing lifecycle configuration, so if you want to retain any configuration details, they must be included in the new lifecycle configuration. For information about lifecycle configuration, see \href{https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-lifecycle-mgmt.html}{Managing your storage lifecycle}.

See \url{https://www.paws-r-sdk.com/docs/s3_put_bucket_lifecycle_configuration/} for full documentation.
}
\keyword{internal}
