% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3control_operations.R
\name{s3control_tag_resource}
\alias{s3control_tag_resource}
\title{Creates a new Amazon Web Services resource tag or updates an existing
resource tag}
\usage{
s3control_tag_resource(AccountId, ResourceArn, Tags)
}
\arguments{
\item{AccountId}{[required] The Amazon Web Services account ID that created the S3 resource that
you're trying to add tags to or the requester's account ID.}

\item{ResourceArn}{[required] The Amazon Resource Name (ARN) of the S3 resource that you're trying to
add tags to. The tagged resource can be an S3 Storage Lens group or S3
Access Grants instance, registered location, or grant.}

\item{Tags}{[required] The Amazon Web Services resource tags that you want to add to the
specified S3 resource.}
}
\description{
Creates a new Amazon Web Services resource tag or updates an existing resource tag. Each tag is a label consisting of a user-defined key and value. Tags can help you manage, identify, organize, search for, and filter resources. You can add up to 50 Amazon Web Services resource tags for each S3 resource.

See \url{https://www.paws-r-sdk.com/docs/s3control_tag_resource/} for full documentation.
}
\keyword{internal}
