# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service set_config merge_config
NULL

#' Amazon Simple Storage Service
#'
#' 
#'
#' @param
#' config
#' Optional configuration of credentials, endpoint, and/or region.
#' \itemize{
#' \item{\strong{credentials}: \itemize{
#' \item{\strong{creds}: \itemize{
#' \item{\strong{access_key_id}: AWS access key ID}
#' \item{\strong{secret_access_key}: AWS secret access key}
#' \item{\strong{session_token}: AWS temporary session token}
#' }}
#' \item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}: Set anonymous credentials.}
#' }}
#' \item{\strong{endpoint}: The complete URL to use for the constructed client.}
#' \item{\strong{region}: The AWS Region used in instantiating the client.}
#' \item{\strong{close_connection}: Immediately close all HTTP connections.}
#' \item{\strong{timeout}: The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
#' \item{\strong{s3_force_path_style}: Set this to `true` to force the request to use path-style addressing, i.e. `http://s3.amazonaws.com/BUCKET/KEY`.}
#' \item{\strong{sts_regional_endpoint}: Set sts regional endpoint resolver to regional or legacy \url{https://docs.aws.amazon.com/sdkref/latest/guide/feature-sts-regionalized-endpoints.html}}
#' }
#' @param
#' credentials
#' Optional credentials shorthand for the config parameter
#' \itemize{
#' \item{\strong{creds}: \itemize{
#' \item{\strong{access_key_id}: AWS access key ID}
#' \item{\strong{secret_access_key}: AWS secret access key}
#' \item{\strong{session_token}: AWS temporary session token}
#' }}
#' \item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}: Set anonymous credentials.}
#' }
#' @param
#' endpoint
#' Optional shorthand for complete URL to use for the constructed client.
#' @param
#' region
#' Optional shorthand for AWS Region used in instantiating the client.
#'
#' @section Service syntax:
#' ```
#' svc <- s3(
#'   config = list(
#'     credentials = list(
#'       creds = list(
#'         access_key_id = "string",
#'         secret_access_key = "string",
#'         session_token = "string"
#'       ),
#'       profile = "string",
#'       anonymous = "logical"
#'     ),
#'     endpoint = "string",
#'     region = "string",
#'     close_connection = "logical",
#'     timeout = "numeric",
#'     s3_force_path_style = "logical",
#'     sts_regional_endpoint = "string"
#'   ),
#'   credentials = list(
#'     creds = list(
#'       access_key_id = "string",
#'       secret_access_key = "string",
#'       session_token = "string"
#'     ),
#'     profile = "string",
#'     anonymous = "logical"
#'   ),
#'   endpoint = "string",
#'   region = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' svc <- s3()
#' # The following example aborts a multipart upload.
#' svc$abort_multipart_upload(
#'   Bucket = "examplebucket",
#'   Key = "bigobject",
#'   UploadId = "xadcOB_7YPBOJuoFiQ9cz4P3Pe6FIZwO4f7wN93uHsNBEw97pl5eNwzExg0LA..."
#' )
#' }
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=s3_abort_multipart_upload]{abort_multipart_upload} \tab This operation aborts a multipart upload\cr
#'  \link[=s3_complete_multipart_upload]{complete_multipart_upload} \tab Completes a multipart upload by assembling previously uploaded parts\cr
#'  \link[=s3_copy_object]{copy_object} \tab Creates a copy of an object that is already stored in Amazon S3\cr
#'  \link[=s3_create_bucket]{create_bucket} \tab This action creates an Amazon S3 bucket\cr
#'  \link[=s3_create_multipart_upload]{create_multipart_upload} \tab This action initiates a multipart upload and returns an upload ID\cr
#'  \link[=s3_create_session]{create_session} \tab Creates a session that establishes temporary security credentials to support fast authentication and authorization for the Zonal endpoint APIs on directory buckets\cr
#'  \link[=s3_delete_bucket]{delete_bucket} \tab Deletes the S3 bucket\cr
#'  \link[=s3_delete_bucket_analytics_configuration]{delete_bucket_analytics_configuration} \tab This operation is not supported by directory buckets\cr
#'  \link[=s3_delete_bucket_cors]{delete_bucket_cors} \tab This operation is not supported by directory buckets\cr
#'  \link[=s3_delete_bucket_encryption]{delete_bucket_encryption} \tab This operation is not supported by directory buckets\cr
#'  \link[=s3_delete_bucket_intelligent_tiering_configuration]{delete_bucket_intelligent_tiering_configuration} \tab This operation is not supported by directory buckets\cr
#'  \link[=s3_delete_bucket_inventory_configuration]{delete_bucket_inventory_configuration} \tab This operation is not supported by directory buckets\cr
#'  \link[=s3_delete_bucket_lifecycle]{delete_bucket_lifecycle} \tab This operation is not supported by directory buckets\cr
#'  \link[=s3_delete_bucket_metrics_configuration]{delete_bucket_metrics_configuration} \tab This operation is not supported by directory buckets\cr
#'  \link[=s3_delete_bucket_ownership_controls]{delete_bucket_ownership_controls} \tab This operation is not supported by directory buckets\cr
#'  \link[=s3_delete_bucket_policy]{delete_bucket_policy} \tab Deletes the policy of a specified bucket\cr
#'  \link[=s3_delete_bucket_replication]{delete_bucket_replication} \tab This operation is not supported by directory buckets\cr
#'  \link[=s3_delete_bucket_tagging]{delete_bucket_tagging} \tab This operation is not supported by directory buckets\cr
#'  \link[=s3_delete_bucket_website]{delete_bucket_website} \tab This operation is not supported by directory buckets\cr
#'  \link[=s3_delete_object]{delete_object} \tab Removes an object from a bucket\cr
#'  \link[=s3_delete_objects]{delete_objects} \tab This operation enables you to delete multiple objects from a bucket using a single HTTP request\cr
#'  \link[=s3_delete_object_tagging]{delete_object_tagging} \tab This operation is not supported by directory buckets\cr
#'  \link[=s3_delete_public_access_block]{delete_public_access_block} \tab This operation is not supported by directory buckets\cr
#'  \link[=s3_download_file]{download_file} \tab Download a file from S3 and store it at a specified file location\cr
#'  \link[=s3_generate_presigned_url]{generate_presigned_url} \tab @title Generate a presigned url given a client, its method, and arguments\cr
#'  \link[=s3_get_bucket_accelerate_configuration]{get_bucket_accelerate_configuration} \tab This operation is not supported by directory buckets\cr
#'  \link[=s3_get_bucket_acl]{get_bucket_acl} \tab This operation is not supported by directory buckets\cr
#'  \link[=s3_get_bucket_analytics_configuration]{get_bucket_analytics_configuration} \tab This operation is not supported by directory buckets\cr
#'  \link[=s3_get_bucket_cors]{get_bucket_cors} \tab This operation is not supported by directory buckets\cr
#'  \link[=s3_get_bucket_encryption]{get_bucket_encryption} \tab This operation is not supported by directory buckets\cr
#'  \link[=s3_get_bucket_intelligent_tiering_configuration]{get_bucket_intelligent_tiering_configuration} \tab This operation is not supported by directory buckets\cr
#'  \link[=s3_get_bucket_inventory_configuration]{get_bucket_inventory_configuration} \tab This operation is not supported by directory buckets\cr
#'  \link[=s3_get_bucket_lifecycle]{get_bucket_lifecycle} \tab For an updated version of this API, see GetBucketLifecycleConfiguration\cr
#'  \link[=s3_get_bucket_lifecycle_configuration]{get_bucket_lifecycle_configuration} \tab This operation is not supported by directory buckets\cr
#'  \link[=s3_get_bucket_location]{get_bucket_location} \tab This operation is not supported by directory buckets\cr
#'  \link[=s3_get_bucket_logging]{get_bucket_logging} \tab This operation is not supported by directory buckets\cr
#'  \link[=s3_get_bucket_metrics_configuration]{get_bucket_metrics_configuration} \tab This operation is not supported by directory buckets\cr
#'  \link[=s3_get_bucket_notification]{get_bucket_notification} \tab This operation is not supported by directory buckets\cr
#'  \link[=s3_get_bucket_notification_configuration]{get_bucket_notification_configuration} \tab This operation is not supported by directory buckets\cr
#'  \link[=s3_get_bucket_ownership_controls]{get_bucket_ownership_controls} \tab This operation is not supported by directory buckets\cr
#'  \link[=s3_get_bucket_policy]{get_bucket_policy} \tab Returns the policy of a specified bucket\cr
#'  \link[=s3_get_bucket_policy_status]{get_bucket_policy_status} \tab This operation is not supported by directory buckets\cr
#'  \link[=s3_get_bucket_replication]{get_bucket_replication} \tab This operation is not supported by directory buckets\cr
#'  \link[=s3_get_bucket_request_payment]{get_bucket_request_payment} \tab This operation is not supported by directory buckets\cr
#'  \link[=s3_get_bucket_tagging]{get_bucket_tagging} \tab This operation is not supported by directory buckets\cr
#'  \link[=s3_get_bucket_versioning]{get_bucket_versioning} \tab This operation is not supported by directory buckets\cr
#'  \link[=s3_get_bucket_website]{get_bucket_website} \tab This operation is not supported by directory buckets\cr
#'  \link[=s3_get_object]{get_object} \tab Retrieves an object from Amazon S3\cr
#'  \link[=s3_get_object_acl]{get_object_acl} \tab This operation is not supported by directory buckets\cr
#'  \link[=s3_get_object_attributes]{get_object_attributes} \tab Retrieves all the metadata from an object without returning the object itself\cr
#'  \link[=s3_get_object_legal_hold]{get_object_legal_hold} \tab This operation is not supported by directory buckets\cr
#'  \link[=s3_get_object_lock_configuration]{get_object_lock_configuration} \tab This operation is not supported by directory buckets\cr
#'  \link[=s3_get_object_retention]{get_object_retention} \tab This operation is not supported by directory buckets\cr
#'  \link[=s3_get_object_tagging]{get_object_tagging} \tab This operation is not supported by directory buckets\cr
#'  \link[=s3_get_object_torrent]{get_object_torrent} \tab This operation is not supported by directory buckets\cr
#'  \link[=s3_get_public_access_block]{get_public_access_block} \tab This operation is not supported by directory buckets\cr
#'  \link[=s3_head_bucket]{head_bucket} \tab You can use this operation to determine if a bucket exists and if you have permission to access it\cr
#'  \link[=s3_head_object]{head_object} \tab The HEAD operation retrieves metadata from an object without returning the object itself\cr
#'  \link[=s3_list_bucket_analytics_configurations]{list_bucket_analytics_configurations} \tab This operation is not supported by directory buckets\cr
#'  \link[=s3_list_bucket_intelligent_tiering_configurations]{list_bucket_intelligent_tiering_configurations} \tab This operation is not supported by directory buckets\cr
#'  \link[=s3_list_bucket_inventory_configurations]{list_bucket_inventory_configurations} \tab This operation is not supported by directory buckets\cr
#'  \link[=s3_list_bucket_metrics_configurations]{list_bucket_metrics_configurations} \tab This operation is not supported by directory buckets\cr
#'  \link[=s3_list_buckets]{list_buckets} \tab This operation is not supported by directory buckets\cr
#'  \link[=s3_list_directory_buckets]{list_directory_buckets} \tab Returns a list of all Amazon S3 directory buckets owned by the authenticated sender of the request\cr
#'  \link[=s3_list_multipart_uploads]{list_multipart_uploads} \tab This operation lists in-progress multipart uploads in a bucket\cr
#'  \link[=s3_list_objects]{list_objects} \tab This operation is not supported by directory buckets\cr
#'  \link[=s3_list_objects_v2]{list_objects_v2} \tab Returns some or all (up to 1,000) of the objects in a bucket with each request\cr
#'  \link[=s3_list_object_versions]{list_object_versions} \tab This operation is not supported by directory buckets\cr
#'  \link[=s3_list_parts]{list_parts} \tab Lists the parts that have been uploaded for a specific multipart upload\cr
#'  \link[=s3_put_bucket_accelerate_configuration]{put_bucket_accelerate_configuration} \tab This operation is not supported by directory buckets\cr
#'  \link[=s3_put_bucket_acl]{put_bucket_acl} \tab This operation is not supported by directory buckets\cr
#'  \link[=s3_put_bucket_analytics_configuration]{put_bucket_analytics_configuration} \tab This operation is not supported by directory buckets\cr
#'  \link[=s3_put_bucket_cors]{put_bucket_cors} \tab This operation is not supported by directory buckets\cr
#'  \link[=s3_put_bucket_encryption]{put_bucket_encryption} \tab This operation is not supported by directory buckets\cr
#'  \link[=s3_put_bucket_intelligent_tiering_configuration]{put_bucket_intelligent_tiering_configuration} \tab This operation is not supported by directory buckets\cr
#'  \link[=s3_put_bucket_inventory_configuration]{put_bucket_inventory_configuration} \tab This operation is not supported by directory buckets\cr
#'  \link[=s3_put_bucket_lifecycle]{put_bucket_lifecycle} \tab This operation is not supported by directory buckets\cr
#'  \link[=s3_put_bucket_lifecycle_configuration]{put_bucket_lifecycle_configuration} \tab This operation is not supported by directory buckets\cr
#'  \link[=s3_put_bucket_logging]{put_bucket_logging} \tab This operation is not supported by directory buckets\cr
#'  \link[=s3_put_bucket_metrics_configuration]{put_bucket_metrics_configuration} \tab This operation is not supported by directory buckets\cr
#'  \link[=s3_put_bucket_notification]{put_bucket_notification} \tab This operation is not supported by directory buckets\cr
#'  \link[=s3_put_bucket_notification_configuration]{put_bucket_notification_configuration} \tab This operation is not supported by directory buckets\cr
#'  \link[=s3_put_bucket_ownership_controls]{put_bucket_ownership_controls} \tab This operation is not supported by directory buckets\cr
#'  \link[=s3_put_bucket_policy]{put_bucket_policy} \tab Applies an Amazon S3 bucket policy to an Amazon S3 bucket\cr
#'  \link[=s3_put_bucket_replication]{put_bucket_replication} \tab This operation is not supported by directory buckets\cr
#'  \link[=s3_put_bucket_request_payment]{put_bucket_request_payment} \tab This operation is not supported by directory buckets\cr
#'  \link[=s3_put_bucket_tagging]{put_bucket_tagging} \tab This operation is not supported by directory buckets\cr
#'  \link[=s3_put_bucket_versioning]{put_bucket_versioning} \tab This operation is not supported by directory buckets\cr
#'  \link[=s3_put_bucket_website]{put_bucket_website} \tab This operation is not supported by directory buckets\cr
#'  \link[=s3_put_object]{put_object} \tab Adds an object to a bucket\cr
#'  \link[=s3_put_object_acl]{put_object_acl} \tab This operation is not supported by directory buckets\cr
#'  \link[=s3_put_object_legal_hold]{put_object_legal_hold} \tab This operation is not supported by directory buckets\cr
#'  \link[=s3_put_object_lock_configuration]{put_object_lock_configuration} \tab This operation is not supported by directory buckets\cr
#'  \link[=s3_put_object_retention]{put_object_retention} \tab This operation is not supported by directory buckets\cr
#'  \link[=s3_put_object_tagging]{put_object_tagging} \tab This operation is not supported by directory buckets\cr
#'  \link[=s3_put_public_access_block]{put_public_access_block} \tab This operation is not supported by directory buckets\cr
#'  \link[=s3_restore_object]{restore_object} \tab This operation is not supported by directory buckets\cr
#'  \link[=s3_select_object_content]{select_object_content} \tab This operation is not supported by directory buckets\cr
#'  \link[=s3_upload_part]{upload_part} \tab Uploads a part in a multipart upload\cr
#'  \link[=s3_upload_part_copy]{upload_part_copy} \tab Uploads a part by copying data from an existing object as data source\cr
#'  \link[=s3_write_get_object_response]{write_get_object_response} \tab This operation is not supported by directory buckets
#' }
#'
#' @return
#' A client for the service. You can call the service's operations using
#' syntax like `svc$operation(...)`, where `svc` is the name you've assigned
#' to the client. The available operations are listed in the
#' Operations section.
#'
#' @rdname s3
#' @export
s3 <- function(config = list(), credentials = list(), endpoint = NULL, region = NULL) {
  config <- merge_config(
    config,
    list(
      credentials = credentials,
      endpoint = endpoint,
      region = region
    )
  )
  svc <- .s3$operations
  svc <- set_config(svc, config)
  return(svc)
}

# Private API objects: metadata, handlers, interfaces, etc.
.s3 <- list()

.s3$operations <- list()

.s3$metadata <- list(
  service_name = "s3",
  endpoints = list("us-gov-west-1" = list(endpoint = "s3.{region}.amazonaws.com", global = FALSE), "us-west-1" = list(endpoint = "s3.{region}.amazonaws.com", global = FALSE), "us-west-2" = list(endpoint = "s3.{region}.amazonaws.com", global = FALSE), "eu-west-1" = list(endpoint = "s3.{region}.amazonaws.com", global = FALSE), "ap-southeast-1" = list(endpoint = "s3.{region}.amazonaws.com", global = FALSE), "ap-southeast-2" = list(endpoint = "s3.{region}.amazonaws.com", global = FALSE), "ap-northeast-1" = list(endpoint = "s3.{region}.amazonaws.com", global = FALSE), "sa-east-1" = list(endpoint = "s3.{region}.amazonaws.com", global = FALSE), "us-east-1" = list(endpoint = "s3.amazonaws.com", global = FALSE), "*" = list(endpoint = "s3.{region}.amazonaws.com", global = FALSE), "cn-*" = list(endpoint = "s3.{region}.amazonaws.com.cn", global = FALSE), "eu-isoe-*" = list(endpoint = "s3.{region}.cloud.adc-e.uk", global = FALSE), "us-iso-*" = list(endpoint = "s3.{region}.c2s.ic.gov", global = FALSE), "us-isob-*" = list(endpoint = "s3.{region}.sc2s.sgov.gov", global = FALSE), "us-isof-*" = list(endpoint = "s3.{region}.csp.hci.ic.gov", global = FALSE)),
  service_id = "S3",
  api_version = "2006-03-01",
  signing_name = "s3",
  json_version = "",
  target_prefix = ""
)

.s3$service <- function(config = list()) {
  handlers <- new_handlers("restxml", "s3")
  new_service(.s3$metadata, handlers, config)
}
