% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_operations.R
\name{s3_put_bucket_lifecycle}
\alias{s3_put_bucket_lifecycle}
\title{For an updated version of this API, see PutBucketLifecycleConfiguration}
\usage{
s3_put_bucket_lifecycle(
  Bucket,
  ContentMD5 = NULL,
  ChecksumAlgorithm = NULL,
  LifecycleConfiguration = NULL,
  ExpectedBucketOwner = NULL
)
}
\arguments{
\item{Bucket}{[required]}

\item{ContentMD5}{For requests made using the Amazon Web Services Command Line Interface
(CLI) or Amazon Web Services SDKs, this field is calculated
automatically.}

\item{ChecksumAlgorithm}{Indicates the algorithm used to create the checksum for the object when
using the SDK. This header will not provide any additional functionality
if not using the SDK. When sending this header, there must be a
corresponding \code{x-amz-checksum} or \code{x-amz-trailer} header sent.
Otherwise, Amazon S3 fails the request with the HTTP status code
\verb{400 Bad Request}. For more information, see \href{https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html}{Checking object integrity}
in the \emph{Amazon S3 User Guide}.

If you provide an individual checksum, Amazon S3 ignores any provided
\code{ChecksumAlgorithm} parameter.}

\item{LifecycleConfiguration}{}

\item{ExpectedBucketOwner}{The account ID of the expected bucket owner. If the bucket is owned by a
different account, the request fails with the HTTP status code
\verb{403 Forbidden} (access denied).}
}
\description{
For an updated version of this API, see \code{\link[=s3_put_bucket_lifecycle_configuration]{put_bucket_lifecycle_configuration}}. This version has been deprecated. Existing lifecycle configurations will work. For new lifecycle configurations, use the updated API.

See \url{https://www.paws-r-sdk.com/docs/s3_put_bucket_lifecycle/} for full documentation.
}
\keyword{internal}
