% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3control_operations.R
\name{s3control_list_regional_buckets}
\alias{s3control_list_regional_buckets}
\title{Returns a list of all Outposts buckets in an Outpost that are owned by
the authenticated sender of the request}
\usage{
s3control_list_regional_buckets(
  AccountId,
  NextToken = NULL,
  MaxResults = NULL,
  OutpostId = NULL
)
}
\arguments{
\item{AccountId}{[required] The Amazon Web Services account ID of the Outposts bucket.}

\item{NextToken}{}

\item{MaxResults}{}

\item{OutpostId}{The ID of the Outposts resource.

This ID is required by Amazon S3 on Outposts buckets.}
}
\description{
Returns a list of all Outposts buckets in an Outpost that are owned by the authenticated sender of the request. For more information, see \href{https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html}{Using Amazon S3 on Outposts} in the \emph{Amazon S3 User Guide}.

See \url{https://www.paws-r-sdk.com/docs/s3control_list_regional_buckets/} for full documentation.
}
\keyword{internal}
