# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include s3_service.R
NULL

#' This action aborts a multipart upload
#'
#' @description
#' This action aborts a multipart upload. After a multipart upload is aborted, no additional parts can be uploaded using that upload ID. The storage consumed by any previously uploaded parts will be freed. However, if any part uploads are currently in progress, those part uploads might or might not succeed. As a result, it might be necessary to abort a given multipart upload multiple times in order to completely free all storage consumed by all parts.
#'
#' See [https://paws-r.github.io/docs/s3/abort_multipart_upload.html](https://paws-r.github.io/docs/s3/abort_multipart_upload.html) for full documentation.
#'
#' @param Bucket &#91;required&#93; The bucket name to which the upload was taking place.
#' 
#' When using this action with an access point, you must direct requests to
#' the access point hostname. The access point hostname takes the form
#' *AccessPointName*-*AccountId*.s3-accesspoint.*Region*.amazonaws.com.
#' When using this action with an access point through the Amazon Web
#' Services SDKs, you provide the access point ARN in place of the bucket
#' name. For more information about access point ARNs, see [Using access
#' points](https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html)
#' in the *Amazon S3 User Guide*.
#' 
#' When using this action with Amazon S3 on Outposts, you must direct
#' requests to the S3 on Outposts hostname. The S3 on Outposts hostname
#' takes the form
#' ` AccessPointName-AccountId.outpostID.s3-outposts.Region.amazonaws.com`.
#' When using this action with S3 on Outposts through the Amazon Web
#' Services SDKs, you provide the Outposts bucket ARN in place of the
#' bucket name. For more information about S3 on Outposts ARNs, see [Using
#' Amazon S3 on
#' Outposts](https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html)
#' in the *Amazon S3 User Guide*.
#' @param Key &#91;required&#93; Key of the object for which the multipart upload was initiated.
#' @param UploadId &#91;required&#93; Upload ID that identifies the multipart upload.
#' @param RequestPayer 
#' @param ExpectedBucketOwner The account ID of the expected bucket owner. If the bucket is owned by a
#' different account, the request fails with the HTTP status code
#' `403 Forbidden` (access denied).
#'
#' @keywords internal
#'
#' @rdname s3_abort_multipart_upload
s3_abort_multipart_upload <- function(Bucket, Key, UploadId, RequestPayer = NULL, ExpectedBucketOwner = NULL) {
  op <- new_operation(
    name = "AbortMultipartUpload",
    http_method = "DELETE",
    http_path = "/{Bucket}/{Key+}",
    paginator = list()
  )
  input <- .s3$abort_multipart_upload_input(Bucket = Bucket, Key = Key, UploadId = UploadId, RequestPayer = RequestPayer, ExpectedBucketOwner = ExpectedBucketOwner)
  output <- .s3$abort_multipart_upload_output()
  config <- get_config()
  svc <- .s3$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$abort_multipart_upload <- s3_abort_multipart_upload

#' Completes a multipart upload by assembling previously uploaded parts
#'
#' @description
#' Completes a multipart upload by assembling previously uploaded parts.
#'
#' See [https://paws-r.github.io/docs/s3/complete_multipart_upload.html](https://paws-r.github.io/docs/s3/complete_multipart_upload.html) for full documentation.
#'
#' @param Bucket &#91;required&#93; Name of the bucket to which the multipart upload was initiated.
#' 
#' When using this action with an access point, you must direct requests to
#' the access point hostname. The access point hostname takes the form
#' *AccessPointName*-*AccountId*.s3-accesspoint.*Region*.amazonaws.com.
#' When using this action with an access point through the Amazon Web
#' Services SDKs, you provide the access point ARN in place of the bucket
#' name. For more information about access point ARNs, see [Using access
#' points](https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html)
#' in the *Amazon S3 User Guide*.
#' 
#' When using this action with Amazon S3 on Outposts, you must direct
#' requests to the S3 on Outposts hostname. The S3 on Outposts hostname
#' takes the form
#' ` AccessPointName-AccountId.outpostID.s3-outposts.Region.amazonaws.com`.
#' When using this action with S3 on Outposts through the Amazon Web
#' Services SDKs, you provide the Outposts bucket ARN in place of the
#' bucket name. For more information about S3 on Outposts ARNs, see [Using
#' Amazon S3 on
#' Outposts](https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html)
#' in the *Amazon S3 User Guide*.
#' @param Key &#91;required&#93; Object key for which the multipart upload was initiated.
#' @param MultipartUpload The container for the multipart upload request information.
#' @param UploadId &#91;required&#93; ID for the initiated multipart upload.
#' @param ChecksumCRC32 This header can be used as a data integrity check to verify that the
#' data received is the same data that was originally sent. This header
#' specifies the base64-encoded, 32-bit CRC32 checksum of the object. For
#' more information, see [Checking object
#' integrity](https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html)
#' in the *Amazon S3 User Guide*.
#' @param ChecksumCRC32C This header can be used as a data integrity check to verify that the
#' data received is the same data that was originally sent. This header
#' specifies the base64-encoded, 32-bit CRC32C checksum of the object. For
#' more information, see [Checking object
#' integrity](https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html)
#' in the *Amazon S3 User Guide*.
#' @param ChecksumSHA1 This header can be used as a data integrity check to verify that the
#' data received is the same data that was originally sent. This header
#' specifies the base64-encoded, 160-bit SHA-1 digest of the object. For
#' more information, see [Checking object
#' integrity](https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html)
#' in the *Amazon S3 User Guide*.
#' @param ChecksumSHA256 This header can be used as a data integrity check to verify that the
#' data received is the same data that was originally sent. This header
#' specifies the base64-encoded, 256-bit SHA-256 digest of the object. For
#' more information, see [Checking object
#' integrity](https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html)
#' in the *Amazon S3 User Guide*.
#' @param RequestPayer 
#' @param ExpectedBucketOwner The account ID of the expected bucket owner. If the bucket is owned by a
#' different account, the request fails with the HTTP status code
#' `403 Forbidden` (access denied).
#' @param SSECustomerAlgorithm The server-side encryption (SSE) algorithm used to encrypt the object.
#' This parameter is needed only when the object was created using a
#' checksum algorithm. For more information, see [Protecting data using
#' SSE-C
#' keys](https://docs.aws.amazon.com/AmazonS3/latest/userguide/ServerSideEncryptionCustomerKeys.html)
#' in the *Amazon S3 User Guide*.
#' @param SSECustomerKey The server-side encryption (SSE) customer managed key. This parameter is
#' needed only when the object was created using a checksum algorithm. For
#' more information, see [Protecting data using SSE-C
#' keys](https://docs.aws.amazon.com/AmazonS3/latest/userguide/ServerSideEncryptionCustomerKeys.html)
#' in the *Amazon S3 User Guide*.
#' @param SSECustomerKeyMD5 The MD5 server-side encryption (SSE) customer managed key. This
#' parameter is needed only when the object was created using a checksum
#' algorithm. For more information, see [Protecting data using SSE-C
#' keys](https://docs.aws.amazon.com/AmazonS3/latest/userguide/ServerSideEncryptionCustomerKeys.html)
#' in the *Amazon S3 User Guide*.
#'
#' @keywords internal
#'
#' @rdname s3_complete_multipart_upload
s3_complete_multipart_upload <- function(Bucket, Key, MultipartUpload = NULL, UploadId, ChecksumCRC32 = NULL, ChecksumCRC32C = NULL, ChecksumSHA1 = NULL, ChecksumSHA256 = NULL, RequestPayer = NULL, ExpectedBucketOwner = NULL, SSECustomerAlgorithm = NULL, SSECustomerKey = NULL, SSECustomerKeyMD5 = NULL) {
  op <- new_operation(
    name = "CompleteMultipartUpload",
    http_method = "POST",
    http_path = "/{Bucket}/{Key+}",
    paginator = list()
  )
  input <- .s3$complete_multipart_upload_input(Bucket = Bucket, Key = Key, MultipartUpload = MultipartUpload, UploadId = UploadId, ChecksumCRC32 = ChecksumCRC32, ChecksumCRC32C = ChecksumCRC32C, ChecksumSHA1 = ChecksumSHA1, ChecksumSHA256 = ChecksumSHA256, RequestPayer = RequestPayer, ExpectedBucketOwner = ExpectedBucketOwner, SSECustomerAlgorithm = SSECustomerAlgorithm, SSECustomerKey = SSECustomerKey, SSECustomerKeyMD5 = SSECustomerKeyMD5)
  output <- .s3$complete_multipart_upload_output()
  config <- get_config()
  svc <- .s3$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$complete_multipart_upload <- s3_complete_multipart_upload

#' Creates a copy of an object that is already stored in Amazon S3
#'
#' @description
#' Creates a copy of an object that is already stored in Amazon S3.
#'
#' See [https://paws-r.github.io/docs/s3/copy_object.html](https://paws-r.github.io/docs/s3/copy_object.html) for full documentation.
#'
#' @param ACL The canned ACL to apply to the object.
#' 
#' This action is not supported by Amazon S3 on Outposts.
#' @param Bucket &#91;required&#93; The name of the destination bucket.
#' 
#' When using this action with an access point, you must direct requests to
#' the access point hostname. The access point hostname takes the form
#' *AccessPointName*-*AccountId*.s3-accesspoint.*Region*.amazonaws.com.
#' When using this action with an access point through the Amazon Web
#' Services SDKs, you provide the access point ARN in place of the bucket
#' name. For more information about access point ARNs, see [Using access
#' points](https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html)
#' in the *Amazon S3 User Guide*.
#' 
#' When using this action with Amazon S3 on Outposts, you must direct
#' requests to the S3 on Outposts hostname. The S3 on Outposts hostname
#' takes the form
#' ` AccessPointName-AccountId.outpostID.s3-outposts.Region.amazonaws.com`.
#' When using this action with S3 on Outposts through the Amazon Web
#' Services SDKs, you provide the Outposts bucket ARN in place of the
#' bucket name. For more information about S3 on Outposts ARNs, see [Using
#' Amazon S3 on
#' Outposts](https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html)
#' in the *Amazon S3 User Guide*.
#' @param CacheControl Specifies caching behavior along the request/reply chain.
#' @param ChecksumAlgorithm Indicates the algorithm you want Amazon S3 to use to create the checksum
#' for the object. For more information, see [Checking object
#' integrity](https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html)
#' in the *Amazon S3 User Guide*.
#' @param ContentDisposition Specifies presentational information for the object.
#' @param ContentEncoding Specifies what content encodings have been applied to the object and
#' thus what decoding mechanisms must be applied to obtain the media-type
#' referenced by the Content-Type header field.
#' @param ContentLanguage The language the content is in.
#' @param ContentType A standard MIME type describing the format of the object data.
#' @param CopySource &#91;required&#93; Specifies the source object for the copy operation. You specify the
#' value in one of two formats, depending on whether you want to access the
#' source object through an [access
#' point](https://docs.aws.amazon.com/AmazonS3/latest/userguide/access-points.html):
#' 
#' -   For objects not accessed through an access point, specify the name
#'     of the source bucket and the key of the source object, separated by
#'     a slash (/). For example, to copy the object `reports/january.pdf`
#'     from the bucket `awsexamplebucket`, use
#'     `awsexamplebucket/reports/january.pdf`. The value must be
#'     URL-encoded.
#' 
#' -   For objects accessed through access points, specify the Amazon
#'     Resource Name (ARN) of the object as accessed through the access
#'     point, in the format
#'     `arn:aws:s3:<Region>:<account-id>:accesspoint/<access-point-name>/object/<key>`.
#'     For example, to copy the object `reports/january.pdf` through access
#'     point `my-access-point` owned by account `123456789012` in Region
#'     `us-west-2`, use the URL encoding of
#'     `arn:aws:s3:us-west-2:123456789012:accesspoint/my-access-point/object/reports/january.pdf`.
#'     The value must be URL encoded.
#' 
#'     Amazon S3 supports copy operations using access points only when the
#'     source and destination buckets are in the same Amazon Web Services
#'     Region.
#' 
#'     Alternatively, for objects accessed through Amazon S3 on Outposts,
#'     specify the ARN of the object as accessed in the format
#'     `arn:aws:s3-outposts:<Region>:<account-id>:outpost/<outpost-id>/object/<key>`.
#'     For example, to copy the object `reports/january.pdf` through
#'     outpost `my-outpost` owned by account `123456789012` in Region
#'     `us-west-2`, use the URL encoding of
#'     `arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/object/reports/january.pdf`.
#'     The value must be URL-encoded.
#' 
#' To copy a specific version of an object, append
#' `?versionId=<version-id>` to the value (for example,
#' `awsexamplebucket/reports/january.pdf?versionId=QUpfdndhfd8438MNFDN93jdnJFkdmqnh893`).
#' If you don't specify a version ID, Amazon S3 copies the latest version
#' of the source object.
#' @param CopySourceIfMatch Copies the object if its entity tag (ETag) matches the specified tag.
#' @param CopySourceIfModifiedSince Copies the object if it has been modified since the specified time.
#' @param CopySourceIfNoneMatch Copies the object if its entity tag (ETag) is different than the
#' specified ETag.
#' @param CopySourceIfUnmodifiedSince Copies the object if it hasn't been modified since the specified time.
#' @param Expires The date and time at which the object is no longer cacheable.
#' @param GrantFullControl Gives the grantee READ, READ_ACP, and WRITE_ACP permissions on the
#' object.
#' 
#' This action is not supported by Amazon S3 on Outposts.
#' @param GrantRead Allows grantee to read the object data and its metadata.
#' 
#' This action is not supported by Amazon S3 on Outposts.
#' @param GrantReadACP Allows grantee to read the object ACL.
#' 
#' This action is not supported by Amazon S3 on Outposts.
#' @param GrantWriteACP Allows grantee to write the ACL for the applicable object.
#' 
#' This action is not supported by Amazon S3 on Outposts.
#' @param Key &#91;required&#93; The key of the destination object.
#' @param Metadata A map of metadata to store with the object in S3.
#' @param MetadataDirective Specifies whether the metadata is copied from the source object or
#' replaced with metadata provided in the request.
#' @param TaggingDirective Specifies whether the object tag-set are copied from the source object
#' or replaced with tag-set provided in the request.
#' @param ServerSideEncryption The server-side encryption algorithm used when storing this object in
#' Amazon S3 (for example, AES256, aws:kms).
#' @param StorageClass By default, Amazon S3 uses the STANDARD Storage Class to store newly
#' created objects. The STANDARD storage class provides high durability and
#' high availability. Depending on performance needs, you can specify a
#' different Storage Class. Amazon S3 on Outposts only uses the OUTPOSTS
#' Storage Class. For more information, see [Storage
#' Classes](https://docs.aws.amazon.com/AmazonS3/latest/userguide/storage-class-intro.html)
#' in the *Amazon S3 User Guide*.
#' @param WebsiteRedirectLocation If the bucket is configured as a website, redirects requests for this
#' object to another object in the same bucket or to an external URL.
#' Amazon S3 stores the value of this header in the object metadata.
#' @param SSECustomerAlgorithm Specifies the algorithm to use to when encrypting the object (for
#' example, AES256).
#' @param SSECustomerKey Specifies the customer-provided encryption key for Amazon S3 to use in
#' encrypting data. This value is used to store the object and then it is
#' discarded; Amazon S3 does not store the encryption key. The key must be
#' appropriate for use with the algorithm specified in the
#' `x-amz-server-side-encryption-customer-algorithm` header.
#' @param SSECustomerKeyMD5 Specifies the 128-bit MD5 digest of the encryption key according to RFC
#' 1321. Amazon S3 uses this header for a message integrity check to ensure
#' that the encryption key was transmitted without error.
#' @param SSEKMSKeyId Specifies the Amazon Web Services KMS key ID to use for object
#' encryption. All GET and PUT requests for an object protected by Amazon
#' Web Services KMS will fail if not made via SSL or using SigV4. For
#' information about configuring using any of the officially supported
#' Amazon Web Services SDKs and Amazon Web Services CLI, see [Specifying
#' the Signature Version in Request
#' Authentication](https://docs.aws.amazon.com/AmazonS3/latest/userguide/UsingAWSSDK.html#specify-signature-version)
#' in the *Amazon S3 User Guide*.
#' @param SSEKMSEncryptionContext Specifies the Amazon Web Services KMS Encryption Context to use for
#' object encryption. The value of this header is a base64-encoded UTF-8
#' string holding JSON with the encryption context key-value pairs.
#' @param BucketKeyEnabled Specifies whether Amazon S3 should use an S3 Bucket Key for object
#' encryption with server-side encryption using AWS KMS (SSE-KMS). Setting
#' this header to `true` causes Amazon S3 to use an S3 Bucket Key for
#' object encryption with SSE-KMS.
#' 
#' Specifying this header with a COPY action doesn’t affect bucket-level
#' settings for S3 Bucket Key.
#' @param CopySourceSSECustomerAlgorithm Specifies the algorithm to use when decrypting the source object (for
#' example, AES256).
#' @param CopySourceSSECustomerKey Specifies the customer-provided encryption key for Amazon S3 to use to
#' decrypt the source object. The encryption key provided in this header
#' must be one that was used when the source object was created.
#' @param CopySourceSSECustomerKeyMD5 Specifies the 128-bit MD5 digest of the encryption key according to RFC
#' 1321. Amazon S3 uses this header for a message integrity check to ensure
#' that the encryption key was transmitted without error.
#' @param RequestPayer 
#' @param Tagging The tag-set for the object destination object this value must be used in
#' conjunction with the `TaggingDirective`. The tag-set must be encoded as
#' URL Query parameters.
#' @param ObjectLockMode The Object Lock mode that you want to apply to the copied object.
#' @param ObjectLockRetainUntilDate The date and time when you want the copied object's Object Lock to
#' expire.
#' @param ObjectLockLegalHoldStatus Specifies whether you want to apply a legal hold to the copied object.
#' @param ExpectedBucketOwner The account ID of the expected destination bucket owner. If the
#' destination bucket is owned by a different account, the request fails
#' with the HTTP status code `403 Forbidden` (access denied).
#' @param ExpectedSourceBucketOwner The account ID of the expected source bucket owner. If the source bucket
#' is owned by a different account, the request fails with the HTTP status
#' code `403 Forbidden` (access denied).
#'
#' @keywords internal
#'
#' @rdname s3_copy_object
s3_copy_object <- function(ACL = NULL, Bucket, CacheControl = NULL, ChecksumAlgorithm = NULL, ContentDisposition = NULL, ContentEncoding = NULL, ContentLanguage = NULL, ContentType = NULL, CopySource, CopySourceIfMatch = NULL, CopySourceIfModifiedSince = NULL, CopySourceIfNoneMatch = NULL, CopySourceIfUnmodifiedSince = NULL, Expires = NULL, GrantFullControl = NULL, GrantRead = NULL, GrantReadACP = NULL, GrantWriteACP = NULL, Key, Metadata = NULL, MetadataDirective = NULL, TaggingDirective = NULL, ServerSideEncryption = NULL, StorageClass = NULL, WebsiteRedirectLocation = NULL, SSECustomerAlgorithm = NULL, SSECustomerKey = NULL, SSECustomerKeyMD5 = NULL, SSEKMSKeyId = NULL, SSEKMSEncryptionContext = NULL, BucketKeyEnabled = NULL, CopySourceSSECustomerAlgorithm = NULL, CopySourceSSECustomerKey = NULL, CopySourceSSECustomerKeyMD5 = NULL, RequestPayer = NULL, Tagging = NULL, ObjectLockMode = NULL, ObjectLockRetainUntilDate = NULL, ObjectLockLegalHoldStatus = NULL, ExpectedBucketOwner = NULL, ExpectedSourceBucketOwner = NULL) {
  op <- new_operation(
    name = "CopyObject",
    http_method = "PUT",
    http_path = "/{Bucket}/{Key+}",
    paginator = list()
  )
  input <- .s3$copy_object_input(ACL = ACL, Bucket = Bucket, CacheControl = CacheControl, ChecksumAlgorithm = ChecksumAlgorithm, ContentDisposition = ContentDisposition, ContentEncoding = ContentEncoding, ContentLanguage = ContentLanguage, ContentType = ContentType, CopySource = CopySource, CopySourceIfMatch = CopySourceIfMatch, CopySourceIfModifiedSince = CopySourceIfModifiedSince, CopySourceIfNoneMatch = CopySourceIfNoneMatch, CopySourceIfUnmodifiedSince = CopySourceIfUnmodifiedSince, Expires = Expires, GrantFullControl = GrantFullControl, GrantRead = GrantRead, GrantReadACP = GrantReadACP, GrantWriteACP = GrantWriteACP, Key = Key, Metadata = Metadata, MetadataDirective = MetadataDirective, TaggingDirective = TaggingDirective, ServerSideEncryption = ServerSideEncryption, StorageClass = StorageClass, WebsiteRedirectLocation = WebsiteRedirectLocation, SSECustomerAlgorithm = SSECustomerAlgorithm, SSECustomerKey = SSECustomerKey, SSECustomerKeyMD5 = SSECustomerKeyMD5, SSEKMSKeyId = SSEKMSKeyId, SSEKMSEncryptionContext = SSEKMSEncryptionContext, BucketKeyEnabled = BucketKeyEnabled, CopySourceSSECustomerAlgorithm = CopySourceSSECustomerAlgorithm, CopySourceSSECustomerKey = CopySourceSSECustomerKey, CopySourceSSECustomerKeyMD5 = CopySourceSSECustomerKeyMD5, RequestPayer = RequestPayer, Tagging = Tagging, ObjectLockMode = ObjectLockMode, ObjectLockRetainUntilDate = ObjectLockRetainUntilDate, ObjectLockLegalHoldStatus = ObjectLockLegalHoldStatus, ExpectedBucketOwner = ExpectedBucketOwner, ExpectedSourceBucketOwner = ExpectedSourceBucketOwner)
  output <- .s3$copy_object_output()
  config <- get_config()
  svc <- .s3$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$copy_object <- s3_copy_object

#' Creates a new S3 bucket
#'
#' @description
#' Creates a new S3 bucket. To create a bucket, you must register with Amazon S3 and have a valid Amazon Web Services Access Key ID to authenticate requests. Anonymous requests are never allowed to create buckets. By creating the bucket, you become the bucket owner.
#'
#' See [https://paws-r.github.io/docs/s3/create_bucket.html](https://paws-r.github.io/docs/s3/create_bucket.html) for full documentation.
#'
#' @param ACL The canned ACL to apply to the bucket.
#' @param Bucket &#91;required&#93; The name of the bucket to create.
#' @param CreateBucketConfiguration The configuration information for the bucket.
#' @param GrantFullControl Allows grantee the read, write, read ACP, and write ACP permissions on
#' the bucket.
#' @param GrantRead Allows grantee to list the objects in the bucket.
#' @param GrantReadACP Allows grantee to read the bucket ACL.
#' @param GrantWrite Allows grantee to create new objects in the bucket.
#' 
#' For the bucket and object owners of existing objects, also allows
#' deletions and overwrites of those objects.
#' @param GrantWriteACP Allows grantee to write the ACL for the applicable bucket.
#' @param ObjectLockEnabledForBucket Specifies whether you want S3 Object Lock to be enabled for the new
#' bucket.
#' @param ObjectOwnership 
#'
#' @keywords internal
#'
#' @rdname s3_create_bucket
s3_create_bucket <- function(ACL = NULL, Bucket, CreateBucketConfiguration = NULL, GrantFullControl = NULL, GrantRead = NULL, GrantReadACP = NULL, GrantWrite = NULL, GrantWriteACP = NULL, ObjectLockEnabledForBucket = NULL, ObjectOwnership = NULL) {
  op <- new_operation(
    name = "CreateBucket",
    http_method = "PUT",
    http_path = "/{Bucket}",
    paginator = list()
  )
  input <- .s3$create_bucket_input(ACL = ACL, Bucket = Bucket, CreateBucketConfiguration = CreateBucketConfiguration, GrantFullControl = GrantFullControl, GrantRead = GrantRead, GrantReadACP = GrantReadACP, GrantWrite = GrantWrite, GrantWriteACP = GrantWriteACP, ObjectLockEnabledForBucket = ObjectLockEnabledForBucket, ObjectOwnership = ObjectOwnership)
  output <- .s3$create_bucket_output()
  config <- get_config()
  svc <- .s3$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$create_bucket <- s3_create_bucket

#' This action initiates a multipart upload and returns an upload ID
#'
#' @description
#' This action initiates a multipart upload and returns an upload ID. This upload ID is used to associate all of the parts in the specific multipart upload. You specify this upload ID in each of your subsequent upload part requests (see [`upload_part`][s3_upload_part]). You also include this upload ID in the final request to either complete or abort the multipart upload request.
#'
#' See [https://paws-r.github.io/docs/s3/create_multipart_upload.html](https://paws-r.github.io/docs/s3/create_multipart_upload.html) for full documentation.
#'
#' @param ACL The canned ACL to apply to the object.
#' 
#' This action is not supported by Amazon S3 on Outposts.
#' @param Bucket &#91;required&#93; The name of the bucket to which to initiate the upload
#' 
#' When using this action with an access point, you must direct requests to
#' the access point hostname. The access point hostname takes the form
#' *AccessPointName*-*AccountId*.s3-accesspoint.*Region*.amazonaws.com.
#' When using this action with an access point through the Amazon Web
#' Services SDKs, you provide the access point ARN in place of the bucket
#' name. For more information about access point ARNs, see [Using access
#' points](https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html)
#' in the *Amazon S3 User Guide*.
#' 
#' When using this action with Amazon S3 on Outposts, you must direct
#' requests to the S3 on Outposts hostname. The S3 on Outposts hostname
#' takes the form
#' ` AccessPointName-AccountId.outpostID.s3-outposts.Region.amazonaws.com`.
#' When using this action with S3 on Outposts through the Amazon Web
#' Services SDKs, you provide the Outposts bucket ARN in place of the
#' bucket name. For more information about S3 on Outposts ARNs, see [Using
#' Amazon S3 on
#' Outposts](https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html)
#' in the *Amazon S3 User Guide*.
#' @param CacheControl Specifies caching behavior along the request/reply chain.
#' @param ContentDisposition Specifies presentational information for the object.
#' @param ContentEncoding Specifies what content encodings have been applied to the object and
#' thus what decoding mechanisms must be applied to obtain the media-type
#' referenced by the Content-Type header field.
#' @param ContentLanguage The language the content is in.
#' @param ContentType A standard MIME type describing the format of the object data.
#' @param Expires The date and time at which the object is no longer cacheable.
#' @param GrantFullControl Gives the grantee READ, READ_ACP, and WRITE_ACP permissions on the
#' object.
#' 
#' This action is not supported by Amazon S3 on Outposts.
#' @param GrantRead Allows grantee to read the object data and its metadata.
#' 
#' This action is not supported by Amazon S3 on Outposts.
#' @param GrantReadACP Allows grantee to read the object ACL.
#' 
#' This action is not supported by Amazon S3 on Outposts.
#' @param GrantWriteACP Allows grantee to write the ACL for the applicable object.
#' 
#' This action is not supported by Amazon S3 on Outposts.
#' @param Key &#91;required&#93; Object key for which the multipart upload is to be initiated.
#' @param Metadata A map of metadata to store with the object in S3.
#' @param ServerSideEncryption The server-side encryption algorithm used when storing this object in
#' Amazon S3 (for example, AES256, aws:kms).
#' @param StorageClass By default, Amazon S3 uses the STANDARD Storage Class to store newly
#' created objects. The STANDARD storage class provides high durability and
#' high availability. Depending on performance needs, you can specify a
#' different Storage Class. Amazon S3 on Outposts only uses the OUTPOSTS
#' Storage Class. For more information, see [Storage
#' Classes](https://docs.aws.amazon.com/AmazonS3/latest/userguide/storage-class-intro.html)
#' in the *Amazon S3 User Guide*.
#' @param WebsiteRedirectLocation If the bucket is configured as a website, redirects requests for this
#' object to another object in the same bucket or to an external URL.
#' Amazon S3 stores the value of this header in the object metadata.
#' @param SSECustomerAlgorithm Specifies the algorithm to use to when encrypting the object (for
#' example, AES256).
#' @param SSECustomerKey Specifies the customer-provided encryption key for Amazon S3 to use in
#' encrypting data. This value is used to store the object and then it is
#' discarded; Amazon S3 does not store the encryption key. The key must be
#' appropriate for use with the algorithm specified in the
#' `x-amz-server-side-encryption-customer-algorithm` header.
#' @param SSECustomerKeyMD5 Specifies the 128-bit MD5 digest of the encryption key according to RFC
#' 1321. Amazon S3 uses this header for a message integrity check to ensure
#' that the encryption key was transmitted without error.
#' @param SSEKMSKeyId Specifies the ID of the symmetric customer managed key to use for object
#' encryption. All GET and PUT requests for an object protected by Amazon
#' Web Services KMS will fail if not made via SSL or using SigV4. For
#' information about configuring using any of the officially supported
#' Amazon Web Services SDKs and Amazon Web Services CLI, see [Specifying
#' the Signature Version in Request
#' Authentication](https://docs.aws.amazon.com/AmazonS3/latest/userguide/UsingAWSSDK.html#specify-signature-version)
#' in the *Amazon S3 User Guide*.
#' @param SSEKMSEncryptionContext Specifies the Amazon Web Services KMS Encryption Context to use for
#' object encryption. The value of this header is a base64-encoded UTF-8
#' string holding JSON with the encryption context key-value pairs.
#' @param BucketKeyEnabled Specifies whether Amazon S3 should use an S3 Bucket Key for object
#' encryption with server-side encryption using AWS KMS (SSE-KMS). Setting
#' this header to `true` causes Amazon S3 to use an S3 Bucket Key for
#' object encryption with SSE-KMS.
#' 
#' Specifying this header with an object action doesn’t affect bucket-level
#' settings for S3 Bucket Key.
#' @param RequestPayer 
#' @param Tagging The tag-set for the object. The tag-set must be encoded as URL Query
#' parameters.
#' @param ObjectLockMode Specifies the Object Lock mode that you want to apply to the uploaded
#' object.
#' @param ObjectLockRetainUntilDate Specifies the date and time when you want the Object Lock to expire.
#' @param ObjectLockLegalHoldStatus Specifies whether you want to apply a legal hold to the uploaded object.
#' @param ExpectedBucketOwner The account ID of the expected bucket owner. If the bucket is owned by a
#' different account, the request fails with the HTTP status code
#' `403 Forbidden` (access denied).
#' @param ChecksumAlgorithm Indicates the algorithm you want Amazon S3 to use to create the checksum
#' for the object. For more information, see [Checking object
#' integrity](https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html)
#' in the *Amazon S3 User Guide*.
#'
#' @keywords internal
#'
#' @rdname s3_create_multipart_upload
s3_create_multipart_upload <- function(ACL = NULL, Bucket, CacheControl = NULL, ContentDisposition = NULL, ContentEncoding = NULL, ContentLanguage = NULL, ContentType = NULL, Expires = NULL, GrantFullControl = NULL, GrantRead = NULL, GrantReadACP = NULL, GrantWriteACP = NULL, Key, Metadata = NULL, ServerSideEncryption = NULL, StorageClass = NULL, WebsiteRedirectLocation = NULL, SSECustomerAlgorithm = NULL, SSECustomerKey = NULL, SSECustomerKeyMD5 = NULL, SSEKMSKeyId = NULL, SSEKMSEncryptionContext = NULL, BucketKeyEnabled = NULL, RequestPayer = NULL, Tagging = NULL, ObjectLockMode = NULL, ObjectLockRetainUntilDate = NULL, ObjectLockLegalHoldStatus = NULL, ExpectedBucketOwner = NULL, ChecksumAlgorithm = NULL) {
  op <- new_operation(
    name = "CreateMultipartUpload",
    http_method = "POST",
    http_path = "/{Bucket}/{Key+}?uploads",
    paginator = list()
  )
  input <- .s3$create_multipart_upload_input(ACL = ACL, Bucket = Bucket, CacheControl = CacheControl, ContentDisposition = ContentDisposition, ContentEncoding = ContentEncoding, ContentLanguage = ContentLanguage, ContentType = ContentType, Expires = Expires, GrantFullControl = GrantFullControl, GrantRead = GrantRead, GrantReadACP = GrantReadACP, GrantWriteACP = GrantWriteACP, Key = Key, Metadata = Metadata, ServerSideEncryption = ServerSideEncryption, StorageClass = StorageClass, WebsiteRedirectLocation = WebsiteRedirectLocation, SSECustomerAlgorithm = SSECustomerAlgorithm, SSECustomerKey = SSECustomerKey, SSECustomerKeyMD5 = SSECustomerKeyMD5, SSEKMSKeyId = SSEKMSKeyId, SSEKMSEncryptionContext = SSEKMSEncryptionContext, BucketKeyEnabled = BucketKeyEnabled, RequestPayer = RequestPayer, Tagging = Tagging, ObjectLockMode = ObjectLockMode, ObjectLockRetainUntilDate = ObjectLockRetainUntilDate, ObjectLockLegalHoldStatus = ObjectLockLegalHoldStatus, ExpectedBucketOwner = ExpectedBucketOwner, ChecksumAlgorithm = ChecksumAlgorithm)
  output <- .s3$create_multipart_upload_output()
  config <- get_config()
  svc <- .s3$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$create_multipart_upload <- s3_create_multipart_upload

#' Deletes the S3 bucket
#'
#' @description
#' Deletes the S3 bucket. All objects (including all object versions and delete markers) in the bucket must be deleted before the bucket itself can be deleted.
#'
#' See [https://paws-r.github.io/docs/s3/delete_bucket.html](https://paws-r.github.io/docs/s3/delete_bucket.html) for full documentation.
#'
#' @param Bucket &#91;required&#93; Specifies the bucket being deleted.
#' @param ExpectedBucketOwner The account ID of the expected bucket owner. If the bucket is owned by a
#' different account, the request fails with the HTTP status code
#' `403 Forbidden` (access denied).
#'
#' @keywords internal
#'
#' @rdname s3_delete_bucket
s3_delete_bucket <- function(Bucket, ExpectedBucketOwner = NULL) {
  op <- new_operation(
    name = "DeleteBucket",
    http_method = "DELETE",
    http_path = "/{Bucket}",
    paginator = list()
  )
  input <- .s3$delete_bucket_input(Bucket = Bucket, ExpectedBucketOwner = ExpectedBucketOwner)
  output <- .s3$delete_bucket_output()
  config <- get_config()
  svc <- .s3$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$delete_bucket <- s3_delete_bucket

#' Deletes an analytics configuration for the bucket (specified by the
#' analytics configuration ID)
#'
#' @description
#' Deletes an analytics configuration for the bucket (specified by the analytics configuration ID).
#'
#' See [https://paws-r.github.io/docs/s3/delete_bucket_analytics_configuration.html](https://paws-r.github.io/docs/s3/delete_bucket_analytics_configuration.html) for full documentation.
#'
#' @param Bucket &#91;required&#93; The name of the bucket from which an analytics configuration is deleted.
#' @param Id &#91;required&#93; The ID that identifies the analytics configuration.
#' @param ExpectedBucketOwner The account ID of the expected bucket owner. If the bucket is owned by a
#' different account, the request fails with the HTTP status code
#' `403 Forbidden` (access denied).
#'
#' @keywords internal
#'
#' @rdname s3_delete_bucket_analytics_configuration
s3_delete_bucket_analytics_configuration <- function(Bucket, Id, ExpectedBucketOwner = NULL) {
  op <- new_operation(
    name = "DeleteBucketAnalyticsConfiguration",
    http_method = "DELETE",
    http_path = "/{Bucket}?analytics",
    paginator = list()
  )
  input <- .s3$delete_bucket_analytics_configuration_input(Bucket = Bucket, Id = Id, ExpectedBucketOwner = ExpectedBucketOwner)
  output <- .s3$delete_bucket_analytics_configuration_output()
  config <- get_config()
  svc <- .s3$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$delete_bucket_analytics_configuration <- s3_delete_bucket_analytics_configuration

#' Deletes the cors configuration information set for the bucket
#'
#' @description
#' Deletes the `cors` configuration information set for the bucket.
#'
#' See [https://paws-r.github.io/docs/s3/delete_bucket_cors.html](https://paws-r.github.io/docs/s3/delete_bucket_cors.html) for full documentation.
#'
#' @param Bucket &#91;required&#93; Specifies the bucket whose `cors` configuration is being deleted.
#' @param ExpectedBucketOwner The account ID of the expected bucket owner. If the bucket is owned by a
#' different account, the request fails with the HTTP status code
#' `403 Forbidden` (access denied).
#'
#' @keywords internal
#'
#' @rdname s3_delete_bucket_cors
s3_delete_bucket_cors <- function(Bucket, ExpectedBucketOwner = NULL) {
  op <- new_operation(
    name = "DeleteBucketCors",
    http_method = "DELETE",
    http_path = "/{Bucket}?cors",
    paginator = list()
  )
  input <- .s3$delete_bucket_cors_input(Bucket = Bucket, ExpectedBucketOwner = ExpectedBucketOwner)
  output <- .s3$delete_bucket_cors_output()
  config <- get_config()
  svc <- .s3$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$delete_bucket_cors <- s3_delete_bucket_cors

#' This implementation of the DELETE action removes default encryption from
#' the bucket
#'
#' @description
#' This implementation of the DELETE action removes default encryption from the bucket. For information about the Amazon S3 default encryption feature, see [Amazon S3 Default Bucket Encryption](https://docs.aws.amazon.com/AmazonS3/latest/userguide/bucket-encryption.html) in the *Amazon S3 User Guide*.
#'
#' See [https://paws-r.github.io/docs/s3/delete_bucket_encryption.html](https://paws-r.github.io/docs/s3/delete_bucket_encryption.html) for full documentation.
#'
#' @param Bucket &#91;required&#93; The name of the bucket containing the server-side encryption
#' configuration to delete.
#' @param ExpectedBucketOwner The account ID of the expected bucket owner. If the bucket is owned by a
#' different account, the request fails with the HTTP status code
#' `403 Forbidden` (access denied).
#'
#' @keywords internal
#'
#' @rdname s3_delete_bucket_encryption
s3_delete_bucket_encryption <- function(Bucket, ExpectedBucketOwner = NULL) {
  op <- new_operation(
    name = "DeleteBucketEncryption",
    http_method = "DELETE",
    http_path = "/{Bucket}?encryption",
    paginator = list()
  )
  input <- .s3$delete_bucket_encryption_input(Bucket = Bucket, ExpectedBucketOwner = ExpectedBucketOwner)
  output <- .s3$delete_bucket_encryption_output()
  config <- get_config()
  svc <- .s3$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$delete_bucket_encryption <- s3_delete_bucket_encryption

#' Deletes the S3 Intelligent-Tiering configuration from the specified
#' bucket
#'
#' @description
#' Deletes the S3 Intelligent-Tiering configuration from the specified bucket.
#'
#' See [https://paws-r.github.io/docs/s3/delete_bucket_intelligent_tiering_configuration.html](https://paws-r.github.io/docs/s3/delete_bucket_intelligent_tiering_configuration.html) for full documentation.
#'
#' @param Bucket &#91;required&#93; The name of the Amazon S3 bucket whose configuration you want to modify
#' or retrieve.
#' @param Id &#91;required&#93; The ID used to identify the S3 Intelligent-Tiering configuration.
#'
#' @keywords internal
#'
#' @rdname s3_delete_bucket_intelligent_tiering_configuration
s3_delete_bucket_intelligent_tiering_configuration <- function(Bucket, Id) {
  op <- new_operation(
    name = "DeleteBucketIntelligentTieringConfiguration",
    http_method = "DELETE",
    http_path = "/{Bucket}?intelligent-tiering",
    paginator = list()
  )
  input <- .s3$delete_bucket_intelligent_tiering_configuration_input(Bucket = Bucket, Id = Id)
  output <- .s3$delete_bucket_intelligent_tiering_configuration_output()
  config <- get_config()
  svc <- .s3$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$delete_bucket_intelligent_tiering_configuration <- s3_delete_bucket_intelligent_tiering_configuration

#' Deletes an inventory configuration (identified by the inventory ID) from
#' the bucket
#'
#' @description
#' Deletes an inventory configuration (identified by the inventory ID) from the bucket.
#'
#' See [https://paws-r.github.io/docs/s3/delete_bucket_inventory_configuration.html](https://paws-r.github.io/docs/s3/delete_bucket_inventory_configuration.html) for full documentation.
#'
#' @param Bucket &#91;required&#93; The name of the bucket containing the inventory configuration to delete.
#' @param Id &#91;required&#93; The ID used to identify the inventory configuration.
#' @param ExpectedBucketOwner The account ID of the expected bucket owner. If the bucket is owned by a
#' different account, the request fails with the HTTP status code
#' `403 Forbidden` (access denied).
#'
#' @keywords internal
#'
#' @rdname s3_delete_bucket_inventory_configuration
s3_delete_bucket_inventory_configuration <- function(Bucket, Id, ExpectedBucketOwner = NULL) {
  op <- new_operation(
    name = "DeleteBucketInventoryConfiguration",
    http_method = "DELETE",
    http_path = "/{Bucket}?inventory",
    paginator = list()
  )
  input <- .s3$delete_bucket_inventory_configuration_input(Bucket = Bucket, Id = Id, ExpectedBucketOwner = ExpectedBucketOwner)
  output <- .s3$delete_bucket_inventory_configuration_output()
  config <- get_config()
  svc <- .s3$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$delete_bucket_inventory_configuration <- s3_delete_bucket_inventory_configuration

#' Deletes the lifecycle configuration from the specified bucket
#'
#' @description
#' Deletes the lifecycle configuration from the specified bucket. Amazon S3 removes all the lifecycle configuration rules in the lifecycle subresource associated with the bucket. Your objects never expire, and Amazon S3 no longer automatically deletes any objects on the basis of rules contained in the deleted lifecycle configuration.
#'
#' See [https://paws-r.github.io/docs/s3/delete_bucket_lifecycle.html](https://paws-r.github.io/docs/s3/delete_bucket_lifecycle.html) for full documentation.
#'
#' @param Bucket &#91;required&#93; The bucket name of the lifecycle to delete.
#' @param ExpectedBucketOwner The account ID of the expected bucket owner. If the bucket is owned by a
#' different account, the request fails with the HTTP status code
#' `403 Forbidden` (access denied).
#'
#' @keywords internal
#'
#' @rdname s3_delete_bucket_lifecycle
s3_delete_bucket_lifecycle <- function(Bucket, ExpectedBucketOwner = NULL) {
  op <- new_operation(
    name = "DeleteBucketLifecycle",
    http_method = "DELETE",
    http_path = "/{Bucket}?lifecycle",
    paginator = list()
  )
  input <- .s3$delete_bucket_lifecycle_input(Bucket = Bucket, ExpectedBucketOwner = ExpectedBucketOwner)
  output <- .s3$delete_bucket_lifecycle_output()
  config <- get_config()
  svc <- .s3$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$delete_bucket_lifecycle <- s3_delete_bucket_lifecycle

#' Deletes a metrics configuration for the Amazon CloudWatch request
#' metrics (specified by the metrics configuration ID) from the bucket
#'
#' @description
#' Deletes a metrics configuration for the Amazon CloudWatch request metrics (specified by the metrics configuration ID) from the bucket. Note that this doesn't include the daily storage metrics.
#'
#' See [https://paws-r.github.io/docs/s3/delete_bucket_metrics_configuration.html](https://paws-r.github.io/docs/s3/delete_bucket_metrics_configuration.html) for full documentation.
#'
#' @param Bucket &#91;required&#93; The name of the bucket containing the metrics configuration to delete.
#' @param Id &#91;required&#93; The ID used to identify the metrics configuration.
#' @param ExpectedBucketOwner The account ID of the expected bucket owner. If the bucket is owned by a
#' different account, the request fails with the HTTP status code
#' `403 Forbidden` (access denied).
#'
#' @keywords internal
#'
#' @rdname s3_delete_bucket_metrics_configuration
s3_delete_bucket_metrics_configuration <- function(Bucket, Id, ExpectedBucketOwner = NULL) {
  op <- new_operation(
    name = "DeleteBucketMetricsConfiguration",
    http_method = "DELETE",
    http_path = "/{Bucket}?metrics",
    paginator = list()
  )
  input <- .s3$delete_bucket_metrics_configuration_input(Bucket = Bucket, Id = Id, ExpectedBucketOwner = ExpectedBucketOwner)
  output <- .s3$delete_bucket_metrics_configuration_output()
  config <- get_config()
  svc <- .s3$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$delete_bucket_metrics_configuration <- s3_delete_bucket_metrics_configuration

#' Removes OwnershipControls for an Amazon S3 bucket
#'
#' @description
#' Removes `OwnershipControls` for an Amazon S3 bucket. To use this operation, you must have the `s3:PutBucketOwnershipControls` permission. For more information about Amazon S3 permissions, see [Specifying Permissions in a Policy](https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-with-s3-actions.html).
#'
#' See [https://paws-r.github.io/docs/s3/delete_bucket_ownership_controls.html](https://paws-r.github.io/docs/s3/delete_bucket_ownership_controls.html) for full documentation.
#'
#' @param Bucket &#91;required&#93; The Amazon S3 bucket whose `OwnershipControls` you want to delete.
#' @param ExpectedBucketOwner The account ID of the expected bucket owner. If the bucket is owned by a
#' different account, the request fails with the HTTP status code
#' `403 Forbidden` (access denied).
#'
#' @keywords internal
#'
#' @rdname s3_delete_bucket_ownership_controls
s3_delete_bucket_ownership_controls <- function(Bucket, ExpectedBucketOwner = NULL) {
  op <- new_operation(
    name = "DeleteBucketOwnershipControls",
    http_method = "DELETE",
    http_path = "/{Bucket}?ownershipControls",
    paginator = list()
  )
  input <- .s3$delete_bucket_ownership_controls_input(Bucket = Bucket, ExpectedBucketOwner = ExpectedBucketOwner)
  output <- .s3$delete_bucket_ownership_controls_output()
  config <- get_config()
  svc <- .s3$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$delete_bucket_ownership_controls <- s3_delete_bucket_ownership_controls

#' This implementation of the DELETE action uses the policy subresource to
#' delete the policy of a specified bucket
#'
#' @description
#' This implementation of the DELETE action uses the policy subresource to delete the policy of a specified bucket. If you are using an identity other than the root user of the Amazon Web Services account that owns the bucket, the calling identity must have the [`delete_bucket_policy`][s3_delete_bucket_policy] permissions on the specified bucket and belong to the bucket owner's account to use this operation.
#'
#' See [https://paws-r.github.io/docs/s3/delete_bucket_policy.html](https://paws-r.github.io/docs/s3/delete_bucket_policy.html) for full documentation.
#'
#' @param Bucket &#91;required&#93; The bucket name.
#' @param ExpectedBucketOwner The account ID of the expected bucket owner. If the bucket is owned by a
#' different account, the request fails with the HTTP status code
#' `403 Forbidden` (access denied).
#'
#' @keywords internal
#'
#' @rdname s3_delete_bucket_policy
s3_delete_bucket_policy <- function(Bucket, ExpectedBucketOwner = NULL) {
  op <- new_operation(
    name = "DeleteBucketPolicy",
    http_method = "DELETE",
    http_path = "/{Bucket}?policy",
    paginator = list()
  )
  input <- .s3$delete_bucket_policy_input(Bucket = Bucket, ExpectedBucketOwner = ExpectedBucketOwner)
  output <- .s3$delete_bucket_policy_output()
  config <- get_config()
  svc <- .s3$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$delete_bucket_policy <- s3_delete_bucket_policy

#' Deletes the replication configuration from the bucket
#'
#' @description
#' Deletes the replication configuration from the bucket.
#'
#' See [https://paws-r.github.io/docs/s3/delete_bucket_replication.html](https://paws-r.github.io/docs/s3/delete_bucket_replication.html) for full documentation.
#'
#' @param Bucket &#91;required&#93; The bucket name.
#' @param ExpectedBucketOwner The account ID of the expected bucket owner. If the bucket is owned by a
#' different account, the request fails with the HTTP status code
#' `403 Forbidden` (access denied).
#'
#' @keywords internal
#'
#' @rdname s3_delete_bucket_replication
s3_delete_bucket_replication <- function(Bucket, ExpectedBucketOwner = NULL) {
  op <- new_operation(
    name = "DeleteBucketReplication",
    http_method = "DELETE",
    http_path = "/{Bucket}?replication",
    paginator = list()
  )
  input <- .s3$delete_bucket_replication_input(Bucket = Bucket, ExpectedBucketOwner = ExpectedBucketOwner)
  output <- .s3$delete_bucket_replication_output()
  config <- get_config()
  svc <- .s3$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$delete_bucket_replication <- s3_delete_bucket_replication

#' Deletes the tags from the bucket
#'
#' @description
#' Deletes the tags from the bucket.
#'
#' See [https://paws-r.github.io/docs/s3/delete_bucket_tagging.html](https://paws-r.github.io/docs/s3/delete_bucket_tagging.html) for full documentation.
#'
#' @param Bucket &#91;required&#93; The bucket that has the tag set to be removed.
#' @param ExpectedBucketOwner The account ID of the expected bucket owner. If the bucket is owned by a
#' different account, the request fails with the HTTP status code
#' `403 Forbidden` (access denied).
#'
#' @keywords internal
#'
#' @rdname s3_delete_bucket_tagging
s3_delete_bucket_tagging <- function(Bucket, ExpectedBucketOwner = NULL) {
  op <- new_operation(
    name = "DeleteBucketTagging",
    http_method = "DELETE",
    http_path = "/{Bucket}?tagging",
    paginator = list()
  )
  input <- .s3$delete_bucket_tagging_input(Bucket = Bucket, ExpectedBucketOwner = ExpectedBucketOwner)
  output <- .s3$delete_bucket_tagging_output()
  config <- get_config()
  svc <- .s3$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$delete_bucket_tagging <- s3_delete_bucket_tagging

#' This action removes the website configuration for a bucket
#'
#' @description
#' This action removes the website configuration for a bucket. Amazon S3 returns a `200 OK` response upon successfully deleting a website configuration on the specified bucket. You will get a `200 OK` response if the website configuration you are trying to delete does not exist on the bucket. Amazon S3 returns a `404` response if the bucket specified in the request does not exist.
#'
#' See [https://paws-r.github.io/docs/s3/delete_bucket_website.html](https://paws-r.github.io/docs/s3/delete_bucket_website.html) for full documentation.
#'
#' @param Bucket &#91;required&#93; The bucket name for which you want to remove the website configuration.
#' @param ExpectedBucketOwner The account ID of the expected bucket owner. If the bucket is owned by a
#' different account, the request fails with the HTTP status code
#' `403 Forbidden` (access denied).
#'
#' @keywords internal
#'
#' @rdname s3_delete_bucket_website
s3_delete_bucket_website <- function(Bucket, ExpectedBucketOwner = NULL) {
  op <- new_operation(
    name = "DeleteBucketWebsite",
    http_method = "DELETE",
    http_path = "/{Bucket}?website",
    paginator = list()
  )
  input <- .s3$delete_bucket_website_input(Bucket = Bucket, ExpectedBucketOwner = ExpectedBucketOwner)
  output <- .s3$delete_bucket_website_output()
  config <- get_config()
  svc <- .s3$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$delete_bucket_website <- s3_delete_bucket_website

#' Removes the null version (if there is one) of an object and inserts a
#' delete marker, which becomes the latest version of the object
#'
#' @description
#' Removes the null version (if there is one) of an object and inserts a delete marker, which becomes the latest version of the object. If there isn't a null version, Amazon S3 does not remove any objects but will still respond that the command was successful.
#'
#' See [https://paws-r.github.io/docs/s3/delete_object.html](https://paws-r.github.io/docs/s3/delete_object.html) for full documentation.
#'
#' @param Bucket &#91;required&#93; The bucket name of the bucket containing the object.
#' 
#' When using this action with an access point, you must direct requests to
#' the access point hostname. The access point hostname takes the form
#' *AccessPointName*-*AccountId*.s3-accesspoint.*Region*.amazonaws.com.
#' When using this action with an access point through the Amazon Web
#' Services SDKs, you provide the access point ARN in place of the bucket
#' name. For more information about access point ARNs, see [Using access
#' points](https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html)
#' in the *Amazon S3 User Guide*.
#' 
#' When using this action with Amazon S3 on Outposts, you must direct
#' requests to the S3 on Outposts hostname. The S3 on Outposts hostname
#' takes the form
#' ` AccessPointName-AccountId.outpostID.s3-outposts.Region.amazonaws.com`.
#' When using this action with S3 on Outposts through the Amazon Web
#' Services SDKs, you provide the Outposts bucket ARN in place of the
#' bucket name. For more information about S3 on Outposts ARNs, see [Using
#' Amazon S3 on
#' Outposts](https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html)
#' in the *Amazon S3 User Guide*.
#' @param Key &#91;required&#93; Key name of the object to delete.
#' @param MFA The concatenation of the authentication device's serial number, a space,
#' and the value that is displayed on your authentication device. Required
#' to permanently delete a versioned object if versioning is configured
#' with MFA delete enabled.
#' @param VersionId VersionId used to reference a specific version of the object.
#' @param RequestPayer 
#' @param BypassGovernanceRetention Indicates whether S3 Object Lock should bypass Governance-mode
#' restrictions to process this operation. To use this header, you must
#' have the `s3:BypassGovernanceRetention` permission.
#' @param ExpectedBucketOwner The account ID of the expected bucket owner. If the bucket is owned by a
#' different account, the request fails with the HTTP status code
#' `403 Forbidden` (access denied).
#'
#' @keywords internal
#'
#' @rdname s3_delete_object
s3_delete_object <- function(Bucket, Key, MFA = NULL, VersionId = NULL, RequestPayer = NULL, BypassGovernanceRetention = NULL, ExpectedBucketOwner = NULL) {
  op <- new_operation(
    name = "DeleteObject",
    http_method = "DELETE",
    http_path = "/{Bucket}/{Key+}",
    paginator = list()
  )
  input <- .s3$delete_object_input(Bucket = Bucket, Key = Key, MFA = MFA, VersionId = VersionId, RequestPayer = RequestPayer, BypassGovernanceRetention = BypassGovernanceRetention, ExpectedBucketOwner = ExpectedBucketOwner)
  output <- .s3$delete_object_output()
  config <- get_config()
  svc <- .s3$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$delete_object <- s3_delete_object

#' Removes the entire tag set from the specified object
#'
#' @description
#' Removes the entire tag set from the specified object. For more information about managing object tags, see [Object Tagging](https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-tagging.html).
#'
#' See [https://paws-r.github.io/docs/s3/delete_object_tagging.html](https://paws-r.github.io/docs/s3/delete_object_tagging.html) for full documentation.
#'
#' @param Bucket &#91;required&#93; The bucket name containing the objects from which to remove the tags.
#' 
#' When using this action with an access point, you must direct requests to
#' the access point hostname. The access point hostname takes the form
#' *AccessPointName*-*AccountId*.s3-accesspoint.*Region*.amazonaws.com.
#' When using this action with an access point through the Amazon Web
#' Services SDKs, you provide the access point ARN in place of the bucket
#' name. For more information about access point ARNs, see [Using access
#' points](https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html)
#' in the *Amazon S3 User Guide*.
#' 
#' When using this action with Amazon S3 on Outposts, you must direct
#' requests to the S3 on Outposts hostname. The S3 on Outposts hostname
#' takes the form
#' ` AccessPointName-AccountId.outpostID.s3-outposts.Region.amazonaws.com`.
#' When using this action with S3 on Outposts through the Amazon Web
#' Services SDKs, you provide the Outposts bucket ARN in place of the
#' bucket name. For more information about S3 on Outposts ARNs, see [Using
#' Amazon S3 on
#' Outposts](https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html)
#' in the *Amazon S3 User Guide*.
#' @param Key &#91;required&#93; The key that identifies the object in the bucket from which to remove
#' all tags.
#' @param VersionId The versionId of the object that the tag-set will be removed from.
#' @param ExpectedBucketOwner The account ID of the expected bucket owner. If the bucket is owned by a
#' different account, the request fails with the HTTP status code
#' `403 Forbidden` (access denied).
#'
#' @keywords internal
#'
#' @rdname s3_delete_object_tagging
s3_delete_object_tagging <- function(Bucket, Key, VersionId = NULL, ExpectedBucketOwner = NULL) {
  op <- new_operation(
    name = "DeleteObjectTagging",
    http_method = "DELETE",
    http_path = "/{Bucket}/{Key+}?tagging",
    paginator = list()
  )
  input <- .s3$delete_object_tagging_input(Bucket = Bucket, Key = Key, VersionId = VersionId, ExpectedBucketOwner = ExpectedBucketOwner)
  output <- .s3$delete_object_tagging_output()
  config <- get_config()
  svc <- .s3$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$delete_object_tagging <- s3_delete_object_tagging

#' This action enables you to delete multiple objects from a bucket using a
#' single HTTP request
#'
#' @description
#' This action enables you to delete multiple objects from a bucket using a single HTTP request. If you know the object keys that you want to delete, then this action provides a suitable alternative to sending individual delete requests, reducing per-request overhead.
#'
#' See [https://paws-r.github.io/docs/s3/delete_objects.html](https://paws-r.github.io/docs/s3/delete_objects.html) for full documentation.
#'
#' @param Bucket &#91;required&#93; The bucket name containing the objects to delete.
#' 
#' When using this action with an access point, you must direct requests to
#' the access point hostname. The access point hostname takes the form
#' *AccessPointName*-*AccountId*.s3-accesspoint.*Region*.amazonaws.com.
#' When using this action with an access point through the Amazon Web
#' Services SDKs, you provide the access point ARN in place of the bucket
#' name. For more information about access point ARNs, see [Using access
#' points](https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html)
#' in the *Amazon S3 User Guide*.
#' 
#' When using this action with Amazon S3 on Outposts, you must direct
#' requests to the S3 on Outposts hostname. The S3 on Outposts hostname
#' takes the form
#' ` AccessPointName-AccountId.outpostID.s3-outposts.Region.amazonaws.com`.
#' When using this action with S3 on Outposts through the Amazon Web
#' Services SDKs, you provide the Outposts bucket ARN in place of the
#' bucket name. For more information about S3 on Outposts ARNs, see [Using
#' Amazon S3 on
#' Outposts](https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html)
#' in the *Amazon S3 User Guide*.
#' @param Delete &#91;required&#93; Container for the request.
#' @param MFA The concatenation of the authentication device's serial number, a space,
#' and the value that is displayed on your authentication device. Required
#' to permanently delete a versioned object if versioning is configured
#' with MFA delete enabled.
#' @param RequestPayer 
#' @param BypassGovernanceRetention Specifies whether you want to delete this object even if it has a
#' Governance-type Object Lock in place. To use this header, you must have
#' the `s3:BypassGovernanceRetention` permission.
#' @param ExpectedBucketOwner The account ID of the expected bucket owner. If the bucket is owned by a
#' different account, the request fails with the HTTP status code
#' `403 Forbidden` (access denied).
#' @param ChecksumAlgorithm Indicates the algorithm used to create the checksum for the object when
#' using the SDK. This header will not provide any additional functionality
#' if not using the SDK. When sending this header, there must be a
#' corresponding `x-amz-checksum` or `x-amz-trailer` header sent.
#' Otherwise, Amazon S3 fails the request with the HTTP status code
#' `400 Bad Request`. For more information, see [Checking object
#' integrity](https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html)
#' in the *Amazon S3 User Guide*.
#' 
#' If you provide an individual checksum, Amazon S3 ignores any provided
#' `ChecksumAlgorithm` parameter.
#' 
#' This checksum algorithm must be the same for all parts and it match the
#' checksum value supplied in the
#' [`create_multipart_upload`][s3_create_multipart_upload] request.
#'
#' @keywords internal
#'
#' @rdname s3_delete_objects
s3_delete_objects <- function(Bucket, Delete, MFA = NULL, RequestPayer = NULL, BypassGovernanceRetention = NULL, ExpectedBucketOwner = NULL, ChecksumAlgorithm = NULL) {
  op <- new_operation(
    name = "DeleteObjects",
    http_method = "POST",
    http_path = "/{Bucket}?delete",
    paginator = list()
  )
  input <- .s3$delete_objects_input(Bucket = Bucket, Delete = Delete, MFA = MFA, RequestPayer = RequestPayer, BypassGovernanceRetention = BypassGovernanceRetention, ExpectedBucketOwner = ExpectedBucketOwner, ChecksumAlgorithm = ChecksumAlgorithm)
  output <- .s3$delete_objects_output()
  config <- get_config()
  svc <- .s3$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$delete_objects <- s3_delete_objects

#' Removes the PublicAccessBlock configuration for an Amazon S3 bucket
#'
#' @description
#' Removes the `PublicAccessBlock` configuration for an Amazon S3 bucket. To use this operation, you must have the `s3:PutBucketPublicAccessBlock` permission. For more information about permissions, see [Permissions Related to Bucket Subresource Operations](https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources) and [Managing Access Permissions to Your Amazon S3 Resources](https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-access-control.html).
#'
#' See [https://paws-r.github.io/docs/s3/delete_public_access_block.html](https://paws-r.github.io/docs/s3/delete_public_access_block.html) for full documentation.
#'
#' @param Bucket &#91;required&#93; The Amazon S3 bucket whose `PublicAccessBlock` configuration you want to
#' delete.
#' @param ExpectedBucketOwner The account ID of the expected bucket owner. If the bucket is owned by a
#' different account, the request fails with the HTTP status code
#' `403 Forbidden` (access denied).
#'
#' @keywords internal
#'
#' @rdname s3_delete_public_access_block
s3_delete_public_access_block <- function(Bucket, ExpectedBucketOwner = NULL) {
  op <- new_operation(
    name = "DeletePublicAccessBlock",
    http_method = "DELETE",
    http_path = "/{Bucket}?publicAccessBlock",
    paginator = list()
  )
  input <- .s3$delete_public_access_block_input(Bucket = Bucket, ExpectedBucketOwner = ExpectedBucketOwner)
  output <- .s3$delete_public_access_block_output()
  config <- get_config()
  svc <- .s3$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$delete_public_access_block <- s3_delete_public_access_block

#' This implementation of the GET action uses the accelerate subresource to
#' return the Transfer Acceleration state of a bucket, which is either
#' Enabled or Suspended
#'
#' @description
#' This implementation of the GET action uses the `accelerate` subresource to return the Transfer Acceleration state of a bucket, which is either `Enabled` or `Suspended`. Amazon S3 Transfer Acceleration is a bucket-level feature that enables you to perform faster data transfers to and from Amazon S3.
#'
#' See [https://paws-r.github.io/docs/s3/get_bucket_accelerate_configuration.html](https://paws-r.github.io/docs/s3/get_bucket_accelerate_configuration.html) for full documentation.
#'
#' @param Bucket &#91;required&#93; The name of the bucket for which the accelerate configuration is
#' retrieved.
#' @param ExpectedBucketOwner The account ID of the expected bucket owner. If the bucket is owned by a
#' different account, the request fails with the HTTP status code
#' `403 Forbidden` (access denied).
#'
#' @keywords internal
#'
#' @rdname s3_get_bucket_accelerate_configuration
s3_get_bucket_accelerate_configuration <- function(Bucket, ExpectedBucketOwner = NULL) {
  op <- new_operation(
    name = "GetBucketAccelerateConfiguration",
    http_method = "GET",
    http_path = "/{Bucket}?accelerate",
    paginator = list()
  )
  input <- .s3$get_bucket_accelerate_configuration_input(Bucket = Bucket, ExpectedBucketOwner = ExpectedBucketOwner)
  output <- .s3$get_bucket_accelerate_configuration_output()
  config <- get_config()
  svc <- .s3$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$get_bucket_accelerate_configuration <- s3_get_bucket_accelerate_configuration

#' This implementation of the GET action uses the acl subresource to return
#' the access control list (ACL) of a bucket
#'
#' @description
#' This implementation of the `GET` action uses the `acl` subresource to return the access control list (ACL) of a bucket. To use `GET` to return the ACL of the bucket, you must have `READ_ACP` access to the bucket. If `READ_ACP` permission is granted to the anonymous user, you can return the ACL of the bucket without using an authorization header.
#'
#' See [https://paws-r.github.io/docs/s3/get_bucket_acl.html](https://paws-r.github.io/docs/s3/get_bucket_acl.html) for full documentation.
#'
#' @param Bucket &#91;required&#93; Specifies the S3 bucket whose ACL is being requested.
#' @param ExpectedBucketOwner The account ID of the expected bucket owner. If the bucket is owned by a
#' different account, the request fails with the HTTP status code
#' `403 Forbidden` (access denied).
#'
#' @keywords internal
#'
#' @rdname s3_get_bucket_acl
s3_get_bucket_acl <- function(Bucket, ExpectedBucketOwner = NULL) {
  op <- new_operation(
    name = "GetBucketAcl",
    http_method = "GET",
    http_path = "/{Bucket}?acl",
    paginator = list()
  )
  input <- .s3$get_bucket_acl_input(Bucket = Bucket, ExpectedBucketOwner = ExpectedBucketOwner)
  output <- .s3$get_bucket_acl_output()
  config <- get_config()
  svc <- .s3$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$get_bucket_acl <- s3_get_bucket_acl

#' This implementation of the GET action returns an analytics configuration
#' (identified by the analytics configuration ID) from the bucket
#'
#' @description
#' This implementation of the GET action returns an analytics configuration (identified by the analytics configuration ID) from the bucket.
#'
#' See [https://paws-r.github.io/docs/s3/get_bucket_analytics_configuration.html](https://paws-r.github.io/docs/s3/get_bucket_analytics_configuration.html) for full documentation.
#'
#' @param Bucket &#91;required&#93; The name of the bucket from which an analytics configuration is
#' retrieved.
#' @param Id &#91;required&#93; The ID that identifies the analytics configuration.
#' @param ExpectedBucketOwner The account ID of the expected bucket owner. If the bucket is owned by a
#' different account, the request fails with the HTTP status code
#' `403 Forbidden` (access denied).
#'
#' @keywords internal
#'
#' @rdname s3_get_bucket_analytics_configuration
s3_get_bucket_analytics_configuration <- function(Bucket, Id, ExpectedBucketOwner = NULL) {
  op <- new_operation(
    name = "GetBucketAnalyticsConfiguration",
    http_method = "GET",
    http_path = "/{Bucket}?analytics",
    paginator = list()
  )
  input <- .s3$get_bucket_analytics_configuration_input(Bucket = Bucket, Id = Id, ExpectedBucketOwner = ExpectedBucketOwner)
  output <- .s3$get_bucket_analytics_configuration_output()
  config <- get_config()
  svc <- .s3$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$get_bucket_analytics_configuration <- s3_get_bucket_analytics_configuration

#' Returns the Cross-Origin Resource Sharing (CORS) configuration
#' information set for the bucket
#'
#' @description
#' Returns the Cross-Origin Resource Sharing (CORS) configuration information set for the bucket.
#'
#' See [https://paws-r.github.io/docs/s3/get_bucket_cors.html](https://paws-r.github.io/docs/s3/get_bucket_cors.html) for full documentation.
#'
#' @param Bucket &#91;required&#93; The bucket name for which to get the cors configuration.
#' @param ExpectedBucketOwner The account ID of the expected bucket owner. If the bucket is owned by a
#' different account, the request fails with the HTTP status code
#' `403 Forbidden` (access denied).
#'
#' @keywords internal
#'
#' @rdname s3_get_bucket_cors
s3_get_bucket_cors <- function(Bucket, ExpectedBucketOwner = NULL) {
  op <- new_operation(
    name = "GetBucketCors",
    http_method = "GET",
    http_path = "/{Bucket}?cors",
    paginator = list()
  )
  input <- .s3$get_bucket_cors_input(Bucket = Bucket, ExpectedBucketOwner = ExpectedBucketOwner)
  output <- .s3$get_bucket_cors_output()
  config <- get_config()
  svc <- .s3$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$get_bucket_cors <- s3_get_bucket_cors

#' Returns the default encryption configuration for an Amazon S3 bucket
#'
#' @description
#' Returns the default encryption configuration for an Amazon S3 bucket. If the bucket does not have a default encryption configuration, GetBucketEncryption returns `ServerSideEncryptionConfigurationNotFoundError`.
#'
#' See [https://paws-r.github.io/docs/s3/get_bucket_encryption.html](https://paws-r.github.io/docs/s3/get_bucket_encryption.html) for full documentation.
#'
#' @param Bucket &#91;required&#93; The name of the bucket from which the server-side encryption
#' configuration is retrieved.
#' @param ExpectedBucketOwner The account ID of the expected bucket owner. If the bucket is owned by a
#' different account, the request fails with the HTTP status code
#' `403 Forbidden` (access denied).
#'
#' @keywords internal
#'
#' @rdname s3_get_bucket_encryption
s3_get_bucket_encryption <- function(Bucket, ExpectedBucketOwner = NULL) {
  op <- new_operation(
    name = "GetBucketEncryption",
    http_method = "GET",
    http_path = "/{Bucket}?encryption",
    paginator = list()
  )
  input <- .s3$get_bucket_encryption_input(Bucket = Bucket, ExpectedBucketOwner = ExpectedBucketOwner)
  output <- .s3$get_bucket_encryption_output()
  config <- get_config()
  svc <- .s3$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$get_bucket_encryption <- s3_get_bucket_encryption

#' Gets the S3 Intelligent-Tiering configuration from the specified bucket
#'
#' @description
#' Gets the S3 Intelligent-Tiering configuration from the specified bucket.
#'
#' See [https://paws-r.github.io/docs/s3/get_bucket_intelligent_tiering_configuration.html](https://paws-r.github.io/docs/s3/get_bucket_intelligent_tiering_configuration.html) for full documentation.
#'
#' @param Bucket &#91;required&#93; The name of the Amazon S3 bucket whose configuration you want to modify
#' or retrieve.
#' @param Id &#91;required&#93; The ID used to identify the S3 Intelligent-Tiering configuration.
#'
#' @keywords internal
#'
#' @rdname s3_get_bucket_intelligent_tiering_configuration
s3_get_bucket_intelligent_tiering_configuration <- function(Bucket, Id) {
  op <- new_operation(
    name = "GetBucketIntelligentTieringConfiguration",
    http_method = "GET",
    http_path = "/{Bucket}?intelligent-tiering",
    paginator = list()
  )
  input <- .s3$get_bucket_intelligent_tiering_configuration_input(Bucket = Bucket, Id = Id)
  output <- .s3$get_bucket_intelligent_tiering_configuration_output()
  config <- get_config()
  svc <- .s3$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$get_bucket_intelligent_tiering_configuration <- s3_get_bucket_intelligent_tiering_configuration

#' Returns an inventory configuration (identified by the inventory
#' configuration ID) from the bucket
#'
#' @description
#' Returns an inventory configuration (identified by the inventory configuration ID) from the bucket.
#'
#' See [https://paws-r.github.io/docs/s3/get_bucket_inventory_configuration.html](https://paws-r.github.io/docs/s3/get_bucket_inventory_configuration.html) for full documentation.
#'
#' @param Bucket &#91;required&#93; The name of the bucket containing the inventory configuration to
#' retrieve.
#' @param Id &#91;required&#93; The ID used to identify the inventory configuration.
#' @param ExpectedBucketOwner The account ID of the expected bucket owner. If the bucket is owned by a
#' different account, the request fails with the HTTP status code
#' `403 Forbidden` (access denied).
#'
#' @keywords internal
#'
#' @rdname s3_get_bucket_inventory_configuration
s3_get_bucket_inventory_configuration <- function(Bucket, Id, ExpectedBucketOwner = NULL) {
  op <- new_operation(
    name = "GetBucketInventoryConfiguration",
    http_method = "GET",
    http_path = "/{Bucket}?inventory",
    paginator = list()
  )
  input <- .s3$get_bucket_inventory_configuration_input(Bucket = Bucket, Id = Id, ExpectedBucketOwner = ExpectedBucketOwner)
  output <- .s3$get_bucket_inventory_configuration_output()
  config <- get_config()
  svc <- .s3$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$get_bucket_inventory_configuration <- s3_get_bucket_inventory_configuration

#' For an updated version of this API, see GetBucketLifecycleConfiguration
#'
#' @description
#' For an updated version of this API, see [`get_bucket_lifecycle_configuration`][s3_get_bucket_lifecycle_configuration]. If you configured a bucket lifecycle using the `filter` element, you should see the updated version of this topic. This topic is provided for backward compatibility.
#'
#' See [https://paws-r.github.io/docs/s3/get_bucket_lifecycle.html](https://paws-r.github.io/docs/s3/get_bucket_lifecycle.html) for full documentation.
#'
#' @param Bucket &#91;required&#93; The name of the bucket for which to get the lifecycle information.
#' @param ExpectedBucketOwner The account ID of the expected bucket owner. If the bucket is owned by a
#' different account, the request fails with the HTTP status code
#' `403 Forbidden` (access denied).
#'
#' @keywords internal
#'
#' @rdname s3_get_bucket_lifecycle
s3_get_bucket_lifecycle <- function(Bucket, ExpectedBucketOwner = NULL) {
  op <- new_operation(
    name = "GetBucketLifecycle",
    http_method = "GET",
    http_path = "/{Bucket}?lifecycle",
    paginator = list()
  )
  input <- .s3$get_bucket_lifecycle_input(Bucket = Bucket, ExpectedBucketOwner = ExpectedBucketOwner)
  output <- .s3$get_bucket_lifecycle_output()
  config <- get_config()
  svc <- .s3$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$get_bucket_lifecycle <- s3_get_bucket_lifecycle

#' Bucket lifecycle configuration now supports specifying a lifecycle rule
#' using an object key name prefix, one or more object tags, or a
#' combination of both
#'
#' @description
#' Bucket lifecycle configuration now supports specifying a lifecycle rule using an object key name prefix, one or more object tags, or a combination of both. Accordingly, this section describes the latest API. The response describes the new filter element that you can use to specify a filter to select a subset of objects to which the rule applies. If you are using a previous version of the lifecycle configuration, it still works. For the earlier action, see [`get_bucket_lifecycle`][s3_get_bucket_lifecycle].
#'
#' See [https://paws-r.github.io/docs/s3/get_bucket_lifecycle_configuration.html](https://paws-r.github.io/docs/s3/get_bucket_lifecycle_configuration.html) for full documentation.
#'
#' @param Bucket &#91;required&#93; The name of the bucket for which to get the lifecycle information.
#' @param ExpectedBucketOwner The account ID of the expected bucket owner. If the bucket is owned by a
#' different account, the request fails with the HTTP status code
#' `403 Forbidden` (access denied).
#'
#' @keywords internal
#'
#' @rdname s3_get_bucket_lifecycle_configuration
s3_get_bucket_lifecycle_configuration <- function(Bucket, ExpectedBucketOwner = NULL) {
  op <- new_operation(
    name = "GetBucketLifecycleConfiguration",
    http_method = "GET",
    http_path = "/{Bucket}?lifecycle",
    paginator = list()
  )
  input <- .s3$get_bucket_lifecycle_configuration_input(Bucket = Bucket, ExpectedBucketOwner = ExpectedBucketOwner)
  output <- .s3$get_bucket_lifecycle_configuration_output()
  config <- get_config()
  svc <- .s3$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$get_bucket_lifecycle_configuration <- s3_get_bucket_lifecycle_configuration

#' Returns the Region the bucket resides in
#'
#' @description
#' Returns the Region the bucket resides in. You set the bucket's Region using the `LocationConstraint` request parameter in a [`create_bucket`][s3_create_bucket] request. For more information, see [`create_bucket`][s3_create_bucket].
#'
#' See [https://paws-r.github.io/docs/s3/get_bucket_location.html](https://paws-r.github.io/docs/s3/get_bucket_location.html) for full documentation.
#'
#' @param Bucket &#91;required&#93; The name of the bucket for which to get the location.
#' @param ExpectedBucketOwner The account ID of the expected bucket owner. If the bucket is owned by a
#' different account, the request fails with the HTTP status code
#' `403 Forbidden` (access denied).
#'
#' @keywords internal
#'
#' @rdname s3_get_bucket_location
s3_get_bucket_location <- function(Bucket, ExpectedBucketOwner = NULL) {
  op <- new_operation(
    name = "GetBucketLocation",
    http_method = "GET",
    http_path = "/{Bucket}?location",
    paginator = list()
  )
  input <- .s3$get_bucket_location_input(Bucket = Bucket, ExpectedBucketOwner = ExpectedBucketOwner)
  output <- .s3$get_bucket_location_output()
  config <- get_config()
  svc <- .s3$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$get_bucket_location <- s3_get_bucket_location

#' Returns the logging status of a bucket and the permissions users have to
#' view and modify that status
#'
#' @description
#' Returns the logging status of a bucket and the permissions users have to view and modify that status. To use GET, you must be the bucket owner.
#'
#' See [https://paws-r.github.io/docs/s3/get_bucket_logging.html](https://paws-r.github.io/docs/s3/get_bucket_logging.html) for full documentation.
#'
#' @param Bucket &#91;required&#93; The bucket name for which to get the logging information.
#' @param ExpectedBucketOwner The account ID of the expected bucket owner. If the bucket is owned by a
#' different account, the request fails with the HTTP status code
#' `403 Forbidden` (access denied).
#'
#' @keywords internal
#'
#' @rdname s3_get_bucket_logging
s3_get_bucket_logging <- function(Bucket, ExpectedBucketOwner = NULL) {
  op <- new_operation(
    name = "GetBucketLogging",
    http_method = "GET",
    http_path = "/{Bucket}?logging",
    paginator = list()
  )
  input <- .s3$get_bucket_logging_input(Bucket = Bucket, ExpectedBucketOwner = ExpectedBucketOwner)
  output <- .s3$get_bucket_logging_output()
  config <- get_config()
  svc <- .s3$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$get_bucket_logging <- s3_get_bucket_logging

#' Gets a metrics configuration (specified by the metrics configuration ID)
#' from the bucket
#'
#' @description
#' Gets a metrics configuration (specified by the metrics configuration ID) from the bucket. Note that this doesn't include the daily storage metrics.
#'
#' See [https://paws-r.github.io/docs/s3/get_bucket_metrics_configuration.html](https://paws-r.github.io/docs/s3/get_bucket_metrics_configuration.html) for full documentation.
#'
#' @param Bucket &#91;required&#93; The name of the bucket containing the metrics configuration to retrieve.
#' @param Id &#91;required&#93; The ID used to identify the metrics configuration.
#' @param ExpectedBucketOwner The account ID of the expected bucket owner. If the bucket is owned by a
#' different account, the request fails with the HTTP status code
#' `403 Forbidden` (access denied).
#'
#' @keywords internal
#'
#' @rdname s3_get_bucket_metrics_configuration
s3_get_bucket_metrics_configuration <- function(Bucket, Id, ExpectedBucketOwner = NULL) {
  op <- new_operation(
    name = "GetBucketMetricsConfiguration",
    http_method = "GET",
    http_path = "/{Bucket}?metrics",
    paginator = list()
  )
  input <- .s3$get_bucket_metrics_configuration_input(Bucket = Bucket, Id = Id, ExpectedBucketOwner = ExpectedBucketOwner)
  output <- .s3$get_bucket_metrics_configuration_output()
  config <- get_config()
  svc <- .s3$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$get_bucket_metrics_configuration <- s3_get_bucket_metrics_configuration

#' No longer used, see GetBucketNotificationConfiguration
#'
#' @description
#' No longer used, see [`get_bucket_notification_configuration`][s3_get_bucket_notification_configuration].
#'
#' See [https://paws-r.github.io/docs/s3/get_bucket_notification.html](https://paws-r.github.io/docs/s3/get_bucket_notification.html) for full documentation.
#'
#' @param Bucket &#91;required&#93; The name of the bucket for which to get the notification configuration.
#' @param ExpectedBucketOwner The account ID of the expected bucket owner. If the bucket is owned by a
#' different account, the request fails with the HTTP status code
#' `403 Forbidden` (access denied).
#'
#' @keywords internal
#'
#' @rdname s3_get_bucket_notification
s3_get_bucket_notification <- function(Bucket, ExpectedBucketOwner = NULL) {
  op <- new_operation(
    name = "GetBucketNotification",
    http_method = "GET",
    http_path = "/{Bucket}?notification",
    paginator = list()
  )
  input <- .s3$get_bucket_notification_input(Bucket = Bucket, ExpectedBucketOwner = ExpectedBucketOwner)
  output <- .s3$get_bucket_notification_output()
  config <- get_config()
  svc <- .s3$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$get_bucket_notification <- s3_get_bucket_notification

#' Returns the notification configuration of a bucket
#'
#' @description
#' Returns the notification configuration of a bucket.
#'
#' See [https://paws-r.github.io/docs/s3/get_bucket_notification_configuration.html](https://paws-r.github.io/docs/s3/get_bucket_notification_configuration.html) for full documentation.
#'
#' @param Bucket &#91;required&#93; The name of the bucket for which to get the notification configuration.
#' @param ExpectedBucketOwner The account ID of the expected bucket owner. If the bucket is owned by a
#' different account, the request fails with the HTTP status code
#' `403 Forbidden` (access denied).
#'
#' @keywords internal
#'
#' @rdname s3_get_bucket_notification_configuration
s3_get_bucket_notification_configuration <- function(Bucket, ExpectedBucketOwner = NULL) {
  op <- new_operation(
    name = "GetBucketNotificationConfiguration",
    http_method = "GET",
    http_path = "/{Bucket}?notification",
    paginator = list()
  )
  input <- .s3$get_bucket_notification_configuration_input(Bucket = Bucket, ExpectedBucketOwner = ExpectedBucketOwner)
  output <- .s3$get_bucket_notification_configuration_output()
  config <- get_config()
  svc <- .s3$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$get_bucket_notification_configuration <- s3_get_bucket_notification_configuration

#' Retrieves OwnershipControls for an Amazon S3 bucket
#'
#' @description
#' Retrieves `OwnershipControls` for an Amazon S3 bucket. To use this operation, you must have the `s3:GetBucketOwnershipControls` permission. For more information about Amazon S3 permissions, see [Specifying permissions in a policy](https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-with-s3-actions.html).
#'
#' See [https://paws-r.github.io/docs/s3/get_bucket_ownership_controls.html](https://paws-r.github.io/docs/s3/get_bucket_ownership_controls.html) for full documentation.
#'
#' @param Bucket &#91;required&#93; The name of the Amazon S3 bucket whose `OwnershipControls` you want to
#' retrieve.
#' @param ExpectedBucketOwner The account ID of the expected bucket owner. If the bucket is owned by a
#' different account, the request fails with the HTTP status code
#' `403 Forbidden` (access denied).
#'
#' @keywords internal
#'
#' @rdname s3_get_bucket_ownership_controls
s3_get_bucket_ownership_controls <- function(Bucket, ExpectedBucketOwner = NULL) {
  op <- new_operation(
    name = "GetBucketOwnershipControls",
    http_method = "GET",
    http_path = "/{Bucket}?ownershipControls",
    paginator = list()
  )
  input <- .s3$get_bucket_ownership_controls_input(Bucket = Bucket, ExpectedBucketOwner = ExpectedBucketOwner)
  output <- .s3$get_bucket_ownership_controls_output()
  config <- get_config()
  svc <- .s3$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$get_bucket_ownership_controls <- s3_get_bucket_ownership_controls

#' Returns the policy of a specified bucket
#'
#' @description
#' Returns the policy of a specified bucket. If you are using an identity other than the root user of the Amazon Web Services account that owns the bucket, the calling identity must have the [`get_bucket_policy`][s3_get_bucket_policy] permissions on the specified bucket and belong to the bucket owner's account in order to use this operation.
#'
#' See [https://paws-r.github.io/docs/s3/get_bucket_policy.html](https://paws-r.github.io/docs/s3/get_bucket_policy.html) for full documentation.
#'
#' @param Bucket &#91;required&#93; The bucket name for which to get the bucket policy.
#' @param ExpectedBucketOwner The account ID of the expected bucket owner. If the bucket is owned by a
#' different account, the request fails with the HTTP status code
#' `403 Forbidden` (access denied).
#'
#' @keywords internal
#'
#' @rdname s3_get_bucket_policy
s3_get_bucket_policy <- function(Bucket, ExpectedBucketOwner = NULL) {
  op <- new_operation(
    name = "GetBucketPolicy",
    http_method = "GET",
    http_path = "/{Bucket}?policy",
    paginator = list()
  )
  input <- .s3$get_bucket_policy_input(Bucket = Bucket, ExpectedBucketOwner = ExpectedBucketOwner)
  output <- .s3$get_bucket_policy_output()
  config <- get_config()
  svc <- .s3$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$get_bucket_policy <- s3_get_bucket_policy

#' Retrieves the policy status for an Amazon S3 bucket, indicating whether
#' the bucket is public
#'
#' @description
#' Retrieves the policy status for an Amazon S3 bucket, indicating whether the bucket is public. In order to use this operation, you must have the `s3:GetBucketPolicyStatus` permission. For more information about Amazon S3 permissions, see [Specifying Permissions in a Policy](https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-with-s3-actions.html).
#'
#' See [https://paws-r.github.io/docs/s3/get_bucket_policy_status.html](https://paws-r.github.io/docs/s3/get_bucket_policy_status.html) for full documentation.
#'
#' @param Bucket &#91;required&#93; The name of the Amazon S3 bucket whose policy status you want to
#' retrieve.
#' @param ExpectedBucketOwner The account ID of the expected bucket owner. If the bucket is owned by a
#' different account, the request fails with the HTTP status code
#' `403 Forbidden` (access denied).
#'
#' @keywords internal
#'
#' @rdname s3_get_bucket_policy_status
s3_get_bucket_policy_status <- function(Bucket, ExpectedBucketOwner = NULL) {
  op <- new_operation(
    name = "GetBucketPolicyStatus",
    http_method = "GET",
    http_path = "/{Bucket}?policyStatus",
    paginator = list()
  )
  input <- .s3$get_bucket_policy_status_input(Bucket = Bucket, ExpectedBucketOwner = ExpectedBucketOwner)
  output <- .s3$get_bucket_policy_status_output()
  config <- get_config()
  svc <- .s3$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$get_bucket_policy_status <- s3_get_bucket_policy_status

#' Returns the replication configuration of a bucket
#'
#' @description
#' Returns the replication configuration of a bucket.
#'
#' See [https://paws-r.github.io/docs/s3/get_bucket_replication.html](https://paws-r.github.io/docs/s3/get_bucket_replication.html) for full documentation.
#'
#' @param Bucket &#91;required&#93; The bucket name for which to get the replication information.
#' @param ExpectedBucketOwner The account ID of the expected bucket owner. If the bucket is owned by a
#' different account, the request fails with the HTTP status code
#' `403 Forbidden` (access denied).
#'
#' @keywords internal
#'
#' @rdname s3_get_bucket_replication
s3_get_bucket_replication <- function(Bucket, ExpectedBucketOwner = NULL) {
  op <- new_operation(
    name = "GetBucketReplication",
    http_method = "GET",
    http_path = "/{Bucket}?replication",
    paginator = list()
  )
  input <- .s3$get_bucket_replication_input(Bucket = Bucket, ExpectedBucketOwner = ExpectedBucketOwner)
  output <- .s3$get_bucket_replication_output()
  config <- get_config()
  svc <- .s3$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$get_bucket_replication <- s3_get_bucket_replication

#' Returns the request payment configuration of a bucket
#'
#' @description
#' Returns the request payment configuration of a bucket. To use this version of the operation, you must be the bucket owner. For more information, see [Requester Pays Buckets](https://docs.aws.amazon.com/AmazonS3/latest/userguide/RequesterPaysBuckets.html).
#'
#' See [https://paws-r.github.io/docs/s3/get_bucket_request_payment.html](https://paws-r.github.io/docs/s3/get_bucket_request_payment.html) for full documentation.
#'
#' @param Bucket &#91;required&#93; The name of the bucket for which to get the payment request
#' configuration
#' @param ExpectedBucketOwner The account ID of the expected bucket owner. If the bucket is owned by a
#' different account, the request fails with the HTTP status code
#' `403 Forbidden` (access denied).
#'
#' @keywords internal
#'
#' @rdname s3_get_bucket_request_payment
s3_get_bucket_request_payment <- function(Bucket, ExpectedBucketOwner = NULL) {
  op <- new_operation(
    name = "GetBucketRequestPayment",
    http_method = "GET",
    http_path = "/{Bucket}?requestPayment",
    paginator = list()
  )
  input <- .s3$get_bucket_request_payment_input(Bucket = Bucket, ExpectedBucketOwner = ExpectedBucketOwner)
  output <- .s3$get_bucket_request_payment_output()
  config <- get_config()
  svc <- .s3$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$get_bucket_request_payment <- s3_get_bucket_request_payment

#' Returns the tag set associated with the bucket
#'
#' @description
#' Returns the tag set associated with the bucket.
#'
#' See [https://paws-r.github.io/docs/s3/get_bucket_tagging.html](https://paws-r.github.io/docs/s3/get_bucket_tagging.html) for full documentation.
#'
#' @param Bucket &#91;required&#93; The name of the bucket for which to get the tagging information.
#' @param ExpectedBucketOwner The account ID of the expected bucket owner. If the bucket is owned by a
#' different account, the request fails with the HTTP status code
#' `403 Forbidden` (access denied).
#'
#' @keywords internal
#'
#' @rdname s3_get_bucket_tagging
s3_get_bucket_tagging <- function(Bucket, ExpectedBucketOwner = NULL) {
  op <- new_operation(
    name = "GetBucketTagging",
    http_method = "GET",
    http_path = "/{Bucket}?tagging",
    paginator = list()
  )
  input <- .s3$get_bucket_tagging_input(Bucket = Bucket, ExpectedBucketOwner = ExpectedBucketOwner)
  output <- .s3$get_bucket_tagging_output()
  config <- get_config()
  svc <- .s3$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$get_bucket_tagging <- s3_get_bucket_tagging

#' Returns the versioning state of a bucket
#'
#' @description
#' Returns the versioning state of a bucket.
#'
#' See [https://paws-r.github.io/docs/s3/get_bucket_versioning.html](https://paws-r.github.io/docs/s3/get_bucket_versioning.html) for full documentation.
#'
#' @param Bucket &#91;required&#93; The name of the bucket for which to get the versioning information.
#' @param ExpectedBucketOwner The account ID of the expected bucket owner. If the bucket is owned by a
#' different account, the request fails with the HTTP status code
#' `403 Forbidden` (access denied).
#'
#' @keywords internal
#'
#' @rdname s3_get_bucket_versioning
s3_get_bucket_versioning <- function(Bucket, ExpectedBucketOwner = NULL) {
  op <- new_operation(
    name = "GetBucketVersioning",
    http_method = "GET",
    http_path = "/{Bucket}?versioning",
    paginator = list()
  )
  input <- .s3$get_bucket_versioning_input(Bucket = Bucket, ExpectedBucketOwner = ExpectedBucketOwner)
  output <- .s3$get_bucket_versioning_output()
  config <- get_config()
  svc <- .s3$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$get_bucket_versioning <- s3_get_bucket_versioning

#' Returns the website configuration for a bucket
#'
#' @description
#' Returns the website configuration for a bucket. To host website on Amazon S3, you can configure a bucket as website by adding a website configuration. For more information about hosting websites, see [Hosting Websites on Amazon S3](https://docs.aws.amazon.com/AmazonS3/latest/userguide/WebsiteHosting.html).
#'
#' See [https://paws-r.github.io/docs/s3/get_bucket_website.html](https://paws-r.github.io/docs/s3/get_bucket_website.html) for full documentation.
#'
#' @param Bucket &#91;required&#93; The bucket name for which to get the website configuration.
#' @param ExpectedBucketOwner The account ID of the expected bucket owner. If the bucket is owned by a
#' different account, the request fails with the HTTP status code
#' `403 Forbidden` (access denied).
#'
#' @keywords internal
#'
#' @rdname s3_get_bucket_website
s3_get_bucket_website <- function(Bucket, ExpectedBucketOwner = NULL) {
  op <- new_operation(
    name = "GetBucketWebsite",
    http_method = "GET",
    http_path = "/{Bucket}?website",
    paginator = list()
  )
  input <- .s3$get_bucket_website_input(Bucket = Bucket, ExpectedBucketOwner = ExpectedBucketOwner)
  output <- .s3$get_bucket_website_output()
  config <- get_config()
  svc <- .s3$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$get_bucket_website <- s3_get_bucket_website

#' Retrieves objects from Amazon S3
#'
#' @description
#' Retrieves objects from Amazon S3. To use `GET`, you must have `READ` access to the object. If you grant `READ` access to the anonymous user, you can return the object without using an authorization header.
#'
#' See [https://paws-r.github.io/docs/s3/get_object.html](https://paws-r.github.io/docs/s3/get_object.html) for full documentation.
#'
#' @param Bucket &#91;required&#93; The bucket name containing the object.
#' 
#' When using this action with an access point, you must direct requests to
#' the access point hostname. The access point hostname takes the form
#' *AccessPointName*-*AccountId*.s3-accesspoint.*Region*.amazonaws.com.
#' When using this action with an access point through the Amazon Web
#' Services SDKs, you provide the access point ARN in place of the bucket
#' name. For more information about access point ARNs, see [Using access
#' points](https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html)
#' in the *Amazon S3 User Guide*.
#' 
#' When using an Object Lambda access point the hostname takes the form
#' *AccessPointName*-*AccountId*.s3-object-lambda.*Region*.amazonaws.com.
#' 
#' When using this action with Amazon S3 on Outposts, you must direct
#' requests to the S3 on Outposts hostname. The S3 on Outposts hostname
#' takes the form
#' ` AccessPointName-AccountId.outpostID.s3-outposts.Region.amazonaws.com`.
#' When using this action with S3 on Outposts through the Amazon Web
#' Services SDKs, you provide the Outposts bucket ARN in place of the
#' bucket name. For more information about S3 on Outposts ARNs, see [Using
#' Amazon S3 on
#' Outposts](https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html)
#' in the *Amazon S3 User Guide*.
#' @param IfMatch Return the object only if its entity tag (ETag) is the same as the one
#' specified; otherwise, return a 412 (precondition failed) error.
#' @param IfModifiedSince Return the object only if it has been modified since the specified time;
#' otherwise, return a 304 (not modified) error.
#' @param IfNoneMatch Return the object only if its entity tag (ETag) is different from the
#' one specified; otherwise, return a 304 (not modified) error.
#' @param IfUnmodifiedSince Return the object only if it has not been modified since the specified
#' time; otherwise, return a 412 (precondition failed) error.
#' @param Key &#91;required&#93; Key of the object to get.
#' @param Range Downloads the specified range bytes of an object. For more information
#' about the HTTP Range header, see
#' <https://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.35>.
#' 
#' Amazon S3 doesn't support retrieving multiple ranges of data per `GET`
#' request.
#' @param ResponseCacheControl Sets the `Cache-Control` header of the response.
#' @param ResponseContentDisposition Sets the `Content-Disposition` header of the response
#' @param ResponseContentEncoding Sets the `Content-Encoding` header of the response.
#' @param ResponseContentLanguage Sets the `Content-Language` header of the response.
#' @param ResponseContentType Sets the `Content-Type` header of the response.
#' @param ResponseExpires Sets the `Expires` header of the response.
#' @param VersionId VersionId used to reference a specific version of the object.
#' @param SSECustomerAlgorithm Specifies the algorithm to use to when decrypting the object (for
#' example, AES256).
#' @param SSECustomerKey Specifies the customer-provided encryption key for Amazon S3 used to
#' encrypt the data. This value is used to decrypt the object when
#' recovering it and must match the one used when storing the data. The key
#' must be appropriate for use with the algorithm specified in the
#' `x-amz-server-side-encryption-customer-algorithm` header.
#' @param SSECustomerKeyMD5 Specifies the 128-bit MD5 digest of the encryption key according to RFC
#' 1321. Amazon S3 uses this header for a message integrity check to ensure
#' that the encryption key was transmitted without error.
#' @param RequestPayer 
#' @param PartNumber Part number of the object being read. This is a positive integer between
#' 1 and 10,000. Effectively performs a 'ranged' GET request for the part
#' specified. Useful for downloading just a part of an object.
#' @param ExpectedBucketOwner The account ID of the expected bucket owner. If the bucket is owned by a
#' different account, the request fails with the HTTP status code
#' `403 Forbidden` (access denied).
#' @param ChecksumMode To retrieve the checksum, this mode must be enabled.
#'
#' @keywords internal
#'
#' @rdname s3_get_object
s3_get_object <- function(Bucket, IfMatch = NULL, IfModifiedSince = NULL, IfNoneMatch = NULL, IfUnmodifiedSince = NULL, Key, Range = NULL, ResponseCacheControl = NULL, ResponseContentDisposition = NULL, ResponseContentEncoding = NULL, ResponseContentLanguage = NULL, ResponseContentType = NULL, ResponseExpires = NULL, VersionId = NULL, SSECustomerAlgorithm = NULL, SSECustomerKey = NULL, SSECustomerKeyMD5 = NULL, RequestPayer = NULL, PartNumber = NULL, ExpectedBucketOwner = NULL, ChecksumMode = NULL) {
  op <- new_operation(
    name = "GetObject",
    http_method = "GET",
    http_path = "/{Bucket}/{Key+}",
    paginator = list()
  )
  input <- .s3$get_object_input(Bucket = Bucket, IfMatch = IfMatch, IfModifiedSince = IfModifiedSince, IfNoneMatch = IfNoneMatch, IfUnmodifiedSince = IfUnmodifiedSince, Key = Key, Range = Range, ResponseCacheControl = ResponseCacheControl, ResponseContentDisposition = ResponseContentDisposition, ResponseContentEncoding = ResponseContentEncoding, ResponseContentLanguage = ResponseContentLanguage, ResponseContentType = ResponseContentType, ResponseExpires = ResponseExpires, VersionId = VersionId, SSECustomerAlgorithm = SSECustomerAlgorithm, SSECustomerKey = SSECustomerKey, SSECustomerKeyMD5 = SSECustomerKeyMD5, RequestPayer = RequestPayer, PartNumber = PartNumber, ExpectedBucketOwner = ExpectedBucketOwner, ChecksumMode = ChecksumMode)
  output <- .s3$get_object_output()
  config <- get_config()
  svc <- .s3$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$get_object <- s3_get_object

#' Returns the access control list (ACL) of an object
#'
#' @description
#' Returns the access control list (ACL) of an object. To use this operation, you must have `s3:GetObjectAcl` permissions or `READ_ACP` access to the object. For more information, see [Mapping of ACL permissions and access policy permissions](https://docs.aws.amazon.com/AmazonS3/latest/userguide/acl-overview.html#acl-access-policy-permission-mapping) in the *Amazon S3 User Guide*
#'
#' See [https://paws-r.github.io/docs/s3/get_object_acl.html](https://paws-r.github.io/docs/s3/get_object_acl.html) for full documentation.
#'
#' @param Bucket &#91;required&#93; The bucket name that contains the object for which to get the ACL
#' information.
#' 
#' When using this action with an access point, you must direct requests to
#' the access point hostname. The access point hostname takes the form
#' *AccessPointName*-*AccountId*.s3-accesspoint.*Region*.amazonaws.com.
#' When using this action with an access point through the Amazon Web
#' Services SDKs, you provide the access point ARN in place of the bucket
#' name. For more information about access point ARNs, see [Using access
#' points](https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html)
#' in the *Amazon S3 User Guide*.
#' @param Key &#91;required&#93; The key of the object for which to get the ACL information.
#' @param VersionId VersionId used to reference a specific version of the object.
#' @param RequestPayer 
#' @param ExpectedBucketOwner The account ID of the expected bucket owner. If the bucket is owned by a
#' different account, the request fails with the HTTP status code
#' `403 Forbidden` (access denied).
#'
#' @keywords internal
#'
#' @rdname s3_get_object_acl
s3_get_object_acl <- function(Bucket, Key, VersionId = NULL, RequestPayer = NULL, ExpectedBucketOwner = NULL) {
  op <- new_operation(
    name = "GetObjectAcl",
    http_method = "GET",
    http_path = "/{Bucket}/{Key+}?acl",
    paginator = list()
  )
  input <- .s3$get_object_acl_input(Bucket = Bucket, Key = Key, VersionId = VersionId, RequestPayer = RequestPayer, ExpectedBucketOwner = ExpectedBucketOwner)
  output <- .s3$get_object_acl_output()
  config <- get_config()
  svc <- .s3$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$get_object_acl <- s3_get_object_acl

#' Retrieves all the metadata from an object without returning the object
#' itself
#'
#' @description
#' Retrieves all the metadata from an object without returning the object itself. This action is useful if you're interested only in an object's metadata. To use [`get_object_attributes`][s3_get_object_attributes], you must have READ access to the object.
#'
#' See [https://paws-r.github.io/docs/s3/get_object_attributes.html](https://paws-r.github.io/docs/s3/get_object_attributes.html) for full documentation.
#'
#' @param Bucket &#91;required&#93; The name of the bucket that contains the object.
#' 
#' When using this action with an access point, you must direct requests to
#' the access point hostname. The access point hostname takes the form
#' *AccessPointName*-*AccountId*.s3-accesspoint.*Region*.amazonaws.com.
#' When using this action with an access point through the Amazon Web
#' Services SDKs, you provide the access point ARN in place of the bucket
#' name. For more information about access point ARNs, see [Using access
#' points](https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html)
#' in the *Amazon S3 User Guide*.
#' 
#' When using this action with Amazon S3 on Outposts, you must direct
#' requests to the S3 on Outposts hostname. The S3 on Outposts hostname
#' takes the form
#' ` AccessPointName-AccountId.outpostID.s3-outposts.Region.amazonaws.com`.
#' When using this action with S3 on Outposts through the Amazon Web
#' Services SDKs, you provide the Outposts bucket ARN in place of the
#' bucket name. For more information about S3 on Outposts ARNs, see [Using
#' Amazon S3 on
#' Outposts](https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html)
#' in the *Amazon S3 User Guide*.
#' @param Key &#91;required&#93; The object key.
#' @param VersionId The version ID used to reference a specific version of the object.
#' @param MaxParts Sets the maximum number of parts to return.
#' @param PartNumberMarker Specifies the part after which listing should begin. Only parts with
#' higher part numbers will be listed.
#' @param SSECustomerAlgorithm Specifies the algorithm to use when encrypting the object (for example,
#' AES256).
#' @param SSECustomerKey Specifies the customer-provided encryption key for Amazon S3 to use in
#' encrypting data. This value is used to store the object and then it is
#' discarded; Amazon S3 does not store the encryption key. The key must be
#' appropriate for use with the algorithm specified in the
#' `x-amz-server-side-encryption-customer-algorithm` header.
#' @param SSECustomerKeyMD5 Specifies the 128-bit MD5 digest of the encryption key according to RFC
#' 1321. Amazon S3 uses this header for a message integrity check to ensure
#' that the encryption key was transmitted without error.
#' @param RequestPayer 
#' @param ExpectedBucketOwner The account ID of the expected bucket owner. If the bucket is owned by a
#' different account, the request fails with the HTTP status code
#' `403 Forbidden` (access denied).
#' @param ObjectAttributes &#91;required&#93; An XML header that specifies the fields at the root level that you want
#' returned in the response. Fields that you do not specify are not
#' returned.
#'
#' @keywords internal
#'
#' @rdname s3_get_object_attributes
s3_get_object_attributes <- function(Bucket, Key, VersionId = NULL, MaxParts = NULL, PartNumberMarker = NULL, SSECustomerAlgorithm = NULL, SSECustomerKey = NULL, SSECustomerKeyMD5 = NULL, RequestPayer = NULL, ExpectedBucketOwner = NULL, ObjectAttributes) {
  op <- new_operation(
    name = "GetObjectAttributes",
    http_method = "GET",
    http_path = "/{Bucket}/{Key+}?attributes",
    paginator = list()
  )
  input <- .s3$get_object_attributes_input(Bucket = Bucket, Key = Key, VersionId = VersionId, MaxParts = MaxParts, PartNumberMarker = PartNumberMarker, SSECustomerAlgorithm = SSECustomerAlgorithm, SSECustomerKey = SSECustomerKey, SSECustomerKeyMD5 = SSECustomerKeyMD5, RequestPayer = RequestPayer, ExpectedBucketOwner = ExpectedBucketOwner, ObjectAttributes = ObjectAttributes)
  output <- .s3$get_object_attributes_output()
  config <- get_config()
  svc <- .s3$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$get_object_attributes <- s3_get_object_attributes

#' Gets an object's current legal hold status
#'
#' @description
#' Gets an object's current legal hold status. For more information, see [Locking Objects](https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-lock.html).
#'
#' See [https://paws-r.github.io/docs/s3/get_object_legal_hold.html](https://paws-r.github.io/docs/s3/get_object_legal_hold.html) for full documentation.
#'
#' @param Bucket &#91;required&#93; The bucket name containing the object whose legal hold status you want
#' to retrieve.
#' 
#' When using this action with an access point, you must direct requests to
#' the access point hostname. The access point hostname takes the form
#' *AccessPointName*-*AccountId*.s3-accesspoint.*Region*.amazonaws.com.
#' When using this action with an access point through the Amazon Web
#' Services SDKs, you provide the access point ARN in place of the bucket
#' name. For more information about access point ARNs, see [Using access
#' points](https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html)
#' in the *Amazon S3 User Guide*.
#' @param Key &#91;required&#93; The key name for the object whose legal hold status you want to
#' retrieve.
#' @param VersionId The version ID of the object whose legal hold status you want to
#' retrieve.
#' @param RequestPayer 
#' @param ExpectedBucketOwner The account ID of the expected bucket owner. If the bucket is owned by a
#' different account, the request fails with the HTTP status code
#' `403 Forbidden` (access denied).
#'
#' @keywords internal
#'
#' @rdname s3_get_object_legal_hold
s3_get_object_legal_hold <- function(Bucket, Key, VersionId = NULL, RequestPayer = NULL, ExpectedBucketOwner = NULL) {
  op <- new_operation(
    name = "GetObjectLegalHold",
    http_method = "GET",
    http_path = "/{Bucket}/{Key+}?legal-hold",
    paginator = list()
  )
  input <- .s3$get_object_legal_hold_input(Bucket = Bucket, Key = Key, VersionId = VersionId, RequestPayer = RequestPayer, ExpectedBucketOwner = ExpectedBucketOwner)
  output <- .s3$get_object_legal_hold_output()
  config <- get_config()
  svc <- .s3$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$get_object_legal_hold <- s3_get_object_legal_hold

#' Gets the Object Lock configuration for a bucket
#'
#' @description
#' Gets the Object Lock configuration for a bucket. The rule specified in the Object Lock configuration will be applied by default to every new object placed in the specified bucket. For more information, see [Locking Objects](https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-lock.html).
#'
#' See [https://paws-r.github.io/docs/s3/get_object_lock_configuration.html](https://paws-r.github.io/docs/s3/get_object_lock_configuration.html) for full documentation.
#'
#' @param Bucket &#91;required&#93; The bucket whose Object Lock configuration you want to retrieve.
#' 
#' When using this action with an access point, you must direct requests to
#' the access point hostname. The access point hostname takes the form
#' *AccessPointName*-*AccountId*.s3-accesspoint.*Region*.amazonaws.com.
#' When using this action with an access point through the Amazon Web
#' Services SDKs, you provide the access point ARN in place of the bucket
#' name. For more information about access point ARNs, see [Using access
#' points](https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html)
#' in the *Amazon S3 User Guide*.
#' @param ExpectedBucketOwner The account ID of the expected bucket owner. If the bucket is owned by a
#' different account, the request fails with the HTTP status code
#' `403 Forbidden` (access denied).
#'
#' @keywords internal
#'
#' @rdname s3_get_object_lock_configuration
s3_get_object_lock_configuration <- function(Bucket, ExpectedBucketOwner = NULL) {
  op <- new_operation(
    name = "GetObjectLockConfiguration",
    http_method = "GET",
    http_path = "/{Bucket}?object-lock",
    paginator = list()
  )
  input <- .s3$get_object_lock_configuration_input(Bucket = Bucket, ExpectedBucketOwner = ExpectedBucketOwner)
  output <- .s3$get_object_lock_configuration_output()
  config <- get_config()
  svc <- .s3$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$get_object_lock_configuration <- s3_get_object_lock_configuration

#' Retrieves an object's retention settings
#'
#' @description
#' Retrieves an object's retention settings. For more information, see [Locking Objects](https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-lock.html).
#'
#' See [https://paws-r.github.io/docs/s3/get_object_retention.html](https://paws-r.github.io/docs/s3/get_object_retention.html) for full documentation.
#'
#' @param Bucket &#91;required&#93; The bucket name containing the object whose retention settings you want
#' to retrieve.
#' 
#' When using this action with an access point, you must direct requests to
#' the access point hostname. The access point hostname takes the form
#' *AccessPointName*-*AccountId*.s3-accesspoint.*Region*.amazonaws.com.
#' When using this action with an access point through the Amazon Web
#' Services SDKs, you provide the access point ARN in place of the bucket
#' name. For more information about access point ARNs, see [Using access
#' points](https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html)
#' in the *Amazon S3 User Guide*.
#' @param Key &#91;required&#93; The key name for the object whose retention settings you want to
#' retrieve.
#' @param VersionId The version ID for the object whose retention settings you want to
#' retrieve.
#' @param RequestPayer 
#' @param ExpectedBucketOwner The account ID of the expected bucket owner. If the bucket is owned by a
#' different account, the request fails with the HTTP status code
#' `403 Forbidden` (access denied).
#'
#' @keywords internal
#'
#' @rdname s3_get_object_retention
s3_get_object_retention <- function(Bucket, Key, VersionId = NULL, RequestPayer = NULL, ExpectedBucketOwner = NULL) {
  op <- new_operation(
    name = "GetObjectRetention",
    http_method = "GET",
    http_path = "/{Bucket}/{Key+}?retention",
    paginator = list()
  )
  input <- .s3$get_object_retention_input(Bucket = Bucket, Key = Key, VersionId = VersionId, RequestPayer = RequestPayer, ExpectedBucketOwner = ExpectedBucketOwner)
  output <- .s3$get_object_retention_output()
  config <- get_config()
  svc <- .s3$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$get_object_retention <- s3_get_object_retention

#' Returns the tag-set of an object
#'
#' @description
#' Returns the tag-set of an object. You send the GET request against the tagging subresource associated with the object.
#'
#' See [https://paws-r.github.io/docs/s3/get_object_tagging.html](https://paws-r.github.io/docs/s3/get_object_tagging.html) for full documentation.
#'
#' @param Bucket &#91;required&#93; The bucket name containing the object for which to get the tagging
#' information.
#' 
#' When using this action with an access point, you must direct requests to
#' the access point hostname. The access point hostname takes the form
#' *AccessPointName*-*AccountId*.s3-accesspoint.*Region*.amazonaws.com.
#' When using this action with an access point through the Amazon Web
#' Services SDKs, you provide the access point ARN in place of the bucket
#' name. For more information about access point ARNs, see [Using access
#' points](https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html)
#' in the *Amazon S3 User Guide*.
#' 
#' When using this action with Amazon S3 on Outposts, you must direct
#' requests to the S3 on Outposts hostname. The S3 on Outposts hostname
#' takes the form
#' ` AccessPointName-AccountId.outpostID.s3-outposts.Region.amazonaws.com`.
#' When using this action with S3 on Outposts through the Amazon Web
#' Services SDKs, you provide the Outposts bucket ARN in place of the
#' bucket name. For more information about S3 on Outposts ARNs, see [Using
#' Amazon S3 on
#' Outposts](https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html)
#' in the *Amazon S3 User Guide*.
#' @param Key &#91;required&#93; Object key for which to get the tagging information.
#' @param VersionId The versionId of the object for which to get the tagging information.
#' @param ExpectedBucketOwner The account ID of the expected bucket owner. If the bucket is owned by a
#' different account, the request fails with the HTTP status code
#' `403 Forbidden` (access denied).
#' @param RequestPayer 
#'
#' @keywords internal
#'
#' @rdname s3_get_object_tagging
s3_get_object_tagging <- function(Bucket, Key, VersionId = NULL, ExpectedBucketOwner = NULL, RequestPayer = NULL) {
  op <- new_operation(
    name = "GetObjectTagging",
    http_method = "GET",
    http_path = "/{Bucket}/{Key+}?tagging",
    paginator = list()
  )
  input <- .s3$get_object_tagging_input(Bucket = Bucket, Key = Key, VersionId = VersionId, ExpectedBucketOwner = ExpectedBucketOwner, RequestPayer = RequestPayer)
  output <- .s3$get_object_tagging_output()
  config <- get_config()
  svc <- .s3$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$get_object_tagging <- s3_get_object_tagging

#' Returns torrent files from a bucket
#'
#' @description
#' Returns torrent files from a bucket. BitTorrent can save you bandwidth when you're distributing large files. For more information about BitTorrent, see [Using BitTorrent with Amazon S3](https://docs.aws.amazon.com/AmazonS3/latest/userguide/uploading-downloading-objects.html).
#'
#' See [https://paws-r.github.io/docs/s3/get_object_torrent.html](https://paws-r.github.io/docs/s3/get_object_torrent.html) for full documentation.
#'
#' @param Bucket &#91;required&#93; The name of the bucket containing the object for which to get the
#' torrent files.
#' @param Key &#91;required&#93; The object key for which to get the information.
#' @param RequestPayer 
#' @param ExpectedBucketOwner The account ID of the expected bucket owner. If the bucket is owned by a
#' different account, the request fails with the HTTP status code
#' `403 Forbidden` (access denied).
#'
#' @keywords internal
#'
#' @rdname s3_get_object_torrent
s3_get_object_torrent <- function(Bucket, Key, RequestPayer = NULL, ExpectedBucketOwner = NULL) {
  op <- new_operation(
    name = "GetObjectTorrent",
    http_method = "GET",
    http_path = "/{Bucket}/{Key+}?torrent",
    paginator = list()
  )
  input <- .s3$get_object_torrent_input(Bucket = Bucket, Key = Key, RequestPayer = RequestPayer, ExpectedBucketOwner = ExpectedBucketOwner)
  output <- .s3$get_object_torrent_output()
  config <- get_config()
  svc <- .s3$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$get_object_torrent <- s3_get_object_torrent

#' Retrieves the PublicAccessBlock configuration for an Amazon S3 bucket
#'
#' @description
#' Retrieves the `PublicAccessBlock` configuration for an Amazon S3 bucket. To use this operation, you must have the `s3:GetBucketPublicAccessBlock` permission. For more information about Amazon S3 permissions, see [Specifying Permissions in a Policy](https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-with-s3-actions.html).
#'
#' See [https://paws-r.github.io/docs/s3/get_public_access_block.html](https://paws-r.github.io/docs/s3/get_public_access_block.html) for full documentation.
#'
#' @param Bucket &#91;required&#93; The name of the Amazon S3 bucket whose `PublicAccessBlock` configuration
#' you want to retrieve.
#' @param ExpectedBucketOwner The account ID of the expected bucket owner. If the bucket is owned by a
#' different account, the request fails with the HTTP status code
#' `403 Forbidden` (access denied).
#'
#' @keywords internal
#'
#' @rdname s3_get_public_access_block
s3_get_public_access_block <- function(Bucket, ExpectedBucketOwner = NULL) {
  op <- new_operation(
    name = "GetPublicAccessBlock",
    http_method = "GET",
    http_path = "/{Bucket}?publicAccessBlock",
    paginator = list()
  )
  input <- .s3$get_public_access_block_input(Bucket = Bucket, ExpectedBucketOwner = ExpectedBucketOwner)
  output <- .s3$get_public_access_block_output()
  config <- get_config()
  svc <- .s3$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$get_public_access_block <- s3_get_public_access_block

#' This action is useful to determine if a bucket exists and you have
#' permission to access it
#'
#' @description
#' This action is useful to determine if a bucket exists and you have permission to access it. The action returns a `200 OK` if the bucket exists and you have permission to access it.
#'
#' See [https://paws-r.github.io/docs/s3/head_bucket.html](https://paws-r.github.io/docs/s3/head_bucket.html) for full documentation.
#'
#' @param Bucket &#91;required&#93; The bucket name.
#' 
#' When using this action with an access point, you must direct requests to
#' the access point hostname. The access point hostname takes the form
#' *AccessPointName*-*AccountId*.s3-accesspoint.*Region*.amazonaws.com.
#' When using this action with an access point through the Amazon Web
#' Services SDKs, you provide the access point ARN in place of the bucket
#' name. For more information about access point ARNs, see [Using access
#' points](https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html)
#' in the *Amazon S3 User Guide*.
#' 
#' When using this action with Amazon S3 on Outposts, you must direct
#' requests to the S3 on Outposts hostname. The S3 on Outposts hostname
#' takes the form
#' ` AccessPointName-AccountId.outpostID.s3-outposts.Region.amazonaws.com`.
#' When using this action with S3 on Outposts through the Amazon Web
#' Services SDKs, you provide the Outposts bucket ARN in place of the
#' bucket name. For more information about S3 on Outposts ARNs, see [Using
#' Amazon S3 on
#' Outposts](https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html)
#' in the *Amazon S3 User Guide*.
#' @param ExpectedBucketOwner The account ID of the expected bucket owner. If the bucket is owned by a
#' different account, the request fails with the HTTP status code
#' `403 Forbidden` (access denied).
#'
#' @keywords internal
#'
#' @rdname s3_head_bucket
s3_head_bucket <- function(Bucket, ExpectedBucketOwner = NULL) {
  op <- new_operation(
    name = "HeadBucket",
    http_method = "HEAD",
    http_path = "/{Bucket}",
    paginator = list()
  )
  input <- .s3$head_bucket_input(Bucket = Bucket, ExpectedBucketOwner = ExpectedBucketOwner)
  output <- .s3$head_bucket_output()
  config <- get_config()
  svc <- .s3$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$head_bucket <- s3_head_bucket

#' The HEAD action retrieves metadata from an object without returning the
#' object itself
#'
#' @description
#' The HEAD action retrieves metadata from an object without returning the object itself. This action is useful if you're only interested in an object's metadata. To use HEAD, you must have READ access to the object.
#'
#' See [https://paws-r.github.io/docs/s3/head_object.html](https://paws-r.github.io/docs/s3/head_object.html) for full documentation.
#'
#' @param Bucket &#91;required&#93; The name of the bucket containing the object.
#' 
#' When using this action with an access point, you must direct requests to
#' the access point hostname. The access point hostname takes the form
#' *AccessPointName*-*AccountId*.s3-accesspoint.*Region*.amazonaws.com.
#' When using this action with an access point through the Amazon Web
#' Services SDKs, you provide the access point ARN in place of the bucket
#' name. For more information about access point ARNs, see [Using access
#' points](https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html)
#' in the *Amazon S3 User Guide*.
#' 
#' When using this action with Amazon S3 on Outposts, you must direct
#' requests to the S3 on Outposts hostname. The S3 on Outposts hostname
#' takes the form
#' ` AccessPointName-AccountId.outpostID.s3-outposts.Region.amazonaws.com`.
#' When using this action with S3 on Outposts through the Amazon Web
#' Services SDKs, you provide the Outposts bucket ARN in place of the
#' bucket name. For more information about S3 on Outposts ARNs, see [Using
#' Amazon S3 on
#' Outposts](https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html)
#' in the *Amazon S3 User Guide*.
#' @param IfMatch Return the object only if its entity tag (ETag) is the same as the one
#' specified; otherwise, return a 412 (precondition failed) error.
#' @param IfModifiedSince Return the object only if it has been modified since the specified time;
#' otherwise, return a 304 (not modified) error.
#' @param IfNoneMatch Return the object only if its entity tag (ETag) is different from the
#' one specified; otherwise, return a 304 (not modified) error.
#' @param IfUnmodifiedSince Return the object only if it has not been modified since the specified
#' time; otherwise, return a 412 (precondition failed) error.
#' @param Key &#91;required&#93; The object key.
#' @param Range Because [`head_object`][s3_head_object] returns only the metadata for an
#' object, this parameter has no effect.
#' @param VersionId VersionId used to reference a specific version of the object.
#' @param SSECustomerAlgorithm Specifies the algorithm to use to when encrypting the object (for
#' example, AES256).
#' @param SSECustomerKey Specifies the customer-provided encryption key for Amazon S3 to use in
#' encrypting data. This value is used to store the object and then it is
#' discarded; Amazon S3 does not store the encryption key. The key must be
#' appropriate for use with the algorithm specified in the
#' `x-amz-server-side-encryption-customer-algorithm` header.
#' @param SSECustomerKeyMD5 Specifies the 128-bit MD5 digest of the encryption key according to RFC
#' 1321. Amazon S3 uses this header for a message integrity check to ensure
#' that the encryption key was transmitted without error.
#' @param RequestPayer 
#' @param PartNumber Part number of the object being read. This is a positive integer between
#' 1 and 10,000. Effectively performs a 'ranged' HEAD request for the part
#' specified. Useful querying about the size of the part and the number of
#' parts in this object.
#' @param ExpectedBucketOwner The account ID of the expected bucket owner. If the bucket is owned by a
#' different account, the request fails with the HTTP status code
#' `403 Forbidden` (access denied).
#' @param ChecksumMode To retrieve the checksum, this parameter must be enabled.
#' 
#' In addition, if you enable `ChecksumMode` and the object is encrypted
#' with Amazon Web Services Key Management Service (Amazon Web Services
#' KMS), you must have permission to use the `kms:Decrypt` action for the
#' request to succeed.
#'
#' @keywords internal
#'
#' @rdname s3_head_object
s3_head_object <- function(Bucket, IfMatch = NULL, IfModifiedSince = NULL, IfNoneMatch = NULL, IfUnmodifiedSince = NULL, Key, Range = NULL, VersionId = NULL, SSECustomerAlgorithm = NULL, SSECustomerKey = NULL, SSECustomerKeyMD5 = NULL, RequestPayer = NULL, PartNumber = NULL, ExpectedBucketOwner = NULL, ChecksumMode = NULL) {
  op <- new_operation(
    name = "HeadObject",
    http_method = "HEAD",
    http_path = "/{Bucket}/{Key+}",
    paginator = list()
  )
  input <- .s3$head_object_input(Bucket = Bucket, IfMatch = IfMatch, IfModifiedSince = IfModifiedSince, IfNoneMatch = IfNoneMatch, IfUnmodifiedSince = IfUnmodifiedSince, Key = Key, Range = Range, VersionId = VersionId, SSECustomerAlgorithm = SSECustomerAlgorithm, SSECustomerKey = SSECustomerKey, SSECustomerKeyMD5 = SSECustomerKeyMD5, RequestPayer = RequestPayer, PartNumber = PartNumber, ExpectedBucketOwner = ExpectedBucketOwner, ChecksumMode = ChecksumMode)
  output <- .s3$head_object_output()
  config <- get_config()
  svc <- .s3$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$head_object <- s3_head_object

#' Lists the analytics configurations for the bucket
#'
#' @description
#' Lists the analytics configurations for the bucket. You can have up to 1,000 analytics configurations per bucket.
#'
#' See [https://paws-r.github.io/docs/s3/list_bucket_analytics_configurations.html](https://paws-r.github.io/docs/s3/list_bucket_analytics_configurations.html) for full documentation.
#'
#' @param Bucket &#91;required&#93; The name of the bucket from which analytics configurations are
#' retrieved.
#' @param ContinuationToken The ContinuationToken that represents a placeholder from where this
#' request should begin.
#' @param ExpectedBucketOwner The account ID of the expected bucket owner. If the bucket is owned by a
#' different account, the request fails with the HTTP status code
#' `403 Forbidden` (access denied).
#'
#' @keywords internal
#'
#' @rdname s3_list_bucket_analytics_configurations
s3_list_bucket_analytics_configurations <- function(Bucket, ContinuationToken = NULL, ExpectedBucketOwner = NULL) {
  op <- new_operation(
    name = "ListBucketAnalyticsConfigurations",
    http_method = "GET",
    http_path = "/{Bucket}?analytics",
    paginator = list()
  )
  input <- .s3$list_bucket_analytics_configurations_input(Bucket = Bucket, ContinuationToken = ContinuationToken, ExpectedBucketOwner = ExpectedBucketOwner)
  output <- .s3$list_bucket_analytics_configurations_output()
  config <- get_config()
  svc <- .s3$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$list_bucket_analytics_configurations <- s3_list_bucket_analytics_configurations

#' Lists the S3 Intelligent-Tiering configuration from the specified bucket
#'
#' @description
#' Lists the S3 Intelligent-Tiering configuration from the specified bucket.
#'
#' See [https://paws-r.github.io/docs/s3/list_bucket_intelligent_tiering_configurations.html](https://paws-r.github.io/docs/s3/list_bucket_intelligent_tiering_configurations.html) for full documentation.
#'
#' @param Bucket &#91;required&#93; The name of the Amazon S3 bucket whose configuration you want to modify
#' or retrieve.
#' @param ContinuationToken The `ContinuationToken` that represents a placeholder from where this
#' request should begin.
#'
#' @keywords internal
#'
#' @rdname s3_list_bucket_intelligent_tiering_configurations
s3_list_bucket_intelligent_tiering_configurations <- function(Bucket, ContinuationToken = NULL) {
  op <- new_operation(
    name = "ListBucketIntelligentTieringConfigurations",
    http_method = "GET",
    http_path = "/{Bucket}?intelligent-tiering",
    paginator = list()
  )
  input <- .s3$list_bucket_intelligent_tiering_configurations_input(Bucket = Bucket, ContinuationToken = ContinuationToken)
  output <- .s3$list_bucket_intelligent_tiering_configurations_output()
  config <- get_config()
  svc <- .s3$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$list_bucket_intelligent_tiering_configurations <- s3_list_bucket_intelligent_tiering_configurations

#' Returns a list of inventory configurations for the bucket
#'
#' @description
#' Returns a list of inventory configurations for the bucket. You can have up to 1,000 analytics configurations per bucket.
#'
#' See [https://paws-r.github.io/docs/s3/list_bucket_inventory_configurations.html](https://paws-r.github.io/docs/s3/list_bucket_inventory_configurations.html) for full documentation.
#'
#' @param Bucket &#91;required&#93; The name of the bucket containing the inventory configurations to
#' retrieve.
#' @param ContinuationToken The marker used to continue an inventory configuration listing that has
#' been truncated. Use the NextContinuationToken from a previously
#' truncated list response to continue the listing. The continuation token
#' is an opaque value that Amazon S3 understands.
#' @param ExpectedBucketOwner The account ID of the expected bucket owner. If the bucket is owned by a
#' different account, the request fails with the HTTP status code
#' `403 Forbidden` (access denied).
#'
#' @keywords internal
#'
#' @rdname s3_list_bucket_inventory_configurations
s3_list_bucket_inventory_configurations <- function(Bucket, ContinuationToken = NULL, ExpectedBucketOwner = NULL) {
  op <- new_operation(
    name = "ListBucketInventoryConfigurations",
    http_method = "GET",
    http_path = "/{Bucket}?inventory",
    paginator = list()
  )
  input <- .s3$list_bucket_inventory_configurations_input(Bucket = Bucket, ContinuationToken = ContinuationToken, ExpectedBucketOwner = ExpectedBucketOwner)
  output <- .s3$list_bucket_inventory_configurations_output()
  config <- get_config()
  svc <- .s3$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$list_bucket_inventory_configurations <- s3_list_bucket_inventory_configurations

#' Lists the metrics configurations for the bucket
#'
#' @description
#' Lists the metrics configurations for the bucket. The metrics configurations are only for the request metrics of the bucket and do not provide information on daily storage metrics. You can have up to 1,000 configurations per bucket.
#'
#' See [https://paws-r.github.io/docs/s3/list_bucket_metrics_configurations.html](https://paws-r.github.io/docs/s3/list_bucket_metrics_configurations.html) for full documentation.
#'
#' @param Bucket &#91;required&#93; The name of the bucket containing the metrics configurations to
#' retrieve.
#' @param ContinuationToken The marker that is used to continue a metrics configuration listing that
#' has been truncated. Use the NextContinuationToken from a previously
#' truncated list response to continue the listing. The continuation token
#' is an opaque value that Amazon S3 understands.
#' @param ExpectedBucketOwner The account ID of the expected bucket owner. If the bucket is owned by a
#' different account, the request fails with the HTTP status code
#' `403 Forbidden` (access denied).
#'
#' @keywords internal
#'
#' @rdname s3_list_bucket_metrics_configurations
s3_list_bucket_metrics_configurations <- function(Bucket, ContinuationToken = NULL, ExpectedBucketOwner = NULL) {
  op <- new_operation(
    name = "ListBucketMetricsConfigurations",
    http_method = "GET",
    http_path = "/{Bucket}?metrics",
    paginator = list()
  )
  input <- .s3$list_bucket_metrics_configurations_input(Bucket = Bucket, ContinuationToken = ContinuationToken, ExpectedBucketOwner = ExpectedBucketOwner)
  output <- .s3$list_bucket_metrics_configurations_output()
  config <- get_config()
  svc <- .s3$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$list_bucket_metrics_configurations <- s3_list_bucket_metrics_configurations

#' Returns a list of all buckets owned by the authenticated sender of the
#' request
#'
#' @description
#' Returns a list of all buckets owned by the authenticated sender of the request. To use this operation, you must have the `s3:ListAllMyBuckets` permission.
#'
#' See [https://paws-r.github.io/docs/s3/list_buckets.html](https://paws-r.github.io/docs/s3/list_buckets.html) for full documentation.
#'

#'
#' @keywords internal
#'
#' @rdname s3_list_buckets
s3_list_buckets <- function() {
  op <- new_operation(
    name = "ListBuckets",
    http_method = "GET",
    http_path = "/",
    paginator = list()
  )
  input <- .s3$list_buckets_input()
  output <- .s3$list_buckets_output()
  config <- get_config()
  svc <- .s3$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$list_buckets <- s3_list_buckets

#' This action lists in-progress multipart uploads
#'
#' @description
#' This action lists in-progress multipart uploads. An in-progress multipart upload is a multipart upload that has been initiated using the Initiate Multipart Upload request, but has not yet been completed or aborted.
#'
#' See [https://paws-r.github.io/docs/s3/list_multipart_uploads.html](https://paws-r.github.io/docs/s3/list_multipart_uploads.html) for full documentation.
#'
#' @param Bucket &#91;required&#93; The name of the bucket to which the multipart upload was initiated.
#' 
#' When using this action with an access point, you must direct requests to
#' the access point hostname. The access point hostname takes the form
#' *AccessPointName*-*AccountId*.s3-accesspoint.*Region*.amazonaws.com.
#' When using this action with an access point through the Amazon Web
#' Services SDKs, you provide the access point ARN in place of the bucket
#' name. For more information about access point ARNs, see [Using access
#' points](https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html)
#' in the *Amazon S3 User Guide*.
#' 
#' When using this action with Amazon S3 on Outposts, you must direct
#' requests to the S3 on Outposts hostname. The S3 on Outposts hostname
#' takes the form
#' ` AccessPointName-AccountId.outpostID.s3-outposts.Region.amazonaws.com`.
#' When using this action with S3 on Outposts through the Amazon Web
#' Services SDKs, you provide the Outposts bucket ARN in place of the
#' bucket name. For more information about S3 on Outposts ARNs, see [Using
#' Amazon S3 on
#' Outposts](https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html)
#' in the *Amazon S3 User Guide*.
#' @param Delimiter Character you use to group keys.
#' 
#' All keys that contain the same string between the prefix, if specified,
#' and the first occurrence of the delimiter after the prefix are grouped
#' under a single result element, `CommonPrefixes`. If you don't specify
#' the prefix parameter, then the substring starts at the beginning of the
#' key. The keys that are grouped under `CommonPrefixes` result element are
#' not returned elsewhere in the response.
#' @param EncodingType 
#' @param KeyMarker Together with upload-id-marker, this parameter specifies the multipart
#' upload after which listing should begin.
#' 
#' If `upload-id-marker` is not specified, only the keys lexicographically
#' greater than the specified `key-marker` will be included in the list.
#' 
#' If `upload-id-marker` is specified, any multipart uploads for a key
#' equal to the `key-marker` might also be included, provided those
#' multipart uploads have upload IDs lexicographically greater than the
#' specified `upload-id-marker`.
#' @param MaxUploads Sets the maximum number of multipart uploads, from 1 to 1,000, to return
#' in the response body. 1,000 is the maximum number of uploads that can be
#' returned in a response.
#' @param Prefix Lists in-progress uploads only for those keys that begin with the
#' specified prefix. You can use prefixes to separate a bucket into
#' different grouping of keys. (You can think of using prefix to make
#' groups in the same way you'd use a folder in a file system.)
#' @param UploadIdMarker Together with key-marker, specifies the multipart upload after which
#' listing should begin. If key-marker is not specified, the
#' upload-id-marker parameter is ignored. Otherwise, any multipart uploads
#' for a key equal to the key-marker might be included in the list only if
#' they have an upload ID lexicographically greater than the specified
#' `upload-id-marker`.
#' @param ExpectedBucketOwner The account ID of the expected bucket owner. If the bucket is owned by a
#' different account, the request fails with the HTTP status code
#' `403 Forbidden` (access denied).
#'
#' @keywords internal
#'
#' @rdname s3_list_multipart_uploads
s3_list_multipart_uploads <- function(Bucket, Delimiter = NULL, EncodingType = NULL, KeyMarker = NULL, MaxUploads = NULL, Prefix = NULL, UploadIdMarker = NULL, ExpectedBucketOwner = NULL) {
  op <- new_operation(
    name = "ListMultipartUploads",
    http_method = "GET",
    http_path = "/{Bucket}?uploads",
    paginator = list()
  )
  input <- .s3$list_multipart_uploads_input(Bucket = Bucket, Delimiter = Delimiter, EncodingType = EncodingType, KeyMarker = KeyMarker, MaxUploads = MaxUploads, Prefix = Prefix, UploadIdMarker = UploadIdMarker, ExpectedBucketOwner = ExpectedBucketOwner)
  output <- .s3$list_multipart_uploads_output()
  config <- get_config()
  svc <- .s3$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$list_multipart_uploads <- s3_list_multipart_uploads

#' Returns metadata about all versions of the objects in a bucket
#'
#' @description
#' Returns metadata about all versions of the objects in a bucket. You can also use request parameters as selection criteria to return metadata about a subset of all the object versions.
#'
#' See [https://paws-r.github.io/docs/s3/list_object_versions.html](https://paws-r.github.io/docs/s3/list_object_versions.html) for full documentation.
#'
#' @param Bucket &#91;required&#93; The bucket name that contains the objects.
#' @param Delimiter A delimiter is a character that you specify to group keys. All keys that
#' contain the same string between the `prefix` and the first occurrence of
#' the delimiter are grouped under a single result element in
#' CommonPrefixes. These groups are counted as one result against the
#' max-keys limitation. These keys are not returned elsewhere in the
#' response.
#' @param EncodingType 
#' @param KeyMarker Specifies the key to start with when listing objects in a bucket.
#' @param MaxKeys Sets the maximum number of keys returned in the response. By default the
#' action returns up to 1,000 key names. The response might contain fewer
#' keys but will never contain more. If additional keys satisfy the search
#' criteria, but were not returned because max-keys was exceeded, the
#' response contains \<isTruncated\>true\</isTruncated\>. To return the
#' additional keys, see key-marker and version-id-marker.
#' @param Prefix Use this parameter to select only those keys that begin with the
#' specified prefix. You can use prefixes to separate a bucket into
#' different groupings of keys. (You can think of using prefix to make
#' groups in the same way you'd use a folder in a file system.) You can use
#' prefix with delimiter to roll up numerous objects into a single result
#' under CommonPrefixes.
#' @param VersionIdMarker Specifies the object version you want to start listing from.
#' @param ExpectedBucketOwner The account ID of the expected bucket owner. If the bucket is owned by a
#' different account, the request fails with the HTTP status code
#' `403 Forbidden` (access denied).
#'
#' @keywords internal
#'
#' @rdname s3_list_object_versions
s3_list_object_versions <- function(Bucket, Delimiter = NULL, EncodingType = NULL, KeyMarker = NULL, MaxKeys = NULL, Prefix = NULL, VersionIdMarker = NULL, ExpectedBucketOwner = NULL) {
  op <- new_operation(
    name = "ListObjectVersions",
    http_method = "GET",
    http_path = "/{Bucket}?versions",
    paginator = list()
  )
  input <- .s3$list_object_versions_input(Bucket = Bucket, Delimiter = Delimiter, EncodingType = EncodingType, KeyMarker = KeyMarker, MaxKeys = MaxKeys, Prefix = Prefix, VersionIdMarker = VersionIdMarker, ExpectedBucketOwner = ExpectedBucketOwner)
  output <- .s3$list_object_versions_output()
  config <- get_config()
  svc <- .s3$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$list_object_versions <- s3_list_object_versions

#' Returns some or all (up to 1,000) of the objects in a bucket
#'
#' @description
#' Returns some or all (up to 1,000) of the objects in a bucket. You can use the request parameters as selection criteria to return a subset of the objects in a bucket. A 200 OK response can contain valid or invalid XML. Be sure to design your application to parse the contents of the response and handle it appropriately.
#'
#' See [https://paws-r.github.io/docs/s3/list_objects.html](https://paws-r.github.io/docs/s3/list_objects.html) for full documentation.
#'
#' @param Bucket &#91;required&#93; The name of the bucket containing the objects.
#' 
#' When using this action with an access point, you must direct requests to
#' the access point hostname. The access point hostname takes the form
#' *AccessPointName*-*AccountId*.s3-accesspoint.*Region*.amazonaws.com.
#' When using this action with an access point through the Amazon Web
#' Services SDKs, you provide the access point ARN in place of the bucket
#' name. For more information about access point ARNs, see [Using access
#' points](https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html)
#' in the *Amazon S3 User Guide*.
#' 
#' When using this action with Amazon S3 on Outposts, you must direct
#' requests to the S3 on Outposts hostname. The S3 on Outposts hostname
#' takes the form
#' ` AccessPointName-AccountId.outpostID.s3-outposts.Region.amazonaws.com`.
#' When using this action with S3 on Outposts through the Amazon Web
#' Services SDKs, you provide the Outposts bucket ARN in place of the
#' bucket name. For more information about S3 on Outposts ARNs, see [Using
#' Amazon S3 on
#' Outposts](https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html)
#' in the *Amazon S3 User Guide*.
#' @param Delimiter A delimiter is a character you use to group keys.
#' @param EncodingType 
#' @param Marker Marker is where you want Amazon S3 to start listing from. Amazon S3
#' starts listing after this specified key. Marker can be any key in the
#' bucket.
#' @param MaxKeys Sets the maximum number of keys returned in the response. By default the
#' action returns up to 1,000 key names. The response might contain fewer
#' keys but will never contain more.
#' @param Prefix Limits the response to keys that begin with the specified prefix.
#' @param RequestPayer Confirms that the requester knows that she or he will be charged for the
#' list objects request. Bucket owners need not specify this parameter in
#' their requests.
#' @param ExpectedBucketOwner The account ID of the expected bucket owner. If the bucket is owned by a
#' different account, the request fails with the HTTP status code
#' `403 Forbidden` (access denied).
#'
#' @keywords internal
#'
#' @rdname s3_list_objects
s3_list_objects <- function(Bucket, Delimiter = NULL, EncodingType = NULL, Marker = NULL, MaxKeys = NULL, Prefix = NULL, RequestPayer = NULL, ExpectedBucketOwner = NULL) {
  op <- new_operation(
    name = "ListObjects",
    http_method = "GET",
    http_path = "/{Bucket}",
    paginator = list()
  )
  input <- .s3$list_objects_input(Bucket = Bucket, Delimiter = Delimiter, EncodingType = EncodingType, Marker = Marker, MaxKeys = MaxKeys, Prefix = Prefix, RequestPayer = RequestPayer, ExpectedBucketOwner = ExpectedBucketOwner)
  output <- .s3$list_objects_output()
  config <- get_config()
  svc <- .s3$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$list_objects <- s3_list_objects

#' Returns some or all (up to 1,000) of the objects in a bucket with each
#' request
#'
#' @description
#' Returns some or all (up to 1,000) of the objects in a bucket with each request. You can use the request parameters as selection criteria to return a subset of the objects in a bucket. A `200 OK` response can contain valid or invalid XML. Make sure to design your application to parse the contents of the response and handle it appropriately. Objects are returned sorted in an ascending order of the respective key names in the list. For more information about listing objects, see [Listing object keys programmatically](https://docs.aws.amazon.com/AmazonS3/latest/userguide/ListingKeysUsingAPIs.html)
#'
#' See [https://paws-r.github.io/docs/s3/list_objects_v2.html](https://paws-r.github.io/docs/s3/list_objects_v2.html) for full documentation.
#'
#' @param Bucket &#91;required&#93; Bucket name to list.
#' 
#' When using this action with an access point, you must direct requests to
#' the access point hostname. The access point hostname takes the form
#' *AccessPointName*-*AccountId*.s3-accesspoint.*Region*.amazonaws.com.
#' When using this action with an access point through the Amazon Web
#' Services SDKs, you provide the access point ARN in place of the bucket
#' name. For more information about access point ARNs, see [Using access
#' points](https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html)
#' in the *Amazon S3 User Guide*.
#' 
#' When using this action with Amazon S3 on Outposts, you must direct
#' requests to the S3 on Outposts hostname. The S3 on Outposts hostname
#' takes the form
#' ` AccessPointName-AccountId.outpostID.s3-outposts.Region.amazonaws.com`.
#' When using this action with S3 on Outposts through the Amazon Web
#' Services SDKs, you provide the Outposts bucket ARN in place of the
#' bucket name. For more information about S3 on Outposts ARNs, see [Using
#' Amazon S3 on
#' Outposts](https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html)
#' in the *Amazon S3 User Guide*.
#' @param Delimiter A delimiter is a character you use to group keys.
#' @param EncodingType Encoding type used by Amazon S3 to encode object keys in the response.
#' @param MaxKeys Sets the maximum number of keys returned in the response. By default the
#' action returns up to 1,000 key names. The response might contain fewer
#' keys but will never contain more.
#' @param Prefix Limits the response to keys that begin with the specified prefix.
#' @param ContinuationToken ContinuationToken indicates Amazon S3 that the list is being continued
#' on this bucket with a token. ContinuationToken is obfuscated and is not
#' a real key.
#' @param FetchOwner The owner field is not present in listV2 by default, if you want to
#' return owner field with each key in the result then set the fetch owner
#' field to true.
#' @param StartAfter StartAfter is where you want Amazon S3 to start listing from. Amazon S3
#' starts listing after this specified key. StartAfter can be any key in
#' the bucket.
#' @param RequestPayer Confirms that the requester knows that she or he will be charged for the
#' list objects request in V2 style. Bucket owners need not specify this
#' parameter in their requests.
#' @param ExpectedBucketOwner The account ID of the expected bucket owner. If the bucket is owned by a
#' different account, the request fails with the HTTP status code
#' `403 Forbidden` (access denied).
#'
#' @keywords internal
#'
#' @rdname s3_list_objects_v2
s3_list_objects_v2 <- function(Bucket, Delimiter = NULL, EncodingType = NULL, MaxKeys = NULL, Prefix = NULL, ContinuationToken = NULL, FetchOwner = NULL, StartAfter = NULL, RequestPayer = NULL, ExpectedBucketOwner = NULL) {
  op <- new_operation(
    name = "ListObjectsV2",
    http_method = "GET",
    http_path = "/{Bucket}?list-type=2",
    paginator = list()
  )
  input <- .s3$list_objects_v2_input(Bucket = Bucket, Delimiter = Delimiter, EncodingType = EncodingType, MaxKeys = MaxKeys, Prefix = Prefix, ContinuationToken = ContinuationToken, FetchOwner = FetchOwner, StartAfter = StartAfter, RequestPayer = RequestPayer, ExpectedBucketOwner = ExpectedBucketOwner)
  output <- .s3$list_objects_v2_output()
  config <- get_config()
  svc <- .s3$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$list_objects_v2 <- s3_list_objects_v2

#' Lists the parts that have been uploaded for a specific multipart upload
#'
#' @description
#' Lists the parts that have been uploaded for a specific multipart upload. This operation must include the upload ID, which you obtain by sending the initiate multipart upload request (see [`create_multipart_upload`][s3_create_multipart_upload]). This request returns a maximum of 1,000 uploaded parts. The default number of parts returned is 1,000 parts. You can restrict the number of parts returned by specifying the `max-parts` request parameter. If your multipart upload consists of more than 1,000 parts, the response returns an `IsTruncated` field with the value of true, and a `NextPartNumberMarker` element. In subsequent [`list_parts`][s3_list_parts] requests you can include the part-number-marker query string parameter and set its value to the `NextPartNumberMarker` field value from the previous response.
#'
#' See [https://paws-r.github.io/docs/s3/list_parts.html](https://paws-r.github.io/docs/s3/list_parts.html) for full documentation.
#'
#' @param Bucket &#91;required&#93; The name of the bucket to which the parts are being uploaded.
#' 
#' When using this action with an access point, you must direct requests to
#' the access point hostname. The access point hostname takes the form
#' *AccessPointName*-*AccountId*.s3-accesspoint.*Region*.amazonaws.com.
#' When using this action with an access point through the Amazon Web
#' Services SDKs, you provide the access point ARN in place of the bucket
#' name. For more information about access point ARNs, see [Using access
#' points](https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html)
#' in the *Amazon S3 User Guide*.
#' 
#' When using this action with Amazon S3 on Outposts, you must direct
#' requests to the S3 on Outposts hostname. The S3 on Outposts hostname
#' takes the form
#' ` AccessPointName-AccountId.outpostID.s3-outposts.Region.amazonaws.com`.
#' When using this action with S3 on Outposts through the Amazon Web
#' Services SDKs, you provide the Outposts bucket ARN in place of the
#' bucket name. For more information about S3 on Outposts ARNs, see [Using
#' Amazon S3 on
#' Outposts](https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html)
#' in the *Amazon S3 User Guide*.
#' @param Key &#91;required&#93; Object key for which the multipart upload was initiated.
#' @param MaxParts Sets the maximum number of parts to return.
#' @param PartNumberMarker Specifies the part after which listing should begin. Only parts with
#' higher part numbers will be listed.
#' @param UploadId &#91;required&#93; Upload ID identifying the multipart upload whose parts are being listed.
#' @param RequestPayer 
#' @param ExpectedBucketOwner The account ID of the expected bucket owner. If the bucket is owned by a
#' different account, the request fails with the HTTP status code
#' `403 Forbidden` (access denied).
#' @param SSECustomerAlgorithm The server-side encryption (SSE) algorithm used to encrypt the object.
#' This parameter is needed only when the object was created using a
#' checksum algorithm. For more information, see [Protecting data using
#' SSE-C
#' keys](https://docs.aws.amazon.com/AmazonS3/latest/userguide/ServerSideEncryptionCustomerKeys.html)
#' in the *Amazon S3 User Guide*.
#' @param SSECustomerKey The server-side encryption (SSE) customer managed key. This parameter is
#' needed only when the object was created using a checksum algorithm. For
#' more information, see [Protecting data using SSE-C
#' keys](https://docs.aws.amazon.com/AmazonS3/latest/userguide/ServerSideEncryptionCustomerKeys.html)
#' in the *Amazon S3 User Guide*.
#' @param SSECustomerKeyMD5 The MD5 server-side encryption (SSE) customer managed key. This
#' parameter is needed only when the object was created using a checksum
#' algorithm. For more information, see [Protecting data using SSE-C
#' keys](https://docs.aws.amazon.com/AmazonS3/latest/userguide/ServerSideEncryptionCustomerKeys.html)
#' in the *Amazon S3 User Guide*.
#'
#' @keywords internal
#'
#' @rdname s3_list_parts
s3_list_parts <- function(Bucket, Key, MaxParts = NULL, PartNumberMarker = NULL, UploadId, RequestPayer = NULL, ExpectedBucketOwner = NULL, SSECustomerAlgorithm = NULL, SSECustomerKey = NULL, SSECustomerKeyMD5 = NULL) {
  op <- new_operation(
    name = "ListParts",
    http_method = "GET",
    http_path = "/{Bucket}/{Key+}",
    paginator = list()
  )
  input <- .s3$list_parts_input(Bucket = Bucket, Key = Key, MaxParts = MaxParts, PartNumberMarker = PartNumberMarker, UploadId = UploadId, RequestPayer = RequestPayer, ExpectedBucketOwner = ExpectedBucketOwner, SSECustomerAlgorithm = SSECustomerAlgorithm, SSECustomerKey = SSECustomerKey, SSECustomerKeyMD5 = SSECustomerKeyMD5)
  output <- .s3$list_parts_output()
  config <- get_config()
  svc <- .s3$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$list_parts <- s3_list_parts

#' Sets the accelerate configuration of an existing bucket
#'
#' @description
#' Sets the accelerate configuration of an existing bucket. Amazon S3 Transfer Acceleration is a bucket-level feature that enables you to perform faster data transfers to Amazon S3.
#'
#' See [https://paws-r.github.io/docs/s3/put_bucket_accelerate_configuration.html](https://paws-r.github.io/docs/s3/put_bucket_accelerate_configuration.html) for full documentation.
#'
#' @param Bucket &#91;required&#93; The name of the bucket for which the accelerate configuration is set.
#' @param AccelerateConfiguration &#91;required&#93; Container for setting the transfer acceleration state.
#' @param ExpectedBucketOwner The account ID of the expected bucket owner. If the bucket is owned by a
#' different account, the request fails with the HTTP status code
#' `403 Forbidden` (access denied).
#' @param ChecksumAlgorithm Indicates the algorithm used to create the checksum for the object when
#' using the SDK. This header will not provide any additional functionality
#' if not using the SDK. When sending this header, there must be a
#' corresponding `x-amz-checksum` or `x-amz-trailer` header sent.
#' Otherwise, Amazon S3 fails the request with the HTTP status code
#' `400 Bad Request`. For more information, see [Checking object
#' integrity](https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html)
#' in the *Amazon S3 User Guide*.
#' 
#' If you provide an individual checksum, Amazon S3 ignores any provided
#' `ChecksumAlgorithm` parameter.
#'
#' @keywords internal
#'
#' @rdname s3_put_bucket_accelerate_configuration
s3_put_bucket_accelerate_configuration <- function(Bucket, AccelerateConfiguration, ExpectedBucketOwner = NULL, ChecksumAlgorithm = NULL) {
  op <- new_operation(
    name = "PutBucketAccelerateConfiguration",
    http_method = "PUT",
    http_path = "/{Bucket}?accelerate",
    paginator = list()
  )
  input <- .s3$put_bucket_accelerate_configuration_input(Bucket = Bucket, AccelerateConfiguration = AccelerateConfiguration, ExpectedBucketOwner = ExpectedBucketOwner, ChecksumAlgorithm = ChecksumAlgorithm)
  output <- .s3$put_bucket_accelerate_configuration_output()
  config <- get_config()
  svc <- .s3$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$put_bucket_accelerate_configuration <- s3_put_bucket_accelerate_configuration

#' Sets the permissions on an existing bucket using access control lists
#' (ACL)
#'
#' @description
#' Sets the permissions on an existing bucket using access control lists (ACL). For more information, see [Using ACLs](https://docs.aws.amazon.com/AmazonS3/latest/userguide/acl-overview.html). To set the ACL of a bucket, you must have `WRITE_ACP` permission.
#'
#' See [https://paws-r.github.io/docs/s3/put_bucket_acl.html](https://paws-r.github.io/docs/s3/put_bucket_acl.html) for full documentation.
#'
#' @param ACL The canned ACL to apply to the bucket.
#' @param AccessControlPolicy Contains the elements that set the ACL permissions for an object per
#' grantee.
#' @param Bucket &#91;required&#93; The bucket to which to apply the ACL.
#' @param ContentMD5 The base64-encoded 128-bit MD5 digest of the data. This header must be
#' used as a message integrity check to verify that the request body was
#' not corrupted in transit. For more information, go to [RFC
#' 1864.](https://www.ietf.org/rfc/rfc1864.txt)
#' 
#' For requests made using the Amazon Web Services Command Line Interface
#' (CLI) or Amazon Web Services SDKs, this field is calculated
#' automatically.
#' @param ChecksumAlgorithm Indicates the algorithm used to create the checksum for the object when
#' using the SDK. This header will not provide any additional functionality
#' if not using the SDK. When sending this header, there must be a
#' corresponding `x-amz-checksum` or `x-amz-trailer` header sent.
#' Otherwise, Amazon S3 fails the request with the HTTP status code
#' `400 Bad Request`. For more information, see [Checking object
#' integrity](https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html)
#' in the *Amazon S3 User Guide*.
#' 
#' If you provide an individual checksum, Amazon S3 ignores any provided
#' `ChecksumAlgorithm` parameter.
#' @param GrantFullControl Allows grantee the read, write, read ACP, and write ACP permissions on
#' the bucket.
#' @param GrantRead Allows grantee to list the objects in the bucket.
#' @param GrantReadACP Allows grantee to read the bucket ACL.
#' @param GrantWrite Allows grantee to create new objects in the bucket.
#' 
#' For the bucket and object owners of existing objects, also allows
#' deletions and overwrites of those objects.
#' @param GrantWriteACP Allows grantee to write the ACL for the applicable bucket.
#' @param ExpectedBucketOwner The account ID of the expected bucket owner. If the bucket is owned by a
#' different account, the request fails with the HTTP status code
#' `403 Forbidden` (access denied).
#'
#' @keywords internal
#'
#' @rdname s3_put_bucket_acl
s3_put_bucket_acl <- function(ACL = NULL, AccessControlPolicy = NULL, Bucket, ContentMD5 = NULL, ChecksumAlgorithm = NULL, GrantFullControl = NULL, GrantRead = NULL, GrantReadACP = NULL, GrantWrite = NULL, GrantWriteACP = NULL, ExpectedBucketOwner = NULL) {
  op <- new_operation(
    name = "PutBucketAcl",
    http_method = "PUT",
    http_path = "/{Bucket}?acl",
    paginator = list()
  )
  input <- .s3$put_bucket_acl_input(ACL = ACL, AccessControlPolicy = AccessControlPolicy, Bucket = Bucket, ContentMD5 = ContentMD5, ChecksumAlgorithm = ChecksumAlgorithm, GrantFullControl = GrantFullControl, GrantRead = GrantRead, GrantReadACP = GrantReadACP, GrantWrite = GrantWrite, GrantWriteACP = GrantWriteACP, ExpectedBucketOwner = ExpectedBucketOwner)
  output <- .s3$put_bucket_acl_output()
  config <- get_config()
  svc <- .s3$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$put_bucket_acl <- s3_put_bucket_acl

#' Sets an analytics configuration for the bucket (specified by the
#' analytics configuration ID)
#'
#' @description
#' Sets an analytics configuration for the bucket (specified by the analytics configuration ID). You can have up to 1,000 analytics configurations per bucket.
#'
#' See [https://paws-r.github.io/docs/s3/put_bucket_analytics_configuration.html](https://paws-r.github.io/docs/s3/put_bucket_analytics_configuration.html) for full documentation.
#'
#' @param Bucket &#91;required&#93; The name of the bucket to which an analytics configuration is stored.
#' @param Id &#91;required&#93; The ID that identifies the analytics configuration.
#' @param AnalyticsConfiguration &#91;required&#93; The configuration and any analyses for the analytics filter.
#' @param ExpectedBucketOwner The account ID of the expected bucket owner. If the bucket is owned by a
#' different account, the request fails with the HTTP status code
#' `403 Forbidden` (access denied).
#'
#' @keywords internal
#'
#' @rdname s3_put_bucket_analytics_configuration
s3_put_bucket_analytics_configuration <- function(Bucket, Id, AnalyticsConfiguration, ExpectedBucketOwner = NULL) {
  op <- new_operation(
    name = "PutBucketAnalyticsConfiguration",
    http_method = "PUT",
    http_path = "/{Bucket}?analytics",
    paginator = list()
  )
  input <- .s3$put_bucket_analytics_configuration_input(Bucket = Bucket, Id = Id, AnalyticsConfiguration = AnalyticsConfiguration, ExpectedBucketOwner = ExpectedBucketOwner)
  output <- .s3$put_bucket_analytics_configuration_output()
  config <- get_config()
  svc <- .s3$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$put_bucket_analytics_configuration <- s3_put_bucket_analytics_configuration

#' Sets the cors configuration for your bucket
#'
#' @description
#' Sets the `cors` configuration for your bucket. If the configuration exists, Amazon S3 replaces it.
#'
#' See [https://paws-r.github.io/docs/s3/put_bucket_cors.html](https://paws-r.github.io/docs/s3/put_bucket_cors.html) for full documentation.
#'
#' @param Bucket &#91;required&#93; Specifies the bucket impacted by the `cors`configuration.
#' @param CORSConfiguration &#91;required&#93; Describes the cross-origin access configuration for objects in an Amazon
#' S3 bucket. For more information, see [Enabling Cross-Origin Resource
#' Sharing](https://docs.aws.amazon.com/AmazonS3/latest/userguide/cors.html)
#' in the *Amazon S3 User Guide*.
#' @param ContentMD5 The base64-encoded 128-bit MD5 digest of the data. This header must be
#' used as a message integrity check to verify that the request body was
#' not corrupted in transit. For more information, go to [RFC
#' 1864.](https://www.ietf.org/rfc/rfc1864.txt)
#' 
#' For requests made using the Amazon Web Services Command Line Interface
#' (CLI) or Amazon Web Services SDKs, this field is calculated
#' automatically.
#' @param ChecksumAlgorithm Indicates the algorithm used to create the checksum for the object when
#' using the SDK. This header will not provide any additional functionality
#' if not using the SDK. When sending this header, there must be a
#' corresponding `x-amz-checksum` or `x-amz-trailer` header sent.
#' Otherwise, Amazon S3 fails the request with the HTTP status code
#' `400 Bad Request`. For more information, see [Checking object
#' integrity](https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html)
#' in the *Amazon S3 User Guide*.
#' 
#' If you provide an individual checksum, Amazon S3 ignores any provided
#' `ChecksumAlgorithm` parameter.
#' @param ExpectedBucketOwner The account ID of the expected bucket owner. If the bucket is owned by a
#' different account, the request fails with the HTTP status code
#' `403 Forbidden` (access denied).
#'
#' @keywords internal
#'
#' @rdname s3_put_bucket_cors
s3_put_bucket_cors <- function(Bucket, CORSConfiguration, ContentMD5 = NULL, ChecksumAlgorithm = NULL, ExpectedBucketOwner = NULL) {
  op <- new_operation(
    name = "PutBucketCors",
    http_method = "PUT",
    http_path = "/{Bucket}?cors",
    paginator = list()
  )
  input <- .s3$put_bucket_cors_input(Bucket = Bucket, CORSConfiguration = CORSConfiguration, ContentMD5 = ContentMD5, ChecksumAlgorithm = ChecksumAlgorithm, ExpectedBucketOwner = ExpectedBucketOwner)
  output <- .s3$put_bucket_cors_output()
  config <- get_config()
  svc <- .s3$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$put_bucket_cors <- s3_put_bucket_cors

#' This action uses the encryption subresource to configure default
#' encryption and Amazon S3 Bucket Key for an existing bucket
#'
#' @description
#' This action uses the `encryption` subresource to configure default encryption and Amazon S3 Bucket Key for an existing bucket.
#'
#' See [https://paws-r.github.io/docs/s3/put_bucket_encryption.html](https://paws-r.github.io/docs/s3/put_bucket_encryption.html) for full documentation.
#'
#' @param Bucket &#91;required&#93; Specifies default encryption for a bucket using server-side encryption
#' with Amazon S3-managed keys (SSE-S3) or customer managed keys (SSE-KMS).
#' For information about the Amazon S3 default encryption feature, see
#' [Amazon S3 Default Bucket
#' Encryption](https://docs.aws.amazon.com/AmazonS3/latest/userguide/bucket-encryption.html)
#' in the *Amazon S3 User Guide*.
#' @param ContentMD5 The base64-encoded 128-bit MD5 digest of the server-side encryption
#' configuration.
#' 
#' For requests made using the Amazon Web Services Command Line Interface
#' (CLI) or Amazon Web Services SDKs, this field is calculated
#' automatically.
#' @param ChecksumAlgorithm Indicates the algorithm used to create the checksum for the object when
#' using the SDK. This header will not provide any additional functionality
#' if not using the SDK. When sending this header, there must be a
#' corresponding `x-amz-checksum` or `x-amz-trailer` header sent.
#' Otherwise, Amazon S3 fails the request with the HTTP status code
#' `400 Bad Request`. For more information, see [Checking object
#' integrity](https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html)
#' in the *Amazon S3 User Guide*.
#' 
#' If you provide an individual checksum, Amazon S3 ignores any provided
#' `ChecksumAlgorithm` parameter.
#' @param ServerSideEncryptionConfiguration &#91;required&#93; 
#' @param ExpectedBucketOwner The account ID of the expected bucket owner. If the bucket is owned by a
#' different account, the request fails with the HTTP status code
#' `403 Forbidden` (access denied).
#'
#' @keywords internal
#'
#' @rdname s3_put_bucket_encryption
s3_put_bucket_encryption <- function(Bucket, ContentMD5 = NULL, ChecksumAlgorithm = NULL, ServerSideEncryptionConfiguration, ExpectedBucketOwner = NULL) {
  op <- new_operation(
    name = "PutBucketEncryption",
    http_method = "PUT",
    http_path = "/{Bucket}?encryption",
    paginator = list()
  )
  input <- .s3$put_bucket_encryption_input(Bucket = Bucket, ContentMD5 = ContentMD5, ChecksumAlgorithm = ChecksumAlgorithm, ServerSideEncryptionConfiguration = ServerSideEncryptionConfiguration, ExpectedBucketOwner = ExpectedBucketOwner)
  output <- .s3$put_bucket_encryption_output()
  config <- get_config()
  svc <- .s3$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$put_bucket_encryption <- s3_put_bucket_encryption

#' Puts a S3 Intelligent-Tiering configuration to the specified bucket
#'
#' @description
#' Puts a S3 Intelligent-Tiering configuration to the specified bucket. You can have up to 1,000 S3 Intelligent-Tiering configurations per bucket.
#'
#' See [https://paws-r.github.io/docs/s3/put_bucket_intelligent_tiering_configuration.html](https://paws-r.github.io/docs/s3/put_bucket_intelligent_tiering_configuration.html) for full documentation.
#'
#' @param Bucket &#91;required&#93; The name of the Amazon S3 bucket whose configuration you want to modify
#' or retrieve.
#' @param Id &#91;required&#93; The ID used to identify the S3 Intelligent-Tiering configuration.
#' @param IntelligentTieringConfiguration &#91;required&#93; Container for S3 Intelligent-Tiering configuration.
#'
#' @keywords internal
#'
#' @rdname s3_put_bucket_intelligent_tiering_configuration
s3_put_bucket_intelligent_tiering_configuration <- function(Bucket, Id, IntelligentTieringConfiguration) {
  op <- new_operation(
    name = "PutBucketIntelligentTieringConfiguration",
    http_method = "PUT",
    http_path = "/{Bucket}?intelligent-tiering",
    paginator = list()
  )
  input <- .s3$put_bucket_intelligent_tiering_configuration_input(Bucket = Bucket, Id = Id, IntelligentTieringConfiguration = IntelligentTieringConfiguration)
  output <- .s3$put_bucket_intelligent_tiering_configuration_output()
  config <- get_config()
  svc <- .s3$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$put_bucket_intelligent_tiering_configuration <- s3_put_bucket_intelligent_tiering_configuration

#' This implementation of the PUT action adds an inventory configuration
#' (identified by the inventory ID) to the bucket
#'
#' @description
#' This implementation of the `PUT` action adds an inventory configuration (identified by the inventory ID) to the bucket. You can have up to 1,000 inventory configurations per bucket.
#'
#' See [https://paws-r.github.io/docs/s3/put_bucket_inventory_configuration.html](https://paws-r.github.io/docs/s3/put_bucket_inventory_configuration.html) for full documentation.
#'
#' @param Bucket &#91;required&#93; The name of the bucket where the inventory configuration will be stored.
#' @param Id &#91;required&#93; The ID used to identify the inventory configuration.
#' @param InventoryConfiguration &#91;required&#93; Specifies the inventory configuration.
#' @param ExpectedBucketOwner The account ID of the expected bucket owner. If the bucket is owned by a
#' different account, the request fails with the HTTP status code
#' `403 Forbidden` (access denied).
#'
#' @keywords internal
#'
#' @rdname s3_put_bucket_inventory_configuration
s3_put_bucket_inventory_configuration <- function(Bucket, Id, InventoryConfiguration, ExpectedBucketOwner = NULL) {
  op <- new_operation(
    name = "PutBucketInventoryConfiguration",
    http_method = "PUT",
    http_path = "/{Bucket}?inventory",
    paginator = list()
  )
  input <- .s3$put_bucket_inventory_configuration_input(Bucket = Bucket, Id = Id, InventoryConfiguration = InventoryConfiguration, ExpectedBucketOwner = ExpectedBucketOwner)
  output <- .s3$put_bucket_inventory_configuration_output()
  config <- get_config()
  svc <- .s3$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$put_bucket_inventory_configuration <- s3_put_bucket_inventory_configuration

#' For an updated version of this API, see PutBucketLifecycleConfiguration
#'
#' @description
#' For an updated version of this API, see [`put_bucket_lifecycle_configuration`][s3_put_bucket_lifecycle_configuration]. This version has been deprecated. Existing lifecycle configurations will work. For new lifecycle configurations, use the updated API.
#'
#' See [https://paws-r.github.io/docs/s3/put_bucket_lifecycle.html](https://paws-r.github.io/docs/s3/put_bucket_lifecycle.html) for full documentation.
#'
#' @param Bucket &#91;required&#93; 
#' @param ContentMD5 For requests made using the Amazon Web Services Command Line Interface
#' (CLI) or Amazon Web Services SDKs, this field is calculated
#' automatically.
#' @param ChecksumAlgorithm Indicates the algorithm used to create the checksum for the object when
#' using the SDK. This header will not provide any additional functionality
#' if not using the SDK. When sending this header, there must be a
#' corresponding `x-amz-checksum` or `x-amz-trailer` header sent.
#' Otherwise, Amazon S3 fails the request with the HTTP status code
#' `400 Bad Request`. For more information, see [Checking object
#' integrity](https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html)
#' in the *Amazon S3 User Guide*.
#' 
#' If you provide an individual checksum, Amazon S3 ignores any provided
#' `ChecksumAlgorithm` parameter.
#' @param LifecycleConfiguration 
#' @param ExpectedBucketOwner The account ID of the expected bucket owner. If the bucket is owned by a
#' different account, the request fails with the HTTP status code
#' `403 Forbidden` (access denied).
#'
#' @keywords internal
#'
#' @rdname s3_put_bucket_lifecycle
s3_put_bucket_lifecycle <- function(Bucket, ContentMD5 = NULL, ChecksumAlgorithm = NULL, LifecycleConfiguration = NULL, ExpectedBucketOwner = NULL) {
  op <- new_operation(
    name = "PutBucketLifecycle",
    http_method = "PUT",
    http_path = "/{Bucket}?lifecycle",
    paginator = list()
  )
  input <- .s3$put_bucket_lifecycle_input(Bucket = Bucket, ContentMD5 = ContentMD5, ChecksumAlgorithm = ChecksumAlgorithm, LifecycleConfiguration = LifecycleConfiguration, ExpectedBucketOwner = ExpectedBucketOwner)
  output <- .s3$put_bucket_lifecycle_output()
  config <- get_config()
  svc <- .s3$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$put_bucket_lifecycle <- s3_put_bucket_lifecycle

#' Creates a new lifecycle configuration for the bucket or replaces an
#' existing lifecycle configuration
#'
#' @description
#' Creates a new lifecycle configuration for the bucket or replaces an existing lifecycle configuration. Keep in mind that this will overwrite an existing lifecycle configuration, so if you want to retain any configuration details, they must be included in the new lifecycle configuration. For information about lifecycle configuration, see [Managing your storage lifecycle](https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-lifecycle-mgmt.html).
#'
#' See [https://paws-r.github.io/docs/s3/put_bucket_lifecycle_configuration.html](https://paws-r.github.io/docs/s3/put_bucket_lifecycle_configuration.html) for full documentation.
#'
#' @param Bucket &#91;required&#93; The name of the bucket for which to set the configuration.
#' @param ChecksumAlgorithm Indicates the algorithm used to create the checksum for the object when
#' using the SDK. This header will not provide any additional functionality
#' if not using the SDK. When sending this header, there must be a
#' corresponding `x-amz-checksum` or `x-amz-trailer` header sent.
#' Otherwise, Amazon S3 fails the request with the HTTP status code
#' `400 Bad Request`. For more information, see [Checking object
#' integrity](https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html)
#' in the *Amazon S3 User Guide*.
#' 
#' If you provide an individual checksum, Amazon S3 ignores any provided
#' `ChecksumAlgorithm` parameter.
#' @param LifecycleConfiguration Container for lifecycle rules. You can add as many as 1,000 rules.
#' @param ExpectedBucketOwner The account ID of the expected bucket owner. If the bucket is owned by a
#' different account, the request fails with the HTTP status code
#' `403 Forbidden` (access denied).
#'
#' @keywords internal
#'
#' @rdname s3_put_bucket_lifecycle_configuration
s3_put_bucket_lifecycle_configuration <- function(Bucket, ChecksumAlgorithm = NULL, LifecycleConfiguration = NULL, ExpectedBucketOwner = NULL) {
  op <- new_operation(
    name = "PutBucketLifecycleConfiguration",
    http_method = "PUT",
    http_path = "/{Bucket}?lifecycle",
    paginator = list()
  )
  input <- .s3$put_bucket_lifecycle_configuration_input(Bucket = Bucket, ChecksumAlgorithm = ChecksumAlgorithm, LifecycleConfiguration = LifecycleConfiguration, ExpectedBucketOwner = ExpectedBucketOwner)
  output <- .s3$put_bucket_lifecycle_configuration_output()
  config <- get_config()
  svc <- .s3$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$put_bucket_lifecycle_configuration <- s3_put_bucket_lifecycle_configuration

#' Set the logging parameters for a bucket and to specify permissions for
#' who can view and modify the logging parameters
#'
#' @description
#' Set the logging parameters for a bucket and to specify permissions for who can view and modify the logging parameters. All logs are saved to buckets in the same Amazon Web Services Region as the source bucket. To set the logging status of a bucket, you must be the bucket owner.
#'
#' See [https://paws-r.github.io/docs/s3/put_bucket_logging.html](https://paws-r.github.io/docs/s3/put_bucket_logging.html) for full documentation.
#'
#' @param Bucket &#91;required&#93; The name of the bucket for which to set the logging parameters.
#' @param BucketLoggingStatus &#91;required&#93; Container for logging status information.
#' @param ContentMD5 The MD5 hash of the [`put_bucket_logging`][s3_put_bucket_logging]
#' request body.
#' 
#' For requests made using the Amazon Web Services Command Line Interface
#' (CLI) or Amazon Web Services SDKs, this field is calculated
#' automatically.
#' @param ChecksumAlgorithm Indicates the algorithm used to create the checksum for the object when
#' using the SDK. This header will not provide any additional functionality
#' if not using the SDK. When sending this header, there must be a
#' corresponding `x-amz-checksum` or `x-amz-trailer` header sent.
#' Otherwise, Amazon S3 fails the request with the HTTP status code
#' `400 Bad Request`. For more information, see [Checking object
#' integrity](https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html)
#' in the *Amazon S3 User Guide*.
#' 
#' If you provide an individual checksum, Amazon S3 ignores any provided
#' `ChecksumAlgorithm` parameter.
#' @param ExpectedBucketOwner The account ID of the expected bucket owner. If the bucket is owned by a
#' different account, the request fails with the HTTP status code
#' `403 Forbidden` (access denied).
#'
#' @keywords internal
#'
#' @rdname s3_put_bucket_logging
s3_put_bucket_logging <- function(Bucket, BucketLoggingStatus, ContentMD5 = NULL, ChecksumAlgorithm = NULL, ExpectedBucketOwner = NULL) {
  op <- new_operation(
    name = "PutBucketLogging",
    http_method = "PUT",
    http_path = "/{Bucket}?logging",
    paginator = list()
  )
  input <- .s3$put_bucket_logging_input(Bucket = Bucket, BucketLoggingStatus = BucketLoggingStatus, ContentMD5 = ContentMD5, ChecksumAlgorithm = ChecksumAlgorithm, ExpectedBucketOwner = ExpectedBucketOwner)
  output <- .s3$put_bucket_logging_output()
  config <- get_config()
  svc <- .s3$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$put_bucket_logging <- s3_put_bucket_logging

#' Sets a metrics configuration (specified by the metrics configuration ID)
#' for the bucket
#'
#' @description
#' Sets a metrics configuration (specified by the metrics configuration ID) for the bucket. You can have up to 1,000 metrics configurations per bucket. If you're updating an existing metrics configuration, note that this is a full replacement of the existing metrics configuration. If you don't include the elements you want to keep, they are erased.
#'
#' See [https://paws-r.github.io/docs/s3/put_bucket_metrics_configuration.html](https://paws-r.github.io/docs/s3/put_bucket_metrics_configuration.html) for full documentation.
#'
#' @param Bucket &#91;required&#93; The name of the bucket for which the metrics configuration is set.
#' @param Id &#91;required&#93; The ID used to identify the metrics configuration.
#' @param MetricsConfiguration &#91;required&#93; Specifies the metrics configuration.
#' @param ExpectedBucketOwner The account ID of the expected bucket owner. If the bucket is owned by a
#' different account, the request fails with the HTTP status code
#' `403 Forbidden` (access denied).
#'
#' @keywords internal
#'
#' @rdname s3_put_bucket_metrics_configuration
s3_put_bucket_metrics_configuration <- function(Bucket, Id, MetricsConfiguration, ExpectedBucketOwner = NULL) {
  op <- new_operation(
    name = "PutBucketMetricsConfiguration",
    http_method = "PUT",
    http_path = "/{Bucket}?metrics",
    paginator = list()
  )
  input <- .s3$put_bucket_metrics_configuration_input(Bucket = Bucket, Id = Id, MetricsConfiguration = MetricsConfiguration, ExpectedBucketOwner = ExpectedBucketOwner)
  output <- .s3$put_bucket_metrics_configuration_output()
  config <- get_config()
  svc <- .s3$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$put_bucket_metrics_configuration <- s3_put_bucket_metrics_configuration

#' No longer used, see the PutBucketNotificationConfiguration operation
#'
#' @description
#' No longer used, see the [`put_bucket_notification_configuration`][s3_put_bucket_notification_configuration] operation.
#'
#' See [https://paws-r.github.io/docs/s3/put_bucket_notification.html](https://paws-r.github.io/docs/s3/put_bucket_notification.html) for full documentation.
#'
#' @param Bucket &#91;required&#93; The name of the bucket.
#' @param ContentMD5 The MD5 hash of the
#' [`put_public_access_block`][s3_put_public_access_block] request body.
#' 
#' For requests made using the Amazon Web Services Command Line Interface
#' (CLI) or Amazon Web Services SDKs, this field is calculated
#' automatically.
#' @param ChecksumAlgorithm Indicates the algorithm used to create the checksum for the object when
#' using the SDK. This header will not provide any additional functionality
#' if not using the SDK. When sending this header, there must be a
#' corresponding `x-amz-checksum` or `x-amz-trailer` header sent.
#' Otherwise, Amazon S3 fails the request with the HTTP status code
#' `400 Bad Request`. For more information, see [Checking object
#' integrity](https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html)
#' in the *Amazon S3 User Guide*.
#' 
#' If you provide an individual checksum, Amazon S3 ignores any provided
#' `ChecksumAlgorithm` parameter.
#' @param NotificationConfiguration &#91;required&#93; The container for the configuration.
#' @param ExpectedBucketOwner The account ID of the expected bucket owner. If the bucket is owned by a
#' different account, the request fails with the HTTP status code
#' `403 Forbidden` (access denied).
#'
#' @keywords internal
#'
#' @rdname s3_put_bucket_notification
s3_put_bucket_notification <- function(Bucket, ContentMD5 = NULL, ChecksumAlgorithm = NULL, NotificationConfiguration, ExpectedBucketOwner = NULL) {
  op <- new_operation(
    name = "PutBucketNotification",
    http_method = "PUT",
    http_path = "/{Bucket}?notification",
    paginator = list()
  )
  input <- .s3$put_bucket_notification_input(Bucket = Bucket, ContentMD5 = ContentMD5, ChecksumAlgorithm = ChecksumAlgorithm, NotificationConfiguration = NotificationConfiguration, ExpectedBucketOwner = ExpectedBucketOwner)
  output <- .s3$put_bucket_notification_output()
  config <- get_config()
  svc <- .s3$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$put_bucket_notification <- s3_put_bucket_notification

#' Enables notifications of specified events for a bucket
#'
#' @description
#' Enables notifications of specified events for a bucket. For more information about event notifications, see [Configuring Event Notifications](https://docs.aws.amazon.com/AmazonS3/latest/userguide/NotificationHowTo.html).
#'
#' See [https://paws-r.github.io/docs/s3/put_bucket_notification_configuration.html](https://paws-r.github.io/docs/s3/put_bucket_notification_configuration.html) for full documentation.
#'
#' @param Bucket &#91;required&#93; The name of the bucket.
#' @param NotificationConfiguration &#91;required&#93; 
#' @param ExpectedBucketOwner The account ID of the expected bucket owner. If the bucket is owned by a
#' different account, the request fails with the HTTP status code
#' `403 Forbidden` (access denied).
#' @param SkipDestinationValidation Skips validation of Amazon SQS, Amazon SNS, and Lambda destinations.
#' True or false value.
#'
#' @keywords internal
#'
#' @rdname s3_put_bucket_notification_configuration
s3_put_bucket_notification_configuration <- function(Bucket, NotificationConfiguration, ExpectedBucketOwner = NULL, SkipDestinationValidation = NULL) {
  op <- new_operation(
    name = "PutBucketNotificationConfiguration",
    http_method = "PUT",
    http_path = "/{Bucket}?notification",
    paginator = list()
  )
  input <- .s3$put_bucket_notification_configuration_input(Bucket = Bucket, NotificationConfiguration = NotificationConfiguration, ExpectedBucketOwner = ExpectedBucketOwner, SkipDestinationValidation = SkipDestinationValidation)
  output <- .s3$put_bucket_notification_configuration_output()
  config <- get_config()
  svc <- .s3$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$put_bucket_notification_configuration <- s3_put_bucket_notification_configuration

#' Creates or modifies OwnershipControls for an Amazon S3 bucket
#'
#' @description
#' Creates or modifies `OwnershipControls` for an Amazon S3 bucket. To use this operation, you must have the `s3:PutBucketOwnershipControls` permission. For more information about Amazon S3 permissions, see [Specifying permissions in a policy](https://docs.aws.amazon.com/AmazonS3/latest/userguide//using-with-s3-actions.html).
#'
#' See [https://paws-r.github.io/docs/s3/put_bucket_ownership_controls.html](https://paws-r.github.io/docs/s3/put_bucket_ownership_controls.html) for full documentation.
#'
#' @param Bucket &#91;required&#93; The name of the Amazon S3 bucket whose `OwnershipControls` you want to
#' set.
#' @param ContentMD5 The MD5 hash of the `OwnershipControls` request body.
#' 
#' For requests made using the Amazon Web Services Command Line Interface
#' (CLI) or Amazon Web Services SDKs, this field is calculated
#' automatically.
#' @param ExpectedBucketOwner The account ID of the expected bucket owner. If the bucket is owned by a
#' different account, the request fails with the HTTP status code
#' `403 Forbidden` (access denied).
#' @param OwnershipControls &#91;required&#93; The `OwnershipControls` (BucketOwnerEnforced, BucketOwnerPreferred, or
#' ObjectWriter) that you want to apply to this Amazon S3 bucket.
#'
#' @keywords internal
#'
#' @rdname s3_put_bucket_ownership_controls
s3_put_bucket_ownership_controls <- function(Bucket, ContentMD5 = NULL, ExpectedBucketOwner = NULL, OwnershipControls) {
  op <- new_operation(
    name = "PutBucketOwnershipControls",
    http_method = "PUT",
    http_path = "/{Bucket}?ownershipControls",
    paginator = list()
  )
  input <- .s3$put_bucket_ownership_controls_input(Bucket = Bucket, ContentMD5 = ContentMD5, ExpectedBucketOwner = ExpectedBucketOwner, OwnershipControls = OwnershipControls)
  output <- .s3$put_bucket_ownership_controls_output()
  config <- get_config()
  svc <- .s3$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$put_bucket_ownership_controls <- s3_put_bucket_ownership_controls

#' Applies an Amazon S3 bucket policy to an Amazon S3 bucket
#'
#' @description
#' Applies an Amazon S3 bucket policy to an Amazon S3 bucket. If you are using an identity other than the root user of the Amazon Web Services account that owns the bucket, the calling identity must have the [`put_bucket_policy`][s3_put_bucket_policy] permissions on the specified bucket and belong to the bucket owner's account in order to use this operation.
#'
#' See [https://paws-r.github.io/docs/s3/put_bucket_policy.html](https://paws-r.github.io/docs/s3/put_bucket_policy.html) for full documentation.
#'
#' @param Bucket &#91;required&#93; The name of the bucket.
#' @param ContentMD5 The MD5 hash of the request body.
#' 
#' For requests made using the Amazon Web Services Command Line Interface
#' (CLI) or Amazon Web Services SDKs, this field is calculated
#' automatically.
#' @param ChecksumAlgorithm Indicates the algorithm used to create the checksum for the object when
#' using the SDK. This header will not provide any additional functionality
#' if not using the SDK. When sending this header, there must be a
#' corresponding `x-amz-checksum` or `x-amz-trailer` header sent.
#' Otherwise, Amazon S3 fails the request with the HTTP status code
#' `400 Bad Request`. For more information, see [Checking object
#' integrity](https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html)
#' in the *Amazon S3 User Guide*.
#' 
#' If you provide an individual checksum, Amazon S3 ignores any provided
#' `ChecksumAlgorithm` parameter.
#' @param ConfirmRemoveSelfBucketAccess Set this parameter to true to confirm that you want to remove your
#' permissions to change this bucket policy in the future.
#' @param Policy &#91;required&#93; The bucket policy as a JSON document.
#' @param ExpectedBucketOwner The account ID of the expected bucket owner. If the bucket is owned by a
#' different account, the request fails with the HTTP status code
#' `403 Forbidden` (access denied).
#'
#' @keywords internal
#'
#' @rdname s3_put_bucket_policy
s3_put_bucket_policy <- function(Bucket, ContentMD5 = NULL, ChecksumAlgorithm = NULL, ConfirmRemoveSelfBucketAccess = NULL, Policy, ExpectedBucketOwner = NULL) {
  op <- new_operation(
    name = "PutBucketPolicy",
    http_method = "PUT",
    http_path = "/{Bucket}?policy",
    paginator = list()
  )
  input <- .s3$put_bucket_policy_input(Bucket = Bucket, ContentMD5 = ContentMD5, ChecksumAlgorithm = ChecksumAlgorithm, ConfirmRemoveSelfBucketAccess = ConfirmRemoveSelfBucketAccess, Policy = Policy, ExpectedBucketOwner = ExpectedBucketOwner)
  output <- .s3$put_bucket_policy_output()
  config <- get_config()
  svc <- .s3$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$put_bucket_policy <- s3_put_bucket_policy

#' Creates a replication configuration or replaces an existing one
#'
#' @description
#' Creates a replication configuration or replaces an existing one. For more information, see [Replication](https://docs.aws.amazon.com/AmazonS3/latest/userguide/replication.html) in the *Amazon S3 User Guide*.
#'
#' See [https://paws-r.github.io/docs/s3/put_bucket_replication.html](https://paws-r.github.io/docs/s3/put_bucket_replication.html) for full documentation.
#'
#' @param Bucket &#91;required&#93; The name of the bucket
#' @param ContentMD5 The base64-encoded 128-bit MD5 digest of the data. You must use this
#' header as a message integrity check to verify that the request body was
#' not corrupted in transit. For more information, see [RFC
#' 1864](https://www.ietf.org/rfc/rfc1864.txt).
#' 
#' For requests made using the Amazon Web Services Command Line Interface
#' (CLI) or Amazon Web Services SDKs, this field is calculated
#' automatically.
#' @param ChecksumAlgorithm Indicates the algorithm used to create the checksum for the object when
#' using the SDK. This header will not provide any additional functionality
#' if not using the SDK. When sending this header, there must be a
#' corresponding `x-amz-checksum` or `x-amz-trailer` header sent.
#' Otherwise, Amazon S3 fails the request with the HTTP status code
#' `400 Bad Request`. For more information, see [Checking object
#' integrity](https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html)
#' in the *Amazon S3 User Guide*.
#' 
#' If you provide an individual checksum, Amazon S3 ignores any provided
#' `ChecksumAlgorithm` parameter.
#' @param ReplicationConfiguration &#91;required&#93; 
#' @param Token A token to allow Object Lock to be enabled for an existing bucket.
#' @param ExpectedBucketOwner The account ID of the expected bucket owner. If the bucket is owned by a
#' different account, the request fails with the HTTP status code
#' `403 Forbidden` (access denied).
#'
#' @keywords internal
#'
#' @rdname s3_put_bucket_replication
s3_put_bucket_replication <- function(Bucket, ContentMD5 = NULL, ChecksumAlgorithm = NULL, ReplicationConfiguration, Token = NULL, ExpectedBucketOwner = NULL) {
  op <- new_operation(
    name = "PutBucketReplication",
    http_method = "PUT",
    http_path = "/{Bucket}?replication",
    paginator = list()
  )
  input <- .s3$put_bucket_replication_input(Bucket = Bucket, ContentMD5 = ContentMD5, ChecksumAlgorithm = ChecksumAlgorithm, ReplicationConfiguration = ReplicationConfiguration, Token = Token, ExpectedBucketOwner = ExpectedBucketOwner)
  output <- .s3$put_bucket_replication_output()
  config <- get_config()
  svc <- .s3$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$put_bucket_replication <- s3_put_bucket_replication

#' Sets the request payment configuration for a bucket
#'
#' @description
#' Sets the request payment configuration for a bucket. By default, the bucket owner pays for downloads from the bucket. This configuration parameter enables the bucket owner (only) to specify that the person requesting the download will be charged for the download. For more information, see [Requester Pays Buckets](https://docs.aws.amazon.com/AmazonS3/latest/userguide/RequesterPaysBuckets.html).
#'
#' See [https://paws-r.github.io/docs/s3/put_bucket_request_payment.html](https://paws-r.github.io/docs/s3/put_bucket_request_payment.html) for full documentation.
#'
#' @param Bucket &#91;required&#93; The bucket name.
#' @param ContentMD5 The base64-encoded 128-bit MD5 digest of the data. You must use this
#' header as a message integrity check to verify that the request body was
#' not corrupted in transit. For more information, see [RFC
#' 1864](https://www.ietf.org/rfc/rfc1864.txt).
#' 
#' For requests made using the Amazon Web Services Command Line Interface
#' (CLI) or Amazon Web Services SDKs, this field is calculated
#' automatically.
#' @param ChecksumAlgorithm Indicates the algorithm used to create the checksum for the object when
#' using the SDK. This header will not provide any additional functionality
#' if not using the SDK. When sending this header, there must be a
#' corresponding `x-amz-checksum` or `x-amz-trailer` header sent.
#' Otherwise, Amazon S3 fails the request with the HTTP status code
#' `400 Bad Request`. For more information, see [Checking object
#' integrity](https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html)
#' in the *Amazon S3 User Guide*.
#' 
#' If you provide an individual checksum, Amazon S3 ignores any provided
#' `ChecksumAlgorithm` parameter.
#' @param RequestPaymentConfiguration &#91;required&#93; Container for Payer.
#' @param ExpectedBucketOwner The account ID of the expected bucket owner. If the bucket is owned by a
#' different account, the request fails with the HTTP status code
#' `403 Forbidden` (access denied).
#'
#' @keywords internal
#'
#' @rdname s3_put_bucket_request_payment
s3_put_bucket_request_payment <- function(Bucket, ContentMD5 = NULL, ChecksumAlgorithm = NULL, RequestPaymentConfiguration, ExpectedBucketOwner = NULL) {
  op <- new_operation(
    name = "PutBucketRequestPayment",
    http_method = "PUT",
    http_path = "/{Bucket}?requestPayment",
    paginator = list()
  )
  input <- .s3$put_bucket_request_payment_input(Bucket = Bucket, ContentMD5 = ContentMD5, ChecksumAlgorithm = ChecksumAlgorithm, RequestPaymentConfiguration = RequestPaymentConfiguration, ExpectedBucketOwner = ExpectedBucketOwner)
  output <- .s3$put_bucket_request_payment_output()
  config <- get_config()
  svc <- .s3$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$put_bucket_request_payment <- s3_put_bucket_request_payment

#' Sets the tags for a bucket
#'
#' @description
#' Sets the tags for a bucket.
#'
#' See [https://paws-r.github.io/docs/s3/put_bucket_tagging.html](https://paws-r.github.io/docs/s3/put_bucket_tagging.html) for full documentation.
#'
#' @param Bucket &#91;required&#93; The bucket name.
#' @param ContentMD5 The base64-encoded 128-bit MD5 digest of the data. You must use this
#' header as a message integrity check to verify that the request body was
#' not corrupted in transit. For more information, see [RFC
#' 1864](https://www.ietf.org/rfc/rfc1864.txt).
#' 
#' For requests made using the Amazon Web Services Command Line Interface
#' (CLI) or Amazon Web Services SDKs, this field is calculated
#' automatically.
#' @param ChecksumAlgorithm Indicates the algorithm used to create the checksum for the object when
#' using the SDK. This header will not provide any additional functionality
#' if not using the SDK. When sending this header, there must be a
#' corresponding `x-amz-checksum` or `x-amz-trailer` header sent.
#' Otherwise, Amazon S3 fails the request with the HTTP status code
#' `400 Bad Request`. For more information, see [Checking object
#' integrity](https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html)
#' in the *Amazon S3 User Guide*.
#' 
#' If you provide an individual checksum, Amazon S3 ignores any provided
#' `ChecksumAlgorithm` parameter.
#' @param Tagging &#91;required&#93; Container for the `TagSet` and `Tag` elements.
#' @param ExpectedBucketOwner The account ID of the expected bucket owner. If the bucket is owned by a
#' different account, the request fails with the HTTP status code
#' `403 Forbidden` (access denied).
#'
#' @keywords internal
#'
#' @rdname s3_put_bucket_tagging
s3_put_bucket_tagging <- function(Bucket, ContentMD5 = NULL, ChecksumAlgorithm = NULL, Tagging, ExpectedBucketOwner = NULL) {
  op <- new_operation(
    name = "PutBucketTagging",
    http_method = "PUT",
    http_path = "/{Bucket}?tagging",
    paginator = list()
  )
  input <- .s3$put_bucket_tagging_input(Bucket = Bucket, ContentMD5 = ContentMD5, ChecksumAlgorithm = ChecksumAlgorithm, Tagging = Tagging, ExpectedBucketOwner = ExpectedBucketOwner)
  output <- .s3$put_bucket_tagging_output()
  config <- get_config()
  svc <- .s3$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$put_bucket_tagging <- s3_put_bucket_tagging

#' Sets the versioning state of an existing bucket
#'
#' @description
#' Sets the versioning state of an existing bucket.
#'
#' See [https://paws-r.github.io/docs/s3/put_bucket_versioning.html](https://paws-r.github.io/docs/s3/put_bucket_versioning.html) for full documentation.
#'
#' @param Bucket &#91;required&#93; The bucket name.
#' @param ContentMD5 \>The base64-encoded 128-bit MD5 digest of the data. You must use this
#' header as a message integrity check to verify that the request body was
#' not corrupted in transit. For more information, see [RFC
#' 1864](https://www.ietf.org/rfc/rfc1864.txt).
#' 
#' For requests made using the Amazon Web Services Command Line Interface
#' (CLI) or Amazon Web Services SDKs, this field is calculated
#' automatically.
#' @param ChecksumAlgorithm Indicates the algorithm used to create the checksum for the object when
#' using the SDK. This header will not provide any additional functionality
#' if not using the SDK. When sending this header, there must be a
#' corresponding `x-amz-checksum` or `x-amz-trailer` header sent.
#' Otherwise, Amazon S3 fails the request with the HTTP status code
#' `400 Bad Request`. For more information, see [Checking object
#' integrity](https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html)
#' in the *Amazon S3 User Guide*.
#' 
#' If you provide an individual checksum, Amazon S3 ignores any provided
#' `ChecksumAlgorithm` parameter.
#' @param MFA The concatenation of the authentication device's serial number, a space,
#' and the value that is displayed on your authentication device.
#' @param VersioningConfiguration &#91;required&#93; Container for setting the versioning state.
#' @param ExpectedBucketOwner The account ID of the expected bucket owner. If the bucket is owned by a
#' different account, the request fails with the HTTP status code
#' `403 Forbidden` (access denied).
#'
#' @keywords internal
#'
#' @rdname s3_put_bucket_versioning
s3_put_bucket_versioning <- function(Bucket, ContentMD5 = NULL, ChecksumAlgorithm = NULL, MFA = NULL, VersioningConfiguration, ExpectedBucketOwner = NULL) {
  op <- new_operation(
    name = "PutBucketVersioning",
    http_method = "PUT",
    http_path = "/{Bucket}?versioning",
    paginator = list()
  )
  input <- .s3$put_bucket_versioning_input(Bucket = Bucket, ContentMD5 = ContentMD5, ChecksumAlgorithm = ChecksumAlgorithm, MFA = MFA, VersioningConfiguration = VersioningConfiguration, ExpectedBucketOwner = ExpectedBucketOwner)
  output <- .s3$put_bucket_versioning_output()
  config <- get_config()
  svc <- .s3$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$put_bucket_versioning <- s3_put_bucket_versioning

#' Sets the configuration of the website that is specified in the website
#' subresource
#'
#' @description
#' Sets the configuration of the website that is specified in the `website` subresource. To configure a bucket as a website, you can add this subresource on the bucket with website configuration information such as the file name of the index document and any redirect rules. For more information, see [Hosting Websites on Amazon S3](https://docs.aws.amazon.com/AmazonS3/latest/userguide/WebsiteHosting.html).
#'
#' See [https://paws-r.github.io/docs/s3/put_bucket_website.html](https://paws-r.github.io/docs/s3/put_bucket_website.html) for full documentation.
#'
#' @param Bucket &#91;required&#93; The bucket name.
#' @param ContentMD5 The base64-encoded 128-bit MD5 digest of the data. You must use this
#' header as a message integrity check to verify that the request body was
#' not corrupted in transit. For more information, see [RFC
#' 1864](https://www.ietf.org/rfc/rfc1864.txt).
#' 
#' For requests made using the Amazon Web Services Command Line Interface
#' (CLI) or Amazon Web Services SDKs, this field is calculated
#' automatically.
#' @param ChecksumAlgorithm Indicates the algorithm used to create the checksum for the object when
#' using the SDK. This header will not provide any additional functionality
#' if not using the SDK. When sending this header, there must be a
#' corresponding `x-amz-checksum` or `x-amz-trailer` header sent.
#' Otherwise, Amazon S3 fails the request with the HTTP status code
#' `400 Bad Request`. For more information, see [Checking object
#' integrity](https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html)
#' in the *Amazon S3 User Guide*.
#' 
#' If you provide an individual checksum, Amazon S3 ignores any provided
#' `ChecksumAlgorithm` parameter.
#' @param WebsiteConfiguration &#91;required&#93; Container for the request.
#' @param ExpectedBucketOwner The account ID of the expected bucket owner. If the bucket is owned by a
#' different account, the request fails with the HTTP status code
#' `403 Forbidden` (access denied).
#'
#' @keywords internal
#'
#' @rdname s3_put_bucket_website
s3_put_bucket_website <- function(Bucket, ContentMD5 = NULL, ChecksumAlgorithm = NULL, WebsiteConfiguration, ExpectedBucketOwner = NULL) {
  op <- new_operation(
    name = "PutBucketWebsite",
    http_method = "PUT",
    http_path = "/{Bucket}?website",
    paginator = list()
  )
  input <- .s3$put_bucket_website_input(Bucket = Bucket, ContentMD5 = ContentMD5, ChecksumAlgorithm = ChecksumAlgorithm, WebsiteConfiguration = WebsiteConfiguration, ExpectedBucketOwner = ExpectedBucketOwner)
  output <- .s3$put_bucket_website_output()
  config <- get_config()
  svc <- .s3$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$put_bucket_website <- s3_put_bucket_website

#' Adds an object to a bucket
#'
#' @description
#' Adds an object to a bucket. You must have WRITE permissions on a bucket to add an object to it.
#'
#' See [https://paws-r.github.io/docs/s3/put_object.html](https://paws-r.github.io/docs/s3/put_object.html) for full documentation.
#'
#' @param ACL The canned ACL to apply to the object. For more information, see [Canned
#' ACL](https://docs.aws.amazon.com/AmazonS3/latest/userguide/acl-overview.html#CannedACL).
#' 
#' This action is not supported by Amazon S3 on Outposts.
#' @param Body Object data.
#' @param Bucket &#91;required&#93; The bucket name to which the PUT action was initiated.
#' 
#' When using this action with an access point, you must direct requests to
#' the access point hostname. The access point hostname takes the form
#' *AccessPointName*-*AccountId*.s3-accesspoint.*Region*.amazonaws.com.
#' When using this action with an access point through the Amazon Web
#' Services SDKs, you provide the access point ARN in place of the bucket
#' name. For more information about access point ARNs, see [Using access
#' points](https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html)
#' in the *Amazon S3 User Guide*.
#' 
#' When using this action with Amazon S3 on Outposts, you must direct
#' requests to the S3 on Outposts hostname. The S3 on Outposts hostname
#' takes the form
#' ` AccessPointName-AccountId.outpostID.s3-outposts.Region.amazonaws.com`.
#' When using this action with S3 on Outposts through the Amazon Web
#' Services SDKs, you provide the Outposts bucket ARN in place of the
#' bucket name. For more information about S3 on Outposts ARNs, see [Using
#' Amazon S3 on
#' Outposts](https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html)
#' in the *Amazon S3 User Guide*.
#' @param CacheControl Can be used to specify caching behavior along the request/reply chain.
#' For more information, see
#' [http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.9](https://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.9).
#' @param ContentDisposition Specifies presentational information for the object. For more
#' information, see
#' [http://www.w3.org/Protocols/rfc2616/rfc2616-sec19.html#sec19.5.1](https://www.w3.org/Protocols/rfc2616/rfc2616-sec19.html#sec19.5.1).
#' @param ContentEncoding Specifies what content encodings have been applied to the object and
#' thus what decoding mechanisms must be applied to obtain the media-type
#' referenced by the Content-Type header field. For more information, see
#' [http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.11](https://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.11).
#' @param ContentLanguage The language the content is in.
#' @param ContentLength Size of the body in bytes. This parameter is useful when the size of the
#' body cannot be determined automatically. For more information, see
#' [http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.13](https://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.13).
#' @param ContentMD5 The base64-encoded 128-bit MD5 digest of the message (without the
#' headers) according to RFC 1864. This header can be used as a message
#' integrity check to verify that the data is the same data that was
#' originally sent. Although it is optional, we recommend using the
#' Content-MD5 mechanism as an end-to-end integrity check. For more
#' information about REST request authentication, see [REST
#' Authentication](https://docs.aws.amazon.com/AmazonS3/latest/userguide/RESTAuthentication.html).
#' @param ContentType A standard MIME type describing the format of the contents. For more
#' information, see
#' [http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.17](https://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.17).
#' @param ChecksumAlgorithm Indicates the algorithm used to create the checksum for the object when
#' using the SDK. This header will not provide any additional functionality
#' if not using the SDK. When sending this header, there must be a
#' corresponding `x-amz-checksum` or `x-amz-trailer` header sent.
#' Otherwise, Amazon S3 fails the request with the HTTP status code
#' `400 Bad Request`. For more information, see [Checking object
#' integrity](https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html)
#' in the *Amazon S3 User Guide*.
#' 
#' If you provide an individual checksum, Amazon S3 ignores any provided
#' `ChecksumAlgorithm` parameter.
#' @param ChecksumCRC32 This header can be used as a data integrity check to verify that the
#' data received is the same data that was originally sent. This header
#' specifies the base64-encoded, 32-bit CRC32 checksum of the object. For
#' more information, see [Checking object
#' integrity](https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html)
#' in the *Amazon S3 User Guide*.
#' @param ChecksumCRC32C This header can be used as a data integrity check to verify that the
#' data received is the same data that was originally sent. This header
#' specifies the base64-encoded, 32-bit CRC32C checksum of the object. For
#' more information, see [Checking object
#' integrity](https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html)
#' in the *Amazon S3 User Guide*.
#' @param ChecksumSHA1 This header can be used as a data integrity check to verify that the
#' data received is the same data that was originally sent. This header
#' specifies the base64-encoded, 160-bit SHA-1 digest of the object. For
#' more information, see [Checking object
#' integrity](https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html)
#' in the *Amazon S3 User Guide*.
#' @param ChecksumSHA256 This header can be used as a data integrity check to verify that the
#' data received is the same data that was originally sent. This header
#' specifies the base64-encoded, 256-bit SHA-256 digest of the object. For
#' more information, see [Checking object
#' integrity](https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html)
#' in the *Amazon S3 User Guide*.
#' @param Expires The date and time at which the object is no longer cacheable. For more
#' information, see
#' [http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.21](https://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.21).
#' @param GrantFullControl Gives the grantee READ, READ_ACP, and WRITE_ACP permissions on the
#' object.
#' 
#' This action is not supported by Amazon S3 on Outposts.
#' @param GrantRead Allows grantee to read the object data and its metadata.
#' 
#' This action is not supported by Amazon S3 on Outposts.
#' @param GrantReadACP Allows grantee to read the object ACL.
#' 
#' This action is not supported by Amazon S3 on Outposts.
#' @param GrantWriteACP Allows grantee to write the ACL for the applicable object.
#' 
#' This action is not supported by Amazon S3 on Outposts.
#' @param Key &#91;required&#93; Object key for which the PUT action was initiated.
#' @param Metadata A map of metadata to store with the object in S3.
#' @param ServerSideEncryption The server-side encryption algorithm used when storing this object in
#' Amazon S3 (for example, AES256, aws:kms).
#' @param StorageClass By default, Amazon S3 uses the STANDARD Storage Class to store newly
#' created objects. The STANDARD storage class provides high durability and
#' high availability. Depending on performance needs, you can specify a
#' different Storage Class. Amazon S3 on Outposts only uses the OUTPOSTS
#' Storage Class. For more information, see [Storage
#' Classes](https://docs.aws.amazon.com/AmazonS3/latest/userguide/storage-class-intro.html)
#' in the *Amazon S3 User Guide*.
#' @param WebsiteRedirectLocation If the bucket is configured as a website, redirects requests for this
#' object to another object in the same bucket or to an external URL.
#' Amazon S3 stores the value of this header in the object metadata. For
#' information about object metadata, see [Object Key and
#' Metadata](https://docs.aws.amazon.com/AmazonS3/latest/userguide/UsingMetadata.html).
#' 
#' In the following example, the request header sets the redirect to an
#' object (anotherPage.html) in the same bucket:
#' 
#' `x-amz-website-redirect-location: /anotherPage.html`
#' 
#' In the following example, the request header sets the object redirect to
#' another website:
#' 
#' `x-amz-website-redirect-location: http://www.example.com/`
#' 
#' For more information about website hosting in Amazon S3, see [Hosting
#' Websites on Amazon
#' S3](https://docs.aws.amazon.com/AmazonS3/latest/userguide/WebsiteHosting.html)
#' and [How to Configure Website Page
#' Redirects](https://docs.aws.amazon.com/AmazonS3/latest/userguide/how-to-page-redirect.html).
#' @param SSECustomerAlgorithm Specifies the algorithm to use to when encrypting the object (for
#' example, AES256).
#' @param SSECustomerKey Specifies the customer-provided encryption key for Amazon S3 to use in
#' encrypting data. This value is used to store the object and then it is
#' discarded; Amazon S3 does not store the encryption key. The key must be
#' appropriate for use with the algorithm specified in the
#' `x-amz-server-side-encryption-customer-algorithm` header.
#' @param SSECustomerKeyMD5 Specifies the 128-bit MD5 digest of the encryption key according to RFC
#' 1321. Amazon S3 uses this header for a message integrity check to ensure
#' that the encryption key was transmitted without error.
#' @param SSEKMSKeyId If `x-amz-server-side-encryption` is present and has the value of
#' `aws:kms`, this header specifies the ID of the Amazon Web Services Key
#' Management Service (Amazon Web Services KMS) symmetrical customer
#' managed key that was used for the object. If you specify
#' `x-amz-server-side-encryption:aws:kms`, but do not
#' provide` x-amz-server-side-encryption-aws-kms-key-id`, Amazon S3 uses
#' the Amazon Web Services managed key to protect the data. If the KMS key
#' does not exist in the same account issuing the command, you must use the
#' full ARN and not just the ID.
#' @param SSEKMSEncryptionContext Specifies the Amazon Web Services KMS Encryption Context to use for
#' object encryption. The value of this header is a base64-encoded UTF-8
#' string holding JSON with the encryption context key-value pairs.
#' @param BucketKeyEnabled Specifies whether Amazon S3 should use an S3 Bucket Key for object
#' encryption with server-side encryption using AWS KMS (SSE-KMS). Setting
#' this header to `true` causes Amazon S3 to use an S3 Bucket Key for
#' object encryption with SSE-KMS.
#' 
#' Specifying this header with a PUT action doesn’t affect bucket-level
#' settings for S3 Bucket Key.
#' @param RequestPayer 
#' @param Tagging The tag-set for the object. The tag-set must be encoded as URL Query
#' parameters. (For example, "Key1=Value1")
#' @param ObjectLockMode The Object Lock mode that you want to apply to this object.
#' @param ObjectLockRetainUntilDate The date and time when you want this object's Object Lock to expire.
#' Must be formatted as a timestamp parameter.
#' @param ObjectLockLegalHoldStatus Specifies whether a legal hold will be applied to this object. For more
#' information about S3 Object Lock, see [Object
#' Lock](https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-lock.html).
#' @param ExpectedBucketOwner The account ID of the expected bucket owner. If the bucket is owned by a
#' different account, the request fails with the HTTP status code
#' `403 Forbidden` (access denied).
#'
#' @keywords internal
#'
#' @rdname s3_put_object
s3_put_object <- function(ACL = NULL, Body = NULL, Bucket, CacheControl = NULL, ContentDisposition = NULL, ContentEncoding = NULL, ContentLanguage = NULL, ContentLength = NULL, ContentMD5 = NULL, ContentType = NULL, ChecksumAlgorithm = NULL, ChecksumCRC32 = NULL, ChecksumCRC32C = NULL, ChecksumSHA1 = NULL, ChecksumSHA256 = NULL, Expires = NULL, GrantFullControl = NULL, GrantRead = NULL, GrantReadACP = NULL, GrantWriteACP = NULL, Key, Metadata = NULL, ServerSideEncryption = NULL, StorageClass = NULL, WebsiteRedirectLocation = NULL, SSECustomerAlgorithm = NULL, SSECustomerKey = NULL, SSECustomerKeyMD5 = NULL, SSEKMSKeyId = NULL, SSEKMSEncryptionContext = NULL, BucketKeyEnabled = NULL, RequestPayer = NULL, Tagging = NULL, ObjectLockMode = NULL, ObjectLockRetainUntilDate = NULL, ObjectLockLegalHoldStatus = NULL, ExpectedBucketOwner = NULL) {
  op <- new_operation(
    name = "PutObject",
    http_method = "PUT",
    http_path = "/{Bucket}/{Key+}",
    paginator = list()
  )
  input <- .s3$put_object_input(ACL = ACL, Body = Body, Bucket = Bucket, CacheControl = CacheControl, ContentDisposition = ContentDisposition, ContentEncoding = ContentEncoding, ContentLanguage = ContentLanguage, ContentLength = ContentLength, ContentMD5 = ContentMD5, ContentType = ContentType, ChecksumAlgorithm = ChecksumAlgorithm, ChecksumCRC32 = ChecksumCRC32, ChecksumCRC32C = ChecksumCRC32C, ChecksumSHA1 = ChecksumSHA1, ChecksumSHA256 = ChecksumSHA256, Expires = Expires, GrantFullControl = GrantFullControl, GrantRead = GrantRead, GrantReadACP = GrantReadACP, GrantWriteACP = GrantWriteACP, Key = Key, Metadata = Metadata, ServerSideEncryption = ServerSideEncryption, StorageClass = StorageClass, WebsiteRedirectLocation = WebsiteRedirectLocation, SSECustomerAlgorithm = SSECustomerAlgorithm, SSECustomerKey = SSECustomerKey, SSECustomerKeyMD5 = SSECustomerKeyMD5, SSEKMSKeyId = SSEKMSKeyId, SSEKMSEncryptionContext = SSEKMSEncryptionContext, BucketKeyEnabled = BucketKeyEnabled, RequestPayer = RequestPayer, Tagging = Tagging, ObjectLockMode = ObjectLockMode, ObjectLockRetainUntilDate = ObjectLockRetainUntilDate, ObjectLockLegalHoldStatus = ObjectLockLegalHoldStatus, ExpectedBucketOwner = ExpectedBucketOwner)
  output <- .s3$put_object_output()
  config <- get_config()
  svc <- .s3$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$put_object <- s3_put_object

#' Uses the acl subresource to set the access control list (ACL)
#' permissions for a new or existing object in an S3 bucket
#'
#' @description
#' Uses the `acl` subresource to set the access control list (ACL) permissions for a new or existing object in an S3 bucket. You must have `WRITE_ACP` permission to set the ACL of an object. For more information, see [What permissions can I grant?](https://docs.aws.amazon.com/AmazonS3/latest/userguide/acl-overview.html#permissions) in the *Amazon S3 User Guide*.
#'
#' See [https://paws-r.github.io/docs/s3/put_object_acl.html](https://paws-r.github.io/docs/s3/put_object_acl.html) for full documentation.
#'
#' @param ACL The canned ACL to apply to the object. For more information, see [Canned
#' ACL](https://docs.aws.amazon.com/AmazonS3/latest/userguide/acl-overview.html#CannedACL).
#' @param AccessControlPolicy Contains the elements that set the ACL permissions for an object per
#' grantee.
#' @param Bucket &#91;required&#93; The bucket name that contains the object to which you want to attach the
#' ACL.
#' 
#' When using this action with an access point, you must direct requests to
#' the access point hostname. The access point hostname takes the form
#' *AccessPointName*-*AccountId*.s3-accesspoint.*Region*.amazonaws.com.
#' When using this action with an access point through the Amazon Web
#' Services SDKs, you provide the access point ARN in place of the bucket
#' name. For more information about access point ARNs, see [Using access
#' points](https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html)
#' in the *Amazon S3 User Guide*.
#' @param ContentMD5 The base64-encoded 128-bit MD5 digest of the data. This header must be
#' used as a message integrity check to verify that the request body was
#' not corrupted in transit. For more information, go to [RFC
#' 1864.\>](https://www.ietf.org/rfc/rfc1864.txt)
#' 
#' For requests made using the Amazon Web Services Command Line Interface
#' (CLI) or Amazon Web Services SDKs, this field is calculated
#' automatically.
#' @param ChecksumAlgorithm Indicates the algorithm used to create the checksum for the object when
#' using the SDK. This header will not provide any additional functionality
#' if not using the SDK. When sending this header, there must be a
#' corresponding `x-amz-checksum` or `x-amz-trailer` header sent.
#' Otherwise, Amazon S3 fails the request with the HTTP status code
#' `400 Bad Request`. For more information, see [Checking object
#' integrity](https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html)
#' in the *Amazon S3 User Guide*.
#' 
#' If you provide an individual checksum, Amazon S3 ignores any provided
#' `ChecksumAlgorithm` parameter.
#' @param GrantFullControl Allows grantee the read, write, read ACP, and write ACP permissions on
#' the bucket.
#' 
#' This action is not supported by Amazon S3 on Outposts.
#' @param GrantRead Allows grantee to list the objects in the bucket.
#' 
#' This action is not supported by Amazon S3 on Outposts.
#' @param GrantReadACP Allows grantee to read the bucket ACL.
#' 
#' This action is not supported by Amazon S3 on Outposts.
#' @param GrantWrite Allows grantee to create new objects in the bucket.
#' 
#' For the bucket and object owners of existing objects, also allows
#' deletions and overwrites of those objects.
#' @param GrantWriteACP Allows grantee to write the ACL for the applicable bucket.
#' 
#' This action is not supported by Amazon S3 on Outposts.
#' @param Key &#91;required&#93; Key for which the PUT action was initiated.
#' 
#' When using this action with an access point, you must direct requests to
#' the access point hostname. The access point hostname takes the form
#' *AccessPointName*-*AccountId*.s3-accesspoint.*Region*.amazonaws.com.
#' When using this action with an access point through the Amazon Web
#' Services SDKs, you provide the access point ARN in place of the bucket
#' name. For more information about access point ARNs, see [Using access
#' points](https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html)
#' in the *Amazon S3 User Guide*.
#' 
#' When using this action with Amazon S3 on Outposts, you must direct
#' requests to the S3 on Outposts hostname. The S3 on Outposts hostname
#' takes the form
#' ` AccessPointName-AccountId.outpostID.s3-outposts.Region.amazonaws.com`.
#' When using this action with S3 on Outposts through the Amazon Web
#' Services SDKs, you provide the Outposts bucket ARN in place of the
#' bucket name. For more information about S3 on Outposts ARNs, see [Using
#' Amazon S3 on
#' Outposts](https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html)
#' in the *Amazon S3 User Guide*.
#' @param RequestPayer 
#' @param VersionId VersionId used to reference a specific version of the object.
#' @param ExpectedBucketOwner The account ID of the expected bucket owner. If the bucket is owned by a
#' different account, the request fails with the HTTP status code
#' `403 Forbidden` (access denied).
#'
#' @keywords internal
#'
#' @rdname s3_put_object_acl
s3_put_object_acl <- function(ACL = NULL, AccessControlPolicy = NULL, Bucket, ContentMD5 = NULL, ChecksumAlgorithm = NULL, GrantFullControl = NULL, GrantRead = NULL, GrantReadACP = NULL, GrantWrite = NULL, GrantWriteACP = NULL, Key, RequestPayer = NULL, VersionId = NULL, ExpectedBucketOwner = NULL) {
  op <- new_operation(
    name = "PutObjectAcl",
    http_method = "PUT",
    http_path = "/{Bucket}/{Key+}?acl",
    paginator = list()
  )
  input <- .s3$put_object_acl_input(ACL = ACL, AccessControlPolicy = AccessControlPolicy, Bucket = Bucket, ContentMD5 = ContentMD5, ChecksumAlgorithm = ChecksumAlgorithm, GrantFullControl = GrantFullControl, GrantRead = GrantRead, GrantReadACP = GrantReadACP, GrantWrite = GrantWrite, GrantWriteACP = GrantWriteACP, Key = Key, RequestPayer = RequestPayer, VersionId = VersionId, ExpectedBucketOwner = ExpectedBucketOwner)
  output <- .s3$put_object_acl_output()
  config <- get_config()
  svc <- .s3$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$put_object_acl <- s3_put_object_acl

#' Applies a legal hold configuration to the specified object
#'
#' @description
#' Applies a legal hold configuration to the specified object. For more information, see [Locking Objects](https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-lock.html).
#'
#' See [https://paws-r.github.io/docs/s3/put_object_legal_hold.html](https://paws-r.github.io/docs/s3/put_object_legal_hold.html) for full documentation.
#'
#' @param Bucket &#91;required&#93; The bucket name containing the object that you want to place a legal
#' hold on.
#' 
#' When using this action with an access point, you must direct requests to
#' the access point hostname. The access point hostname takes the form
#' *AccessPointName*-*AccountId*.s3-accesspoint.*Region*.amazonaws.com.
#' When using this action with an access point through the Amazon Web
#' Services SDKs, you provide the access point ARN in place of the bucket
#' name. For more information about access point ARNs, see [Using access
#' points](https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html)
#' in the *Amazon S3 User Guide*.
#' @param Key &#91;required&#93; The key name for the object that you want to place a legal hold on.
#' @param LegalHold Container element for the legal hold configuration you want to apply to
#' the specified object.
#' @param RequestPayer 
#' @param VersionId The version ID of the object that you want to place a legal hold on.
#' @param ContentMD5 The MD5 hash for the request body.
#' 
#' For requests made using the Amazon Web Services Command Line Interface
#' (CLI) or Amazon Web Services SDKs, this field is calculated
#' automatically.
#' @param ChecksumAlgorithm Indicates the algorithm used to create the checksum for the object when
#' using the SDK. This header will not provide any additional functionality
#' if not using the SDK. When sending this header, there must be a
#' corresponding `x-amz-checksum` or `x-amz-trailer` header sent.
#' Otherwise, Amazon S3 fails the request with the HTTP status code
#' `400 Bad Request`. For more information, see [Checking object
#' integrity](https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html)
#' in the *Amazon S3 User Guide*.
#' 
#' If you provide an individual checksum, Amazon S3 ignores any provided
#' `ChecksumAlgorithm` parameter.
#' @param ExpectedBucketOwner The account ID of the expected bucket owner. If the bucket is owned by a
#' different account, the request fails with the HTTP status code
#' `403 Forbidden` (access denied).
#'
#' @keywords internal
#'
#' @rdname s3_put_object_legal_hold
s3_put_object_legal_hold <- function(Bucket, Key, LegalHold = NULL, RequestPayer = NULL, VersionId = NULL, ContentMD5 = NULL, ChecksumAlgorithm = NULL, ExpectedBucketOwner = NULL) {
  op <- new_operation(
    name = "PutObjectLegalHold",
    http_method = "PUT",
    http_path = "/{Bucket}/{Key+}?legal-hold",
    paginator = list()
  )
  input <- .s3$put_object_legal_hold_input(Bucket = Bucket, Key = Key, LegalHold = LegalHold, RequestPayer = RequestPayer, VersionId = VersionId, ContentMD5 = ContentMD5, ChecksumAlgorithm = ChecksumAlgorithm, ExpectedBucketOwner = ExpectedBucketOwner)
  output <- .s3$put_object_legal_hold_output()
  config <- get_config()
  svc <- .s3$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$put_object_legal_hold <- s3_put_object_legal_hold

#' Places an Object Lock configuration on the specified bucket
#'
#' @description
#' Places an Object Lock configuration on the specified bucket. The rule specified in the Object Lock configuration will be applied by default to every new object placed in the specified bucket. For more information, see [Locking Objects](https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-lock.html).
#'
#' See [https://paws-r.github.io/docs/s3/put_object_lock_configuration.html](https://paws-r.github.io/docs/s3/put_object_lock_configuration.html) for full documentation.
#'
#' @param Bucket &#91;required&#93; The bucket whose Object Lock configuration you want to create or
#' replace.
#' @param ObjectLockConfiguration The Object Lock configuration that you want to apply to the specified
#' bucket.
#' @param RequestPayer 
#' @param Token A token to allow Object Lock to be enabled for an existing bucket.
#' @param ContentMD5 The MD5 hash for the request body.
#' 
#' For requests made using the Amazon Web Services Command Line Interface
#' (CLI) or Amazon Web Services SDKs, this field is calculated
#' automatically.
#' @param ChecksumAlgorithm Indicates the algorithm used to create the checksum for the object when
#' using the SDK. This header will not provide any additional functionality
#' if not using the SDK. When sending this header, there must be a
#' corresponding `x-amz-checksum` or `x-amz-trailer` header sent.
#' Otherwise, Amazon S3 fails the request with the HTTP status code
#' `400 Bad Request`. For more information, see [Checking object
#' integrity](https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html)
#' in the *Amazon S3 User Guide*.
#' 
#' If you provide an individual checksum, Amazon S3 ignores any provided
#' `ChecksumAlgorithm` parameter.
#' @param ExpectedBucketOwner The account ID of the expected bucket owner. If the bucket is owned by a
#' different account, the request fails with the HTTP status code
#' `403 Forbidden` (access denied).
#'
#' @keywords internal
#'
#' @rdname s3_put_object_lock_configuration
s3_put_object_lock_configuration <- function(Bucket, ObjectLockConfiguration = NULL, RequestPayer = NULL, Token = NULL, ContentMD5 = NULL, ChecksumAlgorithm = NULL, ExpectedBucketOwner = NULL) {
  op <- new_operation(
    name = "PutObjectLockConfiguration",
    http_method = "PUT",
    http_path = "/{Bucket}?object-lock",
    paginator = list()
  )
  input <- .s3$put_object_lock_configuration_input(Bucket = Bucket, ObjectLockConfiguration = ObjectLockConfiguration, RequestPayer = RequestPayer, Token = Token, ContentMD5 = ContentMD5, ChecksumAlgorithm = ChecksumAlgorithm, ExpectedBucketOwner = ExpectedBucketOwner)
  output <- .s3$put_object_lock_configuration_output()
  config <- get_config()
  svc <- .s3$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$put_object_lock_configuration <- s3_put_object_lock_configuration

#' Places an Object Retention configuration on an object
#'
#' @description
#' Places an Object Retention configuration on an object. For more information, see [Locking Objects](https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-lock.html). Users or accounts require the `s3:PutObjectRetention` permission in order to place an Object Retention configuration on objects. Bypassing a Governance Retention configuration requires the `s3:BypassGovernanceRetention` permission.
#'
#' See [https://paws-r.github.io/docs/s3/put_object_retention.html](https://paws-r.github.io/docs/s3/put_object_retention.html) for full documentation.
#'
#' @param Bucket &#91;required&#93; The bucket name that contains the object you want to apply this Object
#' Retention configuration to.
#' 
#' When using this action with an access point, you must direct requests to
#' the access point hostname. The access point hostname takes the form
#' *AccessPointName*-*AccountId*.s3-accesspoint.*Region*.amazonaws.com.
#' When using this action with an access point through the Amazon Web
#' Services SDKs, you provide the access point ARN in place of the bucket
#' name. For more information about access point ARNs, see [Using access
#' points](https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html)
#' in the *Amazon S3 User Guide*.
#' @param Key &#91;required&#93; The key name for the object that you want to apply this Object Retention
#' configuration to.
#' @param Retention The container element for the Object Retention configuration.
#' @param RequestPayer 
#' @param VersionId The version ID for the object that you want to apply this Object
#' Retention configuration to.
#' @param BypassGovernanceRetention Indicates whether this action should bypass Governance-mode
#' restrictions.
#' @param ContentMD5 The MD5 hash for the request body.
#' 
#' For requests made using the Amazon Web Services Command Line Interface
#' (CLI) or Amazon Web Services SDKs, this field is calculated
#' automatically.
#' @param ChecksumAlgorithm Indicates the algorithm used to create the checksum for the object when
#' using the SDK. This header will not provide any additional functionality
#' if not using the SDK. When sending this header, there must be a
#' corresponding `x-amz-checksum` or `x-amz-trailer` header sent.
#' Otherwise, Amazon S3 fails the request with the HTTP status code
#' `400 Bad Request`. For more information, see [Checking object
#' integrity](https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html)
#' in the *Amazon S3 User Guide*.
#' 
#' If you provide an individual checksum, Amazon S3 ignores any provided
#' `ChecksumAlgorithm` parameter.
#' @param ExpectedBucketOwner The account ID of the expected bucket owner. If the bucket is owned by a
#' different account, the request fails with the HTTP status code
#' `403 Forbidden` (access denied).
#'
#' @keywords internal
#'
#' @rdname s3_put_object_retention
s3_put_object_retention <- function(Bucket, Key, Retention = NULL, RequestPayer = NULL, VersionId = NULL, BypassGovernanceRetention = NULL, ContentMD5 = NULL, ChecksumAlgorithm = NULL, ExpectedBucketOwner = NULL) {
  op <- new_operation(
    name = "PutObjectRetention",
    http_method = "PUT",
    http_path = "/{Bucket}/{Key+}?retention",
    paginator = list()
  )
  input <- .s3$put_object_retention_input(Bucket = Bucket, Key = Key, Retention = Retention, RequestPayer = RequestPayer, VersionId = VersionId, BypassGovernanceRetention = BypassGovernanceRetention, ContentMD5 = ContentMD5, ChecksumAlgorithm = ChecksumAlgorithm, ExpectedBucketOwner = ExpectedBucketOwner)
  output <- .s3$put_object_retention_output()
  config <- get_config()
  svc <- .s3$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$put_object_retention <- s3_put_object_retention

#' Sets the supplied tag-set to an object that already exists in a bucket
#'
#' @description
#' Sets the supplied tag-set to an object that already exists in a bucket.
#'
#' See [https://paws-r.github.io/docs/s3/put_object_tagging.html](https://paws-r.github.io/docs/s3/put_object_tagging.html) for full documentation.
#'
#' @param Bucket &#91;required&#93; The bucket name containing the object.
#' 
#' When using this action with an access point, you must direct requests to
#' the access point hostname. The access point hostname takes the form
#' *AccessPointName*-*AccountId*.s3-accesspoint.*Region*.amazonaws.com.
#' When using this action with an access point through the Amazon Web
#' Services SDKs, you provide the access point ARN in place of the bucket
#' name. For more information about access point ARNs, see [Using access
#' points](https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html)
#' in the *Amazon S3 User Guide*.
#' 
#' When using this action with Amazon S3 on Outposts, you must direct
#' requests to the S3 on Outposts hostname. The S3 on Outposts hostname
#' takes the form
#' ` AccessPointName-AccountId.outpostID.s3-outposts.Region.amazonaws.com`.
#' When using this action with S3 on Outposts through the Amazon Web
#' Services SDKs, you provide the Outposts bucket ARN in place of the
#' bucket name. For more information about S3 on Outposts ARNs, see [Using
#' Amazon S3 on
#' Outposts](https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html)
#' in the *Amazon S3 User Guide*.
#' @param Key &#91;required&#93; Name of the object key.
#' @param VersionId The versionId of the object that the tag-set will be added to.
#' @param ContentMD5 The MD5 hash for the request body.
#' 
#' For requests made using the Amazon Web Services Command Line Interface
#' (CLI) or Amazon Web Services SDKs, this field is calculated
#' automatically.
#' @param ChecksumAlgorithm Indicates the algorithm used to create the checksum for the object when
#' using the SDK. This header will not provide any additional functionality
#' if not using the SDK. When sending this header, there must be a
#' corresponding `x-amz-checksum` or `x-amz-trailer` header sent.
#' Otherwise, Amazon S3 fails the request with the HTTP status code
#' `400 Bad Request`. For more information, see [Checking object
#' integrity](https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html)
#' in the *Amazon S3 User Guide*.
#' 
#' If you provide an individual checksum, Amazon S3 ignores any provided
#' `ChecksumAlgorithm` parameter.
#' @param Tagging &#91;required&#93; Container for the `TagSet` and `Tag` elements
#' @param ExpectedBucketOwner The account ID of the expected bucket owner. If the bucket is owned by a
#' different account, the request fails with the HTTP status code
#' `403 Forbidden` (access denied).
#' @param RequestPayer 
#'
#' @keywords internal
#'
#' @rdname s3_put_object_tagging
s3_put_object_tagging <- function(Bucket, Key, VersionId = NULL, ContentMD5 = NULL, ChecksumAlgorithm = NULL, Tagging, ExpectedBucketOwner = NULL, RequestPayer = NULL) {
  op <- new_operation(
    name = "PutObjectTagging",
    http_method = "PUT",
    http_path = "/{Bucket}/{Key+}?tagging",
    paginator = list()
  )
  input <- .s3$put_object_tagging_input(Bucket = Bucket, Key = Key, VersionId = VersionId, ContentMD5 = ContentMD5, ChecksumAlgorithm = ChecksumAlgorithm, Tagging = Tagging, ExpectedBucketOwner = ExpectedBucketOwner, RequestPayer = RequestPayer)
  output <- .s3$put_object_tagging_output()
  config <- get_config()
  svc <- .s3$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$put_object_tagging <- s3_put_object_tagging

#' Creates or modifies the PublicAccessBlock configuration for an Amazon S3
#' bucket
#'
#' @description
#' Creates or modifies the `PublicAccessBlock` configuration for an Amazon S3 bucket. To use this operation, you must have the `s3:PutBucketPublicAccessBlock` permission. For more information about Amazon S3 permissions, see [Specifying Permissions in a Policy](https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-with-s3-actions.html).
#'
#' See [https://paws-r.github.io/docs/s3/put_public_access_block.html](https://paws-r.github.io/docs/s3/put_public_access_block.html) for full documentation.
#'
#' @param Bucket &#91;required&#93; The name of the Amazon S3 bucket whose `PublicAccessBlock` configuration
#' you want to set.
#' @param ContentMD5 The MD5 hash of the
#' [`put_public_access_block`][s3_put_public_access_block] request body.
#' 
#' For requests made using the Amazon Web Services Command Line Interface
#' (CLI) or Amazon Web Services SDKs, this field is calculated
#' automatically.
#' @param ChecksumAlgorithm Indicates the algorithm used to create the checksum for the object when
#' using the SDK. This header will not provide any additional functionality
#' if not using the SDK. When sending this header, there must be a
#' corresponding `x-amz-checksum` or `x-amz-trailer` header sent.
#' Otherwise, Amazon S3 fails the request with the HTTP status code
#' `400 Bad Request`. For more information, see [Checking object
#' integrity](https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html)
#' in the *Amazon S3 User Guide*.
#' 
#' If you provide an individual checksum, Amazon S3 ignores any provided
#' `ChecksumAlgorithm` parameter.
#' @param PublicAccessBlockConfiguration &#91;required&#93; The `PublicAccessBlock` configuration that you want to apply to this
#' Amazon S3 bucket. You can enable the configuration options in any
#' combination. For more information about when Amazon S3 considers a
#' bucket or object public, see [The Meaning of
#' "Public"](https://docs.aws.amazon.com/AmazonS3/latest/userguide/access-control-block-public-access.html#access-control-block-public-access-policy-status)
#' in the *Amazon S3 User Guide*.
#' @param ExpectedBucketOwner The account ID of the expected bucket owner. If the bucket is owned by a
#' different account, the request fails with the HTTP status code
#' `403 Forbidden` (access denied).
#'
#' @keywords internal
#'
#' @rdname s3_put_public_access_block
s3_put_public_access_block <- function(Bucket, ContentMD5 = NULL, ChecksumAlgorithm = NULL, PublicAccessBlockConfiguration, ExpectedBucketOwner = NULL) {
  op <- new_operation(
    name = "PutPublicAccessBlock",
    http_method = "PUT",
    http_path = "/{Bucket}?publicAccessBlock",
    paginator = list()
  )
  input <- .s3$put_public_access_block_input(Bucket = Bucket, ContentMD5 = ContentMD5, ChecksumAlgorithm = ChecksumAlgorithm, PublicAccessBlockConfiguration = PublicAccessBlockConfiguration, ExpectedBucketOwner = ExpectedBucketOwner)
  output <- .s3$put_public_access_block_output()
  config <- get_config()
  svc <- .s3$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$put_public_access_block <- s3_put_public_access_block

#' Restores an archived copy of an object back into Amazon S3
#'
#' @description
#' Restores an archived copy of an object back into Amazon S3
#'
#' See [https://paws-r.github.io/docs/s3/restore_object.html](https://paws-r.github.io/docs/s3/restore_object.html) for full documentation.
#'
#' @param Bucket &#91;required&#93; The bucket name containing the object to restore.
#' 
#' When using this action with an access point, you must direct requests to
#' the access point hostname. The access point hostname takes the form
#' *AccessPointName*-*AccountId*.s3-accesspoint.*Region*.amazonaws.com.
#' When using this action with an access point through the Amazon Web
#' Services SDKs, you provide the access point ARN in place of the bucket
#' name. For more information about access point ARNs, see [Using access
#' points](https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html)
#' in the *Amazon S3 User Guide*.
#' 
#' When using this action with Amazon S3 on Outposts, you must direct
#' requests to the S3 on Outposts hostname. The S3 on Outposts hostname
#' takes the form
#' ` AccessPointName-AccountId.outpostID.s3-outposts.Region.amazonaws.com`.
#' When using this action with S3 on Outposts through the Amazon Web
#' Services SDKs, you provide the Outposts bucket ARN in place of the
#' bucket name. For more information about S3 on Outposts ARNs, see [Using
#' Amazon S3 on
#' Outposts](https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html)
#' in the *Amazon S3 User Guide*.
#' @param Key &#91;required&#93; Object key for which the action was initiated.
#' @param VersionId VersionId used to reference a specific version of the object.
#' @param RestoreRequest 
#' @param RequestPayer 
#' @param ChecksumAlgorithm Indicates the algorithm used to create the checksum for the object when
#' using the SDK. This header will not provide any additional functionality
#' if not using the SDK. When sending this header, there must be a
#' corresponding `x-amz-checksum` or `x-amz-trailer` header sent.
#' Otherwise, Amazon S3 fails the request with the HTTP status code
#' `400 Bad Request`. For more information, see [Checking object
#' integrity](https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html)
#' in the *Amazon S3 User Guide*.
#' 
#' If you provide an individual checksum, Amazon S3 ignores any provided
#' `ChecksumAlgorithm` parameter.
#' @param ExpectedBucketOwner The account ID of the expected bucket owner. If the bucket is owned by a
#' different account, the request fails with the HTTP status code
#' `403 Forbidden` (access denied).
#'
#' @keywords internal
#'
#' @rdname s3_restore_object
s3_restore_object <- function(Bucket, Key, VersionId = NULL, RestoreRequest = NULL, RequestPayer = NULL, ChecksumAlgorithm = NULL, ExpectedBucketOwner = NULL) {
  op <- new_operation(
    name = "RestoreObject",
    http_method = "POST",
    http_path = "/{Bucket}/{Key+}?restore",
    paginator = list()
  )
  input <- .s3$restore_object_input(Bucket = Bucket, Key = Key, VersionId = VersionId, RestoreRequest = RestoreRequest, RequestPayer = RequestPayer, ChecksumAlgorithm = ChecksumAlgorithm, ExpectedBucketOwner = ExpectedBucketOwner)
  output <- .s3$restore_object_output()
  config <- get_config()
  svc <- .s3$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$restore_object <- s3_restore_object

#' This action filters the contents of an Amazon S3 object based on a
#' simple structured query language (SQL) statement
#'
#' @description
#' This action filters the contents of an Amazon S3 object based on a simple structured query language (SQL) statement. In the request, along with the SQL expression, you must also specify a data serialization format (JSON, CSV, or Apache Parquet) of the object. Amazon S3 uses this format to parse object data into records, and returns only records that match the specified SQL expression. You must also specify the data serialization format for the response.
#'
#' See [https://paws-r.github.io/docs/s3/select_object_content.html](https://paws-r.github.io/docs/s3/select_object_content.html) for full documentation.
#'
#' @param Bucket &#91;required&#93; The S3 bucket.
#' @param Key &#91;required&#93; The object key.
#' @param SSECustomerAlgorithm The server-side encryption (SSE) algorithm used to encrypt the object.
#' This parameter is needed only when the object was created using a
#' checksum algorithm. For more information, see [Protecting data using
#' SSE-C
#' keys](https://docs.aws.amazon.com/AmazonS3/latest/userguide/ServerSideEncryptionCustomerKeys.html)
#' in the *Amazon S3 User Guide*.
#' @param SSECustomerKey The server-side encryption (SSE) customer managed key. This parameter is
#' needed only when the object was created using a checksum algorithm. For
#' more information, see [Protecting data using SSE-C
#' keys](https://docs.aws.amazon.com/AmazonS3/latest/userguide/ServerSideEncryptionCustomerKeys.html)
#' in the *Amazon S3 User Guide*.
#' @param SSECustomerKeyMD5 The MD5 server-side encryption (SSE) customer managed key. This
#' parameter is needed only when the object was created using a checksum
#' algorithm. For more information, see [Protecting data using SSE-C
#' keys](https://docs.aws.amazon.com/AmazonS3/latest/userguide/ServerSideEncryptionCustomerKeys.html)
#' in the *Amazon S3 User Guide*.
#' @param Expression &#91;required&#93; The expression that is used to query the object.
#' @param ExpressionType &#91;required&#93; The type of the provided expression (for example, SQL).
#' @param RequestProgress Specifies if periodic request progress information should be enabled.
#' @param InputSerialization &#91;required&#93; Describes the format of the data in the object that is being queried.
#' @param OutputSerialization &#91;required&#93; Describes the format of the data that you want Amazon S3 to return in
#' response.
#' @param ScanRange Specifies the byte range of the object to get the records from. A record
#' is processed when its first byte is contained by the range. This
#' parameter is optional, but when specified, it must not be empty. See RFC
#' 2616, Section 14.35.1 about how to specify the start and end of the
#' range.
#' 
#' `ScanRange`may be used in the following ways:
#' 
#' -   `<scanrange><start>50</start><end>100</end></scanrange>` - process
#'     only the records starting between the bytes 50 and 100 (inclusive,
#'     counting from zero)
#' 
#' -   `<scanrange><start>50</start></scanrange>` - process only the
#'     records starting after the byte 50
#' 
#' -   `<scanrange><end>50</end></scanrange>` - process only the records
#'     within the last 50 bytes of the file.
#' @param ExpectedBucketOwner The account ID of the expected bucket owner. If the bucket is owned by a
#' different account, the request fails with the HTTP status code
#' `403 Forbidden` (access denied).
#'
#' @keywords internal
#'
#' @rdname s3_select_object_content
s3_select_object_content <- function(Bucket, Key, SSECustomerAlgorithm = NULL, SSECustomerKey = NULL, SSECustomerKeyMD5 = NULL, Expression, ExpressionType, RequestProgress = NULL, InputSerialization, OutputSerialization, ScanRange = NULL, ExpectedBucketOwner = NULL) {
  op <- new_operation(
    name = "SelectObjectContent",
    http_method = "POST",
    http_path = "/{Bucket}/{Key+}?select&select-type=2",
    paginator = list()
  )
  input <- .s3$select_object_content_input(Bucket = Bucket, Key = Key, SSECustomerAlgorithm = SSECustomerAlgorithm, SSECustomerKey = SSECustomerKey, SSECustomerKeyMD5 = SSECustomerKeyMD5, Expression = Expression, ExpressionType = ExpressionType, RequestProgress = RequestProgress, InputSerialization = InputSerialization, OutputSerialization = OutputSerialization, ScanRange = ScanRange, ExpectedBucketOwner = ExpectedBucketOwner)
  output <- .s3$select_object_content_output()
  config <- get_config()
  svc <- .s3$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$select_object_content <- s3_select_object_content

#' Uploads a part in a multipart upload
#'
#' @description
#' Uploads a part in a multipart upload.
#'
#' See [https://paws-r.github.io/docs/s3/upload_part.html](https://paws-r.github.io/docs/s3/upload_part.html) for full documentation.
#'
#' @param Body Object data.
#' @param Bucket &#91;required&#93; The name of the bucket to which the multipart upload was initiated.
#' 
#' When using this action with an access point, you must direct requests to
#' the access point hostname. The access point hostname takes the form
#' *AccessPointName*-*AccountId*.s3-accesspoint.*Region*.amazonaws.com.
#' When using this action with an access point through the Amazon Web
#' Services SDKs, you provide the access point ARN in place of the bucket
#' name. For more information about access point ARNs, see [Using access
#' points](https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html)
#' in the *Amazon S3 User Guide*.
#' 
#' When using this action with Amazon S3 on Outposts, you must direct
#' requests to the S3 on Outposts hostname. The S3 on Outposts hostname
#' takes the form
#' ` AccessPointName-AccountId.outpostID.s3-outposts.Region.amazonaws.com`.
#' When using this action with S3 on Outposts through the Amazon Web
#' Services SDKs, you provide the Outposts bucket ARN in place of the
#' bucket name. For more information about S3 on Outposts ARNs, see [Using
#' Amazon S3 on
#' Outposts](https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html)
#' in the *Amazon S3 User Guide*.
#' @param ContentLength Size of the body in bytes. This parameter is useful when the size of the
#' body cannot be determined automatically.
#' @param ContentMD5 The base64-encoded 128-bit MD5 digest of the part data. This parameter
#' is auto-populated when using the command from the CLI. This parameter is
#' required if object lock parameters are specified.
#' @param ChecksumAlgorithm Indicates the algorithm used to create the checksum for the object when
#' using the SDK. This header will not provide any additional functionality
#' if not using the SDK. When sending this header, there must be a
#' corresponding `x-amz-checksum` or `x-amz-trailer` header sent.
#' Otherwise, Amazon S3 fails the request with the HTTP status code
#' `400 Bad Request`. For more information, see [Checking object
#' integrity](https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html)
#' in the *Amazon S3 User Guide*.
#' 
#' If you provide an individual checksum, Amazon S3 ignores any provided
#' `ChecksumAlgorithm` parameter.
#' 
#' This checksum algorithm must be the same for all parts and it match the
#' checksum value supplied in the
#' [`create_multipart_upload`][s3_create_multipart_upload] request.
#' @param ChecksumCRC32 This header can be used as a data integrity check to verify that the
#' data received is the same data that was originally sent. This header
#' specifies the base64-encoded, 32-bit CRC32 checksum of the object. For
#' more information, see [Checking object
#' integrity](https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html)
#' in the *Amazon S3 User Guide*.
#' @param ChecksumCRC32C This header can be used as a data integrity check to verify that the
#' data received is the same data that was originally sent. This header
#' specifies the base64-encoded, 32-bit CRC32C checksum of the object. For
#' more information, see [Checking object
#' integrity](https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html)
#' in the *Amazon S3 User Guide*.
#' @param ChecksumSHA1 This header can be used as a data integrity check to verify that the
#' data received is the same data that was originally sent. This header
#' specifies the base64-encoded, 160-bit SHA-1 digest of the object. For
#' more information, see [Checking object
#' integrity](https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html)
#' in the *Amazon S3 User Guide*.
#' @param ChecksumSHA256 This header can be used as a data integrity check to verify that the
#' data received is the same data that was originally sent. This header
#' specifies the base64-encoded, 256-bit SHA-256 digest of the object. For
#' more information, see [Checking object
#' integrity](https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html)
#' in the *Amazon S3 User Guide*.
#' @param Key &#91;required&#93; Object key for which the multipart upload was initiated.
#' @param PartNumber &#91;required&#93; Part number of part being uploaded. This is a positive integer between 1
#' and 10,000.
#' @param UploadId &#91;required&#93; Upload ID identifying the multipart upload whose part is being uploaded.
#' @param SSECustomerAlgorithm Specifies the algorithm to use to when encrypting the object (for
#' example, AES256).
#' @param SSECustomerKey Specifies the customer-provided encryption key for Amazon S3 to use in
#' encrypting data. This value is used to store the object and then it is
#' discarded; Amazon S3 does not store the encryption key. The key must be
#' appropriate for use with the algorithm specified in the
#' `x-amz-server-side-encryption-customer-algorithm header`. This must be
#' the same encryption key specified in the initiate multipart upload
#' request.
#' @param SSECustomerKeyMD5 Specifies the 128-bit MD5 digest of the encryption key according to RFC
#' 1321. Amazon S3 uses this header for a message integrity check to ensure
#' that the encryption key was transmitted without error.
#' @param RequestPayer 
#' @param ExpectedBucketOwner The account ID of the expected bucket owner. If the bucket is owned by a
#' different account, the request fails with the HTTP status code
#' `403 Forbidden` (access denied).
#'
#' @keywords internal
#'
#' @rdname s3_upload_part
s3_upload_part <- function(Body = NULL, Bucket, ContentLength = NULL, ContentMD5 = NULL, ChecksumAlgorithm = NULL, ChecksumCRC32 = NULL, ChecksumCRC32C = NULL, ChecksumSHA1 = NULL, ChecksumSHA256 = NULL, Key, PartNumber, UploadId, SSECustomerAlgorithm = NULL, SSECustomerKey = NULL, SSECustomerKeyMD5 = NULL, RequestPayer = NULL, ExpectedBucketOwner = NULL) {
  op <- new_operation(
    name = "UploadPart",
    http_method = "PUT",
    http_path = "/{Bucket}/{Key+}",
    paginator = list()
  )
  input <- .s3$upload_part_input(Body = Body, Bucket = Bucket, ContentLength = ContentLength, ContentMD5 = ContentMD5, ChecksumAlgorithm = ChecksumAlgorithm, ChecksumCRC32 = ChecksumCRC32, ChecksumCRC32C = ChecksumCRC32C, ChecksumSHA1 = ChecksumSHA1, ChecksumSHA256 = ChecksumSHA256, Key = Key, PartNumber = PartNumber, UploadId = UploadId, SSECustomerAlgorithm = SSECustomerAlgorithm, SSECustomerKey = SSECustomerKey, SSECustomerKeyMD5 = SSECustomerKeyMD5, RequestPayer = RequestPayer, ExpectedBucketOwner = ExpectedBucketOwner)
  output <- .s3$upload_part_output()
  config <- get_config()
  svc <- .s3$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$upload_part <- s3_upload_part

#' Uploads a part by copying data from an existing object as data source
#'
#' @description
#' Uploads a part by copying data from an existing object as data source. You specify the data source by adding the request header `x-amz-copy-source` in your request and a byte range by adding the request header `x-amz-copy-source-range` in your request.
#'
#' See [https://paws-r.github.io/docs/s3/upload_part_copy.html](https://paws-r.github.io/docs/s3/upload_part_copy.html) for full documentation.
#'
#' @param Bucket &#91;required&#93; The bucket name.
#' 
#' When using this action with an access point, you must direct requests to
#' the access point hostname. The access point hostname takes the form
#' *AccessPointName*-*AccountId*.s3-accesspoint.*Region*.amazonaws.com.
#' When using this action with an access point through the Amazon Web
#' Services SDKs, you provide the access point ARN in place of the bucket
#' name. For more information about access point ARNs, see [Using access
#' points](https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html)
#' in the *Amazon S3 User Guide*.
#' 
#' When using this action with Amazon S3 on Outposts, you must direct
#' requests to the S3 on Outposts hostname. The S3 on Outposts hostname
#' takes the form
#' ` AccessPointName-AccountId.outpostID.s3-outposts.Region.amazonaws.com`.
#' When using this action with S3 on Outposts through the Amazon Web
#' Services SDKs, you provide the Outposts bucket ARN in place of the
#' bucket name. For more information about S3 on Outposts ARNs, see [Using
#' Amazon S3 on
#' Outposts](https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html)
#' in the *Amazon S3 User Guide*.
#' @param CopySource &#91;required&#93; Specifies the source object for the copy operation. You specify the
#' value in one of two formats, depending on whether you want to access the
#' source object through an [access
#' point](https://docs.aws.amazon.com/AmazonS3/latest/userguide/access-points.html):
#' 
#' -   For objects not accessed through an access point, specify the name
#'     of the source bucket and key of the source object, separated by a
#'     slash (/). For example, to copy the object `reports/january.pdf`
#'     from the bucket `awsexamplebucket`, use
#'     `awsexamplebucket/reports/january.pdf`. The value must be
#'     URL-encoded.
#' 
#' -   For objects accessed through access points, specify the Amazon
#'     Resource Name (ARN) of the object as accessed through the access
#'     point, in the format
#'     `arn:aws:s3:<Region>:<account-id>:accesspoint/<access-point-name>/object/<key>`.
#'     For example, to copy the object `reports/january.pdf` through access
#'     point `my-access-point` owned by account `123456789012` in Region
#'     `us-west-2`, use the URL encoding of
#'     `arn:aws:s3:us-west-2:123456789012:accesspoint/my-access-point/object/reports/january.pdf`.
#'     The value must be URL encoded.
#' 
#'     Amazon S3 supports copy operations using access points only when the
#'     source and destination buckets are in the same Amazon Web Services
#'     Region.
#' 
#'     Alternatively, for objects accessed through Amazon S3 on Outposts,
#'     specify the ARN of the object as accessed in the format
#'     `arn:aws:s3-outposts:<Region>:<account-id>:outpost/<outpost-id>/object/<key>`.
#'     For example, to copy the object `reports/january.pdf` through
#'     outpost `my-outpost` owned by account `123456789012` in Region
#'     `us-west-2`, use the URL encoding of
#'     `arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/object/reports/january.pdf`.
#'     The value must be URL-encoded.
#' 
#' To copy a specific version of an object, append
#' `?versionId=<version-id>` to the value (for example,
#' `awsexamplebucket/reports/january.pdf?versionId=QUpfdndhfd8438MNFDN93jdnJFkdmqnh893`).
#' If you don't specify a version ID, Amazon S3 copies the latest version
#' of the source object.
#' @param CopySourceIfMatch Copies the object if its entity tag (ETag) matches the specified tag.
#' @param CopySourceIfModifiedSince Copies the object if it has been modified since the specified time.
#' @param CopySourceIfNoneMatch Copies the object if its entity tag (ETag) is different than the
#' specified ETag.
#' @param CopySourceIfUnmodifiedSince Copies the object if it hasn't been modified since the specified time.
#' @param CopySourceRange The range of bytes to copy from the source object. The range value must
#' use the form bytes=first-last, where the first and last are the
#' zero-based byte offsets to copy. For example, bytes=0-9 indicates that
#' you want to copy the first 10 bytes of the source. You can copy a range
#' only if the source object is greater than 5 MB.
#' @param Key &#91;required&#93; Object key for which the multipart upload was initiated.
#' @param PartNumber &#91;required&#93; Part number of part being copied. This is a positive integer between 1
#' and 10,000.
#' @param UploadId &#91;required&#93; Upload ID identifying the multipart upload whose part is being copied.
#' @param SSECustomerAlgorithm Specifies the algorithm to use to when encrypting the object (for
#' example, AES256).
#' @param SSECustomerKey Specifies the customer-provided encryption key for Amazon S3 to use in
#' encrypting data. This value is used to store the object and then it is
#' discarded; Amazon S3 does not store the encryption key. The key must be
#' appropriate for use with the algorithm specified in the
#' `x-amz-server-side-encryption-customer-algorithm` header. This must be
#' the same encryption key specified in the initiate multipart upload
#' request.
#' @param SSECustomerKeyMD5 Specifies the 128-bit MD5 digest of the encryption key according to RFC
#' 1321. Amazon S3 uses this header for a message integrity check to ensure
#' that the encryption key was transmitted without error.
#' @param CopySourceSSECustomerAlgorithm Specifies the algorithm to use when decrypting the source object (for
#' example, AES256).
#' @param CopySourceSSECustomerKey Specifies the customer-provided encryption key for Amazon S3 to use to
#' decrypt the source object. The encryption key provided in this header
#' must be one that was used when the source object was created.
#' @param CopySourceSSECustomerKeyMD5 Specifies the 128-bit MD5 digest of the encryption key according to RFC
#' 1321. Amazon S3 uses this header for a message integrity check to ensure
#' that the encryption key was transmitted without error.
#' @param RequestPayer 
#' @param ExpectedBucketOwner The account ID of the expected destination bucket owner. If the
#' destination bucket is owned by a different account, the request fails
#' with the HTTP status code `403 Forbidden` (access denied).
#' @param ExpectedSourceBucketOwner The account ID of the expected source bucket owner. If the source bucket
#' is owned by a different account, the request fails with the HTTP status
#' code `403 Forbidden` (access denied).
#'
#' @keywords internal
#'
#' @rdname s3_upload_part_copy
s3_upload_part_copy <- function(Bucket, CopySource, CopySourceIfMatch = NULL, CopySourceIfModifiedSince = NULL, CopySourceIfNoneMatch = NULL, CopySourceIfUnmodifiedSince = NULL, CopySourceRange = NULL, Key, PartNumber, UploadId, SSECustomerAlgorithm = NULL, SSECustomerKey = NULL, SSECustomerKeyMD5 = NULL, CopySourceSSECustomerAlgorithm = NULL, CopySourceSSECustomerKey = NULL, CopySourceSSECustomerKeyMD5 = NULL, RequestPayer = NULL, ExpectedBucketOwner = NULL, ExpectedSourceBucketOwner = NULL) {
  op <- new_operation(
    name = "CopyPart",
    http_method = "PUT",
    http_path = "/{Bucket}/{Key+}",
    paginator = list()
  )
  input <- .s3$upload_part_copy_input(Bucket = Bucket, CopySource = CopySource, CopySourceIfMatch = CopySourceIfMatch, CopySourceIfModifiedSince = CopySourceIfModifiedSince, CopySourceIfNoneMatch = CopySourceIfNoneMatch, CopySourceIfUnmodifiedSince = CopySourceIfUnmodifiedSince, CopySourceRange = CopySourceRange, Key = Key, PartNumber = PartNumber, UploadId = UploadId, SSECustomerAlgorithm = SSECustomerAlgorithm, SSECustomerKey = SSECustomerKey, SSECustomerKeyMD5 = SSECustomerKeyMD5, CopySourceSSECustomerAlgorithm = CopySourceSSECustomerAlgorithm, CopySourceSSECustomerKey = CopySourceSSECustomerKey, CopySourceSSECustomerKeyMD5 = CopySourceSSECustomerKeyMD5, RequestPayer = RequestPayer, ExpectedBucketOwner = ExpectedBucketOwner, ExpectedSourceBucketOwner = ExpectedSourceBucketOwner)
  output <- .s3$upload_part_copy_output()
  config <- get_config()
  svc <- .s3$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$upload_part_copy <- s3_upload_part_copy

#' Passes transformed objects to a GetObject operation when using Object
#' Lambda access points
#'
#' @description
#' Passes transformed objects to a [`get_object`][s3_get_object] operation when using Object Lambda access points. For information about Object Lambda access points, see [Transforming objects with Object Lambda access points](https://docs.aws.amazon.com/AmazonS3/latest/userguide/transforming-objects.html) in the *Amazon S3 User Guide*.
#'
#' See [https://paws-r.github.io/docs/s3/write_get_object_response.html](https://paws-r.github.io/docs/s3/write_get_object_response.html) for full documentation.
#'
#' @param RequestRoute &#91;required&#93; Route prefix to the HTTP URL generated.
#' @param RequestToken &#91;required&#93; A single use encrypted token that maps
#' [`write_get_object_response`][s3_write_get_object_response] to the end
#' user [`get_object`][s3_get_object] request.
#' @param Body The object data.
#' @param StatusCode The integer status code for an HTTP response of a corresponding
#' [`get_object`][s3_get_object] request.
#' 
#' **Status Codes**
#' 
#' -   `200 - OK`
#' 
#' -   `206 - Partial Content`
#' 
#' -   `304 - Not Modified`
#' 
#' -   `400 - Bad Request`
#' 
#' -   `401 - Unauthorized`
#' 
#' -   `403 - Forbidden`
#' 
#' -   `404 - Not Found`
#' 
#' -   `405 - Method Not Allowed`
#' 
#' -   `409 - Conflict`
#' 
#' -   `411 - Length Required`
#' 
#' -   `412 - Precondition Failed`
#' 
#' -   `416 - Range Not Satisfiable`
#' 
#' -   `500 - Internal Server Error`
#' 
#' -   `503 - Service Unavailable`
#' @param ErrorCode A string that uniquely identifies an error condition. Returned in the
#' \<Code\> tag of the error XML response for a corresponding
#' [`get_object`][s3_get_object] call. Cannot be used with a successful
#' `StatusCode` header or when the transformed object is provided in the
#' body. All error codes from S3 are sentence-cased. The regular expression
#' (regex) value is `"^[A-Z][a-zA-Z]+$"`.
#' @param ErrorMessage Contains a generic description of the error condition. Returned in the
#' \<Message\> tag of the error XML response for a corresponding
#' [`get_object`][s3_get_object] call. Cannot be used with a successful
#' `StatusCode` header or when the transformed object is provided in body.
#' @param AcceptRanges Indicates that a range of bytes was specified.
#' @param CacheControl Specifies caching behavior along the request/reply chain.
#' @param ContentDisposition Specifies presentational information for the object.
#' @param ContentEncoding Specifies what content encodings have been applied to the object and
#' thus what decoding mechanisms must be applied to obtain the media-type
#' referenced by the Content-Type header field.
#' @param ContentLanguage The language the content is in.
#' @param ContentLength The size of the content body in bytes.
#' @param ContentRange The portion of the object returned in the response.
#' @param ContentType A standard MIME type describing the format of the object data.
#' @param ChecksumCRC32 This header can be used as a data integrity check to verify that the
#' data received is the same data that was originally sent. This specifies
#' the base64-encoded, 32-bit CRC32 checksum of the object returned by the
#' Object Lambda function. This may not match the checksum for the object
#' stored in Amazon S3. Amazon S3 will perform validation of the checksum
#' values only when the original [`get_object`][s3_get_object] request
#' required checksum validation. For more information about checksums, see
#' [Checking object
#' integrity](https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html)
#' in the *Amazon S3 User Guide*.
#' 
#' Only one checksum header can be specified at a time. If you supply
#' multiple checksum headers, this request will fail.
#' @param ChecksumCRC32C This header can be used as a data integrity check to verify that the
#' data received is the same data that was originally sent. This specifies
#' the base64-encoded, 32-bit CRC32C checksum of the object returned by the
#' Object Lambda function. This may not match the checksum for the object
#' stored in Amazon S3. Amazon S3 will perform validation of the checksum
#' values only when the original [`get_object`][s3_get_object] request
#' required checksum validation. For more information about checksums, see
#' [Checking object
#' integrity](https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html)
#' in the *Amazon S3 User Guide*.
#' 
#' Only one checksum header can be specified at a time. If you supply
#' multiple checksum headers, this request will fail.
#' @param ChecksumSHA1 This header can be used as a data integrity check to verify that the
#' data received is the same data that was originally sent. This specifies
#' the base64-encoded, 160-bit SHA-1 digest of the object returned by the
#' Object Lambda function. This may not match the checksum for the object
#' stored in Amazon S3. Amazon S3 will perform validation of the checksum
#' values only when the original [`get_object`][s3_get_object] request
#' required checksum validation. For more information about checksums, see
#' [Checking object
#' integrity](https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html)
#' in the *Amazon S3 User Guide*.
#' 
#' Only one checksum header can be specified at a time. If you supply
#' multiple checksum headers, this request will fail.
#' @param ChecksumSHA256 This header can be used as a data integrity check to verify that the
#' data received is the same data that was originally sent. This specifies
#' the base64-encoded, 256-bit SHA-256 digest of the object returned by the
#' Object Lambda function. This may not match the checksum for the object
#' stored in Amazon S3. Amazon S3 will perform validation of the checksum
#' values only when the original [`get_object`][s3_get_object] request
#' required checksum validation. For more information about checksums, see
#' [Checking object
#' integrity](https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html)
#' in the *Amazon S3 User Guide*.
#' 
#' Only one checksum header can be specified at a time. If you supply
#' multiple checksum headers, this request will fail.
#' @param DeleteMarker Specifies whether an object stored in Amazon S3 is (`true`) or is not
#' (`false`) a delete marker.
#' @param ETag An opaque identifier assigned by a web server to a specific version of a
#' resource found at a URL.
#' @param Expires The date and time at which the object is no longer cacheable.
#' @param Expiration If the object expiration is configured (see PUT Bucket lifecycle), the
#' response includes this header. It includes the `expiry-date` and
#' `rule-id` key-value pairs that provide the object expiration
#' information. The value of the `rule-id` is URL-encoded.
#' @param LastModified The date and time that the object was last modified.
#' @param MissingMeta Set to the number of metadata entries not returned in `x-amz-meta`
#' headers. This can happen if you create metadata using an API like SOAP
#' that supports more flexible metadata than the REST API. For example,
#' using SOAP, you can create metadata whose values are not legal HTTP
#' headers.
#' @param Metadata A map of metadata to store with the object in S3.
#' @param ObjectLockMode Indicates whether an object stored in Amazon S3 has Object Lock enabled.
#' For more information about S3 Object Lock, see [Object
#' Lock](https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-lock.html).
#' @param ObjectLockLegalHoldStatus Indicates whether an object stored in Amazon S3 has an active legal
#' hold.
#' @param ObjectLockRetainUntilDate The date and time when Object Lock is configured to expire.
#' @param PartsCount The count of parts this object has.
#' @param ReplicationStatus Indicates if request involves bucket that is either a source or
#' destination in a Replication rule. For more information about S3
#' Replication, see
#' [Replication](https://docs.aws.amazon.com/AmazonS3/latest/userguide/replication.html).
#' @param RequestCharged 
#' @param Restore Provides information about object restoration operation and expiration
#' time of the restored object copy.
#' @param ServerSideEncryption The server-side encryption algorithm used when storing requested object
#' in Amazon S3 (for example, AES256, aws:kms).
#' @param SSECustomerAlgorithm Encryption algorithm used if server-side encryption with a
#' customer-provided encryption key was specified for object stored in
#' Amazon S3.
#' @param SSEKMSKeyId If present, specifies the ID of the Amazon Web Services Key Management
#' Service (Amazon Web Services KMS) symmetric customer managed key that
#' was used for stored in Amazon S3 object.
#' @param SSECustomerKeyMD5 128-bit MD5 digest of customer-provided encryption key used in Amazon S3
#' to encrypt data stored in S3. For more information, see [Protecting data
#' using server-side encryption with customer-provided encryption keys
#' (SSE-C)](https://docs.aws.amazon.com/AmazonS3/latest/userguide/ServerSideEncryptionCustomerKeys.html).
#' @param StorageClass Provides storage class information of the object. Amazon S3 returns this
#' header for all objects except for S3 Standard storage class objects.
#' 
#' For more information, see [Storage
#' Classes](https://docs.aws.amazon.com/AmazonS3/latest/userguide/storage-class-intro.html).
#' @param TagCount The number of tags, if any, on the object.
#' @param VersionId An ID used to reference a specific version of the object.
#' @param BucketKeyEnabled Indicates whether the object stored in Amazon S3 uses an S3 bucket key
#' for server-side encryption with Amazon Web Services KMS (SSE-KMS).
#'
#' @keywords internal
#'
#' @rdname s3_write_get_object_response
s3_write_get_object_response <- function(RequestRoute, RequestToken, Body = NULL, StatusCode = NULL, ErrorCode = NULL, ErrorMessage = NULL, AcceptRanges = NULL, CacheControl = NULL, ContentDisposition = NULL, ContentEncoding = NULL, ContentLanguage = NULL, ContentLength = NULL, ContentRange = NULL, ContentType = NULL, ChecksumCRC32 = NULL, ChecksumCRC32C = NULL, ChecksumSHA1 = NULL, ChecksumSHA256 = NULL, DeleteMarker = NULL, ETag = NULL, Expires = NULL, Expiration = NULL, LastModified = NULL, MissingMeta = NULL, Metadata = NULL, ObjectLockMode = NULL, ObjectLockLegalHoldStatus = NULL, ObjectLockRetainUntilDate = NULL, PartsCount = NULL, ReplicationStatus = NULL, RequestCharged = NULL, Restore = NULL, ServerSideEncryption = NULL, SSECustomerAlgorithm = NULL, SSEKMSKeyId = NULL, SSECustomerKeyMD5 = NULL, StorageClass = NULL, TagCount = NULL, VersionId = NULL, BucketKeyEnabled = NULL) {
  op <- new_operation(
    name = "WriteGetObjectResponse",
    http_method = "POST",
    http_path = "/WriteGetObjectResponse",
    paginator = list()
  )
  input <- .s3$write_get_object_response_input(RequestRoute = RequestRoute, RequestToken = RequestToken, Body = Body, StatusCode = StatusCode, ErrorCode = ErrorCode, ErrorMessage = ErrorMessage, AcceptRanges = AcceptRanges, CacheControl = CacheControl, ContentDisposition = ContentDisposition, ContentEncoding = ContentEncoding, ContentLanguage = ContentLanguage, ContentLength = ContentLength, ContentRange = ContentRange, ContentType = ContentType, ChecksumCRC32 = ChecksumCRC32, ChecksumCRC32C = ChecksumCRC32C, ChecksumSHA1 = ChecksumSHA1, ChecksumSHA256 = ChecksumSHA256, DeleteMarker = DeleteMarker, ETag = ETag, Expires = Expires, Expiration = Expiration, LastModified = LastModified, MissingMeta = MissingMeta, Metadata = Metadata, ObjectLockMode = ObjectLockMode, ObjectLockLegalHoldStatus = ObjectLockLegalHoldStatus, ObjectLockRetainUntilDate = ObjectLockRetainUntilDate, PartsCount = PartsCount, ReplicationStatus = ReplicationStatus, RequestCharged = RequestCharged, Restore = Restore, ServerSideEncryption = ServerSideEncryption, SSECustomerAlgorithm = SSECustomerAlgorithm, SSEKMSKeyId = SSEKMSKeyId, SSECustomerKeyMD5 = SSECustomerKeyMD5, StorageClass = StorageClass, TagCount = TagCount, VersionId = VersionId, BucketKeyEnabled = BucketKeyEnabled)
  output <- .s3$write_get_object_response_output()
  config <- get_config()
  svc <- .s3$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3$operations$write_get_object_response <- s3_write_get_object_response
