# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include fsx_service.R
NULL

#' Cancels an existing Amazon FSx for Lustre data repository task if that
#' task is in either the PENDING or EXECUTING state
#'
#' Cancels an existing Amazon FSx for Lustre data repository task if that
#' task is in either the `PENDING` or `EXECUTING` state. When you cancel a
#' task, Amazon FSx does the following.
#' 
#' -   Any files that FSx has already exported are not reverted.
#' 
#' -   FSx continues to export any files that are \"in-flight\" when the
#'     cancel operation is received.
#' 
#' -   FSx does not export any files that have not yet been exported.
#'
#' @usage
#' fsx_cancel_data_repository_task(TaskId)
#'
#' @param TaskId &#91;required&#93; Specifies the data repository task to cancel.
#'
#' @section Request syntax:
#' ```
#' svc$cancel_data_repository_task(
#'   TaskId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname fsx_cancel_data_repository_task
fsx_cancel_data_repository_task <- function(TaskId) {
  op <- new_operation(
    name = "CancelDataRepositoryTask",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .fsx$cancel_data_repository_task_input(TaskId = TaskId)
  output <- .fsx$cancel_data_repository_task_output()
  config <- get_config()
  svc <- .fsx$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.fsx$operations$cancel_data_repository_task <- fsx_cancel_data_repository_task

#' Creates a backup of an existing Amazon FSx file system
#'
#' Creates a backup of an existing Amazon FSx file system. Creating regular
#' backups for your file system is a best practice, enabling you to restore
#' a file system from a backup if an issue arises with the original file
#' system.
#' 
#' For Amazon FSx for Lustre file systems, you can create a backup only for
#' file systems with the following configuration:
#' 
#' -   a Persistent deployment type
#' 
#' -   is *not* linked to an Amazon S3 data respository.
#' 
#' For more information, see
#' <https://docs.aws.amazon.com/fsx/latest/LustreGuide/lustre-backups.html>.
#' 
#' If a backup with the specified client request token exists, and the
#' parameters match, this operation returns the description of the existing
#' backup. If a backup specified client request token exists, and the
#' parameters don\'t match, this operation returns
#' `IncompatibleParameterError`. If a backup with the specified client
#' request token doesn\'t exist, `CreateBackup` does the following:
#' 
#' -   Creates a new Amazon FSx backup with an assigned ID, and an initial
#'     lifecycle state of `CREATING`.
#' 
#' -   Returns the description of the backup.
#' 
#' By using the idempotent operation, you can retry a `CreateBackup`
#' operation without the risk of creating an extra backup. This approach
#' can be useful when an initial call fails in a way that makes it unclear
#' whether a backup was created. If you use the same client request token
#' and the initial call created a backup, the operation returns a
#' successful result because all the parameters are the same.
#' 
#' The `CreateBackup` operation returns while the backup\'s lifecycle state
#' is still `CREATING`. You can check the backup creation status by calling
#' the DescribeBackups operation, which returns the backup state along with
#' other information.
#'
#' @usage
#' fsx_create_backup(FileSystemId, ClientRequestToken, Tags)
#'
#' @param FileSystemId &#91;required&#93; The ID of the file system to back up.
#' @param ClientRequestToken A string of up to 64 ASCII characters that Amazon FSx uses to ensure
#' idempotent creation. This string is automatically filled on your behalf
#' when you use the AWS Command Line Interface (AWS CLI) or an AWS SDK.
#' @param Tags The tags to apply to the backup at backup creation. The key value of the
#' `Name` tag appears in the console as the backup name. If you have set
#' `CopyTagsToBackups` to true, and you specify one or more tags using the
#' `CreateBackup` action, no existing tags on the file system are copied
#' from the file system to the backup.
#'
#' @section Request syntax:
#' ```
#' svc$create_backup(
#'   FileSystemId = "string",
#'   ClientRequestToken = "string",
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This operation creates a new backup.
#' svc$create_backup(
#'   FileSystemId = "fs-0498eed5fe91001ec",
#'   Tags = list(
#'     list(
#'       Key = "Name",
#'       Value = "MyBackup"
#'     )
#'   )
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname fsx_create_backup
fsx_create_backup <- function(FileSystemId, ClientRequestToken = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateBackup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .fsx$create_backup_input(FileSystemId = FileSystemId, ClientRequestToken = ClientRequestToken, Tags = Tags)
  output <- .fsx$create_backup_output()
  config <- get_config()
  svc <- .fsx$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.fsx$operations$create_backup <- fsx_create_backup

#' Creates an Amazon FSx for Lustre data repository task
#'
#' Creates an Amazon FSx for Lustre data repository task. You use data
#' repository tasks to perform bulk operations between your Amazon FSx file
#' system and its linked data repository. An example of a data repository
#' task is exporting any data and metadata changes, including POSIX
#' metadata, to files, directories, and symbolic links (symlinks) from your
#' FSx file system to its linked data repository. A
#' `CreateDataRepositoryTask` operation will fail if a data repository is
#' not linked to the FSx file system. To learn more about data repository
#' tasks, see [Using Data Repository
#' Tasks](https://docs.aws.amazon.com/fsx/latest/LustreGuide/data-repository-tasks.html).
#' To learn more about linking a data repository to your file system, see
#' [Setting the Export
#' Prefix](https://docs.aws.amazon.com/fsx/latest/LustreGuide/export-data-repository.html#export-prefix).
#'
#' @usage
#' fsx_create_data_repository_task(Type, Paths, FileSystemId, Report,
#'   ClientRequestToken, Tags)
#'
#' @param Type &#91;required&#93; Specifies the type of data repository task to create.
#' @param Paths (Optional) The path or paths on the Amazon FSx file system to use when
#' the data repository task is processed. The default path is the file
#' system root directory. The paths you provide need to be relative to the
#' mount point of the file system. If the mount point is `/mnt/fsx` and
#' `/mnt/fsx/path1` is a directory or file on the file system you want to
#' export, then the path to provide is `path1`. If a path that you provide
#' isn\'t valid, the task fails.
#' @param FileSystemId &#91;required&#93; 
#' @param Report &#91;required&#93; Defines whether or not Amazon FSx provides a CompletionReport once the
#' task has completed. A CompletionReport provides a detailed report on the
#' files that Amazon FSx processed that meet the criteria specified by the
#' `Scope` parameter. For more information, see [Working with Task
#' Completion
#' Reports](https://docs.aws.amazon.com/fsx/latest/LustreGuide/task-completion-report.html).
#' @param ClientRequestToken 
#' @param Tags 
#'
#' @section Request syntax:
#' ```
#' svc$create_data_repository_task(
#'   Type = "EXPORT_TO_REPOSITORY",
#'   Paths = list(
#'     "string"
#'   ),
#'   FileSystemId = "string",
#'   Report = list(
#'     Enabled = TRUE|FALSE,
#'     Path = "string",
#'     Format = "REPORT_CSV_20191124",
#'     Scope = "FAILED_FILES_ONLY"
#'   ),
#'   ClientRequestToken = "string",
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname fsx_create_data_repository_task
fsx_create_data_repository_task <- function(Type, Paths = NULL, FileSystemId, Report, ClientRequestToken = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateDataRepositoryTask",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .fsx$create_data_repository_task_input(Type = Type, Paths = Paths, FileSystemId = FileSystemId, Report = Report, ClientRequestToken = ClientRequestToken, Tags = Tags)
  output <- .fsx$create_data_repository_task_output()
  config <- get_config()
  svc <- .fsx$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.fsx$operations$create_data_repository_task <- fsx_create_data_repository_task

#' Creates a new, empty Amazon FSx file system
#'
#' Creates a new, empty Amazon FSx file system.
#' 
#' If a file system with the specified client request token exists and the
#' parameters match, `CreateFileSystem` returns the description of the
#' existing file system. If a file system specified client request token
#' exists and the parameters don\'t match, this call returns
#' `IncompatibleParameterError`. If a file system with the specified client
#' request token doesn\'t exist, `CreateFileSystem` does the following:
#' 
#' -   Creates a new, empty Amazon FSx file system with an assigned ID, and
#'     an initial lifecycle state of `CREATING`.
#' 
#' -   Returns the description of the file system.
#' 
#' This operation requires a client request token in the request that
#' Amazon FSx uses to ensure idempotent creation. This means that calling
#' the operation multiple times with the same client request token has no
#' effect. By using the idempotent operation, you can retry a
#' `CreateFileSystem` operation without the risk of creating an extra file
#' system. This approach can be useful when an initial call fails in a way
#' that makes it unclear whether a file system was created. Examples are if
#' a transport level timeout occurred, or your connection was reset. If you
#' use the same client request token and the initial call created a file
#' system, the client receives success as long as the parameters are the
#' same.
#' 
#' The `CreateFileSystem` call returns while the file system\'s lifecycle
#' state is still `CREATING`. You can check the file-system creation status
#' by calling the DescribeFileSystems operation, which returns the file
#' system state along with other information.
#'
#' @usage
#' fsx_create_file_system(ClientRequestToken, FileSystemType,
#'   StorageCapacity, StorageType, SubnetIds, SecurityGroupIds, Tags,
#'   KmsKeyId, WindowsConfiguration, LustreConfiguration)
#'
#' @param ClientRequestToken A string of up to 64 ASCII characters that Amazon FSx uses to ensure
#' idempotent creation. This string is automatically filled on your behalf
#' when you use the AWS Command Line Interface (AWS CLI) or an AWS SDK.
#' @param FileSystemType &#91;required&#93; The type of Amazon FSx file system to create, either `WINDOWS` or
#' `LUSTRE`.
#' @param StorageCapacity &#91;required&#93; Sets the storage capacity of the file system that you\'re creating.
#' 
#' For Lustre file systems:
#' 
#' -   For `SCRATCH_2` and `PERSISTENT_1` deployment types, valid values
#'     are 1.2, 2.4, and increments of 2.4 TiB.
#' 
#' -   For `SCRATCH_1` deployment type, valid values are 1.2, 2.4, and
#'     increments of 3.6 TiB.
#' 
#' For Windows file systems:
#' 
#' -   If `StorageType=SSD`, valid values are 32 GiB - 65,536 GiB (64 TiB).
#' 
#' -   If `StorageType=HDD`, valid values are 2000 GiB - 65,536 GiB (64
#'     TiB).
#' @param StorageType Sets the storage type for the Amazon FSx for Windows file system you\'re
#' creating. Valid values are `SSD` and `HDD`.
#' 
#' -   Set to `SSD` to use solid state drive storage. SSD is supported on
#'     all Windows deployment types.
#' 
#' -   Set to `HDD` to use hard disk drive storage. HDD is supported on
#'     `SINGLE_AZ_2` and `MULTI_AZ_1` Windows file system deployment types.
#' 
#' Default value is `SSD`. For more information, see [Storage Type
#' Options](https://docs.aws.amazon.com/fsx/latest/WindowsGuide/optimize-fsx-costs.html#storage-type-options)
#' in the *Amazon FSx for Windows User Guide*.
#' @param SubnetIds &#91;required&#93; Specifies the IDs of the subnets that the file system will be accessible
#' from. For Windows `MULTI_AZ_1` file system deployment types, provide
#' exactly two subnet IDs, one for the preferred file server and one for
#' the standby file server. You specify one of these subnets as the
#' preferred subnet using the `WindowsConfiguration &gt; PreferredSubnetID`
#' property.
#' 
#' For Windows `SINGLE_AZ_1` and `SINGLE_AZ_2` file system deployment types
#' and Lustre file systems, provide exactly one subnet ID. The file server
#' is launched in that subnet\'s Availability Zone.
#' @param SecurityGroupIds A list of IDs specifying the security groups to apply to all network
#' interfaces created for file system access. This list isn\'t returned in
#' later requests to describe the file system.
#' @param Tags The tags to apply to the file system being created. The key value of the
#' `Name` tag appears in the console as the file system name.
#' @param KmsKeyId 
#' @param WindowsConfiguration The Microsoft Windows configuration for the file system being created.
#' @param LustreConfiguration 
#'
#' @section Request syntax:
#' ```
#' svc$create_file_system(
#'   ClientRequestToken = "string",
#'   FileSystemType = "WINDOWS"|"LUSTRE",
#'   StorageCapacity = 123,
#'   StorageType = "SSD"|"HDD",
#'   SubnetIds = list(
#'     "string"
#'   ),
#'   SecurityGroupIds = list(
#'     "string"
#'   ),
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   ),
#'   KmsKeyId = "string",
#'   WindowsConfiguration = list(
#'     ActiveDirectoryId = "string",
#'     SelfManagedActiveDirectoryConfiguration = list(
#'       DomainName = "string",
#'       OrganizationalUnitDistinguishedName = "string",
#'       FileSystemAdministratorsGroup = "string",
#'       UserName = "string",
#'       Password = "string",
#'       DnsIps = list(
#'         "string"
#'       )
#'     ),
#'     DeploymentType = "MULTI_AZ_1"|"SINGLE_AZ_1"|"SINGLE_AZ_2",
#'     PreferredSubnetId = "string",
#'     ThroughputCapacity = 123,
#'     WeeklyMaintenanceStartTime = "string",
#'     DailyAutomaticBackupStartTime = "string",
#'     AutomaticBackupRetentionDays = 123,
#'     CopyTagsToBackups = TRUE|FALSE
#'   ),
#'   LustreConfiguration = list(
#'     WeeklyMaintenanceStartTime = "string",
#'     ImportPath = "string",
#'     ExportPath = "string",
#'     ImportedFileChunkSize = 123,
#'     DeploymentType = "SCRATCH_1"|"SCRATCH_2"|"PERSISTENT_1",
#'     PerUnitStorageThroughput = 123,
#'     DailyAutomaticBackupStartTime = "string",
#'     AutomaticBackupRetentionDays = 123,
#'     CopyTagsToBackups = TRUE|FALSE
#'   )
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This operation creates a new file system.
#' svc$create_file_system(
#'   ClientRequestToken = "a8ca07e4-61ec-4399-99f4-19853801bcd5",
#'   FileSystemType = "WINDOWS",
#'   KmsKeyId = "arn:aws:kms:us-east-1:012345678912:key/0ff3ea8d-130e-4133-877f-93908b6fdbd6",
#'   SecurityGroupIds = list(
#'     "sg-edcd9784"
#'   ),
#'   StorageCapacity = 300L,
#'   SubnetIds = list(
#'     "subnet-1234abcd"
#'   ),
#'   Tags = list(
#'     list(
#'       Key = "Name",
#'       Value = "MyFileSystem"
#'     )
#'   ),
#'   WindowsConfiguration = list(
#'     ActiveDirectoryId = "d-1234abcd12",
#'     AutomaticBackupRetentionDays = 30L,
#'     DailyAutomaticBackupStartTime = "05:00",
#'     ThroughputCapacity = 8L,
#'     WeeklyMaintenanceStartTime = "1:05:00"
#'   )
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname fsx_create_file_system
fsx_create_file_system <- function(ClientRequestToken = NULL, FileSystemType, StorageCapacity, StorageType = NULL, SubnetIds, SecurityGroupIds = NULL, Tags = NULL, KmsKeyId = NULL, WindowsConfiguration = NULL, LustreConfiguration = NULL) {
  op <- new_operation(
    name = "CreateFileSystem",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .fsx$create_file_system_input(ClientRequestToken = ClientRequestToken, FileSystemType = FileSystemType, StorageCapacity = StorageCapacity, StorageType = StorageType, SubnetIds = SubnetIds, SecurityGroupIds = SecurityGroupIds, Tags = Tags, KmsKeyId = KmsKeyId, WindowsConfiguration = WindowsConfiguration, LustreConfiguration = LustreConfiguration)
  output <- .fsx$create_file_system_output()
  config <- get_config()
  svc <- .fsx$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.fsx$operations$create_file_system <- fsx_create_file_system

#' Creates a new Amazon FSx file system from an existing Amazon FSx backup
#'
#' Creates a new Amazon FSx file system from an existing Amazon FSx backup.
#' 
#' If a file system with the specified client request token exists and the
#' parameters match, this operation returns the description of the file
#' system. If a client request token specified by the file system exists
#' and the parameters don\'t match, this call returns
#' `IncompatibleParameterError`. If a file system with the specified client
#' request token doesn\'t exist, this operation does the following:
#' 
#' -   Creates a new Amazon FSx file system from backup with an assigned
#'     ID, and an initial lifecycle state of `CREATING`.
#' 
#' -   Returns the description of the file system.
#' 
#' Parameters like Active Directory, default share name, automatic backup,
#' and backup settings default to the parameters of the file system that
#' was backed up, unless overridden. You can explicitly supply other
#' settings.
#' 
#' By using the idempotent operation, you can retry a
#' `CreateFileSystemFromBackup` call without the risk of creating an extra
#' file system. This approach can be useful when an initial call fails in a
#' way that makes it unclear whether a file system was created. Examples
#' are if a transport level timeout occurred, or your connection was reset.
#' If you use the same client request token and the initial call created a
#' file system, the client receives success as long as the parameters are
#' the same.
#' 
#' The `CreateFileSystemFromBackup` call returns while the file system\'s
#' lifecycle state is still `CREATING`. You can check the file-system
#' creation status by calling the DescribeFileSystems operation, which
#' returns the file system state along with other information.
#'
#' @usage
#' fsx_create_file_system_from_backup(BackupId, ClientRequestToken,
#'   SubnetIds, SecurityGroupIds, Tags, WindowsConfiguration,
#'   LustreConfiguration, StorageType)
#'
#' @param BackupId &#91;required&#93; 
#' @param ClientRequestToken A string of up to 64 ASCII characters that Amazon FSx uses to ensure
#' idempotent creation. This string is automatically filled on your behalf
#' when you use the AWS Command Line Interface (AWS CLI) or an AWS SDK.
#' @param SubnetIds &#91;required&#93; Specifies the IDs of the subnets that the file system will be accessible
#' from. For Windows `MULTI_AZ_1` file system deployment types, provide
#' exactly two subnet IDs, one for the preferred file server and one for
#' the standby file server. You specify one of these subnets as the
#' preferred subnet using the `WindowsConfiguration &gt; PreferredSubnetID`
#' property.
#' 
#' For Windows `SINGLE_AZ_1` and `SINGLE_AZ_2` deployment types and Lustre
#' file systems, provide exactly one subnet ID. The file server is launched
#' in that subnet\'s Availability Zone.
#' @param SecurityGroupIds A list of IDs for the security groups that apply to the specified
#' network interfaces created for file system access. These security groups
#' apply to all network interfaces. This value isn\'t returned in later
#' DescribeFileSystem requests.
#' @param Tags The tags to be applied to the file system at file system creation. The
#' key value of the `Name` tag appears in the console as the file system
#' name.
#' @param WindowsConfiguration The configuration for this Microsoft Windows file system.
#' @param LustreConfiguration 
#' @param StorageType Sets the storage type for the Windows file system you\'re creating from
#' a backup. Valid values are `SSD` and `HDD`.
#' 
#' -   Set to `SSD` to use solid state drive storage. Supported on all
#'     Windows deployment types.
#' 
#' -   Set to `HDD` to use hard disk drive storage. Supported on
#'     `SINGLE_AZ_2` and `MULTI_AZ_1` Windows file system deployment types.
#' 
#' Default value is `SSD`.
#' 
#' HDD and SSD storage types have different minimum storage capacity
#' requirements. A restored file system\'s storage capacity is tied to the
#' file system that was backed up. You can create a file system that uses
#' HDD storage from a backup of a file system that used SSD storage only if
#' the original SSD file system had a storage capacity of at least 2000
#' GiB.
#'
#' @section Request syntax:
#' ```
#' svc$create_file_system_from_backup(
#'   BackupId = "string",
#'   ClientRequestToken = "string",
#'   SubnetIds = list(
#'     "string"
#'   ),
#'   SecurityGroupIds = list(
#'     "string"
#'   ),
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   ),
#'   WindowsConfiguration = list(
#'     ActiveDirectoryId = "string",
#'     SelfManagedActiveDirectoryConfiguration = list(
#'       DomainName = "string",
#'       OrganizationalUnitDistinguishedName = "string",
#'       FileSystemAdministratorsGroup = "string",
#'       UserName = "string",
#'       Password = "string",
#'       DnsIps = list(
#'         "string"
#'       )
#'     ),
#'     DeploymentType = "MULTI_AZ_1"|"SINGLE_AZ_1"|"SINGLE_AZ_2",
#'     PreferredSubnetId = "string",
#'     ThroughputCapacity = 123,
#'     WeeklyMaintenanceStartTime = "string",
#'     DailyAutomaticBackupStartTime = "string",
#'     AutomaticBackupRetentionDays = 123,
#'     CopyTagsToBackups = TRUE|FALSE
#'   ),
#'   LustreConfiguration = list(
#'     WeeklyMaintenanceStartTime = "string",
#'     ImportPath = "string",
#'     ExportPath = "string",
#'     ImportedFileChunkSize = 123,
#'     DeploymentType = "SCRATCH_1"|"SCRATCH_2"|"PERSISTENT_1",
#'     PerUnitStorageThroughput = 123,
#'     DailyAutomaticBackupStartTime = "string",
#'     AutomaticBackupRetentionDays = 123,
#'     CopyTagsToBackups = TRUE|FALSE
#'   ),
#'   StorageType = "SSD"|"HDD"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This operation creates a new file system from backup.
#' svc$create_file_system_from_backup(
#'   BackupId = "backup-03e3c82e0183b7b6b",
#'   ClientRequestToken = "f4c94ed7-238d-4c46-93db-48cd62ec33b7",
#'   SecurityGroupIds = list(
#'     "sg-edcd9784"
#'   ),
#'   SubnetIds = list(
#'     "subnet-1234abcd"
#'   ),
#'   Tags = list(
#'     list(
#'       Key = "Name",
#'       Value = "MyFileSystem"
#'     )
#'   ),
#'   WindowsConfiguration = list(
#'     ThroughputCapacity = 8L
#'   )
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname fsx_create_file_system_from_backup
fsx_create_file_system_from_backup <- function(BackupId, ClientRequestToken = NULL, SubnetIds, SecurityGroupIds = NULL, Tags = NULL, WindowsConfiguration = NULL, LustreConfiguration = NULL, StorageType = NULL) {
  op <- new_operation(
    name = "CreateFileSystemFromBackup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .fsx$create_file_system_from_backup_input(BackupId = BackupId, ClientRequestToken = ClientRequestToken, SubnetIds = SubnetIds, SecurityGroupIds = SecurityGroupIds, Tags = Tags, WindowsConfiguration = WindowsConfiguration, LustreConfiguration = LustreConfiguration, StorageType = StorageType)
  output <- .fsx$create_file_system_from_backup_output()
  config <- get_config()
  svc <- .fsx$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.fsx$operations$create_file_system_from_backup <- fsx_create_file_system_from_backup

#' Deletes an Amazon FSx backup, deleting its contents
#'
#' Deletes an Amazon FSx backup, deleting its contents. After deletion, the
#' backup no longer exists, and its data is gone.
#' 
#' The `DeleteBackup` call returns instantly. The backup will not show up
#' in later `DescribeBackups` calls.
#' 
#' The data in a deleted backup is also deleted and can\'t be recovered by
#' any means.
#'
#' @usage
#' fsx_delete_backup(BackupId, ClientRequestToken)
#'
#' @param BackupId &#91;required&#93; The ID of the backup you want to delete.
#' @param ClientRequestToken A string of up to 64 ASCII characters that Amazon FSx uses to ensure
#' idempotent deletion. This is automatically filled on your behalf when
#' using the AWS CLI or SDK.
#'
#' @section Request syntax:
#' ```
#' svc$delete_backup(
#'   BackupId = "string",
#'   ClientRequestToken = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This operation deletes an Amazon FSx file system backup.
#' svc$delete_backup(
#'   BackupId = "backup-03e3c82e0183b7b6b"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname fsx_delete_backup
fsx_delete_backup <- function(BackupId, ClientRequestToken = NULL) {
  op <- new_operation(
    name = "DeleteBackup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .fsx$delete_backup_input(BackupId = BackupId, ClientRequestToken = ClientRequestToken)
  output <- .fsx$delete_backup_output()
  config <- get_config()
  svc <- .fsx$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.fsx$operations$delete_backup <- fsx_delete_backup

#' Deletes a file system, deleting its contents
#'
#' Deletes a file system, deleting its contents. After deletion, the file
#' system no longer exists, and its data is gone. Any existing automatic
#' backups will also be deleted.
#' 
#' By default, when you delete an Amazon FSx for Windows File Server file
#' system, a final backup is created upon deletion. This final backup is
#' not subject to the file system\'s retention policy, and must be manually
#' deleted.
#' 
#' The `DeleteFileSystem` action returns while the file system has the
#' `DELETING` status. You can check the file system deletion status by
#' calling the DescribeFileSystems action, which returns a list of file
#' systems in your account. If you pass the file system ID for a deleted
#' file system, the DescribeFileSystems returns a `FileSystemNotFound`
#' error.
#' 
#' Deleting an Amazon FSx for Lustre file system will fail with a 400
#' BadRequest if a data repository task is in a `PENDING` or `EXECUTING`
#' state.
#' 
#' The data in a deleted file system is also deleted and can\'t be
#' recovered by any means.
#'
#' @usage
#' fsx_delete_file_system(FileSystemId, ClientRequestToken,
#'   WindowsConfiguration, LustreConfiguration)
#'
#' @param FileSystemId &#91;required&#93; The ID of the file system you want to delete.
#' @param ClientRequestToken A string of up to 64 ASCII characters that Amazon FSx uses to ensure
#' idempotent deletion. This is automatically filled on your behalf when
#' using the AWS CLI or SDK.
#' @param WindowsConfiguration 
#' @param LustreConfiguration 
#'
#' @section Request syntax:
#' ```
#' svc$delete_file_system(
#'   FileSystemId = "string",
#'   ClientRequestToken = "string",
#'   WindowsConfiguration = list(
#'     SkipFinalBackup = TRUE|FALSE,
#'     FinalBackupTags = list(
#'       list(
#'         Key = "string",
#'         Value = "string"
#'       )
#'     )
#'   ),
#'   LustreConfiguration = list(
#'     SkipFinalBackup = TRUE|FALSE,
#'     FinalBackupTags = list(
#'       list(
#'         Key = "string",
#'         Value = "string"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This operation deletes an Amazon FSx file system.
#' svc$delete_file_system(
#'   FileSystemId = "fs-0498eed5fe91001ec"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname fsx_delete_file_system
fsx_delete_file_system <- function(FileSystemId, ClientRequestToken = NULL, WindowsConfiguration = NULL, LustreConfiguration = NULL) {
  op <- new_operation(
    name = "DeleteFileSystem",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .fsx$delete_file_system_input(FileSystemId = FileSystemId, ClientRequestToken = ClientRequestToken, WindowsConfiguration = WindowsConfiguration, LustreConfiguration = LustreConfiguration)
  output <- .fsx$delete_file_system_output()
  config <- get_config()
  svc <- .fsx$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.fsx$operations$delete_file_system <- fsx_delete_file_system

#' Returns the description of specific Amazon FSx backups, if a BackupIds
#' value is provided for that backup
#'
#' Returns the description of specific Amazon FSx backups, if a `BackupIds`
#' value is provided for that backup. Otherwise, it returns all backups
#' owned by your AWS account in the AWS Region of the endpoint that you\'re
#' calling.
#' 
#' When retrieving all backups, you can optionally specify the `MaxResults`
#' parameter to limit the number of backups in a response. If more backups
#' remain, Amazon FSx returns a `NextToken` value in the response. In this
#' case, send a later request with the `NextToken` request parameter set to
#' the value of `NextToken` from the last response.
#' 
#' This action is used in an iterative process to retrieve a list of your
#' backups. `DescribeBackups` is called first without a `NextToken`value.
#' Then the action continues to be called with the `NextToken` parameter
#' set to the value of the last `NextToken` value until a response has no
#' `NextToken`.
#' 
#' When using this action, keep the following in mind:
#' 
#' -   The implementation might return fewer than `MaxResults` file system
#'     descriptions while still including a `NextToken` value.
#' 
#' -   The order of backups returned in the response of one
#'     `DescribeBackups` call and the order of backups returned across the
#'     responses of a multi-call iteration is unspecified.
#'
#' @usage
#' fsx_describe_backups(BackupIds, Filters, MaxResults, NextToken)
#'
#' @param BackupIds IDs of the backups you want to retrieve (String). This overrides any
#' filters. If any IDs are not found, BackupNotFound will be thrown.
#' @param Filters Filters structure. Supported names are file-system-id and backup-type.
#' @param MaxResults Maximum number of backups to return in the response (integer). This
#' parameter value must be greater than 0. The number of items that Amazon
#' FSx returns is the minimum of the `MaxResults` parameter specified in
#' the request and the service\'s internal maximum number of items per
#' page.
#' @param NextToken Opaque pagination token returned from a previous `DescribeBackups`
#' operation (String). If a token present, the action continues the list
#' from where the returning call left off.
#'
#' @section Request syntax:
#' ```
#' svc$describe_backups(
#'   BackupIds = list(
#'     "string"
#'   ),
#'   Filters = list(
#'     list(
#'       Name = "file-system-id"|"backup-type"|"file-system-type",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This operation describes all of the Amazon FSx backups in an account.
#' svc$describe_backups()
#' }
#'
#' @keywords internal
#'
#' @rdname fsx_describe_backups
fsx_describe_backups <- function(BackupIds = NULL, Filters = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeBackups",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .fsx$describe_backups_input(BackupIds = BackupIds, Filters = Filters, MaxResults = MaxResults, NextToken = NextToken)
  output <- .fsx$describe_backups_output()
  config <- get_config()
  svc <- .fsx$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.fsx$operations$describe_backups <- fsx_describe_backups

#' Returns the description of specific Amazon FSx for Lustre data
#' repository tasks, if one or more TaskIds values are provided in the
#' request, or if filters are used in the request
#'
#' Returns the description of specific Amazon FSx for Lustre data
#' repository tasks, if one or more `TaskIds` values are provided in the
#' request, or if filters are used in the request. You can use filters to
#' narrow the response to include just tasks for specific file systems, or
#' tasks in a specific lifecycle state. Otherwise, it returns all data
#' repository tasks owned by your AWS account in the AWS Region of the
#' endpoint that you\'re calling.
#' 
#' When retrieving all tasks, you can paginate the response by using the
#' optional `MaxResults` parameter to limit the number of tasks returned in
#' a response. If more tasks remain, Amazon FSx returns a `NextToken` value
#' in the response. In this case, send a later request with the `NextToken`
#' request parameter set to the value of `NextToken` from the last
#' response.
#'
#' @usage
#' fsx_describe_data_repository_tasks(TaskIds, Filters, MaxResults,
#'   NextToken)
#'
#' @param TaskIds (Optional) IDs of the tasks whose descriptions you want to retrieve
#' (String).
#' @param Filters (Optional) You can use filters to narrow the
#' `DescribeDataRepositoryTasks` response to include just tasks for
#' specific file systems, or tasks in a specific lifecycle state.
#' @param MaxResults 
#' @param NextToken 
#'
#' @section Request syntax:
#' ```
#' svc$describe_data_repository_tasks(
#'   TaskIds = list(
#'     "string"
#'   ),
#'   Filters = list(
#'     list(
#'       Name = "file-system-id"|"task-lifecycle",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname fsx_describe_data_repository_tasks
fsx_describe_data_repository_tasks <- function(TaskIds = NULL, Filters = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeDataRepositoryTasks",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .fsx$describe_data_repository_tasks_input(TaskIds = TaskIds, Filters = Filters, MaxResults = MaxResults, NextToken = NextToken)
  output <- .fsx$describe_data_repository_tasks_output()
  config <- get_config()
  svc <- .fsx$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.fsx$operations$describe_data_repository_tasks <- fsx_describe_data_repository_tasks

#' Returns the description of specific Amazon FSx file systems, if a
#' FileSystemIds value is provided for that file system
#'
#' Returns the description of specific Amazon FSx file systems, if a
#' `FileSystemIds` value is provided for that file system. Otherwise, it
#' returns descriptions of all file systems owned by your AWS account in
#' the AWS Region of the endpoint that you\'re calling.
#' 
#' When retrieving all file system descriptions, you can optionally specify
#' the `MaxResults` parameter to limit the number of descriptions in a
#' response. If more file system descriptions remain, Amazon FSx returns a
#' `NextToken` value in the response. In this case, send a later request
#' with the `NextToken` request parameter set to the value of `NextToken`
#' from the last response.
#' 
#' This action is used in an iterative process to retrieve a list of your
#' file system descriptions. `DescribeFileSystems` is called first without
#' a `NextToken`value. Then the action continues to be called with the
#' `NextToken` parameter set to the value of the last `NextToken` value
#' until a response has no `NextToken`.
#' 
#' When using this action, keep the following in mind:
#' 
#' -   The implementation might return fewer than `MaxResults` file system
#'     descriptions while still including a `NextToken` value.
#' 
#' -   The order of file systems returned in the response of one
#'     `DescribeFileSystems` call and the order of file systems returned
#'     across the responses of a multicall iteration is unspecified.
#'
#' @usage
#' fsx_describe_file_systems(FileSystemIds, MaxResults, NextToken)
#'
#' @param FileSystemIds IDs of the file systems whose descriptions you want to retrieve
#' (String).
#' @param MaxResults Maximum number of file systems to return in the response (integer). This
#' parameter value must be greater than 0. The number of items that Amazon
#' FSx returns is the minimum of the `MaxResults` parameter specified in
#' the request and the service\'s internal maximum number of items per
#' page.
#' @param NextToken Opaque pagination token returned from a previous `DescribeFileSystems`
#' operation (String). If a token present, the action continues the list
#' from where the returning call left off.
#'
#' @section Request syntax:
#' ```
#' svc$describe_file_systems(
#'   FileSystemIds = list(
#'     "string"
#'   ),
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This operation describes all of the Amazon FSx file systems in an
#' # account.
#' svc$describe_file_systems()
#' }
#'
#' @keywords internal
#'
#' @rdname fsx_describe_file_systems
fsx_describe_file_systems <- function(FileSystemIds = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeFileSystems",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .fsx$describe_file_systems_input(FileSystemIds = FileSystemIds, MaxResults = MaxResults, NextToken = NextToken)
  output <- .fsx$describe_file_systems_output()
  config <- get_config()
  svc <- .fsx$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.fsx$operations$describe_file_systems <- fsx_describe_file_systems

#' Lists tags for an Amazon FSx file systems and backups in the case of
#' Amazon FSx for Windows File Server
#'
#' Lists tags for an Amazon FSx file systems and backups in the case of
#' Amazon FSx for Windows File Server.
#' 
#' When retrieving all tags, you can optionally specify the `MaxResults`
#' parameter to limit the number of tags in a response. If more tags
#' remain, Amazon FSx returns a `NextToken` value in the response. In this
#' case, send a later request with the `NextToken` request parameter set to
#' the value of `NextToken` from the last response.
#' 
#' This action is used in an iterative process to retrieve a list of your
#' tags. `ListTagsForResource` is called first without a `NextToken`value.
#' Then the action continues to be called with the `NextToken` parameter
#' set to the value of the last `NextToken` value until a response has no
#' `NextToken`.
#' 
#' When using this action, keep the following in mind:
#' 
#' -   The implementation might return fewer than `MaxResults` file system
#'     descriptions while still including a `NextToken` value.
#' 
#' -   The order of tags returned in the response of one
#'     `ListTagsForResource` call and the order of tags returned across the
#'     responses of a multi-call iteration is unspecified.
#'
#' @usage
#' fsx_list_tags_for_resource(ResourceARN, MaxResults, NextToken)
#'
#' @param ResourceARN &#91;required&#93; The ARN of the Amazon FSx resource that will have its tags listed.
#' @param MaxResults Maximum number of tags to return in the response (integer). This
#' parameter value must be greater than 0. The number of items that Amazon
#' FSx returns is the minimum of the `MaxResults` parameter specified in
#' the request and the service\'s internal maximum number of items per
#' page.
#' @param NextToken Opaque pagination token returned from a previous `ListTagsForResource`
#' operation (String). If a token present, the action continues the list
#' from where the returning call left off.
#'
#' @section Request syntax:
#' ```
#' svc$list_tags_for_resource(
#'   ResourceARN = "string",
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This operation lists tags for an Amazon FSx resource.
#' svc$list_tags_for_resource(
#'   ResourceARN = "arn:aws:fsx:us-east-1:012345678912:file-system/fs-0498eed5fe91001ec"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname fsx_list_tags_for_resource
fsx_list_tags_for_resource <- function(ResourceARN, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .fsx$list_tags_for_resource_input(ResourceARN = ResourceARN, MaxResults = MaxResults, NextToken = NextToken)
  output <- .fsx$list_tags_for_resource_output()
  config <- get_config()
  svc <- .fsx$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.fsx$operations$list_tags_for_resource <- fsx_list_tags_for_resource

#' Tags an Amazon FSx resource
#'
#' Tags an Amazon FSx resource.
#'
#' @usage
#' fsx_tag_resource(ResourceARN, Tags)
#'
#' @param ResourceARN &#91;required&#93; The Amazon Resource Name (ARN) of the Amazon FSx resource that you want
#' to tag.
#' @param Tags &#91;required&#93; A list of tags for the resource. If a tag with a given key already
#' exists, the value is replaced by the one specified in this parameter.
#'
#' @section Request syntax:
#' ```
#' svc$tag_resource(
#'   ResourceARN = "string",
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This operation tags an Amazon FSx resource.
#' svc$tag_resource(
#'   ResourceARN = "arn:aws:fsx:us-east-1:012345678912:file-system/fs-0498eed5fe91001ec",
#'   Tags = list(
#'     list(
#'       Key = "Name",
#'       Value = "MyFileSystem"
#'     )
#'   )
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname fsx_tag_resource
fsx_tag_resource <- function(ResourceARN, Tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .fsx$tag_resource_input(ResourceARN = ResourceARN, Tags = Tags)
  output <- .fsx$tag_resource_output()
  config <- get_config()
  svc <- .fsx$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.fsx$operations$tag_resource <- fsx_tag_resource

#' This action removes a tag from an Amazon FSx resource
#'
#' This action removes a tag from an Amazon FSx resource.
#'
#' @usage
#' fsx_untag_resource(ResourceARN, TagKeys)
#'
#' @param ResourceARN &#91;required&#93; The ARN of the Amazon FSx resource to untag.
#' @param TagKeys &#91;required&#93; A list of keys of tags on the resource to untag. In case the tag key
#' doesn\'t exist, the call will still succeed to be idempotent.
#'
#' @section Request syntax:
#' ```
#' svc$untag_resource(
#'   ResourceARN = "string",
#'   TagKeys = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This operation untags an Amazon FSx resource.
#' svc$untag_resource(
#'   ResourceARN = "arn:aws:fsx:us-east-1:012345678912:file-system/fs-0498eed5fe91001ec",
#'   TagKeys = list(
#'     "Name"
#'   )
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname fsx_untag_resource
fsx_untag_resource <- function(ResourceARN, TagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .fsx$untag_resource_input(ResourceARN = ResourceARN, TagKeys = TagKeys)
  output <- .fsx$untag_resource_output()
  config <- get_config()
  svc <- .fsx$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.fsx$operations$untag_resource <- fsx_untag_resource

#' Use this operation to update the configuration of an existing Amazon FSx
#' file system
#'
#' Use this operation to update the configuration of an existing Amazon FSx
#' file system. For an Amazon FSx for Lustre file system, you can update
#' only the WeeklyMaintenanceStartTime. For an Amazon for Windows File
#' Server file system, you can update the following properties:
#' 
#' -   AutomaticBackupRetentionDays
#' 
#' -   DailyAutomaticBackupStartTime
#' 
#' -   SelfManagedActiveDirectoryConfiguration
#' 
#' -   StorageCapacity
#' 
#' -   ThroughputCapacity
#' 
#' -   WeeklyMaintenanceStartTime
#' 
#' You can update multiple properties in a single request.
#'
#' @usage
#' fsx_update_file_system(FileSystemId, ClientRequestToken,
#'   StorageCapacity, WindowsConfiguration, LustreConfiguration)
#'
#' @param FileSystemId &#91;required&#93; Identifies the file system that you are updating.
#' @param ClientRequestToken A string of up to 64 ASCII characters that Amazon FSx uses to ensure
#' idempotent updates. This string is automatically filled on your behalf
#' when you use the AWS Command Line Interface (AWS CLI) or an AWS SDK.
#' @param StorageCapacity Use this parameter to increase the storage capacity of an Amazon FSx for
#' Windows File Server file system. Specifies the storage capacity target
#' value, GiB, for the file system you\'re updating. The storage capacity
#' target value must be at least 10 percent (%) greater than the current
#' storage capacity value. In order to increase storage capacity, the file
#' system needs to have at least 16 MB/s of throughput capacity. You cannot
#' make a storage capacity increase request if there is an existing storage
#' capacity increase request in progress. For more information, see
#' [Managing Storage
#' Capacity](https://docs.aws.amazon.com/fsx/latest/WindowsGuide/managing-storage-capacity.html).
#' @param WindowsConfiguration The configuration updates for an Amazon FSx for Windows File Server file
#' system.
#' @param LustreConfiguration 
#'
#' @section Request syntax:
#' ```
#' svc$update_file_system(
#'   FileSystemId = "string",
#'   ClientRequestToken = "string",
#'   StorageCapacity = 123,
#'   WindowsConfiguration = list(
#'     WeeklyMaintenanceStartTime = "string",
#'     DailyAutomaticBackupStartTime = "string",
#'     AutomaticBackupRetentionDays = 123,
#'     ThroughputCapacity = 123,
#'     SelfManagedActiveDirectoryConfiguration = list(
#'       UserName = "string",
#'       Password = "string",
#'       DnsIps = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   LustreConfiguration = list(
#'     WeeklyMaintenanceStartTime = "string",
#'     DailyAutomaticBackupStartTime = "string",
#'     AutomaticBackupRetentionDays = 123
#'   )
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # This operation updates an existing file system.
#' svc$update_file_system(
#'   FileSystemId = "fs-0498eed5fe91001ec",
#'   WindowsConfiguration = list(
#'     AutomaticBackupRetentionDays = 10L,
#'     DailyAutomaticBackupStartTime = "06:00",
#'     WeeklyMaintenanceStartTime = "3:06:00"
#'   )
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname fsx_update_file_system
fsx_update_file_system <- function(FileSystemId, ClientRequestToken = NULL, StorageCapacity = NULL, WindowsConfiguration = NULL, LustreConfiguration = NULL) {
  op <- new_operation(
    name = "UpdateFileSystem",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .fsx$update_file_system_input(FileSystemId = FileSystemId, ClientRequestToken = ClientRequestToken, StorageCapacity = StorageCapacity, WindowsConfiguration = WindowsConfiguration, LustreConfiguration = LustreConfiguration)
  output <- .fsx$update_file_system_output()
  config <- get_config()
  svc <- .fsx$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.fsx$operations$update_file_system <- fsx_update_file_system
