% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/storagegateway_operations.R
\name{storagegateway_describe_storedi_scsi_volumes}
\alias{storagegateway_describe_storedi_scsi_volumes}
\title{Returns the description of the gateway volumes specified in the request}
\usage{
storagegateway_describe_storedi_scsi_volumes(VolumeARNs)
}
\arguments{
\item{VolumeARNs}{[required] An array of strings where each string represents the Amazon Resource
Name (ARN) of a stored volume. All of the specified stored volumes must
from the same gateway. Use ListVolumes to get volume ARNs for a gateway.}
}
\description{
Returns the description of the gateway volumes specified in the request.
The list of gateway volumes in the request must be from one gateway. In
the response Amazon Storage Gateway returns volume information sorted by
volume ARNs. This operation is only supported in stored volume gateway
type.
}
\section{Request syntax}{
\preformatted{svc$describe_storedi_scsi_volumes(
  VolumeARNs = list(
    "string"
  )
)
}
}

\examples{
\dontrun{
# Returns the description of the gateway volumes specified in the request
# belonging to the same gateway.
svc$describe_storedi_scsi_volumes(
  VolumeARNs = list(
    "arn:aws:storagegateway:us-east-1:111122223333:gateway/sgw-12A3456B/volume/vol-1122AABB"
  )
)
}

}
\keyword{internal}
