% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3control_operations.R
\name{s3control_put_access_point_policy}
\alias{s3control_put_access_point_policy}
\title{Associates an access policy with the specified access point}
\usage{
s3control_put_access_point_policy(AccountId, Name, Policy)
}
\arguments{
\item{AccountId}{[required] The AWS account ID for owner of the bucket associated with the specified
access point.}

\item{Name}{[required] The name of the access point that you want to associate with the
specified policy.}

\item{Policy}{[required] The policy that you want to apply to the specified access point. For
more information about access point policies, see \href{https://docs.aws.amazon.com/AmazonS3/latest/dev/access-points.html}{Managing Data Access with Amazon S3 Access Points}
in the \emph{Amazon Simple Storage Service Developer Guide}.}
}
\description{
Associates an access policy with the specified access point. Each access
point can have only one policy, so a request made to this API replaces
any existing policy associated with the specified access point.
}
\section{Request syntax}{
\preformatted{svc$put_access_point_policy(
  AccountId = "string",
  Name = "string",
  Policy = "string"
)
}
}

\keyword{internal}
