% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_operations.R
\name{s3_delete_bucket_cors}
\alias{s3_delete_bucket_cors}
\title{Deletes the cors configuration information set for the bucket}
\usage{
s3_delete_bucket_cors(Bucket)
}
\arguments{
\item{Bucket}{[required] Specifies the bucket whose \code{cors} configuration is being deleted.}
}
\description{
Deletes the \code{cors} configuration information set for the bucket.
}
\details{
To use this operation, you must have permission to perform the
\code{s3:PutBucketCORS} action. The bucket owner has this permission by
default and can grant this permission to others.

For information about \code{cors}, see \href{https://docs.aws.amazon.com/AmazonS3/latest/dev/cors.html}{Enabling Cross-Origin Resource Sharing} in
the \emph{Amazon Simple Storage Service Developer Guide}.

\strong{Related Resources:}
\itemize{
\item 
\itemize{
\item RESTOPTIONSobject
}
}
}
\section{Request syntax}{
\preformatted{svc$delete_bucket_cors(
  Bucket = "string"
)
}
}

\examples{
\dontrun{
# The following example deletes CORS configuration on a bucket.
svc$delete_bucket_cors(
  Bucket = "examplebucket"
)
}

}
\keyword{internal}
