% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/backup_operations.R
\name{backup_put_backup_vault_notifications}
\alias{backup_put_backup_vault_notifications}
\title{Turns on notifications on a backup vault for the specified topic and
events}
\usage{
backup_put_backup_vault_notifications(BackupVaultName, SNSTopicArn,
  BackupVaultEvents)
}
\arguments{
\item{BackupVaultName}{[required] The name of a logical container where backups are stored. Backup vaults
are identified by names that are unique to the account used to create
them and the AWS Region where they are created. They consist of
lowercase letters, numbers, and hyphens.}

\item{SNSTopicArn}{[required] The Amazon Resource Name (ARN) that specifies the topic for a backup
vault's events; for example,
\code{arn:aws:sns:us-west-2:111122223333:MyVaultTopic}.}

\item{BackupVaultEvents}{[required] An array of events that indicate the status of jobs to back up resources
to the backup vault.}
}
\description{
Turns on notifications on a backup vault for the specified topic and
events.
}
\section{Request syntax}{
\preformatted{svc$put_backup_vault_notifications(
  BackupVaultName = "string",
  SNSTopicArn = "string",
  BackupVaultEvents = list(
    "BACKUP_JOB_STARTED"|"BACKUP_JOB_COMPLETED"|"RESTORE_JOB_STARTED"|"RESTORE_JOB_COMPLETED"|"RECOVERY_POINT_MODIFIED"|"BACKUP_PLAN_CREATED"|"BACKUP_PLAN_MODIFIED"
  )
)
}
}

\keyword{internal}
