% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/storagegateway_operations.R
\name{storagegateway_start_gateway}
\alias{storagegateway_start_gateway}
\title{Starts a gateway that you previously shut down (see ShutdownGateway)}
\usage{
storagegateway_start_gateway(GatewayARN)
}
\arguments{
\item{GatewayARN}{[required]}
}
\description{
Starts a gateway that you previously shut down (see ShutdownGateway).
After the gateway starts, you can then make other API calls, your
applications can read from or write to the gateway\'s storage volumes
and you will be able to take snapshot backups.
}
\details{
When you make a request, you will get a 200 OK success response
immediately. However, it might take some time for the gateway to be
ready. You should call DescribeGatewayInformation and check the status
before making any additional API calls. For more information, see
ActivateGateway.

To specify which gateway to start, use the Amazon Resource Name (ARN) of
the gateway in your request.
}
\section{Request syntax}{
\preformatted{svc$start_gateway(
  GatewayARN = "string"
)
}
}

\examples{
# Starts a gateway service that was previously shut down.
\dontrun{svc$start_gateway(
  GatewayARN = "arn:aws:storagegateway:us-east-1:999999999999:gateway/sgw-12A3456B"
)}

}
\keyword{internal}
