% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/backup_operations.R
\name{backup_create_backup_selection}
\alias{backup_create_backup_selection}
\title{Creates a JSON document that specifies a set of resources to assign to a
backup plan}
\usage{
backup_create_backup_selection(BackupPlanId, BackupSelection,
  CreatorRequestId)
}
\arguments{
\item{BackupPlanId}{[required] Uniquely identifies the backup plan to be associated with the selection
of resources.}

\item{BackupSelection}{[required] Specifies the body of a request to assign a set of resources to a backup
plan.

It includes an array of resources, an optional array of patterns to
exclude resources, an optional role to provide access to the AWS service
the resource belongs to, and an optional array of tags used to identify
a set of resources.}

\item{CreatorRequestId}{A unique string that identifies the request and allows failed requests
to be retried without the risk of executing the operation twice.}
}
\description{
Creates a JSON document that specifies a set of resources to assign to a
backup plan. Resources can be included by specifying patterns for a
\code{ListOfTags} and selected \code{Resources}.
}
\details{
For example, consider the following patterns:
\itemize{
\item \code{Resources: "arn:aws:ec2:region:account-id:volume/volume-id"}
\item \code{ConditionKey:"department"}
}

\code{ConditionValue:"finance"}

\code{ConditionType:"StringEquals"}
\itemize{
\item \code{ConditionKey:"importance"}
}

\code{ConditionValue:"critical"}

\code{ConditionType:"StringEquals"}

Using these patterns would back up all Amazon Elastic Block Store
(Amazon EBS) volumes that are tagged as \code{"department=finance"},
\code{"importance=critical"}, in addition to an EBS volume with the specified
volume Id.

Resources and conditions are additive in that all resources that match
the pattern are selected. This shouldn't be confused with a logical
AND, where all conditions must match. The matching patterns are
logically 'put together using the OR operator. In other words, all
patterns that match are selected for backup.
}
\section{Request syntax}{
\preformatted{svc$create_backup_selection(
  BackupPlanId = "string",
  BackupSelection = list(
    SelectionName = "string",
    IamRoleArn = "string",
    Resources = list(
      "string"
    ),
    ListOfTags = list(
      list(
        ConditionType = "STRINGEQUALS",
        ConditionKey = "string",
        ConditionValue = "string"
      )
    )
  ),
  CreatorRequestId = "string"
)
}
}

\keyword{internal}
