% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/storagegateway_operations.R
\name{storagegateway_describe_chap_credentials}
\alias{storagegateway_describe_chap_credentials}
\title{Returns an array of Challenge-Handshake Authentication Protocol (CHAP)
credentials information for a specified iSCSI target, one for each
target-initiator pair}
\usage{
storagegateway_describe_chap_credentials(TargetARN)
}
\arguments{
\item{TargetARN}{[required] The Amazon Resource Name (ARN) of the iSCSI volume target. Use the
DescribeStorediSCSIVolumes operation to return to retrieve the TargetARN
for specified VolumeARN.}
}
\description{
Returns an array of Challenge-Handshake Authentication Protocol (CHAP)
credentials information for a specified iSCSI target, one for each
target-initiator pair.
}
\section{Request syntax}{
\preformatted{svc$describe_chap_credentials(
  TargetARN = "string"
)
}
}

\examples{
# Returns an array of Challenge-Handshake Authentication Protocol (CHAP)
# credentials information for a specified iSCSI target, one for each
# target-initiator pair.
\donttest{svc$describe_chap_credentials(
  TargetARN = "arn:aws:storagegateway:us-east-1:111122223333:gateway/sgw-12A3456B/target/iqn..."
)}

}
\keyword{internal}
