% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_operations.R
\name{s3_put_object}
\alias{s3_put_object}
\title{Adds an object to a bucket}
\usage{
s3_put_object(ACL, Body, Bucket, CacheControl, ContentDisposition,
  ContentEncoding, ContentLanguage, ContentLength, ContentMD5,
  ContentType, Expires, GrantFullControl, GrantRead, GrantReadACP,
  GrantWriteACP, Key, Metadata, ServerSideEncryption, StorageClass,
  WebsiteRedirectLocation, SSECustomerAlgorithm, SSECustomerKey,
  SSECustomerKeyMD5, SSEKMSKeyId, SSEKMSEncryptionContext, RequestPayer,
  Tagging, ObjectLockMode, ObjectLockRetainUntilDate,
  ObjectLockLegalHoldStatus)
}
\arguments{
\item{ACL}{The canned ACL to apply to the object.}

\item{Body}{Object data.}

\item{Bucket}{[required] Name of the bucket to which the PUT operation was initiated.}

\item{CacheControl}{Specifies caching behavior along the request/reply chain.}

\item{ContentDisposition}{Specifies presentational information for the object.}

\item{ContentEncoding}{Specifies what content encodings have been applied to the object and
thus what decoding mechanisms must be applied to obtain the media-type
referenced by the Content-Type header field.}

\item{ContentLanguage}{The language the content is in.}

\item{ContentLength}{Size of the body in bytes. This parameter is useful when the size of the
body cannot be determined automatically.}

\item{ContentMD5}{The base64-encoded 128-bit MD5 digest of the part data. This parameter
is auto-populated when using the command from the CLI. This parameted is
required if object lock parameters are specified.}

\item{ContentType}{A standard MIME type describing the format of the object data.}

\item{Expires}{The date and time at which the object is no longer cacheable.}

\item{GrantFullControl}{Gives the grantee READ, READ\_ACP, and WRITE\_ACP permissions on the
object.}

\item{GrantRead}{Allows grantee to read the object data and its metadata.}

\item{GrantReadACP}{Allows grantee to read the object ACL.}

\item{GrantWriteACP}{Allows grantee to write the ACL for the applicable object.}

\item{Key}{[required] Object key for which the PUT operation was initiated.}

\item{Metadata}{A map of metadata to store with the object in S3.}

\item{ServerSideEncryption}{The Server-side encryption algorithm used when storing this object in S3
(e.g., AES256, aws:kms).}

\item{StorageClass}{The type of storage to use for the object. Defaults to 'STANDARD'.}

\item{WebsiteRedirectLocation}{If the bucket is configured as a website, redirects requests for this
object to another object in the same bucket or to an external URL.
Amazon S3 stores the value of this header in the object metadata.}

\item{SSECustomerAlgorithm}{Specifies the algorithm to use to when encrypting the object (e.g.,
AES256).}

\item{SSECustomerKey}{Specifies the customer-provided encryption key for Amazon S3 to use in
encrypting data. This value is used to store the object and then it is
discarded; Amazon does not store the encryption key. The key must be
appropriate for use with the algorithm specified in the
x-amz-server-sideâ€‹-encryptionâ€‹-customer-algorithm header.}

\item{SSECustomerKeyMD5}{Specifies the 128-bit MD5 digest of the encryption key according to RFC
1321. Amazon S3 uses this header for a message integrity check to ensure
the encryption key was transmitted without error.}

\item{SSEKMSKeyId}{Specifies the AWS KMS key ID to use for object encryption. All GET and
PUT requests for an object protected by AWS KMS will fail if not made
via SSL or using SigV4. Documentation on configuring any of the
officially supported AWS SDKs and CLI can be found at
http://docs.aws.amazon.com/AmazonS3/latest/dev/UsingAWSSDK.html\#specify-signature-version}

\item{SSEKMSEncryptionContext}{Specifies the AWS KMS Encryption Context to use for object encryption.
The value of this header is a base64-encoded UTF-8 string holding JSON
with the encryption context key-value pairs.}

\item{RequestPayer}{}

\item{Tagging}{The tag-set for the object. The tag-set must be encoded as URL Query
parameters. (For example, "Key1=Value1")}

\item{ObjectLockMode}{The object lock mode that you want to apply to this object.}

\item{ObjectLockRetainUntilDate}{The date and time when you want this object's object lock to expire.}

\item{ObjectLockLegalHoldStatus}{The Legal Hold status that you want to apply to the specified object.}
}
\description{
Adds an object to a bucket.
}
\section{Request syntax}{
\preformatted{svc$put_object(
  ACL = "private"|"public-read"|"public-read-write"|"authenticated-read"|"aws-exec-read"|"bucket-owner-read"|"bucket-owner-full-control",
  Body = raw,
  Bucket = "string",
  CacheControl = "string",
  ContentDisposition = "string",
  ContentEncoding = "string",
  ContentLanguage = "string",
  ContentLength = 123,
  ContentMD5 = "string",
  ContentType = "string",
  Expires = as.POSIXct(
    "2015-01-01"
  ),
  GrantFullControl = "string",
  GrantRead = "string",
  GrantReadACP = "string",
  GrantWriteACP = "string",
  Key = "string",
  Metadata = list(
    "string"
  ),
  ServerSideEncryption = "AES256"|"aws:kms",
  StorageClass = "STANDARD"|"REDUCED_REDUNDANCY"|"STANDARD_IA"|"ONEZONE_IA"|"INTELLIGENT_TIERING"|"GLACIER"|"DEEP_ARCHIVE",
  WebsiteRedirectLocation = "string",
  SSECustomerAlgorithm = "string",
  SSECustomerKey = raw,
  SSECustomerKeyMD5 = "string",
  SSEKMSKeyId = "string",
  SSEKMSEncryptionContext = "string",
  RequestPayer = "requester",
  Tagging = "string",
  ObjectLockMode = "GOVERNANCE"|"COMPLIANCE",
  ObjectLockRetainUntilDate = as.POSIXct(
    "2015-01-01"
  ),
  ObjectLockLegalHoldStatus = "ON"|"OFF"
)
}
}

\examples{
# The following example uploads and object. The request specifies optional
# canned ACL (access control list) to all READ access to authenticated
# users. If the bucket is versioning enabled, S3 returns version ID in
# response.
\donttest{svc$put_object(
  ACL = "authenticated-read",
  Body = "filetoupload",
  Bucket = "examplebucket",
  Key = "exampleobject"
)}

# The following example uploads an object. The request specifies optional
# object tags. The bucket is versioned, therefore S3 returns version ID of
# the newly created object.
\donttest{svc$put_object(
  Body = "c:\\\\HappyFace.jpg",
  Bucket = "examplebucket",
  Key = "HappyFace.jpg",
  Tagging = "key1=value1&key2=value2"
)}

# The following example creates an object. The request also specifies
# optional metadata. If the bucket is versioning enabled, S3 returns
# version ID in response.
\donttest{svc$put_object(
  Body = "filetoupload",
  Bucket = "examplebucket",
  Key = "exampleobject",
  Metadata = list(
    metadata1 = "value1",
    metadata2 = "value2"
  )
)}

# The following example uploads and object. The request specifies the
# optional server-side encryption option. The request also specifies
# optional object tags. If the bucket is versioning enabled, S3 returns
# version ID in response.
\donttest{svc$put_object(
  Body = "filetoupload",
  Bucket = "examplebucket",
  Key = "exampleobject",
  ServerSideEncryption = "AES256",
  Tagging = "key1=value1&key2=value2"
)}

# The following example creates an object. If the bucket is versioning
# enabled, S3 returns version ID in response.
\donttest{svc$put_object(
  Body = "filetoupload",
  Bucket = "examplebucket",
  Key = "objectkey"
)}

# The following example uploads an object to a versioning-enabled bucket.
# The source file is specified using Windows file syntax. S3 returns
# VersionId of the newly created object.
\donttest{svc$put_object(
  Body = "HappyFace.jpg",
  Bucket = "examplebucket",
  Key = "HappyFace.jpg"
)}

# The following example uploads an object. The request specifies optional
# request headers to directs S3 to use specific storage class and use
# server-side encryption.
\donttest{svc$put_object(
  Body = "HappyFace.jpg",
  Bucket = "examplebucket",
  Key = "HappyFace.jpg",
  ServerSideEncryption = "AES256",
  StorageClass = "STANDARD_IA"
)}

}
\keyword{internal}
