% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_operations.R
\name{s3_get_bucket_tagging}
\alias{s3_get_bucket_tagging}
\title{Returns the tag set associated with the bucket}
\usage{
s3_get_bucket_tagging(Bucket, ExpectedBucketOwner)
}
\arguments{
\item{Bucket}{[required] The name of the bucket for which to get the tagging information.}

\item{ExpectedBucketOwner}{The account id of the expected bucket owner. If the bucket is owned by a
different account, the request will fail with an HTTP
\verb{403 (Access Denied)} error.}
}
\value{
A list with the following syntax:\preformatted{list(
  TagSet = list(
    list(
      Key = "string",
      Value = "string"
    )
  )
)
}
}
\description{
Returns the tag set associated with the bucket.

To use this operation, you must have permission to perform the
\code{s3:GetBucketTagging} action. By default, the bucket owner has this
permission and can grant this permission to others.

\code{\link[=s3_get_bucket_tagging]{get_bucket_tagging}} has the following special
error:
\itemize{
\item Error code: \code{NoSuchTagSetError}
\itemize{
\item Description: There is no tag set associated with the bucket.
}
}

The following operations are related to
\code{\link[=s3_get_bucket_tagging]{get_bucket_tagging}}:
\itemize{
\item \code{\link[=s3_put_bucket_tagging]{put_bucket_tagging}}
\item \code{\link[=s3_delete_bucket_tagging]{delete_bucket_tagging}}
}
}
\section{Request syntax}{
\preformatted{svc$get_bucket_tagging(
  Bucket = "string",
  ExpectedBucketOwner = "string"
)
}
}

\examples{
\dontrun{
# The following example returns tag set associated with a bucket
svc$get_bucket_tagging(
  Bucket = "examplebucket"
)
}

}
\keyword{internal}
