% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/backup_operations.R
\name{backup_create_backup_vault}
\alias{backup_create_backup_vault}
\title{Creates a logical container where backups are stored}
\usage{
backup_create_backup_vault(BackupVaultName, BackupVaultTags,
  EncryptionKeyArn, CreatorRequestId)
}
\arguments{
\item{BackupVaultName}{[required] The name of a logical container where backups are stored. Backup vaults
are identified by names that are unique to the account used to create
them and the AWS Region where they are created. They consist of
lowercase letters, numbers, and hyphens.}

\item{BackupVaultTags}{Metadata that you can assign to help organize the resources that you
create. Each tag is a key-value pair.}

\item{EncryptionKeyArn}{The server-side encryption key that is used to protect your backups; for
example,
\verb{arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab}.}

\item{CreatorRequestId}{A unique string that identifies the request and allows failed requests
to be retried without the risk of running the operation twice.}
}
\value{
A list with the following syntax:\preformatted{list(
  BackupVaultName = "string",
  BackupVaultArn = "string",
  CreationDate = as.POSIXct(
    "2015-01-01"
  )
)
}
}
\description{
Creates a logical container where backups are stored. A
\code{\link[=backup_create_backup_vault]{create_backup_vault}} request includes a
name, optionally one or more resource tags, an encryption key, and a
request ID.

Sensitive data, such as passport numbers, should not be included the
name of a backup vault.
}
\section{Request syntax}{
\preformatted{svc$create_backup_vault(
  BackupVaultName = "string",
  BackupVaultTags = list(
    "string"
  ),
  EncryptionKeyArn = "string",
  CreatorRequestId = "string"
)
}
}

\keyword{internal}
