% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_operations.R
\name{s3_get_bucket_logging}
\alias{s3_get_bucket_logging}
\title{Returns the logging status of a bucket and the permissions users have to
view and modify that status}
\usage{
s3_get_bucket_logging(Bucket, ExpectedBucketOwner)
}
\arguments{
\item{Bucket}{[required] The bucket name for which to get the logging information.}

\item{ExpectedBucketOwner}{The account id of the expected bucket owner. If the bucket is owned by a
different account, the request will fail with an HTTP
\verb{403 (Access Denied)} error.}
}
\description{
Returns the logging status of a bucket and the permissions users have to
view and modify that status. To use GET, you must be the bucket owner.

The following operations are related to \code{GetBucketLogging}:
\itemize{
\item \href{https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateBucket.html}{CreateBucket}
\item \href{https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketLogging.html}{PutBucketLogging}
}
}
\section{Request syntax}{
\preformatted{svc$get_bucket_logging(
  Bucket = "string",
  ExpectedBucketOwner = "string"
)
}
}

\keyword{internal}
