# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_operation new_request send_request
#' @include efs_service.R
NULL

#' Creates a new, empty file system
#'
#' Creates a new, empty file system. The operation requires a creation
#' token in the request that Amazon EFS uses to ensure idempotent creation
#' (calling the operation with same creation token has no effect). If a
#' file system does not currently exist that is owned by the caller\'s AWS
#' account with the specified creation token, this operation does the
#' following:
#' 
#' -   Creates a new, empty file system. The file system will have an
#'     Amazon EFS assigned ID, and an initial lifecycle state `creating`.
#' 
#' -   Returns with the description of the created file system.
#' 
#' Otherwise, this operation returns a `FileSystemAlreadyExists` error with
#' the ID of the existing file system.
#' 
#' For basic use cases, you can use a randomly generated UUID for the
#' creation token.
#' 
#' The idempotent operation allows you to retry a `CreateFileSystem` call
#' without risk of creating an extra file system. This can happen when an
#' initial call fails in a way that leaves it uncertain whether or not a
#' file system was actually created. An example might be that a transport
#' level timeout occurred or your connection was reset. As long as you use
#' the same creation token, if the initial call had succeeded in creating a
#' file system, the client can learn of its existence from the
#' `FileSystemAlreadyExists` error.
#' 
#' The `CreateFileSystem` call returns while the file system\'s lifecycle
#' state is still `creating`. You can check the file system creation status
#' by calling the DescribeFileSystems operation, which among other things
#' returns the file system state.
#' 
#' This operation also takes an optional `PerformanceMode` parameter that
#' you choose for your file system. We recommend `generalPurpose`
#' performance mode for most file systems. File systems using the `maxIO`
#' performance mode can scale to higher levels of aggregate throughput and
#' operations per second with a tradeoff of slightly higher latencies for
#' most file operations. The performance mode can\'t be changed after the
#' file system has been created. For more information, see [Amazon EFS:
#' Performance
#' Modes](https://docs.aws.amazon.com/efs/latest/ug/performance.html#performancemodes.html).
#' 
#' After the file system is fully created, Amazon EFS sets its lifecycle
#' state to `available`, at which point you can create one or more mount
#' targets for the file system in your VPC. For more information, see
#' CreateMountTarget. You mount your Amazon EFS file system on an EC2
#' instances in your VPC by using the mount target. For more information,
#' see [Amazon EFS: How it
#' Works](https://docs.aws.amazon.com/efs/latest/ug/how-it-works.html).
#' 
#' This operation requires permissions for the
#' `elasticfilesystem:CreateFileSystem` action.
#'
#' @usage
#' efs_create_file_system(CreationToken, PerformanceMode, Encrypted,
#'   KmsKeyId, ThroughputMode, ProvisionedThroughputInMibps, Tags)
#'
#' @param CreationToken &#91;required&#93; A string of up to 64 ASCII characters. Amazon EFS uses this to ensure
#' idempotent creation.
#' @param PerformanceMode The performance mode of the file system. We recommend `generalPurpose`
#' performance mode for most file systems. File systems using the `maxIO`
#' performance mode can scale to higher levels of aggregate throughput and
#' operations per second with a tradeoff of slightly higher latencies for
#' most file operations. The performance mode can\'t be changed after the
#' file system has been created.
#' @param Encrypted A Boolean value that, if true, creates an encrypted file system. When
#' creating an encrypted file system, you have the option of specifying
#' CreateFileSystemRequest\\$KmsKeyId for an existing AWS Key Management
#' Service (AWS KMS) customer master key (CMK). If you don\'t specify a
#' CMK, then the default CMK for Amazon EFS, `/aws/elasticfilesystem`, is
#' used to protect the encrypted file system.
#' @param KmsKeyId The ID of the AWS KMS CMK to be used to protect the encrypted file
#' system. This parameter is only required if you want to use a nondefault
#' CMK. If this parameter is not specified, the default CMK for Amazon EFS
#' is used. This ID can be in one of the following formats:
#' 
#' -   Key ID - A unique identifier of the key, for example
#'     `1234abcd-12ab-34cd-56ef-1234567890ab`.
#' 
#' -   ARN - An Amazon Resource Name (ARN) for the key, for example
#'     `arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`.
#' 
#' -   Key alias - A previously created display name for a key, for example
#'     `alias/projectKey1`.
#' 
#' -   Key alias ARN - An ARN for a key alias, for example
#'     `arn:aws:kms:us-west-2:444455556666:alias/projectKey1`.
#' 
#' If `KmsKeyId` is specified, the CreateFileSystemRequest\\$Encrypted
#' parameter must be set to true.
#' @param ThroughputMode The throughput mode for the file system to be created. There are two
#' throughput modes to choose from for your file system: bursting and
#' provisioned. You can decrease your file system\'s throughput in
#' Provisioned Throughput mode or change between the throughput modes as
#' long as it's been more than 24 hours since the last decrease or
#' throughput mode change.
#' @param ProvisionedThroughputInMibps The throughput, measured in MiB/s, that you want to provision for a file
#' system that you\'re creating. The limit on throughput is 1024 MiB/s. You
#' can get these limits increased by contacting AWS Support. For more
#' information, see [Amazon EFS Limits That You Can
#' Increase](https://docs.aws.amazon.com/efs/latest/ug/limits.html#soft-limits)
#' in the *Amazon EFS User Guide.*
#' @param Tags A value that specifies to create one or more tags associated with the
#' file system. Each tag is a user-defined key-value pair. Name your file
#' system on creation by including a `"Key":"Name","Value":"\{value\}"`
#' key-value pair.
#'
#' @section Request syntax:
#' ```
#' svc$create_file_system(
#'   CreationToken = "string",
#'   PerformanceMode = "generalPurpose"|"maxIO",
#'   Encrypted = TRUE|FALSE,
#'   KmsKeyId = "string",
#'   ThroughputMode = "bursting"|"provisioned",
#'   ProvisionedThroughputInMibps = 123.0,
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @examples
#' # This operation creates a new file system with the default generalpurpose
#' # performance mode.
#' \donttest{svc$create_file_system(
#'   CreationToken = "tokenstring",
#'   PerformanceMode = "generalPurpose",
#'   Tags = list(
#'     list(
#'       Key = "Name",
#'       Value = "MyFileSystem"
#'     )
#'   )
#' )}
#'
#' @keywords internal
#'
#' @rdname efs_create_file_system
efs_create_file_system <- function(CreationToken, PerformanceMode = NULL, Encrypted = NULL, KmsKeyId = NULL, ThroughputMode = NULL, ProvisionedThroughputInMibps = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateFileSystem",
    http_method = "POST",
    http_path = "/2015-02-01/file-systems",
    paginator = list()
  )
  input <- .efs$create_file_system_input(CreationToken = CreationToken, PerformanceMode = PerformanceMode, Encrypted = Encrypted, KmsKeyId = KmsKeyId, ThroughputMode = ThroughputMode, ProvisionedThroughputInMibps = ProvisionedThroughputInMibps, Tags = Tags)
  output <- .efs$create_file_system_output()
  svc <- .efs$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.efs$operations$create_file_system <- efs_create_file_system

#' Creates a mount target for a file system
#'
#' Creates a mount target for a file system. You can then mount the file
#' system on EC2 instances by using the mount target.
#' 
#' You can create one mount target in each Availability Zone in your VPC.
#' All EC2 instances in a VPC within a given Availability Zone share a
#' single mount target for a given file system. If you have multiple
#' subnets in an Availability Zone, you create a mount target in one of the
#' subnets. EC2 instances do not need to be in the same subnet as the mount
#' target in order to access their file system. For more information, see
#' [Amazon EFS: How it
#' Works](https://docs.aws.amazon.com/efs/latest/ug/how-it-works.html).
#' 
#' In the request, you also specify a file system ID for which you are
#' creating the mount target and the file system\'s lifecycle state must be
#' `available`. For more information, see DescribeFileSystems.
#' 
#' In the request, you also provide a subnet ID, which determines the
#' following:
#' 
#' -   VPC in which Amazon EFS creates the mount target
#' 
#' -   Availability Zone in which Amazon EFS creates the mount target
#' 
#' -   IP address range from which Amazon EFS selects the IP address of the
#'     mount target (if you don\'t specify an IP address in the request)
#' 
#' After creating the mount target, Amazon EFS returns a response that
#' includes, a `MountTargetId` and an `IpAddress`. You use this IP address
#' when mounting the file system in an EC2 instance. You can also use the
#' mount target\'s DNS name when mounting the file system. The EC2 instance
#' on which you mount the file system by using the mount target can resolve
#' the mount target\'s DNS name to its IP address. For more information,
#' see [How it Works: Implementation
#' Overview](https://docs.aws.amazon.com/efs/latest/ug/how-it-works.html#how-it-works-implementation).
#' 
#' Note that you can create mount targets for a file system in only one
#' VPC, and there can be only one mount target per Availability Zone. That
#' is, if the file system already has one or more mount targets created for
#' it, the subnet specified in the request to add another mount target must
#' meet the following requirements:
#' 
#' -   Must belong to the same VPC as the subnets of the existing mount
#'     targets
#' 
#' -   Must not be in the same Availability Zone as any of the subnets of
#'     the existing mount targets
#' 
#' If the request satisfies the requirements, Amazon EFS does the
#' following:
#' 
#' -   Creates a new mount target in the specified subnet.
#' 
#' -   Also creates a new network interface in the subnet as follows:
#' 
#'     -   If the request provides an `IpAddress`, Amazon EFS assigns that
#'         IP address to the network interface. Otherwise, Amazon EFS
#'         assigns a free address in the subnet (in the same way that the
#'         Amazon EC2 `CreateNetworkInterface` call does when a request
#'         does not specify a primary private IP address).
#' 
#'     -   If the request provides `SecurityGroups`, this network interface
#'         is associated with those security groups. Otherwise, it belongs
#'         to the default security group for the subnet\'s VPC.
#' 
#'     -   Assigns the description
#'         `Mount target <i>fsmt-id</i> for file system <i>fs-id</i> `
#'         where ` <i>fsmt-id</i> ` is the mount target ID, and
#'         ` <i>fs-id</i> ` is the `FileSystemId`.
#' 
#'     -   Sets the `requesterManaged` property of the network interface to
#'         `true`, and the `requesterId` value to `EFS`.
#' 
#'     Each Amazon EFS mount target has one corresponding requester-managed
#'     EC2 network interface. After the network interface is created,
#'     Amazon EFS sets the `NetworkInterfaceId` field in the mount
#'     target\'s description to the network interface ID, and the
#'     `IpAddress` field to its address. If network interface creation
#'     fails, the entire `CreateMountTarget` operation fails.
#' 
#' The `CreateMountTarget` call returns only after creating the network
#' interface, but while the mount target state is still `creating`, you can
#' check the mount target creation status by calling the
#' DescribeMountTargets operation, which among other things returns the
#' mount target state.
#' 
#' We recommend that you create a mount target in each of the Availability
#' Zones. There are cost considerations for using a file system in an
#' Availability Zone through a mount target created in another Availability
#' Zone. For more information, see [Amazon
#' EFS](http://aws.amazon.com/efs/). In addition, by always using a mount
#' target local to the instance\'s Availability Zone, you eliminate a
#' partial failure scenario. If the Availability Zone in which your mount
#' target is created goes down, then you can\'t access your file system
#' through that mount target.
#' 
#' This operation requires permissions for the following action on the file
#' system:
#' 
#' -   `elasticfilesystem:CreateMountTarget`
#' 
#' This operation also requires permissions for the following Amazon EC2
#' actions:
#' 
#' -   `ec2:DescribeSubnets`
#' 
#' -   `ec2:DescribeNetworkInterfaces`
#' 
#' -   `ec2:CreateNetworkInterface`
#'
#' @usage
#' efs_create_mount_target(FileSystemId, SubnetId, IpAddress,
#'   SecurityGroups)
#'
#' @param FileSystemId &#91;required&#93; The ID of the file system for which to create the mount target.
#' @param SubnetId &#91;required&#93; The ID of the subnet to add the mount target in.
#' @param IpAddress Valid IPv4 address within the address range of the specified subnet.
#' @param SecurityGroups Up to five VPC security group IDs, of the form `sg-xxxxxxxx`. These must
#' be for the same VPC as subnet specified.
#'
#' @section Request syntax:
#' ```
#' svc$create_mount_target(
#'   FileSystemId = "string",
#'   SubnetId = "string",
#'   IpAddress = "string",
#'   SecurityGroups = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @examples
#' # This operation creates a new mount target for an EFS file system.
#' \donttest{svc$create_mount_target(
#'   FileSystemId = "fs-01234567",
#'   SubnetId = "subnet-1234abcd"
#' )}
#'
#' @keywords internal
#'
#' @rdname efs_create_mount_target
efs_create_mount_target <- function(FileSystemId, SubnetId, IpAddress = NULL, SecurityGroups = NULL) {
  op <- new_operation(
    name = "CreateMountTarget",
    http_method = "POST",
    http_path = "/2015-02-01/mount-targets",
    paginator = list()
  )
  input <- .efs$create_mount_target_input(FileSystemId = FileSystemId, SubnetId = SubnetId, IpAddress = IpAddress, SecurityGroups = SecurityGroups)
  output <- .efs$create_mount_target_output()
  svc <- .efs$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.efs$operations$create_mount_target <- efs_create_mount_target

#' Creates or overwrites tags associated with a file system
#'
#' Creates or overwrites tags associated with a file system. Each tag is a
#' key-value pair. If a tag key specified in the request already exists on
#' the file system, this operation overwrites its value with the value
#' provided in the request. If you add the `Name` tag to your file system,
#' Amazon EFS returns it in the response to the DescribeFileSystems
#' operation.
#' 
#' This operation requires permission for the
#' `elasticfilesystem:CreateTags` action.
#'
#' @usage
#' efs_create_tags(FileSystemId, Tags)
#'
#' @param FileSystemId &#91;required&#93; The ID of the file system whose tags you want to modify (String). This
#' operation modifies the tags only, not the file system.
#' @param Tags &#91;required&#93; An array of `Tag` objects to add. Each `Tag` object is a key-value pair.
#'
#' @section Request syntax:
#' ```
#' svc$create_tags(
#'   FileSystemId = "string",
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @examples
#' # This operation creates a new tag for an EFS file system.
#' \donttest{svc$create_tags(
#'   FileSystemId = "fs-01234567",
#'   Tags = list(
#'     list(
#'       Key = "Name",
#'       Value = "MyFileSystem"
#'     )
#'   )
#' )}
#'
#' @keywords internal
#'
#' @rdname efs_create_tags
efs_create_tags <- function(FileSystemId, Tags) {
  op <- new_operation(
    name = "CreateTags",
    http_method = "POST",
    http_path = "/2015-02-01/create-tags/{FileSystemId}",
    paginator = list()
  )
  input <- .efs$create_tags_input(FileSystemId = FileSystemId, Tags = Tags)
  output <- .efs$create_tags_output()
  svc <- .efs$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.efs$operations$create_tags <- efs_create_tags

#' Deletes a file system, permanently severing access to its contents
#'
#' Deletes a file system, permanently severing access to its contents. Upon
#' return, the file system no longer exists and you can\'t access any
#' contents of the deleted file system.
#' 
#' You can\'t delete a file system that is in use. That is, if the file
#' system has any mount targets, you must first delete them. For more
#' information, see DescribeMountTargets and DeleteMountTarget.
#' 
#' The `DeleteFileSystem` call returns while the file system state is still
#' `deleting`. You can check the file system deletion status by calling the
#' DescribeFileSystems operation, which returns a list of file systems in
#' your account. If you pass file system ID or creation token for the
#' deleted file system, the DescribeFileSystems returns a
#' `404 FileSystemNotFound` error.
#' 
#' This operation requires permissions for the
#' `elasticfilesystem:DeleteFileSystem` action.
#'
#' @usage
#' efs_delete_file_system(FileSystemId)
#'
#' @param FileSystemId &#91;required&#93; The ID of the file system you want to delete.
#'
#' @section Request syntax:
#' ```
#' svc$delete_file_system(
#'   FileSystemId = "string"
#' )
#' ```
#'
#' @examples
#' # This operation deletes an EFS file system.
#' \donttest{svc$delete_file_system(
#'   FileSystemId = "fs-01234567"
#' )}
#'
#' @keywords internal
#'
#' @rdname efs_delete_file_system
efs_delete_file_system <- function(FileSystemId) {
  op <- new_operation(
    name = "DeleteFileSystem",
    http_method = "DELETE",
    http_path = "/2015-02-01/file-systems/{FileSystemId}",
    paginator = list()
  )
  input <- .efs$delete_file_system_input(FileSystemId = FileSystemId)
  output <- .efs$delete_file_system_output()
  svc <- .efs$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.efs$operations$delete_file_system <- efs_delete_file_system

#' Deletes the specified mount target
#'
#' Deletes the specified mount target.
#' 
#' This operation forcibly breaks any mounts of the file system by using
#' the mount target that is being deleted, which might disrupt instances or
#' applications using those mounts. To avoid applications getting cut off
#' abruptly, you might consider unmounting any mounts of the mount target,
#' if feasible. The operation also deletes the associated network
#' interface. Uncommitted writes might be lost, but breaking a mount target
#' using this operation does not corrupt the file system itself. The file
#' system you created remains. You can mount an EC2 instance in your VPC by
#' using another mount target.
#' 
#' This operation requires permissions for the following action on the file
#' system:
#' 
#' -   `elasticfilesystem:DeleteMountTarget`
#' 
#' The `DeleteMountTarget` call returns while the mount target state is
#' still `deleting`. You can check the mount target deletion by calling the
#' DescribeMountTargets operation, which returns a list of mount target
#' descriptions for the given file system.
#' 
#' The operation also requires permissions for the following Amazon EC2
#' action on the mount target\'s network interface:
#' 
#' -   `ec2:DeleteNetworkInterface`
#'
#' @usage
#' efs_delete_mount_target(MountTargetId)
#'
#' @param MountTargetId &#91;required&#93; The ID of the mount target to delete (String).
#'
#' @section Request syntax:
#' ```
#' svc$delete_mount_target(
#'   MountTargetId = "string"
#' )
#' ```
#'
#' @examples
#' # This operation deletes a mount target.
#' \donttest{svc$delete_mount_target(
#'   MountTargetId = "fsmt-12340abc"
#' )}
#'
#' @keywords internal
#'
#' @rdname efs_delete_mount_target
efs_delete_mount_target <- function(MountTargetId) {
  op <- new_operation(
    name = "DeleteMountTarget",
    http_method = "DELETE",
    http_path = "/2015-02-01/mount-targets/{MountTargetId}",
    paginator = list()
  )
  input <- .efs$delete_mount_target_input(MountTargetId = MountTargetId)
  output <- .efs$delete_mount_target_output()
  svc <- .efs$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.efs$operations$delete_mount_target <- efs_delete_mount_target

#' Deletes the specified tags from a file system
#'
#' Deletes the specified tags from a file system. If the `DeleteTags`
#' request includes a tag key that doesn\'t exist, Amazon EFS ignores it
#' and doesn\'t cause an error. For more information about tags and related
#' restrictions, see [Tag
#' Restrictions](https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html)
#' in the *AWS Billing and Cost Management User Guide*.
#' 
#' This operation requires permissions for the
#' `elasticfilesystem:DeleteTags` action.
#'
#' @usage
#' efs_delete_tags(FileSystemId, TagKeys)
#'
#' @param FileSystemId &#91;required&#93; The ID of the file system whose tags you want to delete (String).
#' @param TagKeys &#91;required&#93; A list of tag keys to delete.
#'
#' @section Request syntax:
#' ```
#' svc$delete_tags(
#'   FileSystemId = "string",
#'   TagKeys = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @examples
#' # This operation deletes tags for an EFS file system.
#' \donttest{svc$delete_tags(
#'   FileSystemId = "fs-01234567",
#'   TagKeys = list(
#'     "Name"
#'   )
#' )}
#'
#' @keywords internal
#'
#' @rdname efs_delete_tags
efs_delete_tags <- function(FileSystemId, TagKeys) {
  op <- new_operation(
    name = "DeleteTags",
    http_method = "POST",
    http_path = "/2015-02-01/delete-tags/{FileSystemId}",
    paginator = list()
  )
  input <- .efs$delete_tags_input(FileSystemId = FileSystemId, TagKeys = TagKeys)
  output <- .efs$delete_tags_output()
  svc <- .efs$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.efs$operations$delete_tags <- efs_delete_tags

#' Returns the description of a specific Amazon EFS file system if either
#' the file system CreationToken or the FileSystemId is provided
#'
#' Returns the description of a specific Amazon EFS file system if either
#' the file system `CreationToken` or the `FileSystemId` is provided.
#' Otherwise, it returns descriptions of all file systems owned by the
#' caller\'s AWS account in the AWS Region of the endpoint that you\'re
#' calling.
#' 
#' When retrieving all file system descriptions, you can optionally specify
#' the `MaxItems` parameter to limit the number of descriptions in a
#' response. Currently, this number is automatically set to 10. If more
#' file system descriptions remain, Amazon EFS returns a `NextMarker`, an
#' opaque token, in the response. In this case, you should send a
#' subsequent request with the `Marker` request parameter set to the value
#' of `NextMarker`.
#' 
#' To retrieve a list of your file system descriptions, this operation is
#' used in an iterative process, where `DescribeFileSystems` is called
#' first without the `Marker` and then the operation continues to call it
#' with the `Marker` parameter set to the value of the `NextMarker` from
#' the previous response until the response has no `NextMarker`.
#' 
#' The order of file systems returned in the response of one
#' `DescribeFileSystems` call and the order of file systems returned across
#' the responses of a multi-call iteration is unspecified.
#' 
#' This operation requires permissions for the
#' `elasticfilesystem:DescribeFileSystems` action.
#'
#' @usage
#' efs_describe_file_systems(MaxItems, Marker, CreationToken, FileSystemId)
#'
#' @param MaxItems (Optional) Specifies the maximum number of file systems to return in the
#' response (integer). Currently, this number is automatically set to 10.
#' @param Marker (Optional) Opaque pagination token returned from a previous
#' `DescribeFileSystems` operation (String). If present, specifies to
#' continue the list from where the returning call had left off.
#' @param CreationToken (Optional) Restricts the list to the file system with this creation
#' token (String). You specify a creation token when you create an Amazon
#' EFS file system.
#' @param FileSystemId (Optional) ID of the file system whose description you want to retrieve
#' (String).
#'
#' @section Request syntax:
#' ```
#' svc$describe_file_systems(
#'   MaxItems = 123,
#'   Marker = "string",
#'   CreationToken = "string",
#'   FileSystemId = "string"
#' )
#' ```
#'
#' @examples
#' # This operation describes all of the EFS file systems in an account.
#' \donttest{svc$describe_file_systems()}
#'
#' @keywords internal
#'
#' @rdname efs_describe_file_systems
efs_describe_file_systems <- function(MaxItems = NULL, Marker = NULL, CreationToken = NULL, FileSystemId = NULL) {
  op <- new_operation(
    name = "DescribeFileSystems",
    http_method = "GET",
    http_path = "/2015-02-01/file-systems",
    paginator = list()
  )
  input <- .efs$describe_file_systems_input(MaxItems = MaxItems, Marker = Marker, CreationToken = CreationToken, FileSystemId = FileSystemId)
  output <- .efs$describe_file_systems_output()
  svc <- .efs$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.efs$operations$describe_file_systems <- efs_describe_file_systems

#' Returns the current LifecycleConfiguration object for the specified
#' Amazon EFS file system
#'
#' Returns the current `LifecycleConfiguration` object for the specified
#' Amazon EFS file system. EFS lifecycle management uses the
#' `LifecycleConfiguration` object to identify which files to move to the
#' EFS Infrequent Access (IA) storage class. For a file system without a
#' `LifecycleConfiguration` object, the call returns an empty array in the
#' response.
#' 
#' This operation requires permissions for the
#' `elasticfilesystem:DescribeLifecycleConfiguration` operation.
#'
#' @usage
#' efs_describe_lifecycle_configuration(FileSystemId)
#'
#' @param FileSystemId &#91;required&#93; The ID of the file system whose `LifecycleConfiguration` object you want
#' to retrieve (String).
#'
#' @section Request syntax:
#' ```
#' svc$describe_lifecycle_configuration(
#'   FileSystemId = "string"
#' )
#' ```
#'
#' @examples
#' # This operation describes a file system's LifecycleConfiguration. EFS
#' # lifecycle management uses the LifecycleConfiguration object to identify
#' # which files to move to the EFS Infrequent Access (IA) storage class.
#' \donttest{svc$describe_lifecycle_configuration(
#'   FileSystemId = "fs-01234567"
#' )}
#'
#' @keywords internal
#'
#' @rdname efs_describe_lifecycle_configuration
efs_describe_lifecycle_configuration <- function(FileSystemId) {
  op <- new_operation(
    name = "DescribeLifecycleConfiguration",
    http_method = "GET",
    http_path = "/2015-02-01/file-systems/{FileSystemId}/lifecycle-configuration",
    paginator = list()
  )
  input <- .efs$describe_lifecycle_configuration_input(FileSystemId = FileSystemId)
  output <- .efs$describe_lifecycle_configuration_output()
  svc <- .efs$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.efs$operations$describe_lifecycle_configuration <- efs_describe_lifecycle_configuration

#' Returns the security groups currently in effect for a mount target
#'
#' Returns the security groups currently in effect for a mount target. This
#' operation requires that the network interface of the mount target has
#' been created and the lifecycle state of the mount target is not
#' `deleted`.
#' 
#' This operation requires permissions for the following actions:
#' 
#' -   `elasticfilesystem:DescribeMountTargetSecurityGroups` action on the
#'     mount target\'s file system.
#' 
#' -   `ec2:DescribeNetworkInterfaceAttribute` action on the mount
#'     target\'s network interface.
#'
#' @usage
#' efs_describe_mount_target_security_groups(MountTargetId)
#'
#' @param MountTargetId &#91;required&#93; The ID of the mount target whose security groups you want to retrieve.
#'
#' @section Request syntax:
#' ```
#' svc$describe_mount_target_security_groups(
#'   MountTargetId = "string"
#' )
#' ```
#'
#' @examples
#' # This operation describes all of the security groups for a file system's
#' # mount target.
#' \donttest{svc$describe_mount_target_security_groups(
#'   MountTargetId = "fsmt-12340abc"
#' )}
#'
#' @keywords internal
#'
#' @rdname efs_describe_mount_target_security_groups
efs_describe_mount_target_security_groups <- function(MountTargetId) {
  op <- new_operation(
    name = "DescribeMountTargetSecurityGroups",
    http_method = "GET",
    http_path = "/2015-02-01/mount-targets/{MountTargetId}/security-groups",
    paginator = list()
  )
  input <- .efs$describe_mount_target_security_groups_input(MountTargetId = MountTargetId)
  output <- .efs$describe_mount_target_security_groups_output()
  svc <- .efs$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.efs$operations$describe_mount_target_security_groups <- efs_describe_mount_target_security_groups

#' Returns the descriptions of all the current mount targets, or a specific
#' mount target, for a file system
#'
#' Returns the descriptions of all the current mount targets, or a specific
#' mount target, for a file system. When requesting all of the current
#' mount targets, the order of mount targets returned in the response is
#' unspecified.
#' 
#' This operation requires permissions for the
#' `elasticfilesystem:DescribeMountTargets` action, on either the file
#' system ID that you specify in `FileSystemId`, or on the file system of
#' the mount target that you specify in `MountTargetId`.
#'
#' @usage
#' efs_describe_mount_targets(MaxItems, Marker, FileSystemId,
#'   MountTargetId)
#'
#' @param MaxItems (Optional) Maximum number of mount targets to return in the response.
#' Currently, this number is automatically set to 10.
#' @param Marker (Optional) Opaque pagination token returned from a previous
#' `DescribeMountTargets` operation (String). If present, it specifies to
#' continue the list from where the previous returning call left off.
#' @param FileSystemId (Optional) ID of the file system whose mount targets you want to list
#' (String). It must be included in your request if `MountTargetId` is not
#' included.
#' @param MountTargetId (Optional) ID of the mount target that you want to have described
#' (String). It must be included in your request if `FileSystemId` is not
#' included.
#'
#' @section Request syntax:
#' ```
#' svc$describe_mount_targets(
#'   MaxItems = 123,
#'   Marker = "string",
#'   FileSystemId = "string",
#'   MountTargetId = "string"
#' )
#' ```
#'
#' @examples
#' # This operation describes all of a file system's mount targets.
#' \donttest{svc$describe_mount_targets(
#'   FileSystemId = "fs-01234567"
#' )}
#'
#' @keywords internal
#'
#' @rdname efs_describe_mount_targets
efs_describe_mount_targets <- function(MaxItems = NULL, Marker = NULL, FileSystemId = NULL, MountTargetId = NULL) {
  op <- new_operation(
    name = "DescribeMountTargets",
    http_method = "GET",
    http_path = "/2015-02-01/mount-targets",
    paginator = list()
  )
  input <- .efs$describe_mount_targets_input(MaxItems = MaxItems, Marker = Marker, FileSystemId = FileSystemId, MountTargetId = MountTargetId)
  output <- .efs$describe_mount_targets_output()
  svc <- .efs$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.efs$operations$describe_mount_targets <- efs_describe_mount_targets

#' Returns the tags associated with a file system
#'
#' Returns the tags associated with a file system. The order of tags
#' returned in the response of one `DescribeTags` call and the order of
#' tags returned across the responses of a multiple-call iteration (when
#' using pagination) is unspecified.
#' 
#' This operation requires permissions for the
#' `elasticfilesystem:DescribeTags` action.
#'
#' @usage
#' efs_describe_tags(MaxItems, Marker, FileSystemId)
#'
#' @param MaxItems (Optional) The maximum number of file system tags to return in the
#' response. Currently, this number is automatically set to 10.
#' @param Marker (Optional) An opaque pagination token returned from a previous
#' `DescribeTags` operation (String). If present, it specifies to continue
#' the list from where the previous call left off.
#' @param FileSystemId &#91;required&#93; The ID of the file system whose tag set you want to retrieve.
#'
#' @section Request syntax:
#' ```
#' svc$describe_tags(
#'   MaxItems = 123,
#'   Marker = "string",
#'   FileSystemId = "string"
#' )
#' ```
#'
#' @examples
#' # This operation describes all of a file system's tags.
#' \donttest{svc$describe_tags(
#'   FileSystemId = "fs-01234567"
#' )}
#'
#' @keywords internal
#'
#' @rdname efs_describe_tags
efs_describe_tags <- function(MaxItems = NULL, Marker = NULL, FileSystemId) {
  op <- new_operation(
    name = "DescribeTags",
    http_method = "GET",
    http_path = "/2015-02-01/tags/{FileSystemId}/",
    paginator = list()
  )
  input <- .efs$describe_tags_input(MaxItems = MaxItems, Marker = Marker, FileSystemId = FileSystemId)
  output <- .efs$describe_tags_output()
  svc <- .efs$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.efs$operations$describe_tags <- efs_describe_tags

#' Modifies the set of security groups in effect for a mount target
#'
#' Modifies the set of security groups in effect for a mount target.
#' 
#' When you create a mount target, Amazon EFS also creates a new network
#' interface. For more information, see CreateMountTarget. This operation
#' replaces the security groups in effect for the network interface
#' associated with a mount target, with the `SecurityGroups` provided in
#' the request. This operation requires that the network interface of the
#' mount target has been created and the lifecycle state of the mount
#' target is not `deleted`.
#' 
#' The operation requires permissions for the following actions:
#' 
#' -   `elasticfilesystem:ModifyMountTargetSecurityGroups` action on the
#'     mount target\'s file system.
#' 
#' -   `ec2:ModifyNetworkInterfaceAttribute` action on the mount target\'s
#'     network interface.
#'
#' @usage
#' efs_modify_mount_target_security_groups(MountTargetId, SecurityGroups)
#'
#' @param MountTargetId &#91;required&#93; The ID of the mount target whose security groups you want to modify.
#' @param SecurityGroups An array of up to five VPC security group IDs.
#'
#' @section Request syntax:
#' ```
#' svc$modify_mount_target_security_groups(
#'   MountTargetId = "string",
#'   SecurityGroups = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @examples
#' # This operation modifies the security groups associated with a mount
#' # target for a file system.
#' \donttest{svc$modify_mount_target_security_groups(
#'   MountTargetId = "fsmt-12340abc",
#'   SecurityGroups = list(
#'     "sg-abcd1234"
#'   )
#' )}
#'
#' @keywords internal
#'
#' @rdname efs_modify_mount_target_security_groups
efs_modify_mount_target_security_groups <- function(MountTargetId, SecurityGroups = NULL) {
  op <- new_operation(
    name = "ModifyMountTargetSecurityGroups",
    http_method = "PUT",
    http_path = "/2015-02-01/mount-targets/{MountTargetId}/security-groups",
    paginator = list()
  )
  input <- .efs$modify_mount_target_security_groups_input(MountTargetId = MountTargetId, SecurityGroups = SecurityGroups)
  output <- .efs$modify_mount_target_security_groups_output()
  svc <- .efs$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.efs$operations$modify_mount_target_security_groups <- efs_modify_mount_target_security_groups

#' Enables lifecycle management by creating a new LifecycleConfiguration
#' object
#'
#' Enables lifecycle management by creating a new `LifecycleConfiguration`
#' object. A `LifecycleConfiguration` object defines when files in an
#' Amazon EFS file system are automatically transitioned to the lower-cost
#' EFS Infrequent Access (IA) storage class. A `LifecycleConfiguration`
#' applies to all files in a file system.
#' 
#' Each Amazon EFS file system supports one lifecycle configuration, which
#' applies to all files in the file system. If a `LifecycleConfiguration`
#' object already exists for the specified file system, a
#' `PutLifecycleConfiguration` call modifies the existing configuration. A
#' `PutLifecycleConfiguration` call with an empty `LifecyclePolicies` array
#' in the request body deletes any existing `LifecycleConfiguration` and
#' disables lifecycle management.
#' 
#' You can enable lifecycle management only for EFS file systems created
#' after the release of EFS infrequent access.
#' 
#' In the request, specify the following:
#' 
#' -   The ID for the file system for which you are creating a lifecycle
#'     management configuration.
#' 
#' -   A `LifecyclePolicies` array of `LifecyclePolicy` objects that define
#'     when files are moved to the IA storage class. The array can contain
#'     only one `"TransitionToIA": "AFTER_30_DAYS"` `LifecyclePolicy` item.
#' 
#' This operation requires permissions for the
#' `elasticfilesystem:PutLifecycleConfiguration` operation.
#' 
#' To apply a `LifecycleConfiguration` object to an encrypted file system,
#' you need the same AWS Key Management Service (AWS KMS) permissions as
#' when you created the encrypted file system.
#'
#' @usage
#' efs_put_lifecycle_configuration(FileSystemId, LifecyclePolicies)
#'
#' @param FileSystemId &#91;required&#93; The ID of the file system for which you are creating the
#' `LifecycleConfiguration` object (String).
#' @param LifecyclePolicies &#91;required&#93; An array of `LifecyclePolicy` objects that define the file system\'s
#' `LifecycleConfiguration` object. A `LifecycleConfiguration` object tells
#' lifecycle management when to transition files from the Standard storage
#' class to the Infrequent Access storage class.
#'
#' @section Request syntax:
#' ```
#' svc$put_lifecycle_configuration(
#'   FileSystemId = "string",
#'   LifecyclePolicies = list(
#'     list(
#'       TransitionToIA = "AFTER_30_DAYS"
#'     )
#'   )
#' )
#' ```
#'
#' @examples
#' # This operation enables lifecycle management on a file system by creating
#' # a new LifecycleConfiguration object. A LifecycleConfiguration object
#' # defines when files in an Amazon EFS file system are automatically
#' # transitioned to the lower-cost EFS Infrequent Access (IA) storage class.
#' # A LifecycleConfiguration applies to all files in a file system.
#' \donttest{svc$put_lifecycle_configuration(
#'   FileSystemId = "fs-01234567",
#'   LifecyclePolicies = list(
#'     list(
#'       TransitionToIA = "AFTER_30_DAYS"
#'     )
#'   )
#' )}
#'
#' @keywords internal
#'
#' @rdname efs_put_lifecycle_configuration
efs_put_lifecycle_configuration <- function(FileSystemId, LifecyclePolicies) {
  op <- new_operation(
    name = "PutLifecycleConfiguration",
    http_method = "PUT",
    http_path = "/2015-02-01/file-systems/{FileSystemId}/lifecycle-configuration",
    paginator = list()
  )
  input <- .efs$put_lifecycle_configuration_input(FileSystemId = FileSystemId, LifecyclePolicies = LifecyclePolicies)
  output <- .efs$put_lifecycle_configuration_output()
  svc <- .efs$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.efs$operations$put_lifecycle_configuration <- efs_put_lifecycle_configuration

#' Updates the throughput mode or the amount of provisioned throughput of
#' an existing file system
#'
#' Updates the throughput mode or the amount of provisioned throughput of
#' an existing file system.
#'
#' @usage
#' efs_update_file_system(FileSystemId, ThroughputMode,
#'   ProvisionedThroughputInMibps)
#'
#' @param FileSystemId &#91;required&#93; The ID of the file system that you want to update.
#' @param ThroughputMode (Optional) The throughput mode that you want your file system to use. If
#' you\'re not updating your throughput mode, you don\'t need to provide
#' this value in your request.
#' @param ProvisionedThroughputInMibps (Optional) The amount of throughput, in MiB/s, that you want to
#' provision for your file system. If you\'re not updating the amount of
#' provisioned throughput for your file system, you don\'t need to provide
#' this value in your request.
#'
#' @section Request syntax:
#' ```
#' svc$update_file_system(
#'   FileSystemId = "string",
#'   ThroughputMode = "bursting"|"provisioned",
#'   ProvisionedThroughputInMibps = 123.0
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname efs_update_file_system
efs_update_file_system <- function(FileSystemId, ThroughputMode = NULL, ProvisionedThroughputInMibps = NULL) {
  op <- new_operation(
    name = "UpdateFileSystem",
    http_method = "PUT",
    http_path = "/2015-02-01/file-systems/{FileSystemId}",
    paginator = list()
  )
  input <- .efs$update_file_system_input(FileSystemId = FileSystemId, ThroughputMode = ThroughputMode, ProvisionedThroughputInMibps = ProvisionedThroughputInMibps)
  output <- .efs$update_file_system_output()
  svc <- .efs$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.efs$operations$update_file_system <- efs_update_file_system
