# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include iam_service.R
NULL

#' Adds a new client ID (also known as audience) to the list of client IDs
#' already registered for the specified IAM OpenID Connect (OIDC) provider
#' resource
#'
#' @description
#' Adds a new client ID (also known as audience) to the list of client IDs already registered for the specified IAM OpenID Connect (OIDC) provider resource.
#'
#' See [https://www.paws-r-sdk.com/docs/iam_add_client_id_to_open_id_connect_provider/](https://www.paws-r-sdk.com/docs/iam_add_client_id_to_open_id_connect_provider/) for full documentation.
#'
#' @param OpenIDConnectProviderArn &#91;required&#93; The Amazon Resource Name (ARN) of the IAM OpenID Connect (OIDC) provider
#' resource to add the client ID to. You can get a list of OIDC provider
#' ARNs by using the
#' [`list_open_id_connect_providers`][iam_list_open_id_connect_providers]
#' operation.
#' @param ClientID &#91;required&#93; The client ID (also known as audience) to add to the IAM OpenID Connect
#' provider resource.
#'
#' @keywords internal
#'
#' @rdname iam_add_client_id_to_open_id_connect_provider
iam_add_client_id_to_open_id_connect_provider <- function(OpenIDConnectProviderArn, ClientID) {
  op <- new_operation(
    name = "AddClientIDToOpenIDConnectProvider",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .iam$add_client_id_to_open_id_connect_provider_input(OpenIDConnectProviderArn = OpenIDConnectProviderArn, ClientID = ClientID)
  output <- .iam$add_client_id_to_open_id_connect_provider_output()
  config <- get_config()
  svc <- .iam$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$add_client_id_to_open_id_connect_provider <- iam_add_client_id_to_open_id_connect_provider

#' Adds the specified IAM role to the specified instance profile
#'
#' @description
#' Adds the specified IAM role to the specified instance profile. An instance profile can contain only one role, and this quota cannot be increased. You can remove the existing role and then add a different role to an instance profile. You must then wait for the change to appear across all of Amazon Web Services because of [eventual consistency](https://en.wikipedia.org/wiki/Eventual_consistency). To force the change, you must [disassociate the instance profile](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DisassociateIamInstanceProfile.html) and then [associate the instance profile](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_AssociateIamInstanceProfile.html), or you can stop your instance and then restart it.
#'
#' See [https://www.paws-r-sdk.com/docs/iam_add_role_to_instance_profile/](https://www.paws-r-sdk.com/docs/iam_add_role_to_instance_profile/) for full documentation.
#'
#' @param InstanceProfileName &#91;required&#93; The name of the instance profile to update.
#' 
#' This parameter allows (through its [regex
#' pattern](https://en.wikipedia.org/wiki/Regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: _+=,.@@-
#' @param RoleName &#91;required&#93; The name of the role to add.
#' 
#' This parameter allows (through its [regex
#' pattern](https://en.wikipedia.org/wiki/Regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: _+=,.@@-
#'
#' @keywords internal
#'
#' @rdname iam_add_role_to_instance_profile
iam_add_role_to_instance_profile <- function(InstanceProfileName, RoleName) {
  op <- new_operation(
    name = "AddRoleToInstanceProfile",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .iam$add_role_to_instance_profile_input(InstanceProfileName = InstanceProfileName, RoleName = RoleName)
  output <- .iam$add_role_to_instance_profile_output()
  config <- get_config()
  svc <- .iam$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$add_role_to_instance_profile <- iam_add_role_to_instance_profile

#' Adds the specified user to the specified group
#'
#' @description
#' Adds the specified user to the specified group.
#'
#' See [https://www.paws-r-sdk.com/docs/iam_add_user_to_group/](https://www.paws-r-sdk.com/docs/iam_add_user_to_group/) for full documentation.
#'
#' @param GroupName &#91;required&#93; The name of the group to update.
#' 
#' This parameter allows (through its [regex
#' pattern](https://en.wikipedia.org/wiki/Regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: _+=,.@@-
#' @param UserName &#91;required&#93; The name of the user to add.
#' 
#' This parameter allows (through its [regex
#' pattern](https://en.wikipedia.org/wiki/Regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: _+=,.@@-
#'
#' @keywords internal
#'
#' @rdname iam_add_user_to_group
iam_add_user_to_group <- function(GroupName, UserName) {
  op <- new_operation(
    name = "AddUserToGroup",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .iam$add_user_to_group_input(GroupName = GroupName, UserName = UserName)
  output <- .iam$add_user_to_group_output()
  config <- get_config()
  svc <- .iam$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$add_user_to_group <- iam_add_user_to_group

#' Attaches the specified managed policy to the specified IAM group
#'
#' @description
#' Attaches the specified managed policy to the specified IAM group.
#'
#' See [https://www.paws-r-sdk.com/docs/iam_attach_group_policy/](https://www.paws-r-sdk.com/docs/iam_attach_group_policy/) for full documentation.
#'
#' @param GroupName &#91;required&#93; The name (friendly name, not ARN) of the group to attach the policy to.
#' 
#' This parameter allows (through its [regex
#' pattern](https://en.wikipedia.org/wiki/Regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: _+=,.@@-
#' @param PolicyArn &#91;required&#93; The Amazon Resource Name (ARN) of the IAM policy you want to attach.
#' 
#' For more information about ARNs, see [Amazon Resource Names
#' (ARNs)](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html)
#' in the *Amazon Web Services General Reference*.
#'
#' @keywords internal
#'
#' @rdname iam_attach_group_policy
iam_attach_group_policy <- function(GroupName, PolicyArn) {
  op <- new_operation(
    name = "AttachGroupPolicy",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .iam$attach_group_policy_input(GroupName = GroupName, PolicyArn = PolicyArn)
  output <- .iam$attach_group_policy_output()
  config <- get_config()
  svc <- .iam$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$attach_group_policy <- iam_attach_group_policy

#' Attaches the specified managed policy to the specified IAM role
#'
#' @description
#' Attaches the specified managed policy to the specified IAM role. When you attach a managed policy to a role, the managed policy becomes part of the role's permission (access) policy.
#'
#' See [https://www.paws-r-sdk.com/docs/iam_attach_role_policy/](https://www.paws-r-sdk.com/docs/iam_attach_role_policy/) for full documentation.
#'
#' @param RoleName &#91;required&#93; The name (friendly name, not ARN) of the role to attach the policy to.
#' 
#' This parameter allows (through its [regex
#' pattern](https://en.wikipedia.org/wiki/Regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: _+=,.@@-
#' @param PolicyArn &#91;required&#93; The Amazon Resource Name (ARN) of the IAM policy you want to attach.
#' 
#' For more information about ARNs, see [Amazon Resource Names
#' (ARNs)](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html)
#' in the *Amazon Web Services General Reference*.
#'
#' @keywords internal
#'
#' @rdname iam_attach_role_policy
iam_attach_role_policy <- function(RoleName, PolicyArn) {
  op <- new_operation(
    name = "AttachRolePolicy",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .iam$attach_role_policy_input(RoleName = RoleName, PolicyArn = PolicyArn)
  output <- .iam$attach_role_policy_output()
  config <- get_config()
  svc <- .iam$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$attach_role_policy <- iam_attach_role_policy

#' Attaches the specified managed policy to the specified user
#'
#' @description
#' Attaches the specified managed policy to the specified user.
#'
#' See [https://www.paws-r-sdk.com/docs/iam_attach_user_policy/](https://www.paws-r-sdk.com/docs/iam_attach_user_policy/) for full documentation.
#'
#' @param UserName &#91;required&#93; The name (friendly name, not ARN) of the IAM user to attach the policy
#' to.
#' 
#' This parameter allows (through its [regex
#' pattern](https://en.wikipedia.org/wiki/Regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: _+=,.@@-
#' @param PolicyArn &#91;required&#93; The Amazon Resource Name (ARN) of the IAM policy you want to attach.
#' 
#' For more information about ARNs, see [Amazon Resource Names
#' (ARNs)](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html)
#' in the *Amazon Web Services General Reference*.
#'
#' @keywords internal
#'
#' @rdname iam_attach_user_policy
iam_attach_user_policy <- function(UserName, PolicyArn) {
  op <- new_operation(
    name = "AttachUserPolicy",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .iam$attach_user_policy_input(UserName = UserName, PolicyArn = PolicyArn)
  output <- .iam$attach_user_policy_output()
  config <- get_config()
  svc <- .iam$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$attach_user_policy <- iam_attach_user_policy

#' Changes the password of the IAM user who is calling this operation
#'
#' @description
#' Changes the password of the IAM user who is calling this operation. This operation can be performed using the CLI, the Amazon Web Services API, or the **My Security Credentials** page in the Amazon Web Services Management Console. The Amazon Web Services account root user password is not affected by this operation.
#'
#' See [https://www.paws-r-sdk.com/docs/iam_change_password/](https://www.paws-r-sdk.com/docs/iam_change_password/) for full documentation.
#'
#' @param OldPassword &#91;required&#93; The IAM user's current password.
#' @param NewPassword &#91;required&#93; The new password. The new password must conform to the Amazon Web
#' Services account's password policy, if one exists.
#' 
#' The [regex pattern](https://en.wikipedia.org/wiki/Regex) that is used to
#' validate this parameter is a string of characters. That string can
#' include almost any printable ASCII character from the space (``U+0020``)
#' through the end of the ASCII character range (``U+00FF``). You can also
#' include the tab (``U+0009``), line feed (``U+000A``), and carriage return
#' (``U+000D``) characters. Any of these characters are valid in a password.
#' However, many tools, such as the Amazon Web Services Management Console,
#' might restrict the ability to type certain characters because they have
#' special meaning within that tool.
#'
#' @keywords internal
#'
#' @rdname iam_change_password
iam_change_password <- function(OldPassword, NewPassword) {
  op <- new_operation(
    name = "ChangePassword",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .iam$change_password_input(OldPassword = OldPassword, NewPassword = NewPassword)
  output <- .iam$change_password_output()
  config <- get_config()
  svc <- .iam$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$change_password <- iam_change_password

#' Creates a new Amazon Web Services secret access key and corresponding
#' Amazon Web Services access key ID for the specified user
#'
#' @description
#' Creates a new Amazon Web Services secret access key and corresponding Amazon Web Services access key ID for the specified user. The default status for new keys is `Active`.
#'
#' See [https://www.paws-r-sdk.com/docs/iam_create_access_key/](https://www.paws-r-sdk.com/docs/iam_create_access_key/) for full documentation.
#'
#' @param UserName The name of the IAM user that the new key will belong to.
#' 
#' This parameter allows (through its [regex
#' pattern](https://en.wikipedia.org/wiki/Regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: _+=,.@@-
#'
#' @keywords internal
#'
#' @rdname iam_create_access_key
iam_create_access_key <- function(UserName = NULL) {
  op <- new_operation(
    name = "CreateAccessKey",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .iam$create_access_key_input(UserName = UserName)
  output <- .iam$create_access_key_output()
  config <- get_config()
  svc <- .iam$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$create_access_key <- iam_create_access_key

#' Creates an alias for your Amazon Web Services account
#'
#' @description
#' Creates an alias for your Amazon Web Services account. For information about using an Amazon Web Services account alias, see [Creating, deleting, and listing an Amazon Web Services account alias](https://docs.aws.amazon.com/IAM/latest/UserGuide/account-alias-create.html) in the *Amazon Web Services Sign-In User Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/iam_create_account_alias/](https://www.paws-r-sdk.com/docs/iam_create_account_alias/) for full documentation.
#'
#' @param AccountAlias &#91;required&#93; The account alias to create.
#' 
#' This parameter allows (through its [regex
#' pattern](https://en.wikipedia.org/wiki/Regex)) a string of characters
#' consisting of lowercase letters, digits, and dashes. You cannot start or
#' finish with a dash, nor can you have two dashes in a row.
#'
#' @keywords internal
#'
#' @rdname iam_create_account_alias
iam_create_account_alias <- function(AccountAlias) {
  op <- new_operation(
    name = "CreateAccountAlias",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .iam$create_account_alias_input(AccountAlias = AccountAlias)
  output <- .iam$create_account_alias_output()
  config <- get_config()
  svc <- .iam$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$create_account_alias <- iam_create_account_alias

#' Creates a new group
#'
#' @description
#' Creates a new group.
#'
#' See [https://www.paws-r-sdk.com/docs/iam_create_group/](https://www.paws-r-sdk.com/docs/iam_create_group/) for full documentation.
#'
#' @param Path The path to the group. For more information about paths, see [IAM
#' identifiers](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html)
#' in the *IAM User Guide*.
#' 
#' This parameter is optional. If it is not included, it defaults to a
#' slash (/).
#' 
#' This parameter allows (through its [regex
#' pattern](https://en.wikipedia.org/wiki/Regex)) a string of characters
#' consisting of either a forward slash (/) by itself or a string that must
#' begin and end with forward slashes. In addition, it can contain any
#' ASCII character from the ! (``U+0021``) through the DEL character
#' (``U+007F``), including most punctuation characters, digits, and upper and
#' lowercased letters.
#' @param GroupName &#91;required&#93; The name of the group to create. Do not include the path in this value.
#' 
#' IAM user, group, role, and policy names must be unique within the
#' account. Names are not distinguished by case. For example, you cannot
#' create resources named both "MyResource" and "myresource".
#'
#' @keywords internal
#'
#' @rdname iam_create_group
iam_create_group <- function(Path = NULL, GroupName) {
  op <- new_operation(
    name = "CreateGroup",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .iam$create_group_input(Path = Path, GroupName = GroupName)
  output <- .iam$create_group_output()
  config <- get_config()
  svc <- .iam$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$create_group <- iam_create_group

#' Creates a new instance profile
#'
#' @description
#' Creates a new instance profile. For information about instance profiles, see [Using roles for applications on Amazon EC2](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use_switch-role-ec2.html) in the *IAM User Guide*, and [Instance profiles](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/iam-roles-for-amazon-ec2.html#ec2-instance-profile) in the *Amazon EC2 User Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/iam_create_instance_profile/](https://www.paws-r-sdk.com/docs/iam_create_instance_profile/) for full documentation.
#'
#' @param InstanceProfileName &#91;required&#93; The name of the instance profile to create.
#' 
#' This parameter allows (through its [regex
#' pattern](https://en.wikipedia.org/wiki/Regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: _+=,.@@-
#' @param Path The path to the instance profile. For more information about paths, see
#' [IAM
#' Identifiers](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html)
#' in the *IAM User Guide*.
#' 
#' This parameter is optional. If it is not included, it defaults to a
#' slash (/).
#' 
#' This parameter allows (through its [regex
#' pattern](https://en.wikipedia.org/wiki/Regex)) a string of characters
#' consisting of either a forward slash (/) by itself or a string that must
#' begin and end with forward slashes. In addition, it can contain any
#' ASCII character from the ! (``U+0021``) through the DEL character
#' (``U+007F``), including most punctuation characters, digits, and upper and
#' lowercased letters.
#' @param Tags A list of tags that you want to attach to the newly created IAM instance
#' profile. Each tag consists of a key name and an associated value. For
#' more information about tagging, see [Tagging IAM
#' resources](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html)
#' in the *IAM User Guide*.
#' 
#' If any one of the tags is invalid or if you exceed the allowed maximum
#' number of tags, then the entire request fails and the resource is not
#' created.
#'
#' @keywords internal
#'
#' @rdname iam_create_instance_profile
iam_create_instance_profile <- function(InstanceProfileName, Path = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateInstanceProfile",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .iam$create_instance_profile_input(InstanceProfileName = InstanceProfileName, Path = Path, Tags = Tags)
  output <- .iam$create_instance_profile_output()
  config <- get_config()
  svc <- .iam$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$create_instance_profile <- iam_create_instance_profile

#' Creates a password for the specified IAM user
#'
#' @description
#' Creates a password for the specified IAM user. A password allows an IAM user to access Amazon Web Services services through the Amazon Web Services Management Console.
#'
#' See [https://www.paws-r-sdk.com/docs/iam_create_login_profile/](https://www.paws-r-sdk.com/docs/iam_create_login_profile/) for full documentation.
#'
#' @param UserName The name of the IAM user to create a password for. The user must already
#' exist.
#' 
#' This parameter is optional. If no user name is included, it defaults to
#' the principal making the request. When you make this request with root
#' user credentials, you must use an
#' [AssumeRoot](https://docs.aws.amazon.com/STS/latest/APIReference/API_AssumeRoot.html)
#' session to omit the user name.
#' 
#' This parameter allows (through its [regex
#' pattern](https://en.wikipedia.org/wiki/Regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: _+=,.@@-
#' @param Password The new password for the user.
#' 
#' This parameter must be omitted when you make the request with an
#' [AssumeRoot](https://docs.aws.amazon.com/STS/latest/APIReference/API_AssumeRoot.html)
#' session. It is required in all other cases.
#' 
#' The [regex pattern](https://en.wikipedia.org/wiki/Regex) that is used to
#' validate this parameter is a string of characters. That string can
#' include almost any printable ASCII character from the space (``U+0020``)
#' through the end of the ASCII character range (``U+00FF``). You can also
#' include the tab (``U+0009``), line feed (``U+000A``), and carriage return
#' (``U+000D``) characters. Any of these characters are valid in a password.
#' However, many tools, such as the Amazon Web Services Management Console,
#' might restrict the ability to type certain characters because they have
#' special meaning within that tool.
#' @param PasswordResetRequired Specifies whether the user is required to set a new password on next
#' sign-in.
#'
#' @keywords internal
#'
#' @rdname iam_create_login_profile
iam_create_login_profile <- function(UserName = NULL, Password = NULL, PasswordResetRequired = NULL) {
  op <- new_operation(
    name = "CreateLoginProfile",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .iam$create_login_profile_input(UserName = UserName, Password = Password, PasswordResetRequired = PasswordResetRequired)
  output <- .iam$create_login_profile_output()
  config <- get_config()
  svc <- .iam$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$create_login_profile <- iam_create_login_profile

#' Creates an IAM entity to describe an identity provider (IdP) that
#' supports OpenID Connect (OIDC)
#'
#' @description
#' Creates an IAM entity to describe an identity provider (IdP) that supports OpenID Connect (OIDC).
#'
#' See [https://www.paws-r-sdk.com/docs/iam_create_open_id_connect_provider/](https://www.paws-r-sdk.com/docs/iam_create_open_id_connect_provider/) for full documentation.
#'
#' @param Url &#91;required&#93; The URL of the identity provider. The URL must begin with `https://` and
#' should correspond to the `iss` claim in the provider's OpenID Connect ID
#' tokens. Per the OIDC standard, path components are allowed but query
#' parameters are not. Typically the URL consists of only a hostname, like
#' `https://server.example.org` or `https://example.com`. The URL should
#' not contain a port number.
#' 
#' You cannot register the same provider multiple times in a single Amazon
#' Web Services account. If you try to submit a URL that has already been
#' used for an OpenID Connect provider in the Amazon Web Services account,
#' you will get an error.
#' @param ClientIDList Provides a list of client IDs, also known as audiences. When a mobile or
#' web app registers with an OpenID Connect provider, they establish a
#' value that identifies the application. This is the value that's sent as
#' the `client_id` parameter on OAuth requests.
#' 
#' You can register multiple client IDs with the same provider. For
#' example, you might have multiple applications that use the same OIDC
#' provider. You cannot register more than 100 client IDs with a single IAM
#' OIDC provider.
#' 
#' There is no defined format for a client ID. The
#' `CreateOpenIDConnectProviderRequest` operation accepts client IDs up to
#' 255 characters long.
#' @param ThumbprintList A list of server certificate thumbprints for the OpenID Connect (OIDC)
#' identity provider's server certificates. Typically this list includes
#' only one entry. However, IAM lets you have up to five thumbprints for an
#' OIDC provider. This lets you maintain multiple thumbprints if the
#' identity provider is rotating certificates.
#' 
#' This parameter is optional. If it is not included, IAM will retrieve and
#' use the top intermediate certificate authority (CA) thumbprint of the
#' OpenID Connect identity provider server certificate.
#' 
#' The server certificate thumbprint is the hex-encoded SHA-1 hash value of
#' the X.509 certificate used by the domain where the OpenID Connect
#' provider makes its keys available. It is always a 40-character string.
#' 
#' For example, assume that the OIDC provider is `server.example.com` and
#' the provider stores its keys at
#' https://keys.server.example.com/openid-connect. In that case, the
#' thumbprint string would be the hex-encoded SHA-1 hash value of the
#' certificate used by `https://keys.server.example.com.`
#' 
#' For more information about obtaining the OIDC provider thumbprint, see
#' [Obtaining the thumbprint for an OpenID Connect
#' provider](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_create_oidc_verify-thumbprint.html)
#' in the *IAM user Guide*.
#' @param Tags A list of tags that you want to attach to the new IAM OpenID Connect
#' (OIDC) provider. Each tag consists of a key name and an associated
#' value. For more information about tagging, see [Tagging IAM
#' resources](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html)
#' in the *IAM User Guide*.
#' 
#' If any one of the tags is invalid or if you exceed the allowed maximum
#' number of tags, then the entire request fails and the resource is not
#' created.
#'
#' @keywords internal
#'
#' @rdname iam_create_open_id_connect_provider
iam_create_open_id_connect_provider <- function(Url, ClientIDList = NULL, ThumbprintList = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateOpenIDConnectProvider",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .iam$create_open_id_connect_provider_input(Url = Url, ClientIDList = ClientIDList, ThumbprintList = ThumbprintList, Tags = Tags)
  output <- .iam$create_open_id_connect_provider_output()
  config <- get_config()
  svc <- .iam$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$create_open_id_connect_provider <- iam_create_open_id_connect_provider

#' Creates a new managed policy for your Amazon Web Services account
#'
#' @description
#' Creates a new managed policy for your Amazon Web Services account.
#'
#' See [https://www.paws-r-sdk.com/docs/iam_create_policy/](https://www.paws-r-sdk.com/docs/iam_create_policy/) for full documentation.
#'
#' @param PolicyName &#91;required&#93; The friendly name of the policy.
#' 
#' IAM user, group, role, and policy names must be unique within the
#' account. Names are not distinguished by case. For example, you cannot
#' create resources named both "MyResource" and "myresource".
#' @param Path The path for the policy.
#' 
#' For more information about paths, see [IAM
#' identifiers](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html)
#' in the *IAM User Guide*.
#' 
#' This parameter is optional. If it is not included, it defaults to a
#' slash (/).
#' 
#' This parameter allows (through its [regex
#' pattern](https://en.wikipedia.org/wiki/Regex)) a string of characters
#' consisting of either a forward slash (/) by itself or a string that must
#' begin and end with forward slashes. In addition, it can contain any
#' ASCII character from the ! (``U+0021``) through the DEL character
#' (``U+007F``), including most punctuation characters, digits, and upper and
#' lowercased letters.
#' 
#' You cannot use an asterisk (*) in the path name.
#' @param PolicyDocument &#91;required&#93; The JSON policy document that you want to use as the content for the new
#' policy.
#' 
#' You must provide policies in JSON format in IAM. However, for
#' CloudFormation templates formatted in YAML, you can provide the policy
#' in JSON or YAML format. CloudFormation always converts a YAML policy to
#' JSON format before submitting it to IAM.
#' 
#' The maximum length of the policy document that you can pass in this
#' operation, including whitespace, is listed below. To view the maximum
#' character counts of a managed policy with no whitespaces, see [IAM and
#' STS character
#' quotas](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html#reference_iam-quotas-entity-length).
#' 
#' To learn more about JSON policy grammar, see [Grammar of the IAM JSON
#' policy
#' language](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_grammar.html)
#' in the *IAM User Guide*.
#' 
#' The [regex pattern](https://en.wikipedia.org/wiki/Regex) used to
#' validate this parameter is a string of characters consisting of the
#' following:
#' 
#' -   Any printable ASCII character ranging from the space character
#'     (``U+0020``) through the end of the ASCII character range
#' 
#' -   The printable characters in the Basic Latin and Latin-1 Supplement
#'     character set (through ``U+00FF``)
#' 
#' -   The special characters tab (``U+0009``), line feed (``U+000A``), and
#'     carriage return (``U+000D``)
#' @param Description A friendly description of the policy.
#' 
#' Typically used to store information about the permissions defined in the
#' policy. For example, "Grants access to production DynamoDB tables."
#' 
#' The policy description is immutable. After a value is assigned, it
#' cannot be changed.
#' @param Tags A list of tags that you want to attach to the new IAM customer managed
#' policy. Each tag consists of a key name and an associated value. For
#' more information about tagging, see [Tagging IAM
#' resources](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html)
#' in the *IAM User Guide*.
#' 
#' If any one of the tags is invalid or if you exceed the allowed maximum
#' number of tags, then the entire request fails and the resource is not
#' created.
#'
#' @keywords internal
#'
#' @rdname iam_create_policy
iam_create_policy <- function(PolicyName, Path = NULL, PolicyDocument, Description = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreatePolicy",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .iam$create_policy_input(PolicyName = PolicyName, Path = Path, PolicyDocument = PolicyDocument, Description = Description, Tags = Tags)
  output <- .iam$create_policy_output()
  config <- get_config()
  svc <- .iam$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$create_policy <- iam_create_policy

#' Creates a new version of the specified managed policy
#'
#' @description
#' Creates a new version of the specified managed policy. To update a managed policy, you create a new policy version. A managed policy can have up to five versions. If the policy has five versions, you must delete an existing version using [`delete_policy_version`][iam_delete_policy_version] before you create a new version.
#'
#' See [https://www.paws-r-sdk.com/docs/iam_create_policy_version/](https://www.paws-r-sdk.com/docs/iam_create_policy_version/) for full documentation.
#'
#' @param PolicyArn &#91;required&#93; The Amazon Resource Name (ARN) of the IAM policy to which you want to
#' add a new version.
#' 
#' For more information about ARNs, see [Amazon Resource Names
#' (ARNs)](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html)
#' in the *Amazon Web Services General Reference*.
#' @param PolicyDocument &#91;required&#93; The JSON policy document that you want to use as the content for this
#' new version of the policy.
#' 
#' You must provide policies in JSON format in IAM. However, for
#' CloudFormation templates formatted in YAML, you can provide the policy
#' in JSON or YAML format. CloudFormation always converts a YAML policy to
#' JSON format before submitting it to IAM.
#' 
#' The maximum length of the policy document that you can pass in this
#' operation, including whitespace, is listed below. To view the maximum
#' character counts of a managed policy with no whitespaces, see [IAM and
#' STS character
#' quotas](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html#reference_iam-quotas-entity-length).
#' 
#' The [regex pattern](https://en.wikipedia.org/wiki/Regex) used to
#' validate this parameter is a string of characters consisting of the
#' following:
#' 
#' -   Any printable ASCII character ranging from the space character
#'     (``U+0020``) through the end of the ASCII character range
#' 
#' -   The printable characters in the Basic Latin and Latin-1 Supplement
#'     character set (through ``U+00FF``)
#' 
#' -   The special characters tab (``U+0009``), line feed (``U+000A``), and
#'     carriage return (``U+000D``)
#' @param SetAsDefault Specifies whether to set this version as the policy's default version.
#' 
#' When this parameter is `true`, the new policy version becomes the
#' operative version. That is, it becomes the version that is in effect for
#' the IAM users, groups, and roles that the policy is attached to.
#' 
#' For more information about managed policy versions, see [Versioning for
#' managed
#' policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_managed-versioning.html)
#' in the *IAM User Guide*.
#'
#' @keywords internal
#'
#' @rdname iam_create_policy_version
iam_create_policy_version <- function(PolicyArn, PolicyDocument, SetAsDefault = NULL) {
  op <- new_operation(
    name = "CreatePolicyVersion",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .iam$create_policy_version_input(PolicyArn = PolicyArn, PolicyDocument = PolicyDocument, SetAsDefault = SetAsDefault)
  output <- .iam$create_policy_version_output()
  config <- get_config()
  svc <- .iam$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$create_policy_version <- iam_create_policy_version

#' Creates a new role for your Amazon Web Services account
#'
#' @description
#' Creates a new role for your Amazon Web Services account.
#'
#' See [https://www.paws-r-sdk.com/docs/iam_create_role/](https://www.paws-r-sdk.com/docs/iam_create_role/) for full documentation.
#'
#' @param Path The path to the role. For more information about paths, see [IAM
#' Identifiers](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html)
#' in the *IAM User Guide*.
#' 
#' This parameter is optional. If it is not included, it defaults to a
#' slash (/).
#' 
#' This parameter allows (through its [regex
#' pattern](https://en.wikipedia.org/wiki/Regex)) a string of characters
#' consisting of either a forward slash (/) by itself or a string that must
#' begin and end with forward slashes. In addition, it can contain any
#' ASCII character from the ! (``U+0021``) through the DEL character
#' (``U+007F``), including most punctuation characters, digits, and upper and
#' lowercased letters.
#' @param RoleName &#91;required&#93; The name of the role to create.
#' 
#' IAM user, group, role, and policy names must be unique within the
#' account. Names are not distinguished by case. For example, you cannot
#' create resources named both "MyResource" and "myresource".
#' 
#' This parameter allows (through its [regex
#' pattern](https://en.wikipedia.org/wiki/Regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: _+=,.@@-
#' @param AssumeRolePolicyDocument &#91;required&#93; The trust relationship policy document that grants an entity permission
#' to assume the role.
#' 
#' In IAM, you must provide a JSON policy that has been converted to a
#' string. However, for CloudFormation templates formatted in YAML, you can
#' provide the policy in JSON or YAML format. CloudFormation always
#' converts a YAML policy to JSON format before submitting it to IAM.
#' 
#' The [regex pattern](https://en.wikipedia.org/wiki/Regex) used to
#' validate this parameter is a string of characters consisting of the
#' following:
#' 
#' -   Any printable ASCII character ranging from the space character
#'     (``U+0020``) through the end of the ASCII character range
#' 
#' -   The printable characters in the Basic Latin and Latin-1 Supplement
#'     character set (through ``U+00FF``)
#' 
#' -   The special characters tab (``U+0009``), line feed (``U+000A``), and
#'     carriage return (``U+000D``)
#' 
#' Upon success, the response includes the same trust policy in JSON
#' format.
#' @param Description A description of the role.
#' @param MaxSessionDuration The maximum session duration (in seconds) that you want to set for the
#' specified role. If you do not specify a value for this setting, the
#' default value of one hour is applied. This setting can have a value from
#' 1 hour to 12 hours.
#' 
#' Anyone who assumes the role from the CLI or API can use the
#' `DurationSeconds` API parameter or the `duration-seconds` CLI parameter
#' to request a longer session. The `MaxSessionDuration` setting determines
#' the maximum duration that can be requested using the `DurationSeconds`
#' parameter. If users don't specify a value for the `DurationSeconds`
#' parameter, their security credentials are valid for one hour by default.
#' This applies when you use the `AssumeRole*` API operations or the
#' `assume-role*` CLI operations but does not apply when you use those
#' operations to create a console URL. For more information, see [Using IAM
#' roles](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_manage-assume.html)
#' in the *IAM User Guide*.
#' @param PermissionsBoundary The ARN of the managed policy that is used to set the permissions
#' boundary for the role.
#' 
#' A permissions boundary policy defines the maximum permissions that
#' identity-based policies can grant to an entity, but does not grant
#' permissions. Permissions boundaries do not define the maximum
#' permissions that a resource-based policy can grant to an entity. To
#' learn more, see [Permissions boundaries for IAM
#' entities](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_boundaries.html)
#' in the *IAM User Guide*.
#' 
#' For more information about policy types, see [Policy
#' types](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html#access_policy-types)
#' in the *IAM User Guide*.
#' @param Tags A list of tags that you want to attach to the new role. Each tag
#' consists of a key name and an associated value. For more information
#' about tagging, see [Tagging IAM
#' resources](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html)
#' in the *IAM User Guide*.
#' 
#' If any one of the tags is invalid or if you exceed the allowed maximum
#' number of tags, then the entire request fails and the resource is not
#' created.
#'
#' @keywords internal
#'
#' @rdname iam_create_role
iam_create_role <- function(Path = NULL, RoleName, AssumeRolePolicyDocument, Description = NULL, MaxSessionDuration = NULL, PermissionsBoundary = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateRole",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .iam$create_role_input(Path = Path, RoleName = RoleName, AssumeRolePolicyDocument = AssumeRolePolicyDocument, Description = Description, MaxSessionDuration = MaxSessionDuration, PermissionsBoundary = PermissionsBoundary, Tags = Tags)
  output <- .iam$create_role_output()
  config <- get_config()
  svc <- .iam$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$create_role <- iam_create_role

#' Creates an IAM resource that describes an identity provider (IdP) that
#' supports SAML 2
#'
#' @description
#' Creates an IAM resource that describes an identity provider (IdP) that supports SAML 2.0.
#'
#' See [https://www.paws-r-sdk.com/docs/iam_create_saml_provider/](https://www.paws-r-sdk.com/docs/iam_create_saml_provider/) for full documentation.
#'
#' @param SAMLMetadataDocument &#91;required&#93; An XML document generated by an identity provider (IdP) that supports
#' SAML 2.0. The document includes the issuer's name, expiration
#' information, and keys that can be used to validate the SAML
#' authentication response (assertions) that are received from the IdP. You
#' must generate the metadata document using the identity management
#' software that is used as your organization's IdP.
#' 
#' For more information, see [About SAML 2.0-based
#' federation](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_saml.html)
#' in the *IAM User Guide*
#' @param Name &#91;required&#93; The name of the provider to create.
#' 
#' This parameter allows (through its [regex
#' pattern](https://en.wikipedia.org/wiki/Regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: _+=,.@@-
#' @param Tags A list of tags that you want to attach to the new IAM SAML provider.
#' Each tag consists of a key name and an associated value. For more
#' information about tagging, see [Tagging IAM
#' resources](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html)
#' in the *IAM User Guide*.
#' 
#' If any one of the tags is invalid or if you exceed the allowed maximum
#' number of tags, then the entire request fails and the resource is not
#' created.
#'
#' @keywords internal
#'
#' @rdname iam_create_saml_provider
iam_create_saml_provider <- function(SAMLMetadataDocument, Name, Tags = NULL) {
  op <- new_operation(
    name = "CreateSAMLProvider",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .iam$create_saml_provider_input(SAMLMetadataDocument = SAMLMetadataDocument, Name = Name, Tags = Tags)
  output <- .iam$create_saml_provider_output()
  config <- get_config()
  svc <- .iam$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$create_saml_provider <- iam_create_saml_provider

#' Creates an IAM role that is linked to a specific Amazon Web Services
#' service
#'
#' @description
#' Creates an IAM role that is linked to a specific Amazon Web Services service. The service controls the attached policies and when the role can be deleted. This helps ensure that the service is not broken by an unexpectedly changed or deleted role, which could put your Amazon Web Services resources into an unknown state. Allowing the service to control the role helps improve service stability and proper cleanup when a service and its role are no longer needed. For more information, see [Using service-linked roles](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_create-service-linked-role.html) in the *IAM User Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/iam_create_service_linked_role/](https://www.paws-r-sdk.com/docs/iam_create_service_linked_role/) for full documentation.
#'
#' @param AWSServiceName &#91;required&#93; The service principal for the Amazon Web Services service to which this
#' role is attached. You use a string similar to a URL but without the
#' http:// in front. For example: `elasticbeanstalk.amazonaws.com`.
#' 
#' Service principals are unique and case-sensitive. To find the exact
#' service principal for your service-linked role, see [Amazon Web Services
#' services that work with
#' IAM](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-services-that-work-with-iam.html)
#' in the *IAM User Guide*. Look for the services that have **Yes** in the
#' **Service-Linked Role** column. Choose the **Yes** link to view the
#' service-linked role documentation for that service.
#' @param Description The description of the role.
#' @param CustomSuffix A string that you provide, which is combined with the service-provided
#' prefix to form the complete role name. If you make multiple requests for
#' the same service, then you must supply a different `CustomSuffix` for
#' each request. Otherwise the request fails with a duplicate role name
#' error. For example, you could add `-1` or `-debug` to the suffix.
#' 
#' Some services do not support the `CustomSuffix` parameter. If you
#' provide an optional suffix and the operation fails, try the operation
#' again without the suffix.
#'
#' @keywords internal
#'
#' @rdname iam_create_service_linked_role
iam_create_service_linked_role <- function(AWSServiceName, Description = NULL, CustomSuffix = NULL) {
  op <- new_operation(
    name = "CreateServiceLinkedRole",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .iam$create_service_linked_role_input(AWSServiceName = AWSServiceName, Description = Description, CustomSuffix = CustomSuffix)
  output <- .iam$create_service_linked_role_output()
  config <- get_config()
  svc <- .iam$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$create_service_linked_role <- iam_create_service_linked_role

#' Generates a set of credentials consisting of a user name and password
#' that can be used to access the service specified in the request
#'
#' @description
#' Generates a set of credentials consisting of a user name and password that can be used to access the service specified in the request. These credentials are generated by IAM, and can be used only for the specified service.
#'
#' See [https://www.paws-r-sdk.com/docs/iam_create_service_specific_credential/](https://www.paws-r-sdk.com/docs/iam_create_service_specific_credential/) for full documentation.
#'
#' @param UserName &#91;required&#93; The name of the IAM user that is to be associated with the credentials.
#' The new service-specific credentials have the same permissions as the
#' associated user except that they can be used only to access the
#' specified service.
#' 
#' This parameter allows (through its [regex
#' pattern](https://en.wikipedia.org/wiki/Regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: _+=,.@@-
#' @param ServiceName &#91;required&#93; The name of the Amazon Web Services service that is to be associated
#' with the credentials. The service you specify here is the only service
#' that can be accessed using these credentials.
#'
#' @keywords internal
#'
#' @rdname iam_create_service_specific_credential
iam_create_service_specific_credential <- function(UserName, ServiceName) {
  op <- new_operation(
    name = "CreateServiceSpecificCredential",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .iam$create_service_specific_credential_input(UserName = UserName, ServiceName = ServiceName)
  output <- .iam$create_service_specific_credential_output()
  config <- get_config()
  svc <- .iam$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$create_service_specific_credential <- iam_create_service_specific_credential

#' Creates a new IAM user for your Amazon Web Services account
#'
#' @description
#' Creates a new IAM user for your Amazon Web Services account.
#'
#' See [https://www.paws-r-sdk.com/docs/iam_create_user/](https://www.paws-r-sdk.com/docs/iam_create_user/) for full documentation.
#'
#' @param Path The path for the user name. For more information about paths, see [IAM
#' identifiers](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html)
#' in the *IAM User Guide*.
#' 
#' This parameter is optional. If it is not included, it defaults to a
#' slash (/).
#' 
#' This parameter allows (through its [regex
#' pattern](https://en.wikipedia.org/wiki/Regex)) a string of characters
#' consisting of either a forward slash (/) by itself or a string that must
#' begin and end with forward slashes. In addition, it can contain any
#' ASCII character from the ! (``U+0021``) through the DEL character
#' (``U+007F``), including most punctuation characters, digits, and upper and
#' lowercased letters.
#' @param UserName &#91;required&#93; The name of the user to create.
#' 
#' IAM user, group, role, and policy names must be unique within the
#' account. Names are not distinguished by case. For example, you cannot
#' create resources named both "MyResource" and "myresource".
#' @param PermissionsBoundary The ARN of the managed policy that is used to set the permissions
#' boundary for the user.
#' 
#' A permissions boundary policy defines the maximum permissions that
#' identity-based policies can grant to an entity, but does not grant
#' permissions. Permissions boundaries do not define the maximum
#' permissions that a resource-based policy can grant to an entity. To
#' learn more, see [Permissions boundaries for IAM
#' entities](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_boundaries.html)
#' in the *IAM User Guide*.
#' 
#' For more information about policy types, see [Policy
#' types](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html#access_policy-types)
#' in the *IAM User Guide*.
#' @param Tags A list of tags that you want to attach to the new user. Each tag
#' consists of a key name and an associated value. For more information
#' about tagging, see [Tagging IAM
#' resources](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html)
#' in the *IAM User Guide*.
#' 
#' If any one of the tags is invalid or if you exceed the allowed maximum
#' number of tags, then the entire request fails and the resource is not
#' created.
#'
#' @keywords internal
#'
#' @rdname iam_create_user
iam_create_user <- function(Path = NULL, UserName, PermissionsBoundary = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateUser",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .iam$create_user_input(Path = Path, UserName = UserName, PermissionsBoundary = PermissionsBoundary, Tags = Tags)
  output <- .iam$create_user_output()
  config <- get_config()
  svc <- .iam$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$create_user <- iam_create_user

#' Creates a new virtual MFA device for the Amazon Web Services account
#'
#' @description
#' Creates a new virtual MFA device for the Amazon Web Services account. After creating the virtual MFA, use [`enable_mfa_device`][iam_enable_mfa_device] to attach the MFA device to an IAM user. For more information about creating and working with virtual MFA devices, see [Using a virtual MFA device](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_mfa_enable_virtual.html) in the *IAM User Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/iam_create_virtual_mfa_device/](https://www.paws-r-sdk.com/docs/iam_create_virtual_mfa_device/) for full documentation.
#'
#' @param Path The path for the virtual MFA device. For more information about paths,
#' see [IAM
#' identifiers](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html)
#' in the *IAM User Guide*.
#' 
#' This parameter is optional. If it is not included, it defaults to a
#' slash (/).
#' 
#' This parameter allows (through its [regex
#' pattern](https://en.wikipedia.org/wiki/Regex)) a string of characters
#' consisting of either a forward slash (/) by itself or a string that must
#' begin and end with forward slashes. In addition, it can contain any
#' ASCII character from the ! (``U+0021``) through the DEL character
#' (``U+007F``), including most punctuation characters, digits, and upper and
#' lowercased letters.
#' @param VirtualMFADeviceName &#91;required&#93; The name of the virtual MFA device, which must be unique. Use with path
#' to uniquely identify a virtual MFA device.
#' 
#' This parameter allows (through its [regex
#' pattern](https://en.wikipedia.org/wiki/Regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: _+=,.@@-
#' @param Tags A list of tags that you want to attach to the new IAM virtual MFA
#' device. Each tag consists of a key name and an associated value. For
#' more information about tagging, see [Tagging IAM
#' resources](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html)
#' in the *IAM User Guide*.
#' 
#' If any one of the tags is invalid or if you exceed the allowed maximum
#' number of tags, then the entire request fails and the resource is not
#' created.
#'
#' @keywords internal
#'
#' @rdname iam_create_virtual_mfa_device
iam_create_virtual_mfa_device <- function(Path = NULL, VirtualMFADeviceName, Tags = NULL) {
  op <- new_operation(
    name = "CreateVirtualMFADevice",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .iam$create_virtual_mfa_device_input(Path = Path, VirtualMFADeviceName = VirtualMFADeviceName, Tags = Tags)
  output <- .iam$create_virtual_mfa_device_output()
  config <- get_config()
  svc <- .iam$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$create_virtual_mfa_device <- iam_create_virtual_mfa_device

#' Deactivates the specified MFA device and removes it from association
#' with the user name for which it was originally enabled
#'
#' @description
#' Deactivates the specified MFA device and removes it from association with the user name for which it was originally enabled.
#'
#' See [https://www.paws-r-sdk.com/docs/iam_deactivate_mfa_device/](https://www.paws-r-sdk.com/docs/iam_deactivate_mfa_device/) for full documentation.
#'
#' @param UserName The name of the user whose MFA device you want to deactivate.
#' 
#' This parameter is optional. If no user name is included, it defaults to
#' the principal making the request. When you make this request with root
#' user credentials, you must use an
#' [AssumeRoot](https://docs.aws.amazon.com/STS/latest/APIReference/API_AssumeRoot.html)
#' session to omit the user name.
#' 
#' This parameter allows (through its [regex
#' pattern](https://en.wikipedia.org/wiki/Regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: _+=,.@@-
#' @param SerialNumber &#91;required&#93; The serial number that uniquely identifies the MFA device. For virtual
#' MFA devices, the serial number is the device ARN.
#' 
#' This parameter allows (through its [regex
#' pattern](https://en.wikipedia.org/wiki/Regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: =,.@@:/-
#'
#' @keywords internal
#'
#' @rdname iam_deactivate_mfa_device
iam_deactivate_mfa_device <- function(UserName = NULL, SerialNumber) {
  op <- new_operation(
    name = "DeactivateMFADevice",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .iam$deactivate_mfa_device_input(UserName = UserName, SerialNumber = SerialNumber)
  output <- .iam$deactivate_mfa_device_output()
  config <- get_config()
  svc <- .iam$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$deactivate_mfa_device <- iam_deactivate_mfa_device

#' Deletes the access key pair associated with the specified IAM user
#'
#' @description
#' Deletes the access key pair associated with the specified IAM user.
#'
#' See [https://www.paws-r-sdk.com/docs/iam_delete_access_key/](https://www.paws-r-sdk.com/docs/iam_delete_access_key/) for full documentation.
#'
#' @param UserName The name of the user whose access key pair you want to delete.
#' 
#' This parameter allows (through its [regex
#' pattern](https://en.wikipedia.org/wiki/Regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: _+=,.@@-
#' @param AccessKeyId &#91;required&#93; The access key ID for the access key ID and secret access key you want
#' to delete.
#' 
#' This parameter allows (through its [regex
#' pattern](https://en.wikipedia.org/wiki/Regex)) a string of characters
#' that can consist of any upper or lowercased letter or digit.
#'
#' @keywords internal
#'
#' @rdname iam_delete_access_key
iam_delete_access_key <- function(UserName = NULL, AccessKeyId) {
  op <- new_operation(
    name = "DeleteAccessKey",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .iam$delete_access_key_input(UserName = UserName, AccessKeyId = AccessKeyId)
  output <- .iam$delete_access_key_output()
  config <- get_config()
  svc <- .iam$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$delete_access_key <- iam_delete_access_key

#' Deletes the specified Amazon Web Services account alias
#'
#' @description
#' Deletes the specified Amazon Web Services account alias. For information about using an Amazon Web Services account alias, see [Creating, deleting, and listing an Amazon Web Services account alias](https://docs.aws.amazon.com/IAM/latest/UserGuide/account-alias-create.html) in the *Amazon Web Services Sign-In User Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/iam_delete_account_alias/](https://www.paws-r-sdk.com/docs/iam_delete_account_alias/) for full documentation.
#'
#' @param AccountAlias &#91;required&#93; The name of the account alias to delete.
#' 
#' This parameter allows (through its [regex
#' pattern](https://en.wikipedia.org/wiki/Regex)) a string of characters
#' consisting of lowercase letters, digits, and dashes. You cannot start or
#' finish with a dash, nor can you have two dashes in a row.
#'
#' @keywords internal
#'
#' @rdname iam_delete_account_alias
iam_delete_account_alias <- function(AccountAlias) {
  op <- new_operation(
    name = "DeleteAccountAlias",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .iam$delete_account_alias_input(AccountAlias = AccountAlias)
  output <- .iam$delete_account_alias_output()
  config <- get_config()
  svc <- .iam$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$delete_account_alias <- iam_delete_account_alias

#' Deletes the password policy for the Amazon Web Services account
#'
#' @description
#' Deletes the password policy for the Amazon Web Services account. There are no parameters.
#'
#' See [https://www.paws-r-sdk.com/docs/iam_delete_account_password_policy/](https://www.paws-r-sdk.com/docs/iam_delete_account_password_policy/) for full documentation.
#'

#'
#' @keywords internal
#'
#' @rdname iam_delete_account_password_policy
iam_delete_account_password_policy <- function() {
  op <- new_operation(
    name = "DeleteAccountPasswordPolicy",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .iam$delete_account_password_policy_input()
  output <- .iam$delete_account_password_policy_output()
  config <- get_config()
  svc <- .iam$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$delete_account_password_policy <- iam_delete_account_password_policy

#' Deletes the specified IAM group
#'
#' @description
#' Deletes the specified IAM group. The group must not contain any users or have any attached policies.
#'
#' See [https://www.paws-r-sdk.com/docs/iam_delete_group/](https://www.paws-r-sdk.com/docs/iam_delete_group/) for full documentation.
#'
#' @param GroupName &#91;required&#93; The name of the IAM group to delete.
#' 
#' This parameter allows (through its [regex
#' pattern](https://en.wikipedia.org/wiki/Regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: _+=,.@@-
#'
#' @keywords internal
#'
#' @rdname iam_delete_group
iam_delete_group <- function(GroupName) {
  op <- new_operation(
    name = "DeleteGroup",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .iam$delete_group_input(GroupName = GroupName)
  output <- .iam$delete_group_output()
  config <- get_config()
  svc <- .iam$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$delete_group <- iam_delete_group

#' Deletes the specified inline policy that is embedded in the specified
#' IAM group
#'
#' @description
#' Deletes the specified inline policy that is embedded in the specified IAM group.
#'
#' See [https://www.paws-r-sdk.com/docs/iam_delete_group_policy/](https://www.paws-r-sdk.com/docs/iam_delete_group_policy/) for full documentation.
#'
#' @param GroupName &#91;required&#93; The name (friendly name, not ARN) identifying the group that the policy
#' is embedded in.
#' 
#' This parameter allows (through its [regex
#' pattern](https://en.wikipedia.org/wiki/Regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: _+=,.@@-
#' @param PolicyName &#91;required&#93; The name identifying the policy document to delete.
#' 
#' This parameter allows (through its [regex
#' pattern](https://en.wikipedia.org/wiki/Regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: _+=,.@@-
#'
#' @keywords internal
#'
#' @rdname iam_delete_group_policy
iam_delete_group_policy <- function(GroupName, PolicyName) {
  op <- new_operation(
    name = "DeleteGroupPolicy",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .iam$delete_group_policy_input(GroupName = GroupName, PolicyName = PolicyName)
  output <- .iam$delete_group_policy_output()
  config <- get_config()
  svc <- .iam$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$delete_group_policy <- iam_delete_group_policy

#' Deletes the specified instance profile
#'
#' @description
#' Deletes the specified instance profile. The instance profile must not have an associated role.
#'
#' See [https://www.paws-r-sdk.com/docs/iam_delete_instance_profile/](https://www.paws-r-sdk.com/docs/iam_delete_instance_profile/) for full documentation.
#'
#' @param InstanceProfileName &#91;required&#93; The name of the instance profile to delete.
#' 
#' This parameter allows (through its [regex
#' pattern](https://en.wikipedia.org/wiki/Regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: _+=,.@@-
#'
#' @keywords internal
#'
#' @rdname iam_delete_instance_profile
iam_delete_instance_profile <- function(InstanceProfileName) {
  op <- new_operation(
    name = "DeleteInstanceProfile",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .iam$delete_instance_profile_input(InstanceProfileName = InstanceProfileName)
  output <- .iam$delete_instance_profile_output()
  config <- get_config()
  svc <- .iam$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$delete_instance_profile <- iam_delete_instance_profile

#' Deletes the password for the specified IAM user, For more information,
#' see Managing passwords for IAM users
#'
#' @description
#' Deletes the password for the specified IAM user, For more information, see [Managing passwords for IAM users](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_passwords_admin-change-user.html).
#'
#' See [https://www.paws-r-sdk.com/docs/iam_delete_login_profile/](https://www.paws-r-sdk.com/docs/iam_delete_login_profile/) for full documentation.
#'
#' @param UserName The name of the user whose password you want to delete.
#' 
#' This parameter is optional. If no user name is included, it defaults to
#' the principal making the request. When you make this request with root
#' user credentials, you must use an
#' [AssumeRoot](https://docs.aws.amazon.com/STS/latest/APIReference/API_AssumeRoot.html)
#' session to omit the user name.
#' 
#' This parameter allows (through its [regex
#' pattern](https://en.wikipedia.org/wiki/Regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: _+=,.@@-
#'
#' @keywords internal
#'
#' @rdname iam_delete_login_profile
iam_delete_login_profile <- function(UserName = NULL) {
  op <- new_operation(
    name = "DeleteLoginProfile",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .iam$delete_login_profile_input(UserName = UserName)
  output <- .iam$delete_login_profile_output()
  config <- get_config()
  svc <- .iam$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$delete_login_profile <- iam_delete_login_profile

#' Deletes an OpenID Connect identity provider (IdP) resource object in IAM
#'
#' @description
#' Deletes an OpenID Connect identity provider (IdP) resource object in IAM.
#'
#' See [https://www.paws-r-sdk.com/docs/iam_delete_open_id_connect_provider/](https://www.paws-r-sdk.com/docs/iam_delete_open_id_connect_provider/) for full documentation.
#'
#' @param OpenIDConnectProviderArn &#91;required&#93; The Amazon Resource Name (ARN) of the IAM OpenID Connect provider
#' resource object to delete. You can get a list of OpenID Connect provider
#' resource ARNs by using the
#' [`list_open_id_connect_providers`][iam_list_open_id_connect_providers]
#' operation.
#'
#' @keywords internal
#'
#' @rdname iam_delete_open_id_connect_provider
iam_delete_open_id_connect_provider <- function(OpenIDConnectProviderArn) {
  op <- new_operation(
    name = "DeleteOpenIDConnectProvider",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .iam$delete_open_id_connect_provider_input(OpenIDConnectProviderArn = OpenIDConnectProviderArn)
  output <- .iam$delete_open_id_connect_provider_output()
  config <- get_config()
  svc <- .iam$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$delete_open_id_connect_provider <- iam_delete_open_id_connect_provider

#' Deletes the specified managed policy
#'
#' @description
#' Deletes the specified managed policy.
#'
#' See [https://www.paws-r-sdk.com/docs/iam_delete_policy/](https://www.paws-r-sdk.com/docs/iam_delete_policy/) for full documentation.
#'
#' @param PolicyArn &#91;required&#93; The Amazon Resource Name (ARN) of the IAM policy you want to delete.
#' 
#' For more information about ARNs, see [Amazon Resource Names
#' (ARNs)](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html)
#' in the *Amazon Web Services General Reference*.
#'
#' @keywords internal
#'
#' @rdname iam_delete_policy
iam_delete_policy <- function(PolicyArn) {
  op <- new_operation(
    name = "DeletePolicy",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .iam$delete_policy_input(PolicyArn = PolicyArn)
  output <- .iam$delete_policy_output()
  config <- get_config()
  svc <- .iam$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$delete_policy <- iam_delete_policy

#' Deletes the specified version from the specified managed policy
#'
#' @description
#' Deletes the specified version from the specified managed policy.
#'
#' See [https://www.paws-r-sdk.com/docs/iam_delete_policy_version/](https://www.paws-r-sdk.com/docs/iam_delete_policy_version/) for full documentation.
#'
#' @param PolicyArn &#91;required&#93; The Amazon Resource Name (ARN) of the IAM policy from which you want to
#' delete a version.
#' 
#' For more information about ARNs, see [Amazon Resource Names
#' (ARNs)](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html)
#' in the *Amazon Web Services General Reference*.
#' @param VersionId &#91;required&#93; The policy version to delete.
#' 
#' This parameter allows (through its [regex
#' pattern](https://en.wikipedia.org/wiki/Regex)) a string of characters
#' that consists of the lowercase letter 'v' followed by one or two digits,
#' and optionally followed by a period '.' and a string of letters and
#' digits.
#' 
#' For more information about managed policy versions, see [Versioning for
#' managed
#' policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_managed-versioning.html)
#' in the *IAM User Guide*.
#'
#' @keywords internal
#'
#' @rdname iam_delete_policy_version
iam_delete_policy_version <- function(PolicyArn, VersionId) {
  op <- new_operation(
    name = "DeletePolicyVersion",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .iam$delete_policy_version_input(PolicyArn = PolicyArn, VersionId = VersionId)
  output <- .iam$delete_policy_version_output()
  config <- get_config()
  svc <- .iam$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$delete_policy_version <- iam_delete_policy_version

#' Deletes the specified role
#'
#' @description
#' Deletes the specified role. Unlike the Amazon Web Services Management Console, when you delete a role programmatically, you must delete the items attached to the role manually, or the deletion fails. For more information, see [Deleting an IAM role](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_manage_delete.html#roles-managingrole-deleting-cli). Before attempting to delete a role, remove the following attached items:
#'
#' See [https://www.paws-r-sdk.com/docs/iam_delete_role/](https://www.paws-r-sdk.com/docs/iam_delete_role/) for full documentation.
#'
#' @param RoleName &#91;required&#93; The name of the role to delete.
#' 
#' This parameter allows (through its [regex
#' pattern](https://en.wikipedia.org/wiki/Regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: _+=,.@@-
#'
#' @keywords internal
#'
#' @rdname iam_delete_role
iam_delete_role <- function(RoleName) {
  op <- new_operation(
    name = "DeleteRole",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .iam$delete_role_input(RoleName = RoleName)
  output <- .iam$delete_role_output()
  config <- get_config()
  svc <- .iam$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$delete_role <- iam_delete_role

#' Deletes the permissions boundary for the specified IAM role
#'
#' @description
#' Deletes the permissions boundary for the specified IAM role.
#'
#' See [https://www.paws-r-sdk.com/docs/iam_delete_role_permissions_boundary/](https://www.paws-r-sdk.com/docs/iam_delete_role_permissions_boundary/) for full documentation.
#'
#' @param RoleName &#91;required&#93; The name (friendly name, not ARN) of the IAM role from which you want to
#' remove the permissions boundary.
#'
#' @keywords internal
#'
#' @rdname iam_delete_role_permissions_boundary
iam_delete_role_permissions_boundary <- function(RoleName) {
  op <- new_operation(
    name = "DeleteRolePermissionsBoundary",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .iam$delete_role_permissions_boundary_input(RoleName = RoleName)
  output <- .iam$delete_role_permissions_boundary_output()
  config <- get_config()
  svc <- .iam$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$delete_role_permissions_boundary <- iam_delete_role_permissions_boundary

#' Deletes the specified inline policy that is embedded in the specified
#' IAM role
#'
#' @description
#' Deletes the specified inline policy that is embedded in the specified IAM role.
#'
#' See [https://www.paws-r-sdk.com/docs/iam_delete_role_policy/](https://www.paws-r-sdk.com/docs/iam_delete_role_policy/) for full documentation.
#'
#' @param RoleName &#91;required&#93; The name (friendly name, not ARN) identifying the role that the policy
#' is embedded in.
#' 
#' This parameter allows (through its [regex
#' pattern](https://en.wikipedia.org/wiki/Regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: _+=,.@@-
#' @param PolicyName &#91;required&#93; The name of the inline policy to delete from the specified IAM role.
#' 
#' This parameter allows (through its [regex
#' pattern](https://en.wikipedia.org/wiki/Regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: _+=,.@@-
#'
#' @keywords internal
#'
#' @rdname iam_delete_role_policy
iam_delete_role_policy <- function(RoleName, PolicyName) {
  op <- new_operation(
    name = "DeleteRolePolicy",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .iam$delete_role_policy_input(RoleName = RoleName, PolicyName = PolicyName)
  output <- .iam$delete_role_policy_output()
  config <- get_config()
  svc <- .iam$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$delete_role_policy <- iam_delete_role_policy

#' Deletes a SAML provider resource in IAM
#'
#' @description
#' Deletes a SAML provider resource in IAM.
#'
#' See [https://www.paws-r-sdk.com/docs/iam_delete_saml_provider/](https://www.paws-r-sdk.com/docs/iam_delete_saml_provider/) for full documentation.
#'
#' @param SAMLProviderArn &#91;required&#93; The Amazon Resource Name (ARN) of the SAML provider to delete.
#'
#' @keywords internal
#'
#' @rdname iam_delete_saml_provider
iam_delete_saml_provider <- function(SAMLProviderArn) {
  op <- new_operation(
    name = "DeleteSAMLProvider",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .iam$delete_saml_provider_input(SAMLProviderArn = SAMLProviderArn)
  output <- .iam$delete_saml_provider_output()
  config <- get_config()
  svc <- .iam$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$delete_saml_provider <- iam_delete_saml_provider

#' Deletes the specified SSH public key
#'
#' @description
#' Deletes the specified SSH public key.
#'
#' See [https://www.paws-r-sdk.com/docs/iam_delete_ssh_public_key/](https://www.paws-r-sdk.com/docs/iam_delete_ssh_public_key/) for full documentation.
#'
#' @param UserName &#91;required&#93; The name of the IAM user associated with the SSH public key.
#' 
#' This parameter allows (through its [regex
#' pattern](https://en.wikipedia.org/wiki/Regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: _+=,.@@-
#' @param SSHPublicKeyId &#91;required&#93; The unique identifier for the SSH public key.
#' 
#' This parameter allows (through its [regex
#' pattern](https://en.wikipedia.org/wiki/Regex)) a string of characters
#' that can consist of any upper or lowercased letter or digit.
#'
#' @keywords internal
#'
#' @rdname iam_delete_ssh_public_key
iam_delete_ssh_public_key <- function(UserName, SSHPublicKeyId) {
  op <- new_operation(
    name = "DeleteSSHPublicKey",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .iam$delete_ssh_public_key_input(UserName = UserName, SSHPublicKeyId = SSHPublicKeyId)
  output <- .iam$delete_ssh_public_key_output()
  config <- get_config()
  svc <- .iam$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$delete_ssh_public_key <- iam_delete_ssh_public_key

#' Deletes the specified server certificate
#'
#' @description
#' Deletes the specified server certificate.
#'
#' See [https://www.paws-r-sdk.com/docs/iam_delete_server_certificate/](https://www.paws-r-sdk.com/docs/iam_delete_server_certificate/) for full documentation.
#'
#' @param ServerCertificateName &#91;required&#93; The name of the server certificate you want to delete.
#' 
#' This parameter allows (through its [regex
#' pattern](https://en.wikipedia.org/wiki/Regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: _+=,.@@-
#'
#' @keywords internal
#'
#' @rdname iam_delete_server_certificate
iam_delete_server_certificate <- function(ServerCertificateName) {
  op <- new_operation(
    name = "DeleteServerCertificate",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .iam$delete_server_certificate_input(ServerCertificateName = ServerCertificateName)
  output <- .iam$delete_server_certificate_output()
  config <- get_config()
  svc <- .iam$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$delete_server_certificate <- iam_delete_server_certificate

#' Submits a service-linked role deletion request and returns a
#' DeletionTaskId, which you can use to check the status of the deletion
#'
#' @description
#' Submits a service-linked role deletion request and returns a `DeletionTaskId`, which you can use to check the status of the deletion. Before you call this operation, confirm that the role has no active sessions and that any resources used by the role in the linked service are deleted. If you call this operation more than once for the same service-linked role and an earlier deletion task is not complete, then the `DeletionTaskId` of the earlier request is returned.
#'
#' See [https://www.paws-r-sdk.com/docs/iam_delete_service_linked_role/](https://www.paws-r-sdk.com/docs/iam_delete_service_linked_role/) for full documentation.
#'
#' @param RoleName &#91;required&#93; The name of the service-linked role to be deleted.
#'
#' @keywords internal
#'
#' @rdname iam_delete_service_linked_role
iam_delete_service_linked_role <- function(RoleName) {
  op <- new_operation(
    name = "DeleteServiceLinkedRole",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .iam$delete_service_linked_role_input(RoleName = RoleName)
  output <- .iam$delete_service_linked_role_output()
  config <- get_config()
  svc <- .iam$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$delete_service_linked_role <- iam_delete_service_linked_role

#' Deletes the specified service-specific credential
#'
#' @description
#' Deletes the specified service-specific credential.
#'
#' See [https://www.paws-r-sdk.com/docs/iam_delete_service_specific_credential/](https://www.paws-r-sdk.com/docs/iam_delete_service_specific_credential/) for full documentation.
#'
#' @param UserName The name of the IAM user associated with the service-specific
#' credential. If this value is not specified, then the operation assumes
#' the user whose credentials are used to call the operation.
#' 
#' This parameter allows (through its [regex
#' pattern](https://en.wikipedia.org/wiki/Regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: _+=,.@@-
#' @param ServiceSpecificCredentialId &#91;required&#93; The unique identifier of the service-specific credential. You can get
#' this value by calling
#' [`list_service_specific_credentials`][iam_list_service_specific_credentials].
#' 
#' This parameter allows (through its [regex
#' pattern](https://en.wikipedia.org/wiki/Regex)) a string of characters
#' that can consist of any upper or lowercased letter or digit.
#'
#' @keywords internal
#'
#' @rdname iam_delete_service_specific_credential
iam_delete_service_specific_credential <- function(UserName = NULL, ServiceSpecificCredentialId) {
  op <- new_operation(
    name = "DeleteServiceSpecificCredential",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .iam$delete_service_specific_credential_input(UserName = UserName, ServiceSpecificCredentialId = ServiceSpecificCredentialId)
  output <- .iam$delete_service_specific_credential_output()
  config <- get_config()
  svc <- .iam$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$delete_service_specific_credential <- iam_delete_service_specific_credential

#' Deletes a signing certificate associated with the specified IAM user
#'
#' @description
#' Deletes a signing certificate associated with the specified IAM user.
#'
#' See [https://www.paws-r-sdk.com/docs/iam_delete_signing_certificate/](https://www.paws-r-sdk.com/docs/iam_delete_signing_certificate/) for full documentation.
#'
#' @param UserName The name of the user the signing certificate belongs to.
#' 
#' This parameter allows (through its [regex
#' pattern](https://en.wikipedia.org/wiki/Regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: _+=,.@@-
#' @param CertificateId &#91;required&#93; The ID of the signing certificate to delete.
#' 
#' The format of this parameter, as described by its
#' [regex](https://en.wikipedia.org/wiki/Regex) pattern, is a string of
#' characters that can be upper- or lower-cased letters or digits.
#'
#' @keywords internal
#'
#' @rdname iam_delete_signing_certificate
iam_delete_signing_certificate <- function(UserName = NULL, CertificateId) {
  op <- new_operation(
    name = "DeleteSigningCertificate",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .iam$delete_signing_certificate_input(UserName = UserName, CertificateId = CertificateId)
  output <- .iam$delete_signing_certificate_output()
  config <- get_config()
  svc <- .iam$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$delete_signing_certificate <- iam_delete_signing_certificate

#' Deletes the specified IAM user
#'
#' @description
#' Deletes the specified IAM user. Unlike the Amazon Web Services Management Console, when you delete a user programmatically, you must delete the items attached to the user manually, or the deletion fails. For more information, see [Deleting an IAM user](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_users_rename.html#id_users_deleting_cli). Before attempting to delete a user, remove the following items:
#'
#' See [https://www.paws-r-sdk.com/docs/iam_delete_user/](https://www.paws-r-sdk.com/docs/iam_delete_user/) for full documentation.
#'
#' @param UserName &#91;required&#93; The name of the user to delete.
#' 
#' This parameter allows (through its [regex
#' pattern](https://en.wikipedia.org/wiki/Regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: _+=,.@@-
#'
#' @keywords internal
#'
#' @rdname iam_delete_user
iam_delete_user <- function(UserName) {
  op <- new_operation(
    name = "DeleteUser",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .iam$delete_user_input(UserName = UserName)
  output <- .iam$delete_user_output()
  config <- get_config()
  svc <- .iam$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$delete_user <- iam_delete_user

#' Deletes the permissions boundary for the specified IAM user
#'
#' @description
#' Deletes the permissions boundary for the specified IAM user.
#'
#' See [https://www.paws-r-sdk.com/docs/iam_delete_user_permissions_boundary/](https://www.paws-r-sdk.com/docs/iam_delete_user_permissions_boundary/) for full documentation.
#'
#' @param UserName &#91;required&#93; The name (friendly name, not ARN) of the IAM user from which you want to
#' remove the permissions boundary.
#'
#' @keywords internal
#'
#' @rdname iam_delete_user_permissions_boundary
iam_delete_user_permissions_boundary <- function(UserName) {
  op <- new_operation(
    name = "DeleteUserPermissionsBoundary",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .iam$delete_user_permissions_boundary_input(UserName = UserName)
  output <- .iam$delete_user_permissions_boundary_output()
  config <- get_config()
  svc <- .iam$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$delete_user_permissions_boundary <- iam_delete_user_permissions_boundary

#' Deletes the specified inline policy that is embedded in the specified
#' IAM user
#'
#' @description
#' Deletes the specified inline policy that is embedded in the specified IAM user.
#'
#' See [https://www.paws-r-sdk.com/docs/iam_delete_user_policy/](https://www.paws-r-sdk.com/docs/iam_delete_user_policy/) for full documentation.
#'
#' @param UserName &#91;required&#93; The name (friendly name, not ARN) identifying the user that the policy
#' is embedded in.
#' 
#' This parameter allows (through its [regex
#' pattern](https://en.wikipedia.org/wiki/Regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: _+=,.@@-
#' @param PolicyName &#91;required&#93; The name identifying the policy document to delete.
#' 
#' This parameter allows (through its [regex
#' pattern](https://en.wikipedia.org/wiki/Regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: _+=,.@@-
#'
#' @keywords internal
#'
#' @rdname iam_delete_user_policy
iam_delete_user_policy <- function(UserName, PolicyName) {
  op <- new_operation(
    name = "DeleteUserPolicy",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .iam$delete_user_policy_input(UserName = UserName, PolicyName = PolicyName)
  output <- .iam$delete_user_policy_output()
  config <- get_config()
  svc <- .iam$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$delete_user_policy <- iam_delete_user_policy

#' Deletes a virtual MFA device
#'
#' @description
#' Deletes a virtual MFA device.
#'
#' See [https://www.paws-r-sdk.com/docs/iam_delete_virtual_mfa_device/](https://www.paws-r-sdk.com/docs/iam_delete_virtual_mfa_device/) for full documentation.
#'
#' @param SerialNumber &#91;required&#93; The serial number that uniquely identifies the MFA device. For virtual
#' MFA devices, the serial number is the same as the ARN.
#' 
#' This parameter allows (through its [regex
#' pattern](https://en.wikipedia.org/wiki/Regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: =,.@@:/-
#'
#' @keywords internal
#'
#' @rdname iam_delete_virtual_mfa_device
iam_delete_virtual_mfa_device <- function(SerialNumber) {
  op <- new_operation(
    name = "DeleteVirtualMFADevice",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .iam$delete_virtual_mfa_device_input(SerialNumber = SerialNumber)
  output <- .iam$delete_virtual_mfa_device_output()
  config <- get_config()
  svc <- .iam$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$delete_virtual_mfa_device <- iam_delete_virtual_mfa_device

#' Removes the specified managed policy from the specified IAM group
#'
#' @description
#' Removes the specified managed policy from the specified IAM group.
#'
#' See [https://www.paws-r-sdk.com/docs/iam_detach_group_policy/](https://www.paws-r-sdk.com/docs/iam_detach_group_policy/) for full documentation.
#'
#' @param GroupName &#91;required&#93; The name (friendly name, not ARN) of the IAM group to detach the policy
#' from.
#' 
#' This parameter allows (through its [regex
#' pattern](https://en.wikipedia.org/wiki/Regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: _+=,.@@-
#' @param PolicyArn &#91;required&#93; The Amazon Resource Name (ARN) of the IAM policy you want to detach.
#' 
#' For more information about ARNs, see [Amazon Resource Names
#' (ARNs)](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html)
#' in the *Amazon Web Services General Reference*.
#'
#' @keywords internal
#'
#' @rdname iam_detach_group_policy
iam_detach_group_policy <- function(GroupName, PolicyArn) {
  op <- new_operation(
    name = "DetachGroupPolicy",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .iam$detach_group_policy_input(GroupName = GroupName, PolicyArn = PolicyArn)
  output <- .iam$detach_group_policy_output()
  config <- get_config()
  svc <- .iam$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$detach_group_policy <- iam_detach_group_policy

#' Removes the specified managed policy from the specified role
#'
#' @description
#' Removes the specified managed policy from the specified role.
#'
#' See [https://www.paws-r-sdk.com/docs/iam_detach_role_policy/](https://www.paws-r-sdk.com/docs/iam_detach_role_policy/) for full documentation.
#'
#' @param RoleName &#91;required&#93; The name (friendly name, not ARN) of the IAM role to detach the policy
#' from.
#' 
#' This parameter allows (through its [regex
#' pattern](https://en.wikipedia.org/wiki/Regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: _+=,.@@-
#' @param PolicyArn &#91;required&#93; The Amazon Resource Name (ARN) of the IAM policy you want to detach.
#' 
#' For more information about ARNs, see [Amazon Resource Names
#' (ARNs)](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html)
#' in the *Amazon Web Services General Reference*.
#'
#' @keywords internal
#'
#' @rdname iam_detach_role_policy
iam_detach_role_policy <- function(RoleName, PolicyArn) {
  op <- new_operation(
    name = "DetachRolePolicy",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .iam$detach_role_policy_input(RoleName = RoleName, PolicyArn = PolicyArn)
  output <- .iam$detach_role_policy_output()
  config <- get_config()
  svc <- .iam$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$detach_role_policy <- iam_detach_role_policy

#' Removes the specified managed policy from the specified user
#'
#' @description
#' Removes the specified managed policy from the specified user.
#'
#' See [https://www.paws-r-sdk.com/docs/iam_detach_user_policy/](https://www.paws-r-sdk.com/docs/iam_detach_user_policy/) for full documentation.
#'
#' @param UserName &#91;required&#93; The name (friendly name, not ARN) of the IAM user to detach the policy
#' from.
#' 
#' This parameter allows (through its [regex
#' pattern](https://en.wikipedia.org/wiki/Regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: _+=,.@@-
#' @param PolicyArn &#91;required&#93; The Amazon Resource Name (ARN) of the IAM policy you want to detach.
#' 
#' For more information about ARNs, see [Amazon Resource Names
#' (ARNs)](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html)
#' in the *Amazon Web Services General Reference*.
#'
#' @keywords internal
#'
#' @rdname iam_detach_user_policy
iam_detach_user_policy <- function(UserName, PolicyArn) {
  op <- new_operation(
    name = "DetachUserPolicy",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .iam$detach_user_policy_input(UserName = UserName, PolicyArn = PolicyArn)
  output <- .iam$detach_user_policy_output()
  config <- get_config()
  svc <- .iam$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$detach_user_policy <- iam_detach_user_policy

#' Disables the management of privileged root user credentials across
#' member accounts in your organization
#'
#' @description
#' Disables the management of privileged root user credentials across member accounts in your organization. When you disable this feature, the management account and the delegated admininstrator for IAM can no longer manage root user credentials for member accounts in your organization.
#'
#' See [https://www.paws-r-sdk.com/docs/iam_disable_organizations_root_credentials_management/](https://www.paws-r-sdk.com/docs/iam_disable_organizations_root_credentials_management/) for full documentation.
#'

#'
#' @keywords internal
#'
#' @rdname iam_disable_organizations_root_credentials_management
iam_disable_organizations_root_credentials_management <- function() {
  op <- new_operation(
    name = "DisableOrganizationsRootCredentialsManagement",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .iam$disable_organizations_root_credentials_management_input()
  output <- .iam$disable_organizations_root_credentials_management_output()
  config <- get_config()
  svc <- .iam$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$disable_organizations_root_credentials_management <- iam_disable_organizations_root_credentials_management

#' Disables root user sessions for privileged tasks across member accounts
#' in your organization
#'
#' @description
#' Disables root user sessions for privileged tasks across member accounts in your organization. When you disable this feature, the management account and the delegated admininstrator for IAM can no longer perform privileged tasks on member accounts in your organization.
#'
#' See [https://www.paws-r-sdk.com/docs/iam_disable_organizations_root_sessions/](https://www.paws-r-sdk.com/docs/iam_disable_organizations_root_sessions/) for full documentation.
#'

#'
#' @keywords internal
#'
#' @rdname iam_disable_organizations_root_sessions
iam_disable_organizations_root_sessions <- function() {
  op <- new_operation(
    name = "DisableOrganizationsRootSessions",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .iam$disable_organizations_root_sessions_input()
  output <- .iam$disable_organizations_root_sessions_output()
  config <- get_config()
  svc <- .iam$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$disable_organizations_root_sessions <- iam_disable_organizations_root_sessions

#' Enables the specified MFA device and associates it with the specified
#' IAM user
#'
#' @description
#' Enables the specified MFA device and associates it with the specified IAM user. When enabled, the MFA device is required for every subsequent login by the IAM user associated with the device.
#'
#' See [https://www.paws-r-sdk.com/docs/iam_enable_mfa_device/](https://www.paws-r-sdk.com/docs/iam_enable_mfa_device/) for full documentation.
#'
#' @param UserName &#91;required&#93; The name of the IAM user for whom you want to enable the MFA device.
#' 
#' This parameter allows (through its [regex
#' pattern](https://en.wikipedia.org/wiki/Regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: _+=,.@@-
#' @param SerialNumber &#91;required&#93; The serial number that uniquely identifies the MFA device. For virtual
#' MFA devices, the serial number is the device ARN.
#' 
#' This parameter allows (through its [regex
#' pattern](https://en.wikipedia.org/wiki/Regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: =,.@@:/-
#' @param AuthenticationCode1 &#91;required&#93; An authentication code emitted by the device.
#' 
#' The format for this parameter is a string of six digits.
#' 
#' Submit your request immediately after generating the authentication
#' codes. If you generate the codes and then wait too long to submit the
#' request, the MFA device successfully associates with the user but the
#' MFA device becomes out of sync. This happens because time-based one-time
#' passwords (TOTP) expire after a short period of time. If this happens,
#' you can [resync the
#' device](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_mfa_sync.html).
#' @param AuthenticationCode2 &#91;required&#93; A subsequent authentication code emitted by the device.
#' 
#' The format for this parameter is a string of six digits.
#' 
#' Submit your request immediately after generating the authentication
#' codes. If you generate the codes and then wait too long to submit the
#' request, the MFA device successfully associates with the user but the
#' MFA device becomes out of sync. This happens because time-based one-time
#' passwords (TOTP) expire after a short period of time. If this happens,
#' you can [resync the
#' device](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_mfa_sync.html).
#'
#' @keywords internal
#'
#' @rdname iam_enable_mfa_device
iam_enable_mfa_device <- function(UserName, SerialNumber, AuthenticationCode1, AuthenticationCode2) {
  op <- new_operation(
    name = "EnableMFADevice",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .iam$enable_mfa_device_input(UserName = UserName, SerialNumber = SerialNumber, AuthenticationCode1 = AuthenticationCode1, AuthenticationCode2 = AuthenticationCode2)
  output <- .iam$enable_mfa_device_output()
  config <- get_config()
  svc <- .iam$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$enable_mfa_device <- iam_enable_mfa_device

#' Enables the management of privileged root user credentials across member
#' accounts in your organization
#'
#' @description
#' Enables the management of privileged root user credentials across member accounts in your organization. When you enable root credentials management for [centralized root access](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_root-user.html#id_root-user-access-management), the management account and the delegated admininstrator for IAM can manage root user credentials for member accounts in your organization.
#'
#' See [https://www.paws-r-sdk.com/docs/iam_enable_organizations_root_credentials_management/](https://www.paws-r-sdk.com/docs/iam_enable_organizations_root_credentials_management/) for full documentation.
#'

#'
#' @keywords internal
#'
#' @rdname iam_enable_organizations_root_credentials_management
iam_enable_organizations_root_credentials_management <- function() {
  op <- new_operation(
    name = "EnableOrganizationsRootCredentialsManagement",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .iam$enable_organizations_root_credentials_management_input()
  output <- .iam$enable_organizations_root_credentials_management_output()
  config <- get_config()
  svc <- .iam$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$enable_organizations_root_credentials_management <- iam_enable_organizations_root_credentials_management

#' Allows the management account or delegated administrator to perform
#' privileged tasks on member accounts in your organization
#'
#' @description
#' Allows the management account or delegated administrator to perform privileged tasks on member accounts in your organization. For more information, see [Centrally manage root access for member accounts](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_root-user.html#id_root-user-access-management) in the *Identity and Access Management User Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/iam_enable_organizations_root_sessions/](https://www.paws-r-sdk.com/docs/iam_enable_organizations_root_sessions/) for full documentation.
#'

#'
#' @keywords internal
#'
#' @rdname iam_enable_organizations_root_sessions
iam_enable_organizations_root_sessions <- function() {
  op <- new_operation(
    name = "EnableOrganizationsRootSessions",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .iam$enable_organizations_root_sessions_input()
  output <- .iam$enable_organizations_root_sessions_output()
  config <- get_config()
  svc <- .iam$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$enable_organizations_root_sessions <- iam_enable_organizations_root_sessions

#' Generates a credential report for the Amazon Web Services account
#'
#' @description
#' Generates a credential report for the Amazon Web Services account. For more information about the credential report, see [Getting credential reports](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_getting-report.html) in the *IAM User Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/iam_generate_credential_report/](https://www.paws-r-sdk.com/docs/iam_generate_credential_report/) for full documentation.
#'

#'
#' @keywords internal
#'
#' @rdname iam_generate_credential_report
iam_generate_credential_report <- function() {
  op <- new_operation(
    name = "GenerateCredentialReport",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .iam$generate_credential_report_input()
  output <- .iam$generate_credential_report_output()
  config <- get_config()
  svc <- .iam$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$generate_credential_report <- iam_generate_credential_report

#' Generates a report for service last accessed data for Organizations
#'
#' @description
#' Generates a report for service last accessed data for Organizations. You can generate a report for any entities (organization root, organizational unit, or account) or policies in your organization.
#'
#' See [https://www.paws-r-sdk.com/docs/iam_generate_organizations_access_report/](https://www.paws-r-sdk.com/docs/iam_generate_organizations_access_report/) for full documentation.
#'
#' @param EntityPath &#91;required&#93; The path of the Organizations entity (root, OU, or account). You can
#' build an entity path using the known structure of your organization. For
#' example, assume that your account ID is `123456789012` and its parent OU
#' ID is `ou-rge0-awsabcde`. The organization root ID is
#' `r-f6g7h8i9j0example` and your organization ID is `o-a1b2c3d4e5`. Your
#' entity path is
#' `o-a1b2c3d4e5/r-f6g7h8i9j0example/ou-rge0-awsabcde/123456789012`.
#' @param OrganizationsPolicyId The identifier of the Organizations service control policy (SCP). This
#' parameter is optional.
#' 
#' This ID is used to generate information about when an account principal
#' that is limited by the SCP attempted to access an Amazon Web Services
#' service.
#'
#' @keywords internal
#'
#' @rdname iam_generate_organizations_access_report
iam_generate_organizations_access_report <- function(EntityPath, OrganizationsPolicyId = NULL) {
  op <- new_operation(
    name = "GenerateOrganizationsAccessReport",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .iam$generate_organizations_access_report_input(EntityPath = EntityPath, OrganizationsPolicyId = OrganizationsPolicyId)
  output <- .iam$generate_organizations_access_report_output()
  config <- get_config()
  svc <- .iam$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$generate_organizations_access_report <- iam_generate_organizations_access_report

#' Generates a report that includes details about when an IAM resource
#' (user, group, role, or policy) was last used in an attempt to access
#' Amazon Web Services services
#'
#' @description
#' Generates a report that includes details about when an IAM resource (user, group, role, or policy) was last used in an attempt to access Amazon Web Services services. Recent activity usually appears within four hours. IAM reports activity for at least the last 400 days, or less if your Region began supporting this feature within the last year. For more information, see [Regions where data is tracked](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_last-accessed.html#access-advisor_tracking-period). For more information about services and actions for which action last accessed information is displayed, see [IAM action last accessed information services and actions](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_last-accessed-action-last-accessed.html).
#'
#' See [https://www.paws-r-sdk.com/docs/iam_generate_service_last_accessed_details/](https://www.paws-r-sdk.com/docs/iam_generate_service_last_accessed_details/) for full documentation.
#'
#' @param Arn &#91;required&#93; The ARN of the IAM resource (user, group, role, or managed policy) used
#' to generate information about when the resource was last used in an
#' attempt to access an Amazon Web Services service.
#' @param Granularity The level of detail that you want to generate. You can specify whether
#' you want to generate information about the last attempt to access
#' services or actions. If you specify service-level granularity, this
#' operation generates only service data. If you specify action-level
#' granularity, it generates service and action data. If you don't include
#' this optional parameter, the operation generates service data.
#'
#' @keywords internal
#'
#' @rdname iam_generate_service_last_accessed_details
iam_generate_service_last_accessed_details <- function(Arn, Granularity = NULL) {
  op <- new_operation(
    name = "GenerateServiceLastAccessedDetails",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .iam$generate_service_last_accessed_details_input(Arn = Arn, Granularity = Granularity)
  output <- .iam$generate_service_last_accessed_details_output()
  config <- get_config()
  svc <- .iam$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$generate_service_last_accessed_details <- iam_generate_service_last_accessed_details

#' Retrieves information about when the specified access key was last used
#'
#' @description
#' Retrieves information about when the specified access key was last used. The information includes the date and time of last use, along with the Amazon Web Services service and Region that were specified in the last request made with that key.
#'
#' See [https://www.paws-r-sdk.com/docs/iam_get_access_key_last_used/](https://www.paws-r-sdk.com/docs/iam_get_access_key_last_used/) for full documentation.
#'
#' @param AccessKeyId &#91;required&#93; The identifier of an access key.
#' 
#' This parameter allows (through its [regex
#' pattern](https://en.wikipedia.org/wiki/Regex)) a string of characters
#' that can consist of any upper or lowercased letter or digit.
#'
#' @keywords internal
#'
#' @rdname iam_get_access_key_last_used
iam_get_access_key_last_used <- function(AccessKeyId) {
  op <- new_operation(
    name = "GetAccessKeyLastUsed",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .iam$get_access_key_last_used_input(AccessKeyId = AccessKeyId)
  output <- .iam$get_access_key_last_used_output()
  config <- get_config()
  svc <- .iam$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$get_access_key_last_used <- iam_get_access_key_last_used

#' Retrieves information about all IAM users, groups, roles, and policies
#' in your Amazon Web Services account, including their relationships to
#' one another
#'
#' @description
#' Retrieves information about all IAM users, groups, roles, and policies in your Amazon Web Services account, including their relationships to one another. Use this operation to obtain a snapshot of the configuration of IAM permissions (users, groups, roles, and policies) in your account.
#'
#' See [https://www.paws-r-sdk.com/docs/iam_get_account_authorization_details/](https://www.paws-r-sdk.com/docs/iam_get_account_authorization_details/) for full documentation.
#'
#' @param Filter A list of entity types used to filter the results. Only the entities
#' that match the types you specify are included in the output. Use the
#' value `LocalManagedPolicy` to include customer managed policies.
#' 
#' The format for this parameter is a comma-separated (if more than one)
#' list of strings. Each string value in the list must be one of the valid
#' values listed below.
#' @param MaxItems Use this only when paginating results to indicate the maximum number of
#' items you want in the response. If additional items exist beyond the
#' maximum you specify, the `IsTruncated` response element is `true`.
#' 
#' If you do not include this parameter, the number of items defaults to
#' 100. Note that IAM might return fewer results, even when there are more
#' results available. In that case, the `IsTruncated` response element
#' returns `true`, and `Marker` contains a value to include in the
#' subsequent call that tells the service where to continue from.
#' @param Marker Use this parameter only when paginating results and only after you
#' receive a response indicating that the results are truncated. Set it to
#' the value of the `Marker` element in the response that you received to
#' indicate where the next call should start.
#'
#' @keywords internal
#'
#' @rdname iam_get_account_authorization_details
iam_get_account_authorization_details <- function(Filter = NULL, MaxItems = NULL, Marker = NULL) {
  op <- new_operation(
    name = "GetAccountAuthorizationDetails",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "Marker", limit_key = "MaxItems", more_results = "IsTruncated", output_token = "Marker", result_key = list("UserDetailList", "GroupDetailList", "RoleDetailList", "Policies")),
    stream_api = FALSE
  )
  input <- .iam$get_account_authorization_details_input(Filter = Filter, MaxItems = MaxItems, Marker = Marker)
  output <- .iam$get_account_authorization_details_output()
  config <- get_config()
  svc <- .iam$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$get_account_authorization_details <- iam_get_account_authorization_details

#' Retrieves the password policy for the Amazon Web Services account
#'
#' @description
#' Retrieves the password policy for the Amazon Web Services account. This tells you the complexity requirements and mandatory rotation periods for the IAM user passwords in your account. For more information about using a password policy, see [Managing an IAM password policy](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_passwords_account-policy.html).
#'
#' See [https://www.paws-r-sdk.com/docs/iam_get_account_password_policy/](https://www.paws-r-sdk.com/docs/iam_get_account_password_policy/) for full documentation.
#'

#'
#' @keywords internal
#'
#' @rdname iam_get_account_password_policy
iam_get_account_password_policy <- function() {
  op <- new_operation(
    name = "GetAccountPasswordPolicy",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .iam$get_account_password_policy_input()
  output <- .iam$get_account_password_policy_output()
  config <- get_config()
  svc <- .iam$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$get_account_password_policy <- iam_get_account_password_policy

#' Retrieves information about IAM entity usage and IAM quotas in the
#' Amazon Web Services account
#'
#' @description
#' Retrieves information about IAM entity usage and IAM quotas in the Amazon Web Services account.
#'
#' See [https://www.paws-r-sdk.com/docs/iam_get_account_summary/](https://www.paws-r-sdk.com/docs/iam_get_account_summary/) for full documentation.
#'

#'
#' @keywords internal
#'
#' @rdname iam_get_account_summary
iam_get_account_summary <- function() {
  op <- new_operation(
    name = "GetAccountSummary",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .iam$get_account_summary_input()
  output <- .iam$get_account_summary_output()
  config <- get_config()
  svc <- .iam$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$get_account_summary <- iam_get_account_summary

#' Gets a list of all of the context keys referenced in the input policies
#'
#' @description
#' Gets a list of all of the context keys referenced in the input policies. The policies are supplied as a list of one or more strings. To get the context keys from policies associated with an IAM user, group, or role, use [`get_context_keys_for_principal_policy`][iam_get_context_keys_for_principal_policy].
#'
#' See [https://www.paws-r-sdk.com/docs/iam_get_context_keys_for_custom_policy/](https://www.paws-r-sdk.com/docs/iam_get_context_keys_for_custom_policy/) for full documentation.
#'
#' @param PolicyInputList &#91;required&#93; A list of policies for which you want the list of context keys
#' referenced in those policies. Each document is specified as a string
#' containing the complete, valid JSON text of an IAM policy.
#' 
#' The [regex pattern](https://en.wikipedia.org/wiki/Regex) used to
#' validate this parameter is a string of characters consisting of the
#' following:
#' 
#' -   Any printable ASCII character ranging from the space character
#'     (``U+0020``) through the end of the ASCII character range
#' 
#' -   The printable characters in the Basic Latin and Latin-1 Supplement
#'     character set (through ``U+00FF``)
#' 
#' -   The special characters tab (``U+0009``), line feed (``U+000A``), and
#'     carriage return (``U+000D``)
#'
#' @keywords internal
#'
#' @rdname iam_get_context_keys_for_custom_policy
iam_get_context_keys_for_custom_policy <- function(PolicyInputList) {
  op <- new_operation(
    name = "GetContextKeysForCustomPolicy",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .iam$get_context_keys_for_custom_policy_input(PolicyInputList = PolicyInputList)
  output <- .iam$get_context_keys_for_custom_policy_output()
  config <- get_config()
  svc <- .iam$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$get_context_keys_for_custom_policy <- iam_get_context_keys_for_custom_policy

#' Gets a list of all of the context keys referenced in all the IAM
#' policies that are attached to the specified IAM entity
#'
#' @description
#' Gets a list of all of the context keys referenced in all the IAM policies that are attached to the specified IAM entity. The entity can be an IAM user, group, or role. If you specify a user, then the request also includes all of the policies attached to groups that the user is a member of.
#'
#' See [https://www.paws-r-sdk.com/docs/iam_get_context_keys_for_principal_policy/](https://www.paws-r-sdk.com/docs/iam_get_context_keys_for_principal_policy/) for full documentation.
#'
#' @param PolicySourceArn &#91;required&#93; The ARN of a user, group, or role whose policies contain the context
#' keys that you want listed. If you specify a user, the list includes
#' context keys that are found in all policies that are attached to the
#' user. The list also includes all groups that the user is a member of. If
#' you pick a group or a role, then it includes only those context keys
#' that are found in policies attached to that entity. Note that all
#' parameters are shown in unencoded form here for clarity, but must be URL
#' encoded to be included as a part of a real HTML request.
#' 
#' For more information about ARNs, see [Amazon Resource Names
#' (ARNs)](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html)
#' in the *Amazon Web Services General Reference*.
#' @param PolicyInputList An optional list of additional policies for which you want the list of
#' context keys that are referenced.
#' 
#' The [regex pattern](https://en.wikipedia.org/wiki/Regex) used to
#' validate this parameter is a string of characters consisting of the
#' following:
#' 
#' -   Any printable ASCII character ranging from the space character
#'     (``U+0020``) through the end of the ASCII character range
#' 
#' -   The printable characters in the Basic Latin and Latin-1 Supplement
#'     character set (through ``U+00FF``)
#' 
#' -   The special characters tab (``U+0009``), line feed (``U+000A``), and
#'     carriage return (``U+000D``)
#'
#' @keywords internal
#'
#' @rdname iam_get_context_keys_for_principal_policy
iam_get_context_keys_for_principal_policy <- function(PolicySourceArn, PolicyInputList = NULL) {
  op <- new_operation(
    name = "GetContextKeysForPrincipalPolicy",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .iam$get_context_keys_for_principal_policy_input(PolicySourceArn = PolicySourceArn, PolicyInputList = PolicyInputList)
  output <- .iam$get_context_keys_for_principal_policy_output()
  config <- get_config()
  svc <- .iam$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$get_context_keys_for_principal_policy <- iam_get_context_keys_for_principal_policy

#' Retrieves a credential report for the Amazon Web Services account
#'
#' @description
#' Retrieves a credential report for the Amazon Web Services account. For more information about the credential report, see [Getting credential reports](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_getting-report.html) in the *IAM User Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/iam_get_credential_report/](https://www.paws-r-sdk.com/docs/iam_get_credential_report/) for full documentation.
#'

#'
#' @keywords internal
#'
#' @rdname iam_get_credential_report
iam_get_credential_report <- function() {
  op <- new_operation(
    name = "GetCredentialReport",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .iam$get_credential_report_input()
  output <- .iam$get_credential_report_output()
  config <- get_config()
  svc <- .iam$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$get_credential_report <- iam_get_credential_report

#' Returns a list of IAM users that are in the specified IAM group
#'
#' @description
#' Returns a list of IAM users that are in the specified IAM group. You can paginate the results using the `MaxItems` and `Marker` parameters.
#'
#' See [https://www.paws-r-sdk.com/docs/iam_get_group/](https://www.paws-r-sdk.com/docs/iam_get_group/) for full documentation.
#'
#' @param GroupName &#91;required&#93; The name of the group.
#' 
#' This parameter allows (through its [regex
#' pattern](https://en.wikipedia.org/wiki/Regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: _+=,.@@-
#' @param Marker Use this parameter only when paginating results and only after you
#' receive a response indicating that the results are truncated. Set it to
#' the value of the `Marker` element in the response that you received to
#' indicate where the next call should start.
#' @param MaxItems Use this only when paginating results to indicate the maximum number of
#' items you want in the response. If additional items exist beyond the
#' maximum you specify, the `IsTruncated` response element is `true`.
#' 
#' If you do not include this parameter, the number of items defaults to
#' 100. Note that IAM might return fewer results, even when there are more
#' results available. In that case, the `IsTruncated` response element
#' returns `true`, and `Marker` contains a value to include in the
#' subsequent call that tells the service where to continue from.
#'
#' @keywords internal
#'
#' @rdname iam_get_group
iam_get_group <- function(GroupName, Marker = NULL, MaxItems = NULL) {
  op <- new_operation(
    name = "GetGroup",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "Marker", limit_key = "MaxItems", more_results = "IsTruncated", output_token = "Marker", result_key = "Users", non_aggregate_keys = list( "Group")),
    stream_api = FALSE
  )
  input <- .iam$get_group_input(GroupName = GroupName, Marker = Marker, MaxItems = MaxItems)
  output <- .iam$get_group_output()
  config <- get_config()
  svc <- .iam$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$get_group <- iam_get_group

#' Retrieves the specified inline policy document that is embedded in the
#' specified IAM group
#'
#' @description
#' Retrieves the specified inline policy document that is embedded in the specified IAM group.
#'
#' See [https://www.paws-r-sdk.com/docs/iam_get_group_policy/](https://www.paws-r-sdk.com/docs/iam_get_group_policy/) for full documentation.
#'
#' @param GroupName &#91;required&#93; The name of the group the policy is associated with.
#' 
#' This parameter allows (through its [regex
#' pattern](https://en.wikipedia.org/wiki/Regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: _+=,.@@-
#' @param PolicyName &#91;required&#93; The name of the policy document to get.
#' 
#' This parameter allows (through its [regex
#' pattern](https://en.wikipedia.org/wiki/Regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: _+=,.@@-
#'
#' @keywords internal
#'
#' @rdname iam_get_group_policy
iam_get_group_policy <- function(GroupName, PolicyName) {
  op <- new_operation(
    name = "GetGroupPolicy",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .iam$get_group_policy_input(GroupName = GroupName, PolicyName = PolicyName)
  output <- .iam$get_group_policy_output()
  config <- get_config()
  svc <- .iam$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$get_group_policy <- iam_get_group_policy

#' Retrieves information about the specified instance profile, including
#' the instance profile's path, GUID, ARN, and role
#'
#' @description
#' Retrieves information about the specified instance profile, including the instance profile's path, GUID, ARN, and role. For more information about instance profiles, see [Using instance profiles](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use_switch-role-ec2_instance-profiles.html) in the *IAM User Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/iam_get_instance_profile/](https://www.paws-r-sdk.com/docs/iam_get_instance_profile/) for full documentation.
#'
#' @param InstanceProfileName &#91;required&#93; The name of the instance profile to get information about.
#' 
#' This parameter allows (through its [regex
#' pattern](https://en.wikipedia.org/wiki/Regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: _+=,.@@-
#'
#' @keywords internal
#'
#' @rdname iam_get_instance_profile
iam_get_instance_profile <- function(InstanceProfileName) {
  op <- new_operation(
    name = "GetInstanceProfile",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .iam$get_instance_profile_input(InstanceProfileName = InstanceProfileName)
  output <- .iam$get_instance_profile_output()
  config <- get_config()
  svc <- .iam$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$get_instance_profile <- iam_get_instance_profile

#' Retrieves the user name for the specified IAM user
#'
#' @description
#' Retrieves the user name for the specified IAM user. A login profile is created when you create a password for the user to access the Amazon Web Services Management Console. If the user does not exist or does not have a password, the operation returns a 404 (`NoSuchEntity`) error.
#'
#' See [https://www.paws-r-sdk.com/docs/iam_get_login_profile/](https://www.paws-r-sdk.com/docs/iam_get_login_profile/) for full documentation.
#'
#' @param UserName The name of the user whose login profile you want to retrieve.
#' 
#' This parameter is optional. If no user name is included, it defaults to
#' the principal making the request. When you make this request with root
#' user credentials, you must use an
#' [AssumeRoot](https://docs.aws.amazon.com/STS/latest/APIReference/API_AssumeRoot.html)
#' session to omit the user name.
#' 
#' This parameter allows (through its [regex
#' pattern](https://en.wikipedia.org/wiki/Regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: _+=,.@@-
#'
#' @keywords internal
#'
#' @rdname iam_get_login_profile
iam_get_login_profile <- function(UserName = NULL) {
  op <- new_operation(
    name = "GetLoginProfile",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .iam$get_login_profile_input(UserName = UserName)
  output <- .iam$get_login_profile_output()
  config <- get_config()
  svc <- .iam$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$get_login_profile <- iam_get_login_profile

#' Retrieves information about an MFA device for a specified user
#'
#' @description
#' Retrieves information about an MFA device for a specified user.
#'
#' See [https://www.paws-r-sdk.com/docs/iam_get_mfa_device/](https://www.paws-r-sdk.com/docs/iam_get_mfa_device/) for full documentation.
#'
#' @param SerialNumber &#91;required&#93; Serial number that uniquely identifies the MFA device. For this API, we
#' only accept FIDO security key
#' [ARNs](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html).
#' @param UserName The friendly name identifying the user.
#'
#' @keywords internal
#'
#' @rdname iam_get_mfa_device
iam_get_mfa_device <- function(SerialNumber, UserName = NULL) {
  op <- new_operation(
    name = "GetMFADevice",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .iam$get_mfa_device_input(SerialNumber = SerialNumber, UserName = UserName)
  output <- .iam$get_mfa_device_output()
  config <- get_config()
  svc <- .iam$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$get_mfa_device <- iam_get_mfa_device

#' Returns information about the specified OpenID Connect (OIDC) provider
#' resource object in IAM
#'
#' @description
#' Returns information about the specified OpenID Connect (OIDC) provider resource object in IAM.
#'
#' See [https://www.paws-r-sdk.com/docs/iam_get_open_id_connect_provider/](https://www.paws-r-sdk.com/docs/iam_get_open_id_connect_provider/) for full documentation.
#'
#' @param OpenIDConnectProviderArn &#91;required&#93; The Amazon Resource Name (ARN) of the OIDC provider resource object in
#' IAM to get information for. You can get a list of OIDC provider resource
#' ARNs by using the
#' [`list_open_id_connect_providers`][iam_list_open_id_connect_providers]
#' operation.
#' 
#' For more information about ARNs, see [Amazon Resource Names
#' (ARNs)](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html)
#' in the *Amazon Web Services General Reference*.
#'
#' @keywords internal
#'
#' @rdname iam_get_open_id_connect_provider
iam_get_open_id_connect_provider <- function(OpenIDConnectProviderArn) {
  op <- new_operation(
    name = "GetOpenIDConnectProvider",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .iam$get_open_id_connect_provider_input(OpenIDConnectProviderArn = OpenIDConnectProviderArn)
  output <- .iam$get_open_id_connect_provider_output()
  config <- get_config()
  svc <- .iam$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$get_open_id_connect_provider <- iam_get_open_id_connect_provider

#' Retrieves the service last accessed data report for Organizations that
#' was previously generated using the GenerateOrganizationsAccessReport
#' operation
#'
#' @description
#' Retrieves the service last accessed data report for Organizations that was previously generated using the [`generate_organizations_access_report`][iam_generate_organizations_access_report] operation. This operation retrieves the status of your report job and the report contents.
#'
#' See [https://www.paws-r-sdk.com/docs/iam_get_organizations_access_report/](https://www.paws-r-sdk.com/docs/iam_get_organizations_access_report/) for full documentation.
#'
#' @param JobId &#91;required&#93; The identifier of the request generated by the
#' [`generate_organizations_access_report`][iam_generate_organizations_access_report]
#' operation.
#' @param MaxItems Use this only when paginating results to indicate the maximum number of
#' items you want in the response. If additional items exist beyond the
#' maximum you specify, the `IsTruncated` response element is `true`.
#' 
#' If you do not include this parameter, the number of items defaults to
#' 100. Note that IAM might return fewer results, even when there are more
#' results available. In that case, the `IsTruncated` response element
#' returns `true`, and `Marker` contains a value to include in the
#' subsequent call that tells the service where to continue from.
#' @param Marker Use this parameter only when paginating results and only after you
#' receive a response indicating that the results are truncated. Set it to
#' the value of the `Marker` element in the response that you received to
#' indicate where the next call should start.
#' @param SortKey The key that is used to sort the results. If you choose the namespace
#' key, the results are returned in alphabetical order. If you choose the
#' time key, the results are sorted numerically by the date and time.
#'
#' @keywords internal
#'
#' @rdname iam_get_organizations_access_report
iam_get_organizations_access_report <- function(JobId, MaxItems = NULL, Marker = NULL, SortKey = NULL) {
  op <- new_operation(
    name = "GetOrganizationsAccessReport",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .iam$get_organizations_access_report_input(JobId = JobId, MaxItems = MaxItems, Marker = Marker, SortKey = SortKey)
  output <- .iam$get_organizations_access_report_output()
  config <- get_config()
  svc <- .iam$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$get_organizations_access_report <- iam_get_organizations_access_report

#' Retrieves information about the specified managed policy, including the
#' policy's default version and the total number of IAM users, groups, and
#' roles to which the policy is attached
#'
#' @description
#' Retrieves information about the specified managed policy, including the policy's default version and the total number of IAM users, groups, and roles to which the policy is attached. To retrieve the list of the specific users, groups, and roles that the policy is attached to, use [`list_entities_for_policy`][iam_list_entities_for_policy]. This operation returns metadata about the policy. To retrieve the actual policy document for a specific version of the policy, use [`get_policy_version`][iam_get_policy_version].
#'
#' See [https://www.paws-r-sdk.com/docs/iam_get_policy/](https://www.paws-r-sdk.com/docs/iam_get_policy/) for full documentation.
#'
#' @param PolicyArn &#91;required&#93; The Amazon Resource Name (ARN) of the managed policy that you want
#' information about.
#' 
#' For more information about ARNs, see [Amazon Resource Names
#' (ARNs)](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html)
#' in the *Amazon Web Services General Reference*.
#'
#' @keywords internal
#'
#' @rdname iam_get_policy
iam_get_policy <- function(PolicyArn) {
  op <- new_operation(
    name = "GetPolicy",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .iam$get_policy_input(PolicyArn = PolicyArn)
  output <- .iam$get_policy_output()
  config <- get_config()
  svc <- .iam$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$get_policy <- iam_get_policy

#' Retrieves information about the specified version of the specified
#' managed policy, including the policy document
#'
#' @description
#' Retrieves information about the specified version of the specified managed policy, including the policy document.
#'
#' See [https://www.paws-r-sdk.com/docs/iam_get_policy_version/](https://www.paws-r-sdk.com/docs/iam_get_policy_version/) for full documentation.
#'
#' @param PolicyArn &#91;required&#93; The Amazon Resource Name (ARN) of the managed policy that you want
#' information about.
#' 
#' For more information about ARNs, see [Amazon Resource Names
#' (ARNs)](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html)
#' in the *Amazon Web Services General Reference*.
#' @param VersionId &#91;required&#93; Identifies the policy version to retrieve.
#' 
#' This parameter allows (through its [regex
#' pattern](https://en.wikipedia.org/wiki/Regex)) a string of characters
#' that consists of the lowercase letter 'v' followed by one or two digits,
#' and optionally followed by a period '.' and a string of letters and
#' digits.
#'
#' @keywords internal
#'
#' @rdname iam_get_policy_version
iam_get_policy_version <- function(PolicyArn, VersionId) {
  op <- new_operation(
    name = "GetPolicyVersion",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .iam$get_policy_version_input(PolicyArn = PolicyArn, VersionId = VersionId)
  output <- .iam$get_policy_version_output()
  config <- get_config()
  svc <- .iam$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$get_policy_version <- iam_get_policy_version

#' Retrieves information about the specified role, including the role's
#' path, GUID, ARN, and the role's trust policy that grants permission to
#' assume the role
#'
#' @description
#' Retrieves information about the specified role, including the role's path, GUID, ARN, and the role's trust policy that grants permission to assume the role. For more information about roles, see [IAM roles](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles.html) in the *IAM User Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/iam_get_role/](https://www.paws-r-sdk.com/docs/iam_get_role/) for full documentation.
#'
#' @param RoleName &#91;required&#93; The name of the IAM role to get information about.
#' 
#' This parameter allows (through its [regex
#' pattern](https://en.wikipedia.org/wiki/Regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: _+=,.@@-
#'
#' @keywords internal
#'
#' @rdname iam_get_role
iam_get_role <- function(RoleName) {
  op <- new_operation(
    name = "GetRole",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .iam$get_role_input(RoleName = RoleName)
  output <- .iam$get_role_output()
  config <- get_config()
  svc <- .iam$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$get_role <- iam_get_role

#' Retrieves the specified inline policy document that is embedded with the
#' specified IAM role
#'
#' @description
#' Retrieves the specified inline policy document that is embedded with the specified IAM role.
#'
#' See [https://www.paws-r-sdk.com/docs/iam_get_role_policy/](https://www.paws-r-sdk.com/docs/iam_get_role_policy/) for full documentation.
#'
#' @param RoleName &#91;required&#93; The name of the role associated with the policy.
#' 
#' This parameter allows (through its [regex
#' pattern](https://en.wikipedia.org/wiki/Regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: _+=,.@@-
#' @param PolicyName &#91;required&#93; The name of the policy document to get.
#' 
#' This parameter allows (through its [regex
#' pattern](https://en.wikipedia.org/wiki/Regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: _+=,.@@-
#'
#' @keywords internal
#'
#' @rdname iam_get_role_policy
iam_get_role_policy <- function(RoleName, PolicyName) {
  op <- new_operation(
    name = "GetRolePolicy",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .iam$get_role_policy_input(RoleName = RoleName, PolicyName = PolicyName)
  output <- .iam$get_role_policy_output()
  config <- get_config()
  svc <- .iam$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$get_role_policy <- iam_get_role_policy

#' Returns the SAML provider metadocument that was uploaded when the IAM
#' SAML provider resource object was created or updated
#'
#' @description
#' Returns the SAML provider metadocument that was uploaded when the IAM SAML provider resource object was created or updated.
#'
#' See [https://www.paws-r-sdk.com/docs/iam_get_saml_provider/](https://www.paws-r-sdk.com/docs/iam_get_saml_provider/) for full documentation.
#'
#' @param SAMLProviderArn &#91;required&#93; The Amazon Resource Name (ARN) of the SAML provider resource object in
#' IAM to get information about.
#' 
#' For more information about ARNs, see [Amazon Resource Names
#' (ARNs)](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html)
#' in the *Amazon Web Services General Reference*.
#'
#' @keywords internal
#'
#' @rdname iam_get_saml_provider
iam_get_saml_provider <- function(SAMLProviderArn) {
  op <- new_operation(
    name = "GetSAMLProvider",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .iam$get_saml_provider_input(SAMLProviderArn = SAMLProviderArn)
  output <- .iam$get_saml_provider_output()
  config <- get_config()
  svc <- .iam$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$get_saml_provider <- iam_get_saml_provider

#' Retrieves the specified SSH public key, including metadata about the key
#'
#' @description
#' Retrieves the specified SSH public key, including metadata about the key.
#'
#' See [https://www.paws-r-sdk.com/docs/iam_get_ssh_public_key/](https://www.paws-r-sdk.com/docs/iam_get_ssh_public_key/) for full documentation.
#'
#' @param UserName &#91;required&#93; The name of the IAM user associated with the SSH public key.
#' 
#' This parameter allows (through its [regex
#' pattern](https://en.wikipedia.org/wiki/Regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: _+=,.@@-
#' @param SSHPublicKeyId &#91;required&#93; The unique identifier for the SSH public key.
#' 
#' This parameter allows (through its [regex
#' pattern](https://en.wikipedia.org/wiki/Regex)) a string of characters
#' that can consist of any upper or lowercased letter or digit.
#' @param Encoding &#91;required&#93; Specifies the public key encoding format to use in the response. To
#' retrieve the public key in ssh-rsa format, use `SSH`. To retrieve the
#' public key in PEM format, use `PEM`.
#'
#' @keywords internal
#'
#' @rdname iam_get_ssh_public_key
iam_get_ssh_public_key <- function(UserName, SSHPublicKeyId, Encoding) {
  op <- new_operation(
    name = "GetSSHPublicKey",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .iam$get_ssh_public_key_input(UserName = UserName, SSHPublicKeyId = SSHPublicKeyId, Encoding = Encoding)
  output <- .iam$get_ssh_public_key_output()
  config <- get_config()
  svc <- .iam$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$get_ssh_public_key <- iam_get_ssh_public_key

#' Retrieves information about the specified server certificate stored in
#' IAM
#'
#' @description
#' Retrieves information about the specified server certificate stored in IAM.
#'
#' See [https://www.paws-r-sdk.com/docs/iam_get_server_certificate/](https://www.paws-r-sdk.com/docs/iam_get_server_certificate/) for full documentation.
#'
#' @param ServerCertificateName &#91;required&#93; The name of the server certificate you want to retrieve information
#' about.
#' 
#' This parameter allows (through its [regex
#' pattern](https://en.wikipedia.org/wiki/Regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: _+=,.@@-
#'
#' @keywords internal
#'
#' @rdname iam_get_server_certificate
iam_get_server_certificate <- function(ServerCertificateName) {
  op <- new_operation(
    name = "GetServerCertificate",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .iam$get_server_certificate_input(ServerCertificateName = ServerCertificateName)
  output <- .iam$get_server_certificate_output()
  config <- get_config()
  svc <- .iam$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$get_server_certificate <- iam_get_server_certificate

#' Retrieves a service last accessed report that was created using the
#' GenerateServiceLastAccessedDetails operation
#'
#' @description
#' Retrieves a service last accessed report that was created using the [`generate_service_last_accessed_details`][iam_generate_service_last_accessed_details] operation. You can use the `JobId` parameter in [`get_service_last_accessed_details`][iam_get_service_last_accessed_details] to retrieve the status of your report job. When the report is complete, you can retrieve the generated report. The report includes a list of Amazon Web Services services that the resource (user, group, role, or managed policy) can access.
#'
#' See [https://www.paws-r-sdk.com/docs/iam_get_service_last_accessed_details/](https://www.paws-r-sdk.com/docs/iam_get_service_last_accessed_details/) for full documentation.
#'
#' @param JobId &#91;required&#93; The ID of the request generated by the
#' [`generate_service_last_accessed_details`][iam_generate_service_last_accessed_details]
#' operation. The `JobId` returned by `GenerateServiceLastAccessedDetail`
#' must be used by the same role within a session, or by the same user when
#' used to call `GetServiceLastAccessedDetail`.
#' @param MaxItems Use this only when paginating results to indicate the maximum number of
#' items you want in the response. If additional items exist beyond the
#' maximum you specify, the `IsTruncated` response element is `true`.
#' 
#' If you do not include this parameter, the number of items defaults to
#' 100. Note that IAM might return fewer results, even when there are more
#' results available. In that case, the `IsTruncated` response element
#' returns `true`, and `Marker` contains a value to include in the
#' subsequent call that tells the service where to continue from.
#' @param Marker Use this parameter only when paginating results and only after you
#' receive a response indicating that the results are truncated. Set it to
#' the value of the `Marker` element in the response that you received to
#' indicate where the next call should start.
#'
#' @keywords internal
#'
#' @rdname iam_get_service_last_accessed_details
iam_get_service_last_accessed_details <- function(JobId, MaxItems = NULL, Marker = NULL) {
  op <- new_operation(
    name = "GetServiceLastAccessedDetails",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .iam$get_service_last_accessed_details_input(JobId = JobId, MaxItems = MaxItems, Marker = Marker)
  output <- .iam$get_service_last_accessed_details_output()
  config <- get_config()
  svc <- .iam$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$get_service_last_accessed_details <- iam_get_service_last_accessed_details

#' After you generate a group or policy report using the
#' GenerateServiceLastAccessedDetails operation, you can use the JobId
#' parameter in GetServiceLastAccessedDetailsWithEntities
#'
#' @description
#' After you generate a group or policy report using the [`generate_service_last_accessed_details`][iam_generate_service_last_accessed_details] operation, you can use the `JobId` parameter in [`get_service_last_accessed_details_with_entities`][iam_get_service_last_accessed_details_with_entities]. This operation retrieves the status of your report job and a list of entities that could have used group or policy permissions to access the specified service.
#'
#' See [https://www.paws-r-sdk.com/docs/iam_get_service_last_accessed_details_with_entities/](https://www.paws-r-sdk.com/docs/iam_get_service_last_accessed_details_with_entities/) for full documentation.
#'
#' @param JobId &#91;required&#93; The ID of the request generated by the
#' [`generate_service_last_accessed_details`][iam_generate_service_last_accessed_details]
#' operation.
#' @param ServiceNamespace &#91;required&#93; The service namespace for an Amazon Web Services service. Provide the
#' service namespace to learn when the IAM entity last attempted to access
#' the specified service.
#' 
#' To learn the service namespace for a service, see [Actions, resources,
#' and condition keys for Amazon Web Services
#' services](https://docs.aws.amazon.com/service-authorization/latest/reference/reference_policies_actions-resources-contextkeys.html)
#' in the *IAM User Guide*. Choose the name of the service to view details
#' for that service. In the first paragraph, find the service prefix. For
#' example, `(service prefix: a4b)`. For more information about service
#' namespaces, see [Amazon Web Services service
#' namespaces](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html#genref-aws-service-namespaces)
#' in the *Amazon Web Services General Reference*.
#' @param MaxItems Use this only when paginating results to indicate the maximum number of
#' items you want in the response. If additional items exist beyond the
#' maximum you specify, the `IsTruncated` response element is `true`.
#' 
#' If you do not include this parameter, the number of items defaults to
#' 100. Note that IAM might return fewer results, even when there are more
#' results available. In that case, the `IsTruncated` response element
#' returns `true`, and `Marker` contains a value to include in the
#' subsequent call that tells the service where to continue from.
#' @param Marker Use this parameter only when paginating results and only after you
#' receive a response indicating that the results are truncated. Set it to
#' the value of the `Marker` element in the response that you received to
#' indicate where the next call should start.
#'
#' @keywords internal
#'
#' @rdname iam_get_service_last_accessed_details_with_entities
iam_get_service_last_accessed_details_with_entities <- function(JobId, ServiceNamespace, MaxItems = NULL, Marker = NULL) {
  op <- new_operation(
    name = "GetServiceLastAccessedDetailsWithEntities",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .iam$get_service_last_accessed_details_with_entities_input(JobId = JobId, ServiceNamespace = ServiceNamespace, MaxItems = MaxItems, Marker = Marker)
  output <- .iam$get_service_last_accessed_details_with_entities_output()
  config <- get_config()
  svc <- .iam$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$get_service_last_accessed_details_with_entities <- iam_get_service_last_accessed_details_with_entities

#' Retrieves the status of your service-linked role deletion
#'
#' @description
#' Retrieves the status of your service-linked role deletion. After you use [`delete_service_linked_role`][iam_delete_service_linked_role] to submit a service-linked role for deletion, you can use the `DeletionTaskId` parameter in [`get_service_linked_role_deletion_status`][iam_get_service_linked_role_deletion_status] to check the status of the deletion. If the deletion fails, this operation returns the reason that it failed, if that information is returned by the service.
#'
#' See [https://www.paws-r-sdk.com/docs/iam_get_service_linked_role_deletion_status/](https://www.paws-r-sdk.com/docs/iam_get_service_linked_role_deletion_status/) for full documentation.
#'
#' @param DeletionTaskId &#91;required&#93; The deletion task identifier. This identifier is returned by the
#' [`delete_service_linked_role`][iam_delete_service_linked_role] operation
#' in the format
#' `task/aws-service-role/<service-principal-name>/<role-name>/<task-uuid>`.
#'
#' @keywords internal
#'
#' @rdname iam_get_service_linked_role_deletion_status
iam_get_service_linked_role_deletion_status <- function(DeletionTaskId) {
  op <- new_operation(
    name = "GetServiceLinkedRoleDeletionStatus",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .iam$get_service_linked_role_deletion_status_input(DeletionTaskId = DeletionTaskId)
  output <- .iam$get_service_linked_role_deletion_status_output()
  config <- get_config()
  svc <- .iam$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$get_service_linked_role_deletion_status <- iam_get_service_linked_role_deletion_status

#' Retrieves information about the specified IAM user, including the user's
#' creation date, path, unique ID, and ARN
#'
#' @description
#' Retrieves information about the specified IAM user, including the user's creation date, path, unique ID, and ARN.
#'
#' See [https://www.paws-r-sdk.com/docs/iam_get_user/](https://www.paws-r-sdk.com/docs/iam_get_user/) for full documentation.
#'
#' @param UserName The name of the user to get information about.
#' 
#' This parameter is optional. If it is not included, it defaults to the
#' user making the request. This parameter allows (through its [regex
#' pattern](https://en.wikipedia.org/wiki/Regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: _+=,.@@-
#'
#' @keywords internal
#'
#' @rdname iam_get_user
iam_get_user <- function(UserName = NULL) {
  op <- new_operation(
    name = "GetUser",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .iam$get_user_input(UserName = UserName)
  output <- .iam$get_user_output()
  config <- get_config()
  svc <- .iam$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$get_user <- iam_get_user

#' Retrieves the specified inline policy document that is embedded in the
#' specified IAM user
#'
#' @description
#' Retrieves the specified inline policy document that is embedded in the specified IAM user.
#'
#' See [https://www.paws-r-sdk.com/docs/iam_get_user_policy/](https://www.paws-r-sdk.com/docs/iam_get_user_policy/) for full documentation.
#'
#' @param UserName &#91;required&#93; The name of the user who the policy is associated with.
#' 
#' This parameter allows (through its [regex
#' pattern](https://en.wikipedia.org/wiki/Regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: _+=,.@@-
#' @param PolicyName &#91;required&#93; The name of the policy document to get.
#' 
#' This parameter allows (through its [regex
#' pattern](https://en.wikipedia.org/wiki/Regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: _+=,.@@-
#'
#' @keywords internal
#'
#' @rdname iam_get_user_policy
iam_get_user_policy <- function(UserName, PolicyName) {
  op <- new_operation(
    name = "GetUserPolicy",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .iam$get_user_policy_input(UserName = UserName, PolicyName = PolicyName)
  output <- .iam$get_user_policy_output()
  config <- get_config()
  svc <- .iam$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$get_user_policy <- iam_get_user_policy

#' Returns information about the access key IDs associated with the
#' specified IAM user
#'
#' @description
#' Returns information about the access key IDs associated with the specified IAM user. If there is none, the operation returns an empty list.
#'
#' See [https://www.paws-r-sdk.com/docs/iam_list_access_keys/](https://www.paws-r-sdk.com/docs/iam_list_access_keys/) for full documentation.
#'
#' @param UserName The name of the user.
#' 
#' This parameter allows (through its [regex
#' pattern](https://en.wikipedia.org/wiki/Regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: _+=,.@@-
#' @param Marker Use this parameter only when paginating results and only after you
#' receive a response indicating that the results are truncated. Set it to
#' the value of the `Marker` element in the response that you received to
#' indicate where the next call should start.
#' @param MaxItems Use this only when paginating results to indicate the maximum number of
#' items you want in the response. If additional items exist beyond the
#' maximum you specify, the `IsTruncated` response element is `true`.
#' 
#' If you do not include this parameter, the number of items defaults to
#' 100. Note that IAM might return fewer results, even when there are more
#' results available. In that case, the `IsTruncated` response element
#' returns `true`, and `Marker` contains a value to include in the
#' subsequent call that tells the service where to continue from.
#'
#' @keywords internal
#'
#' @rdname iam_list_access_keys
iam_list_access_keys <- function(UserName = NULL, Marker = NULL, MaxItems = NULL) {
  op <- new_operation(
    name = "ListAccessKeys",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "Marker", limit_key = "MaxItems", more_results = "IsTruncated", output_token = "Marker", result_key = "AccessKeyMetadata"),
    stream_api = FALSE
  )
  input <- .iam$list_access_keys_input(UserName = UserName, Marker = Marker, MaxItems = MaxItems)
  output <- .iam$list_access_keys_output()
  config <- get_config()
  svc <- .iam$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$list_access_keys <- iam_list_access_keys

#' Lists the account alias associated with the Amazon Web Services account
#' (Note: you can have only one)
#'
#' @description
#' Lists the account alias associated with the Amazon Web Services account (Note: you can have only one). For information about using an Amazon Web Services account alias, see [Creating, deleting, and listing an Amazon Web Services account alias](https://docs.aws.amazon.com/IAM/latest/UserGuide/account-alias-create.html) in the *Amazon Web Services Sign-In User Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/iam_list_account_aliases/](https://www.paws-r-sdk.com/docs/iam_list_account_aliases/) for full documentation.
#'
#' @param Marker Use this parameter only when paginating results and only after you
#' receive a response indicating that the results are truncated. Set it to
#' the value of the `Marker` element in the response that you received to
#' indicate where the next call should start.
#' @param MaxItems Use this only when paginating results to indicate the maximum number of
#' items you want in the response. If additional items exist beyond the
#' maximum you specify, the `IsTruncated` response element is `true`.
#' 
#' If you do not include this parameter, the number of items defaults to
#' 100. Note that IAM might return fewer results, even when there are more
#' results available. In that case, the `IsTruncated` response element
#' returns `true`, and `Marker` contains a value to include in the
#' subsequent call that tells the service where to continue from.
#'
#' @keywords internal
#'
#' @rdname iam_list_account_aliases
iam_list_account_aliases <- function(Marker = NULL, MaxItems = NULL) {
  op <- new_operation(
    name = "ListAccountAliases",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "Marker", limit_key = "MaxItems", more_results = "IsTruncated", output_token = "Marker", result_key = "AccountAliases"),
    stream_api = FALSE
  )
  input <- .iam$list_account_aliases_input(Marker = Marker, MaxItems = MaxItems)
  output <- .iam$list_account_aliases_output()
  config <- get_config()
  svc <- .iam$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$list_account_aliases <- iam_list_account_aliases

#' Lists all managed policies that are attached to the specified IAM group
#'
#' @description
#' Lists all managed policies that are attached to the specified IAM group.
#'
#' See [https://www.paws-r-sdk.com/docs/iam_list_attached_group_policies/](https://www.paws-r-sdk.com/docs/iam_list_attached_group_policies/) for full documentation.
#'
#' @param GroupName &#91;required&#93; The name (friendly name, not ARN) of the group to list attached policies
#' for.
#' 
#' This parameter allows (through its [regex
#' pattern](https://en.wikipedia.org/wiki/Regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: _+=,.@@-
#' @param PathPrefix The path prefix for filtering the results. This parameter is optional.
#' If it is not included, it defaults to a slash (/), listing all policies.
#' 
#' This parameter allows (through its [regex
#' pattern](https://en.wikipedia.org/wiki/Regex)) a string of characters
#' consisting of either a forward slash (/) by itself or a string that must
#' begin and end with forward slashes. In addition, it can contain any
#' ASCII character from the ! (``U+0021``) through the DEL character
#' (``U+007F``), including most punctuation characters, digits, and upper and
#' lowercased letters.
#' @param Marker Use this parameter only when paginating results and only after you
#' receive a response indicating that the results are truncated. Set it to
#' the value of the `Marker` element in the response that you received to
#' indicate where the next call should start.
#' @param MaxItems Use this only when paginating results to indicate the maximum number of
#' items you want in the response. If additional items exist beyond the
#' maximum you specify, the `IsTruncated` response element is `true`.
#' 
#' If you do not include this parameter, the number of items defaults to
#' 100. Note that IAM might return fewer results, even when there are more
#' results available. In that case, the `IsTruncated` response element
#' returns `true`, and `Marker` contains a value to include in the
#' subsequent call that tells the service where to continue from.
#'
#' @keywords internal
#'
#' @rdname iam_list_attached_group_policies
iam_list_attached_group_policies <- function(GroupName, PathPrefix = NULL, Marker = NULL, MaxItems = NULL) {
  op <- new_operation(
    name = "ListAttachedGroupPolicies",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "Marker", limit_key = "MaxItems", more_results = "IsTruncated", output_token = "Marker", result_key = "AttachedPolicies"),
    stream_api = FALSE
  )
  input <- .iam$list_attached_group_policies_input(GroupName = GroupName, PathPrefix = PathPrefix, Marker = Marker, MaxItems = MaxItems)
  output <- .iam$list_attached_group_policies_output()
  config <- get_config()
  svc <- .iam$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$list_attached_group_policies <- iam_list_attached_group_policies

#' Lists all managed policies that are attached to the specified IAM role
#'
#' @description
#' Lists all managed policies that are attached to the specified IAM role.
#'
#' See [https://www.paws-r-sdk.com/docs/iam_list_attached_role_policies/](https://www.paws-r-sdk.com/docs/iam_list_attached_role_policies/) for full documentation.
#'
#' @param RoleName &#91;required&#93; The name (friendly name, not ARN) of the role to list attached policies
#' for.
#' 
#' This parameter allows (through its [regex
#' pattern](https://en.wikipedia.org/wiki/Regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: _+=,.@@-
#' @param PathPrefix The path prefix for filtering the results. This parameter is optional.
#' If it is not included, it defaults to a slash (/), listing all policies.
#' 
#' This parameter allows (through its [regex
#' pattern](https://en.wikipedia.org/wiki/Regex)) a string of characters
#' consisting of either a forward slash (/) by itself or a string that must
#' begin and end with forward slashes. In addition, it can contain any
#' ASCII character from the ! (``U+0021``) through the DEL character
#' (``U+007F``), including most punctuation characters, digits, and upper and
#' lowercased letters.
#' @param Marker Use this parameter only when paginating results and only after you
#' receive a response indicating that the results are truncated. Set it to
#' the value of the `Marker` element in the response that you received to
#' indicate where the next call should start.
#' @param MaxItems Use this only when paginating results to indicate the maximum number of
#' items you want in the response. If additional items exist beyond the
#' maximum you specify, the `IsTruncated` response element is `true`.
#' 
#' If you do not include this parameter, the number of items defaults to
#' 100. Note that IAM might return fewer results, even when there are more
#' results available. In that case, the `IsTruncated` response element
#' returns `true`, and `Marker` contains a value to include in the
#' subsequent call that tells the service where to continue from.
#'
#' @keywords internal
#'
#' @rdname iam_list_attached_role_policies
iam_list_attached_role_policies <- function(RoleName, PathPrefix = NULL, Marker = NULL, MaxItems = NULL) {
  op <- new_operation(
    name = "ListAttachedRolePolicies",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "Marker", limit_key = "MaxItems", more_results = "IsTruncated", output_token = "Marker", result_key = "AttachedPolicies"),
    stream_api = FALSE
  )
  input <- .iam$list_attached_role_policies_input(RoleName = RoleName, PathPrefix = PathPrefix, Marker = Marker, MaxItems = MaxItems)
  output <- .iam$list_attached_role_policies_output()
  config <- get_config()
  svc <- .iam$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$list_attached_role_policies <- iam_list_attached_role_policies

#' Lists all managed policies that are attached to the specified IAM user
#'
#' @description
#' Lists all managed policies that are attached to the specified IAM user.
#'
#' See [https://www.paws-r-sdk.com/docs/iam_list_attached_user_policies/](https://www.paws-r-sdk.com/docs/iam_list_attached_user_policies/) for full documentation.
#'
#' @param UserName &#91;required&#93; The name (friendly name, not ARN) of the user to list attached policies
#' for.
#' 
#' This parameter allows (through its [regex
#' pattern](https://en.wikipedia.org/wiki/Regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: _+=,.@@-
#' @param PathPrefix The path prefix for filtering the results. This parameter is optional.
#' If it is not included, it defaults to a slash (/), listing all policies.
#' 
#' This parameter allows (through its [regex
#' pattern](https://en.wikipedia.org/wiki/Regex)) a string of characters
#' consisting of either a forward slash (/) by itself or a string that must
#' begin and end with forward slashes. In addition, it can contain any
#' ASCII character from the ! (``U+0021``) through the DEL character
#' (``U+007F``), including most punctuation characters, digits, and upper and
#' lowercased letters.
#' @param Marker Use this parameter only when paginating results and only after you
#' receive a response indicating that the results are truncated. Set it to
#' the value of the `Marker` element in the response that you received to
#' indicate where the next call should start.
#' @param MaxItems Use this only when paginating results to indicate the maximum number of
#' items you want in the response. If additional items exist beyond the
#' maximum you specify, the `IsTruncated` response element is `true`.
#' 
#' If you do not include this parameter, the number of items defaults to
#' 100. Note that IAM might return fewer results, even when there are more
#' results available. In that case, the `IsTruncated` response element
#' returns `true`, and `Marker` contains a value to include in the
#' subsequent call that tells the service where to continue from.
#'
#' @keywords internal
#'
#' @rdname iam_list_attached_user_policies
iam_list_attached_user_policies <- function(UserName, PathPrefix = NULL, Marker = NULL, MaxItems = NULL) {
  op <- new_operation(
    name = "ListAttachedUserPolicies",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "Marker", limit_key = "MaxItems", more_results = "IsTruncated", output_token = "Marker", result_key = "AttachedPolicies"),
    stream_api = FALSE
  )
  input <- .iam$list_attached_user_policies_input(UserName = UserName, PathPrefix = PathPrefix, Marker = Marker, MaxItems = MaxItems)
  output <- .iam$list_attached_user_policies_output()
  config <- get_config()
  svc <- .iam$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$list_attached_user_policies <- iam_list_attached_user_policies

#' Lists all IAM users, groups, and roles that the specified managed policy
#' is attached to
#'
#' @description
#' Lists all IAM users, groups, and roles that the specified managed policy is attached to.
#'
#' See [https://www.paws-r-sdk.com/docs/iam_list_entities_for_policy/](https://www.paws-r-sdk.com/docs/iam_list_entities_for_policy/) for full documentation.
#'
#' @param PolicyArn &#91;required&#93; The Amazon Resource Name (ARN) of the IAM policy for which you want the
#' versions.
#' 
#' For more information about ARNs, see [Amazon Resource Names
#' (ARNs)](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html)
#' in the *Amazon Web Services General Reference*.
#' @param EntityFilter The entity type to use for filtering the results.
#' 
#' For example, when `EntityFilter` is `Role`, only the roles that are
#' attached to the specified policy are returned. This parameter is
#' optional. If it is not included, all attached entities (users, groups,
#' and roles) are returned. The argument for this parameter must be one of
#' the valid values listed below.
#' @param PathPrefix The path prefix for filtering the results. This parameter is optional.
#' If it is not included, it defaults to a slash (/), listing all entities.
#' 
#' This parameter allows (through its [regex
#' pattern](https://en.wikipedia.org/wiki/Regex)) a string of characters
#' consisting of either a forward slash (/) by itself or a string that must
#' begin and end with forward slashes. In addition, it can contain any
#' ASCII character from the ! (``U+0021``) through the DEL character
#' (``U+007F``), including most punctuation characters, digits, and upper and
#' lowercased letters.
#' @param PolicyUsageFilter The policy usage method to use for filtering the results.
#' 
#' To list only permissions policies,
#' set `PolicyUsageFilter` to `PermissionsPolicy`. To list only the
#' policies used to set permissions boundaries, set the value
#' to `PermissionsBoundary`.
#' 
#' This parameter is optional. If it is not included, all policies are
#' returned.
#' @param Marker Use this parameter only when paginating results and only after you
#' receive a response indicating that the results are truncated. Set it to
#' the value of the `Marker` element in the response that you received to
#' indicate where the next call should start.
#' @param MaxItems Use this only when paginating results to indicate the maximum number of
#' items you want in the response. If additional items exist beyond the
#' maximum you specify, the `IsTruncated` response element is `true`.
#' 
#' If you do not include this parameter, the number of items defaults to
#' 100. Note that IAM might return fewer results, even when there are more
#' results available. In that case, the `IsTruncated` response element
#' returns `true`, and `Marker` contains a value to include in the
#' subsequent call that tells the service where to continue from.
#'
#' @keywords internal
#'
#' @rdname iam_list_entities_for_policy
iam_list_entities_for_policy <- function(PolicyArn, EntityFilter = NULL, PathPrefix = NULL, PolicyUsageFilter = NULL, Marker = NULL, MaxItems = NULL) {
  op <- new_operation(
    name = "ListEntitiesForPolicy",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "Marker", limit_key = "MaxItems", more_results = "IsTruncated", output_token = "Marker", result_key = list("PolicyGroups", "PolicyUsers", "PolicyRoles")),
    stream_api = FALSE
  )
  input <- .iam$list_entities_for_policy_input(PolicyArn = PolicyArn, EntityFilter = EntityFilter, PathPrefix = PathPrefix, PolicyUsageFilter = PolicyUsageFilter, Marker = Marker, MaxItems = MaxItems)
  output <- .iam$list_entities_for_policy_output()
  config <- get_config()
  svc <- .iam$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$list_entities_for_policy <- iam_list_entities_for_policy

#' Lists the names of the inline policies that are embedded in the
#' specified IAM group
#'
#' @description
#' Lists the names of the inline policies that are embedded in the specified IAM group.
#'
#' See [https://www.paws-r-sdk.com/docs/iam_list_group_policies/](https://www.paws-r-sdk.com/docs/iam_list_group_policies/) for full documentation.
#'
#' @param GroupName &#91;required&#93; The name of the group to list policies for.
#' 
#' This parameter allows (through its [regex
#' pattern](https://en.wikipedia.org/wiki/Regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: _+=,.@@-
#' @param Marker Use this parameter only when paginating results and only after you
#' receive a response indicating that the results are truncated. Set it to
#' the value of the `Marker` element in the response that you received to
#' indicate where the next call should start.
#' @param MaxItems Use this only when paginating results to indicate the maximum number of
#' items you want in the response. If additional items exist beyond the
#' maximum you specify, the `IsTruncated` response element is `true`.
#' 
#' If you do not include this parameter, the number of items defaults to
#' 100. Note that IAM might return fewer results, even when there are more
#' results available. In that case, the `IsTruncated` response element
#' returns `true`, and `Marker` contains a value to include in the
#' subsequent call that tells the service where to continue from.
#'
#' @keywords internal
#'
#' @rdname iam_list_group_policies
iam_list_group_policies <- function(GroupName, Marker = NULL, MaxItems = NULL) {
  op <- new_operation(
    name = "ListGroupPolicies",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "Marker", limit_key = "MaxItems", more_results = "IsTruncated", output_token = "Marker", result_key = "PolicyNames"),
    stream_api = FALSE
  )
  input <- .iam$list_group_policies_input(GroupName = GroupName, Marker = Marker, MaxItems = MaxItems)
  output <- .iam$list_group_policies_output()
  config <- get_config()
  svc <- .iam$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$list_group_policies <- iam_list_group_policies

#' Lists the IAM groups that have the specified path prefix
#'
#' @description
#' Lists the IAM groups that have the specified path prefix.
#'
#' See [https://www.paws-r-sdk.com/docs/iam_list_groups/](https://www.paws-r-sdk.com/docs/iam_list_groups/) for full documentation.
#'
#' @param PathPrefix The path prefix for filtering the results. For example, the prefix
#' `/division_abc/subdivision_xyz/` gets all groups whose path starts with
#' `/division_abc/subdivision_xyz/`.
#' 
#' This parameter is optional. If it is not included, it defaults to a
#' slash (/), listing all groups. This parameter allows (through its [regex
#' pattern](https://en.wikipedia.org/wiki/Regex)) a string of characters
#' consisting of either a forward slash (/) by itself or a string that must
#' begin and end with forward slashes. In addition, it can contain any
#' ASCII character from the ! (``U+0021``) through the DEL character
#' (``U+007F``), including most punctuation characters, digits, and upper and
#' lowercased letters.
#' @param Marker Use this parameter only when paginating results and only after you
#' receive a response indicating that the results are truncated. Set it to
#' the value of the `Marker` element in the response that you received to
#' indicate where the next call should start.
#' @param MaxItems Use this only when paginating results to indicate the maximum number of
#' items you want in the response. If additional items exist beyond the
#' maximum you specify, the `IsTruncated` response element is `true`.
#' 
#' If you do not include this parameter, the number of items defaults to
#' 100. Note that IAM might return fewer results, even when there are more
#' results available. In that case, the `IsTruncated` response element
#' returns `true`, and `Marker` contains a value to include in the
#' subsequent call that tells the service where to continue from.
#'
#' @keywords internal
#'
#' @rdname iam_list_groups
iam_list_groups <- function(PathPrefix = NULL, Marker = NULL, MaxItems = NULL) {
  op <- new_operation(
    name = "ListGroups",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "Marker", limit_key = "MaxItems", more_results = "IsTruncated", output_token = "Marker", result_key = "Groups"),
    stream_api = FALSE
  )
  input <- .iam$list_groups_input(PathPrefix = PathPrefix, Marker = Marker, MaxItems = MaxItems)
  output <- .iam$list_groups_output()
  config <- get_config()
  svc <- .iam$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$list_groups <- iam_list_groups

#' Lists the IAM groups that the specified IAM user belongs to
#'
#' @description
#' Lists the IAM groups that the specified IAM user belongs to.
#'
#' See [https://www.paws-r-sdk.com/docs/iam_list_groups_for_user/](https://www.paws-r-sdk.com/docs/iam_list_groups_for_user/) for full documentation.
#'
#' @param UserName &#91;required&#93; The name of the user to list groups for.
#' 
#' This parameter allows (through its [regex
#' pattern](https://en.wikipedia.org/wiki/Regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: _+=,.@@-
#' @param Marker Use this parameter only when paginating results and only after you
#' receive a response indicating that the results are truncated. Set it to
#' the value of the `Marker` element in the response that you received to
#' indicate where the next call should start.
#' @param MaxItems Use this only when paginating results to indicate the maximum number of
#' items you want in the response. If additional items exist beyond the
#' maximum you specify, the `IsTruncated` response element is `true`.
#' 
#' If you do not include this parameter, the number of items defaults to
#' 100. Note that IAM might return fewer results, even when there are more
#' results available. In that case, the `IsTruncated` response element
#' returns `true`, and `Marker` contains a value to include in the
#' subsequent call that tells the service where to continue from.
#'
#' @keywords internal
#'
#' @rdname iam_list_groups_for_user
iam_list_groups_for_user <- function(UserName, Marker = NULL, MaxItems = NULL) {
  op <- new_operation(
    name = "ListGroupsForUser",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "Marker", limit_key = "MaxItems", more_results = "IsTruncated", output_token = "Marker", result_key = "Groups"),
    stream_api = FALSE
  )
  input <- .iam$list_groups_for_user_input(UserName = UserName, Marker = Marker, MaxItems = MaxItems)
  output <- .iam$list_groups_for_user_output()
  config <- get_config()
  svc <- .iam$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$list_groups_for_user <- iam_list_groups_for_user

#' Lists the tags that are attached to the specified IAM instance profile
#'
#' @description
#' Lists the tags that are attached to the specified IAM instance profile. The returned list of tags is sorted by tag key. For more information about tagging, see [Tagging IAM resources](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html) in the *IAM User Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/iam_list_instance_profile_tags/](https://www.paws-r-sdk.com/docs/iam_list_instance_profile_tags/) for full documentation.
#'
#' @param InstanceProfileName &#91;required&#93; The name of the IAM instance profile whose tags you want to see.
#' 
#' This parameter allows (through its [regex
#' pattern](https://en.wikipedia.org/wiki/Regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: _+=,.@@-
#' @param Marker Use this parameter only when paginating results and only after you
#' receive a response indicating that the results are truncated. Set it to
#' the value of the `Marker` element in the response that you received to
#' indicate where the next call should start.
#' @param MaxItems Use this only when paginating results to indicate the maximum number of
#' items you want in the response. If additional items exist beyond the
#' maximum you specify, the `IsTruncated` response element is `true`.
#' 
#' If you do not include this parameter, the number of items defaults to
#' 100. Note that IAM might return fewer results, even when there are more
#' results available. In that case, the `IsTruncated` response element
#' returns `true`, and `Marker` contains a value to include in the
#' subsequent call that tells the service where to continue from.
#'
#' @keywords internal
#'
#' @rdname iam_list_instance_profile_tags
iam_list_instance_profile_tags <- function(InstanceProfileName, Marker = NULL, MaxItems = NULL) {
  op <- new_operation(
    name = "ListInstanceProfileTags",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "Marker", limit_key = "MaxItems", more_results = "IsTruncated", output_token = "Marker", result_key = "Tags"),
    stream_api = FALSE
  )
  input <- .iam$list_instance_profile_tags_input(InstanceProfileName = InstanceProfileName, Marker = Marker, MaxItems = MaxItems)
  output <- .iam$list_instance_profile_tags_output()
  config <- get_config()
  svc <- .iam$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$list_instance_profile_tags <- iam_list_instance_profile_tags

#' Lists the instance profiles that have the specified path prefix
#'
#' @description
#' Lists the instance profiles that have the specified path prefix. If there are none, the operation returns an empty list. For more information about instance profiles, see [Using instance profiles](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use_switch-role-ec2_instance-profiles.html) in the *IAM User Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/iam_list_instance_profiles/](https://www.paws-r-sdk.com/docs/iam_list_instance_profiles/) for full documentation.
#'
#' @param PathPrefix The path prefix for filtering the results. For example, the prefix
#' `/application_abc/component_xyz/` gets all instance profiles whose path
#' starts with `/application_abc/component_xyz/`.
#' 
#' This parameter is optional. If it is not included, it defaults to a
#' slash (/), listing all instance profiles. This parameter allows (through
#' its [regex pattern](https://en.wikipedia.org/wiki/Regex)) a string of
#' characters consisting of either a forward slash (/) by itself or a
#' string that must begin and end with forward slashes. In addition, it can
#' contain any ASCII character from the ! (``U+0021``) through the DEL
#' character (``U+007F``), including most punctuation characters, digits, and
#' upper and lowercased letters.
#' @param Marker Use this parameter only when paginating results and only after you
#' receive a response indicating that the results are truncated. Set it to
#' the value of the `Marker` element in the response that you received to
#' indicate where the next call should start.
#' @param MaxItems Use this only when paginating results to indicate the maximum number of
#' items you want in the response. If additional items exist beyond the
#' maximum you specify, the `IsTruncated` response element is `true`.
#' 
#' If you do not include this parameter, the number of items defaults to
#' 100. Note that IAM might return fewer results, even when there are more
#' results available. In that case, the `IsTruncated` response element
#' returns `true`, and `Marker` contains a value to include in the
#' subsequent call that tells the service where to continue from.
#'
#' @keywords internal
#'
#' @rdname iam_list_instance_profiles
iam_list_instance_profiles <- function(PathPrefix = NULL, Marker = NULL, MaxItems = NULL) {
  op <- new_operation(
    name = "ListInstanceProfiles",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "Marker", limit_key = "MaxItems", more_results = "IsTruncated", output_token = "Marker", result_key = "InstanceProfiles"),
    stream_api = FALSE
  )
  input <- .iam$list_instance_profiles_input(PathPrefix = PathPrefix, Marker = Marker, MaxItems = MaxItems)
  output <- .iam$list_instance_profiles_output()
  config <- get_config()
  svc <- .iam$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$list_instance_profiles <- iam_list_instance_profiles

#' Lists the instance profiles that have the specified associated IAM role
#'
#' @description
#' Lists the instance profiles that have the specified associated IAM role. If there are none, the operation returns an empty list. For more information about instance profiles, go to [Using instance profiles](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use_switch-role-ec2_instance-profiles.html) in the *IAM User Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/iam_list_instance_profiles_for_role/](https://www.paws-r-sdk.com/docs/iam_list_instance_profiles_for_role/) for full documentation.
#'
#' @param RoleName &#91;required&#93; The name of the role to list instance profiles for.
#' 
#' This parameter allows (through its [regex
#' pattern](https://en.wikipedia.org/wiki/Regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: _+=,.@@-
#' @param Marker Use this parameter only when paginating results and only after you
#' receive a response indicating that the results are truncated. Set it to
#' the value of the `Marker` element in the response that you received to
#' indicate where the next call should start.
#' @param MaxItems Use this only when paginating results to indicate the maximum number of
#' items you want in the response. If additional items exist beyond the
#' maximum you specify, the `IsTruncated` response element is `true`.
#' 
#' If you do not include this parameter, the number of items defaults to
#' 100. Note that IAM might return fewer results, even when there are more
#' results available. In that case, the `IsTruncated` response element
#' returns `true`, and `Marker` contains a value to include in the
#' subsequent call that tells the service where to continue from.
#'
#' @keywords internal
#'
#' @rdname iam_list_instance_profiles_for_role
iam_list_instance_profiles_for_role <- function(RoleName, Marker = NULL, MaxItems = NULL) {
  op <- new_operation(
    name = "ListInstanceProfilesForRole",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "Marker", limit_key = "MaxItems", more_results = "IsTruncated", output_token = "Marker", result_key = "InstanceProfiles"),
    stream_api = FALSE
  )
  input <- .iam$list_instance_profiles_for_role_input(RoleName = RoleName, Marker = Marker, MaxItems = MaxItems)
  output <- .iam$list_instance_profiles_for_role_output()
  config <- get_config()
  svc <- .iam$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$list_instance_profiles_for_role <- iam_list_instance_profiles_for_role

#' Lists the tags that are attached to the specified IAM virtual
#' multi-factor authentication (MFA) device
#'
#' @description
#' Lists the tags that are attached to the specified IAM virtual multi-factor authentication (MFA) device. The returned list of tags is sorted by tag key. For more information about tagging, see [Tagging IAM resources](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html) in the *IAM User Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/iam_list_mfa_device_tags/](https://www.paws-r-sdk.com/docs/iam_list_mfa_device_tags/) for full documentation.
#'
#' @param SerialNumber &#91;required&#93; The unique identifier for the IAM virtual MFA device whose tags you want
#' to see. For virtual MFA devices, the serial number is the same as the
#' ARN.
#' 
#' This parameter allows (through its [regex
#' pattern](https://en.wikipedia.org/wiki/Regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: _+=,.@@-
#' @param Marker Use this parameter only when paginating results and only after you
#' receive a response indicating that the results are truncated. Set it to
#' the value of the `Marker` element in the response that you received to
#' indicate where the next call should start.
#' @param MaxItems Use this only when paginating results to indicate the maximum number of
#' items you want in the response. If additional items exist beyond the
#' maximum you specify, the `IsTruncated` response element is `true`.
#' 
#' If you do not include this parameter, the number of items defaults to
#' 100. Note that IAM might return fewer results, even when there are more
#' results available. In that case, the `IsTruncated` response element
#' returns `true`, and `Marker` contains a value to include in the
#' subsequent call that tells the service where to continue from.
#'
#' @keywords internal
#'
#' @rdname iam_list_mfa_device_tags
iam_list_mfa_device_tags <- function(SerialNumber, Marker = NULL, MaxItems = NULL) {
  op <- new_operation(
    name = "ListMFADeviceTags",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "Marker", limit_key = "MaxItems", more_results = "IsTruncated", output_token = "Marker", result_key = "Tags"),
    stream_api = FALSE
  )
  input <- .iam$list_mfa_device_tags_input(SerialNumber = SerialNumber, Marker = Marker, MaxItems = MaxItems)
  output <- .iam$list_mfa_device_tags_output()
  config <- get_config()
  svc <- .iam$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$list_mfa_device_tags <- iam_list_mfa_device_tags

#' Lists the MFA devices for an IAM user
#'
#' @description
#' Lists the MFA devices for an IAM user. If the request includes a IAM user name, then this operation lists all the MFA devices associated with the specified user. If you do not specify a user name, IAM determines the user name implicitly based on the Amazon Web Services access key ID signing the request for this operation.
#'
#' See [https://www.paws-r-sdk.com/docs/iam_list_mfa_devices/](https://www.paws-r-sdk.com/docs/iam_list_mfa_devices/) for full documentation.
#'
#' @param UserName The name of the user whose MFA devices you want to list.
#' 
#' This parameter allows (through its [regex
#' pattern](https://en.wikipedia.org/wiki/Regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: _+=,.@@-
#' @param Marker Use this parameter only when paginating results and only after you
#' receive a response indicating that the results are truncated. Set it to
#' the value of the `Marker` element in the response that you received to
#' indicate where the next call should start.
#' @param MaxItems Use this only when paginating results to indicate the maximum number of
#' items you want in the response. If additional items exist beyond the
#' maximum you specify, the `IsTruncated` response element is `true`.
#' 
#' If you do not include this parameter, the number of items defaults to
#' 100. Note that IAM might return fewer results, even when there are more
#' results available. In that case, the `IsTruncated` response element
#' returns `true`, and `Marker` contains a value to include in the
#' subsequent call that tells the service where to continue from.
#'
#' @keywords internal
#'
#' @rdname iam_list_mfa_devices
iam_list_mfa_devices <- function(UserName = NULL, Marker = NULL, MaxItems = NULL) {
  op <- new_operation(
    name = "ListMFADevices",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "Marker", limit_key = "MaxItems", more_results = "IsTruncated", output_token = "Marker", result_key = "MFADevices"),
    stream_api = FALSE
  )
  input <- .iam$list_mfa_devices_input(UserName = UserName, Marker = Marker, MaxItems = MaxItems)
  output <- .iam$list_mfa_devices_output()
  config <- get_config()
  svc <- .iam$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$list_mfa_devices <- iam_list_mfa_devices

#' Lists the tags that are attached to the specified OpenID Connect
#' (OIDC)-compatible identity provider
#'
#' @description
#' Lists the tags that are attached to the specified OpenID Connect (OIDC)-compatible identity provider. The returned list of tags is sorted by tag key. For more information, see [About web identity federation](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_oidc.html).
#'
#' See [https://www.paws-r-sdk.com/docs/iam_list_open_id_connect_provider_tags/](https://www.paws-r-sdk.com/docs/iam_list_open_id_connect_provider_tags/) for full documentation.
#'
#' @param OpenIDConnectProviderArn &#91;required&#93; The ARN of the OpenID Connect (OIDC) identity provider whose tags you
#' want to see.
#' 
#' This parameter allows (through its [regex
#' pattern](https://en.wikipedia.org/wiki/Regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: _+=,.@@-
#' @param Marker Use this parameter only when paginating results and only after you
#' receive a response indicating that the results are truncated. Set it to
#' the value of the `Marker` element in the response that you received to
#' indicate where the next call should start.
#' @param MaxItems Use this only when paginating results to indicate the maximum number of
#' items you want in the response. If additional items exist beyond the
#' maximum you specify, the `IsTruncated` response element is `true`.
#' 
#' If you do not include this parameter, the number of items defaults to
#' 100. Note that IAM might return fewer results, even when there are more
#' results available. In that case, the `IsTruncated` response element
#' returns `true`, and `Marker` contains a value to include in the
#' subsequent call that tells the service where to continue from.
#'
#' @keywords internal
#'
#' @rdname iam_list_open_id_connect_provider_tags
iam_list_open_id_connect_provider_tags <- function(OpenIDConnectProviderArn, Marker = NULL, MaxItems = NULL) {
  op <- new_operation(
    name = "ListOpenIDConnectProviderTags",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "Marker", limit_key = "MaxItems", more_results = "IsTruncated", output_token = "Marker", result_key = "Tags"),
    stream_api = FALSE
  )
  input <- .iam$list_open_id_connect_provider_tags_input(OpenIDConnectProviderArn = OpenIDConnectProviderArn, Marker = Marker, MaxItems = MaxItems)
  output <- .iam$list_open_id_connect_provider_tags_output()
  config <- get_config()
  svc <- .iam$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$list_open_id_connect_provider_tags <- iam_list_open_id_connect_provider_tags

#' Lists information about the IAM OpenID Connect (OIDC) provider resource
#' objects defined in the Amazon Web Services account
#'
#' @description
#' Lists information about the IAM OpenID Connect (OIDC) provider resource objects defined in the Amazon Web Services account.
#'
#' See [https://www.paws-r-sdk.com/docs/iam_list_open_id_connect_providers/](https://www.paws-r-sdk.com/docs/iam_list_open_id_connect_providers/) for full documentation.
#'

#'
#' @keywords internal
#'
#' @rdname iam_list_open_id_connect_providers
iam_list_open_id_connect_providers <- function() {
  op <- new_operation(
    name = "ListOpenIDConnectProviders",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .iam$list_open_id_connect_providers_input()
  output <- .iam$list_open_id_connect_providers_output()
  config <- get_config()
  svc <- .iam$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$list_open_id_connect_providers <- iam_list_open_id_connect_providers

#' Lists the centralized root access features enabled for your organization
#'
#' @description
#' Lists the centralized root access features enabled for your organization. For more information, see [Centrally manage root access for member accounts](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_root-user.html#id_root-user-access-management).
#'
#' See [https://www.paws-r-sdk.com/docs/iam_list_organizations_features/](https://www.paws-r-sdk.com/docs/iam_list_organizations_features/) for full documentation.
#'

#'
#' @keywords internal
#'
#' @rdname iam_list_organizations_features
iam_list_organizations_features <- function() {
  op <- new_operation(
    name = "ListOrganizationsFeatures",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .iam$list_organizations_features_input()
  output <- .iam$list_organizations_features_output()
  config <- get_config()
  svc <- .iam$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$list_organizations_features <- iam_list_organizations_features

#' Lists all the managed policies that are available in your Amazon Web
#' Services account, including your own customer-defined managed policies
#' and all Amazon Web Services managed policies
#'
#' @description
#' Lists all the managed policies that are available in your Amazon Web Services account, including your own customer-defined managed policies and all Amazon Web Services managed policies.
#'
#' See [https://www.paws-r-sdk.com/docs/iam_list_policies/](https://www.paws-r-sdk.com/docs/iam_list_policies/) for full documentation.
#'
#' @param Scope The scope to use for filtering the results.
#' 
#' To list only Amazon Web Services managed policies, set `Scope` to `AWS`.
#' To list only the customer managed policies in your Amazon Web Services
#' account, set `Scope` to `Local`.
#' 
#' This parameter is optional. If it is not included, or if it is set to
#' `All`, all policies are returned.
#' @param OnlyAttached A flag to filter the results to only the attached policies.
#' 
#' When `OnlyAttached` is `true`, the returned list contains only the
#' policies that are attached to an IAM user, group, or role. When
#' `OnlyAttached` is `false`, or when the parameter is not included, all
#' policies are returned.
#' @param PathPrefix The path prefix for filtering the results. This parameter is optional.
#' If it is not included, it defaults to a slash (/), listing all policies.
#' This parameter allows (through its [regex
#' pattern](https://en.wikipedia.org/wiki/Regex)) a string of characters
#' consisting of either a forward slash (/) by itself or a string that must
#' begin and end with forward slashes. In addition, it can contain any
#' ASCII character from the ! (``U+0021``) through the DEL character
#' (``U+007F``), including most punctuation characters, digits, and upper and
#' lowercased letters.
#' @param PolicyUsageFilter The policy usage method to use for filtering the results.
#' 
#' To list only permissions policies,
#' set `PolicyUsageFilter` to `PermissionsPolicy`. To list only the
#' policies used to set permissions boundaries, set the value
#' to `PermissionsBoundary`.
#' 
#' This parameter is optional. If it is not included, all policies are
#' returned.
#' @param Marker Use this parameter only when paginating results and only after you
#' receive a response indicating that the results are truncated. Set it to
#' the value of the `Marker` element in the response that you received to
#' indicate where the next call should start.
#' @param MaxItems Use this only when paginating results to indicate the maximum number of
#' items you want in the response. If additional items exist beyond the
#' maximum you specify, the `IsTruncated` response element is `true`.
#' 
#' If you do not include this parameter, the number of items defaults to
#' 100. Note that IAM might return fewer results, even when there are more
#' results available. In that case, the `IsTruncated` response element
#' returns `true`, and `Marker` contains a value to include in the
#' subsequent call that tells the service where to continue from.
#'
#' @keywords internal
#'
#' @rdname iam_list_policies
iam_list_policies <- function(Scope = NULL, OnlyAttached = NULL, PathPrefix = NULL, PolicyUsageFilter = NULL, Marker = NULL, MaxItems = NULL) {
  op <- new_operation(
    name = "ListPolicies",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "Marker", limit_key = "MaxItems", more_results = "IsTruncated", output_token = "Marker", result_key = "Policies"),
    stream_api = FALSE
  )
  input <- .iam$list_policies_input(Scope = Scope, OnlyAttached = OnlyAttached, PathPrefix = PathPrefix, PolicyUsageFilter = PolicyUsageFilter, Marker = Marker, MaxItems = MaxItems)
  output <- .iam$list_policies_output()
  config <- get_config()
  svc <- .iam$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$list_policies <- iam_list_policies

#' Retrieves a list of policies that the IAM identity (user, group, or
#' role) can use to access each specified service
#'
#' @description
#' Retrieves a list of policies that the IAM identity (user, group, or role) can use to access each specified service.
#'
#' See [https://www.paws-r-sdk.com/docs/iam_list_policies_granting_service_access/](https://www.paws-r-sdk.com/docs/iam_list_policies_granting_service_access/) for full documentation.
#'
#' @param Marker Use this parameter only when paginating results and only after you
#' receive a response indicating that the results are truncated. Set it to
#' the value of the `Marker` element in the response that you received to
#' indicate where the next call should start.
#' @param Arn &#91;required&#93; The ARN of the IAM identity (user, group, or role) whose policies you
#' want to list.
#' @param ServiceNamespaces &#91;required&#93; The service namespace for the Amazon Web Services services whose
#' policies you want to list.
#' 
#' To learn the service namespace for a service, see [Actions, resources,
#' and condition keys for Amazon Web Services
#' services](https://docs.aws.amazon.com/service-authorization/latest/reference/reference_policies_actions-resources-contextkeys.html)
#' in the *IAM User Guide*. Choose the name of the service to view details
#' for that service. In the first paragraph, find the service prefix. For
#' example, `(service prefix: a4b)`. For more information about service
#' namespaces, see [Amazon Web Services service
#' namespaces](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html#genref-aws-service-namespaces)
#' in the *Amazon Web Services General Reference*.
#'
#' @keywords internal
#'
#' @rdname iam_list_policies_granting_service_access
iam_list_policies_granting_service_access <- function(Marker = NULL, Arn, ServiceNamespaces) {
  op <- new_operation(
    name = "ListPoliciesGrantingServiceAccess",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .iam$list_policies_granting_service_access_input(Marker = Marker, Arn = Arn, ServiceNamespaces = ServiceNamespaces)
  output <- .iam$list_policies_granting_service_access_output()
  config <- get_config()
  svc <- .iam$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$list_policies_granting_service_access <- iam_list_policies_granting_service_access

#' Lists the tags that are attached to the specified IAM customer managed
#' policy
#'
#' @description
#' Lists the tags that are attached to the specified IAM customer managed policy. The returned list of tags is sorted by tag key. For more information about tagging, see [Tagging IAM resources](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html) in the *IAM User Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/iam_list_policy_tags/](https://www.paws-r-sdk.com/docs/iam_list_policy_tags/) for full documentation.
#'
#' @param PolicyArn &#91;required&#93; The ARN of the IAM customer managed policy whose tags you want to see.
#' 
#' This parameter allows (through its [regex
#' pattern](https://en.wikipedia.org/wiki/Regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: _+=,.@@-
#' @param Marker Use this parameter only when paginating results and only after you
#' receive a response indicating that the results are truncated. Set it to
#' the value of the `Marker` element in the response that you received to
#' indicate where the next call should start.
#' @param MaxItems Use this only when paginating results to indicate the maximum number of
#' items you want in the response. If additional items exist beyond the
#' maximum you specify, the `IsTruncated` response element is `true`.
#' 
#' If you do not include this parameter, the number of items defaults to
#' 100. Note that IAM might return fewer results, even when there are more
#' results available. In that case, the `IsTruncated` response element
#' returns `true`, and `Marker` contains a value to include in the
#' subsequent call that tells the service where to continue from.
#'
#' @keywords internal
#'
#' @rdname iam_list_policy_tags
iam_list_policy_tags <- function(PolicyArn, Marker = NULL, MaxItems = NULL) {
  op <- new_operation(
    name = "ListPolicyTags",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "Marker", limit_key = "MaxItems", more_results = "IsTruncated", output_token = "Marker", result_key = "Tags"),
    stream_api = FALSE
  )
  input <- .iam$list_policy_tags_input(PolicyArn = PolicyArn, Marker = Marker, MaxItems = MaxItems)
  output <- .iam$list_policy_tags_output()
  config <- get_config()
  svc <- .iam$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$list_policy_tags <- iam_list_policy_tags

#' Lists information about the versions of the specified managed policy,
#' including the version that is currently set as the policy's default
#' version
#'
#' @description
#' Lists information about the versions of the specified managed policy, including the version that is currently set as the policy's default version.
#'
#' See [https://www.paws-r-sdk.com/docs/iam_list_policy_versions/](https://www.paws-r-sdk.com/docs/iam_list_policy_versions/) for full documentation.
#'
#' @param PolicyArn &#91;required&#93; The Amazon Resource Name (ARN) of the IAM policy for which you want the
#' versions.
#' 
#' For more information about ARNs, see [Amazon Resource Names
#' (ARNs)](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html)
#' in the *Amazon Web Services General Reference*.
#' @param Marker Use this parameter only when paginating results and only after you
#' receive a response indicating that the results are truncated. Set it to
#' the value of the `Marker` element in the response that you received to
#' indicate where the next call should start.
#' @param MaxItems Use this only when paginating results to indicate the maximum number of
#' items you want in the response. If additional items exist beyond the
#' maximum you specify, the `IsTruncated` response element is `true`.
#' 
#' If you do not include this parameter, the number of items defaults to
#' 100. Note that IAM might return fewer results, even when there are more
#' results available. In that case, the `IsTruncated` response element
#' returns `true`, and `Marker` contains a value to include in the
#' subsequent call that tells the service where to continue from.
#'
#' @keywords internal
#'
#' @rdname iam_list_policy_versions
iam_list_policy_versions <- function(PolicyArn, Marker = NULL, MaxItems = NULL) {
  op <- new_operation(
    name = "ListPolicyVersions",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "Marker", limit_key = "MaxItems", more_results = "IsTruncated", output_token = "Marker", result_key = "Versions"),
    stream_api = FALSE
  )
  input <- .iam$list_policy_versions_input(PolicyArn = PolicyArn, Marker = Marker, MaxItems = MaxItems)
  output <- .iam$list_policy_versions_output()
  config <- get_config()
  svc <- .iam$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$list_policy_versions <- iam_list_policy_versions

#' Lists the names of the inline policies that are embedded in the
#' specified IAM role
#'
#' @description
#' Lists the names of the inline policies that are embedded in the specified IAM role.
#'
#' See [https://www.paws-r-sdk.com/docs/iam_list_role_policies/](https://www.paws-r-sdk.com/docs/iam_list_role_policies/) for full documentation.
#'
#' @param RoleName &#91;required&#93; The name of the role to list policies for.
#' 
#' This parameter allows (through its [regex
#' pattern](https://en.wikipedia.org/wiki/Regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: _+=,.@@-
#' @param Marker Use this parameter only when paginating results and only after you
#' receive a response indicating that the results are truncated. Set it to
#' the value of the `Marker` element in the response that you received to
#' indicate where the next call should start.
#' @param MaxItems Use this only when paginating results to indicate the maximum number of
#' items you want in the response. If additional items exist beyond the
#' maximum you specify, the `IsTruncated` response element is `true`.
#' 
#' If you do not include this parameter, the number of items defaults to
#' 100. Note that IAM might return fewer results, even when there are more
#' results available. In that case, the `IsTruncated` response element
#' returns `true`, and `Marker` contains a value to include in the
#' subsequent call that tells the service where to continue from.
#'
#' @keywords internal
#'
#' @rdname iam_list_role_policies
iam_list_role_policies <- function(RoleName, Marker = NULL, MaxItems = NULL) {
  op <- new_operation(
    name = "ListRolePolicies",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "Marker", limit_key = "MaxItems", more_results = "IsTruncated", output_token = "Marker", result_key = "PolicyNames"),
    stream_api = FALSE
  )
  input <- .iam$list_role_policies_input(RoleName = RoleName, Marker = Marker, MaxItems = MaxItems)
  output <- .iam$list_role_policies_output()
  config <- get_config()
  svc <- .iam$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$list_role_policies <- iam_list_role_policies

#' Lists the tags that are attached to the specified role
#'
#' @description
#' Lists the tags that are attached to the specified role. The returned list of tags is sorted by tag key. For more information about tagging, see [Tagging IAM resources](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html) in the *IAM User Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/iam_list_role_tags/](https://www.paws-r-sdk.com/docs/iam_list_role_tags/) for full documentation.
#'
#' @param RoleName &#91;required&#93; The name of the IAM role for which you want to see the list of tags.
#' 
#' This parameter accepts (through its [regex
#' pattern](https://en.wikipedia.org/wiki/Regex)) a string of characters
#' that consist of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: _+=,.@@-
#' @param Marker Use this parameter only when paginating results and only after you
#' receive a response indicating that the results are truncated. Set it to
#' the value of the `Marker` element in the response that you received to
#' indicate where the next call should start.
#' @param MaxItems Use this only when paginating results to indicate the maximum number of
#' items you want in the response. If additional items exist beyond the
#' maximum you specify, the `IsTruncated` response element is `true`.
#' 
#' If you do not include this parameter, the number of items defaults to
#' 100. Note that IAM might return fewer results, even when there are more
#' results available. In that case, the `IsTruncated` response element
#' returns `true`, and `Marker` contains a value to include in the
#' subsequent call that tells the service where to continue from.
#'
#' @keywords internal
#'
#' @rdname iam_list_role_tags
iam_list_role_tags <- function(RoleName, Marker = NULL, MaxItems = NULL) {
  op <- new_operation(
    name = "ListRoleTags",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "Marker", limit_key = "MaxItems", more_results = "IsTruncated", output_token = "Marker", result_key = "Tags"),
    stream_api = FALSE
  )
  input <- .iam$list_role_tags_input(RoleName = RoleName, Marker = Marker, MaxItems = MaxItems)
  output <- .iam$list_role_tags_output()
  config <- get_config()
  svc <- .iam$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$list_role_tags <- iam_list_role_tags

#' Lists the IAM roles that have the specified path prefix
#'
#' @description
#' Lists the IAM roles that have the specified path prefix. If there are none, the operation returns an empty list. For more information about roles, see [IAM roles](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles.html) in the *IAM User Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/iam_list_roles/](https://www.paws-r-sdk.com/docs/iam_list_roles/) for full documentation.
#'
#' @param PathPrefix The path prefix for filtering the results. For example, the prefix
#' `/application_abc/component_xyz/` gets all roles whose path starts with
#' `/application_abc/component_xyz/`.
#' 
#' This parameter is optional. If it is not included, it defaults to a
#' slash (/), listing all roles. This parameter allows (through its [regex
#' pattern](https://en.wikipedia.org/wiki/Regex)) a string of characters
#' consisting of either a forward slash (/) by itself or a string that must
#' begin and end with forward slashes. In addition, it can contain any
#' ASCII character from the ! (``U+0021``) through the DEL character
#' (``U+007F``), including most punctuation characters, digits, and upper and
#' lowercased letters.
#' @param Marker Use this parameter only when paginating results and only after you
#' receive a response indicating that the results are truncated. Set it to
#' the value of the `Marker` element in the response that you received to
#' indicate where the next call should start.
#' @param MaxItems Use this only when paginating results to indicate the maximum number of
#' items you want in the response. If additional items exist beyond the
#' maximum you specify, the `IsTruncated` response element is `true`.
#' 
#' If you do not include this parameter, the number of items defaults to
#' 100. Note that IAM might return fewer results, even when there are more
#' results available. In that case, the `IsTruncated` response element
#' returns `true`, and `Marker` contains a value to include in the
#' subsequent call that tells the service where to continue from.
#'
#' @keywords internal
#'
#' @rdname iam_list_roles
iam_list_roles <- function(PathPrefix = NULL, Marker = NULL, MaxItems = NULL) {
  op <- new_operation(
    name = "ListRoles",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "Marker", limit_key = "MaxItems", more_results = "IsTruncated", output_token = "Marker", result_key = "Roles"),
    stream_api = FALSE
  )
  input <- .iam$list_roles_input(PathPrefix = PathPrefix, Marker = Marker, MaxItems = MaxItems)
  output <- .iam$list_roles_output()
  config <- get_config()
  svc <- .iam$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$list_roles <- iam_list_roles

#' Lists the tags that are attached to the specified Security Assertion
#' Markup Language (SAML) identity provider
#'
#' @description
#' Lists the tags that are attached to the specified Security Assertion Markup Language (SAML) identity provider. The returned list of tags is sorted by tag key. For more information, see [About SAML 2.0-based federation](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_saml.html).
#'
#' See [https://www.paws-r-sdk.com/docs/iam_list_saml_provider_tags/](https://www.paws-r-sdk.com/docs/iam_list_saml_provider_tags/) for full documentation.
#'
#' @param SAMLProviderArn &#91;required&#93; The ARN of the Security Assertion Markup Language (SAML) identity
#' provider whose tags you want to see.
#' 
#' This parameter allows (through its [regex
#' pattern](https://en.wikipedia.org/wiki/Regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: _+=,.@@-
#' @param Marker Use this parameter only when paginating results and only after you
#' receive a response indicating that the results are truncated. Set it to
#' the value of the `Marker` element in the response that you received to
#' indicate where the next call should start.
#' @param MaxItems Use this only when paginating results to indicate the maximum number of
#' items you want in the response. If additional items exist beyond the
#' maximum you specify, the `IsTruncated` response element is `true`.
#' 
#' If you do not include this parameter, the number of items defaults to
#' 100. Note that IAM might return fewer results, even when there are more
#' results available. In that case, the `IsTruncated` response element
#' returns `true`, and `Marker` contains a value to include in the
#' subsequent call that tells the service where to continue from.
#'
#' @keywords internal
#'
#' @rdname iam_list_saml_provider_tags
iam_list_saml_provider_tags <- function(SAMLProviderArn, Marker = NULL, MaxItems = NULL) {
  op <- new_operation(
    name = "ListSAMLProviderTags",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "Marker", limit_key = "MaxItems", more_results = "IsTruncated", output_token = "Marker", result_key = "Tags"),
    stream_api = FALSE
  )
  input <- .iam$list_saml_provider_tags_input(SAMLProviderArn = SAMLProviderArn, Marker = Marker, MaxItems = MaxItems)
  output <- .iam$list_saml_provider_tags_output()
  config <- get_config()
  svc <- .iam$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$list_saml_provider_tags <- iam_list_saml_provider_tags

#' Lists the SAML provider resource objects defined in IAM in the account
#'
#' @description
#' Lists the SAML provider resource objects defined in IAM in the account. IAM resource-listing operations return a subset of the available attributes for the resource. For example, this operation does not return tags, even though they are an attribute of the returned object. To view all of the information for a SAML provider, see [`get_saml_provider`][iam_get_saml_provider].
#'
#' See [https://www.paws-r-sdk.com/docs/iam_list_saml_providers/](https://www.paws-r-sdk.com/docs/iam_list_saml_providers/) for full documentation.
#'

#'
#' @keywords internal
#'
#' @rdname iam_list_saml_providers
iam_list_saml_providers <- function() {
  op <- new_operation(
    name = "ListSAMLProviders",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .iam$list_saml_providers_input()
  output <- .iam$list_saml_providers_output()
  config <- get_config()
  svc <- .iam$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$list_saml_providers <- iam_list_saml_providers

#' Returns information about the SSH public keys associated with the
#' specified IAM user
#'
#' @description
#' Returns information about the SSH public keys associated with the specified IAM user. If none exists, the operation returns an empty list.
#'
#' See [https://www.paws-r-sdk.com/docs/iam_list_ssh_public_keys/](https://www.paws-r-sdk.com/docs/iam_list_ssh_public_keys/) for full documentation.
#'
#' @param UserName The name of the IAM user to list SSH public keys for. If none is
#' specified, the `UserName` field is determined implicitly based on the
#' Amazon Web Services access key used to sign the request.
#' 
#' This parameter allows (through its [regex
#' pattern](https://en.wikipedia.org/wiki/Regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: _+=,.@@-
#' @param Marker Use this parameter only when paginating results and only after you
#' receive a response indicating that the results are truncated. Set it to
#' the value of the `Marker` element in the response that you received to
#' indicate where the next call should start.
#' @param MaxItems Use this only when paginating results to indicate the maximum number of
#' items you want in the response. If additional items exist beyond the
#' maximum you specify, the `IsTruncated` response element is `true`.
#' 
#' If you do not include this parameter, the number of items defaults to
#' 100. Note that IAM might return fewer results, even when there are more
#' results available. In that case, the `IsTruncated` response element
#' returns `true`, and `Marker` contains a value to include in the
#' subsequent call that tells the service where to continue from.
#'
#' @keywords internal
#'
#' @rdname iam_list_ssh_public_keys
iam_list_ssh_public_keys <- function(UserName = NULL, Marker = NULL, MaxItems = NULL) {
  op <- new_operation(
    name = "ListSSHPublicKeys",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "Marker", limit_key = "MaxItems", more_results = "IsTruncated", output_token = "Marker", result_key = "SSHPublicKeys"),
    stream_api = FALSE
  )
  input <- .iam$list_ssh_public_keys_input(UserName = UserName, Marker = Marker, MaxItems = MaxItems)
  output <- .iam$list_ssh_public_keys_output()
  config <- get_config()
  svc <- .iam$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$list_ssh_public_keys <- iam_list_ssh_public_keys

#' Lists the tags that are attached to the specified IAM server certificate
#'
#' @description
#' Lists the tags that are attached to the specified IAM server certificate. The returned list of tags is sorted by tag key. For more information about tagging, see [Tagging IAM resources](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html) in the *IAM User Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/iam_list_server_certificate_tags/](https://www.paws-r-sdk.com/docs/iam_list_server_certificate_tags/) for full documentation.
#'
#' @param ServerCertificateName &#91;required&#93; The name of the IAM server certificate whose tags you want to see.
#' 
#' This parameter allows (through its [regex
#' pattern](https://en.wikipedia.org/wiki/Regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: _+=,.@@-
#' @param Marker Use this parameter only when paginating results and only after you
#' receive a response indicating that the results are truncated. Set it to
#' the value of the `Marker` element in the response that you received to
#' indicate where the next call should start.
#' @param MaxItems Use this only when paginating results to indicate the maximum number of
#' items you want in the response. If additional items exist beyond the
#' maximum you specify, the `IsTruncated` response element is `true`.
#' 
#' If you do not include this parameter, the number of items defaults to
#' 100. Note that IAM might return fewer results, even when there are more
#' results available. In that case, the `IsTruncated` response element
#' returns `true`, and `Marker` contains a value to include in the
#' subsequent call that tells the service where to continue from.
#'
#' @keywords internal
#'
#' @rdname iam_list_server_certificate_tags
iam_list_server_certificate_tags <- function(ServerCertificateName, Marker = NULL, MaxItems = NULL) {
  op <- new_operation(
    name = "ListServerCertificateTags",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "Marker", limit_key = "MaxItems", more_results = "IsTruncated", output_token = "Marker", result_key = "Tags"),
    stream_api = FALSE
  )
  input <- .iam$list_server_certificate_tags_input(ServerCertificateName = ServerCertificateName, Marker = Marker, MaxItems = MaxItems)
  output <- .iam$list_server_certificate_tags_output()
  config <- get_config()
  svc <- .iam$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$list_server_certificate_tags <- iam_list_server_certificate_tags

#' Lists the server certificates stored in IAM that have the specified path
#' prefix
#'
#' @description
#' Lists the server certificates stored in IAM that have the specified path prefix. If none exist, the operation returns an empty list.
#'
#' See [https://www.paws-r-sdk.com/docs/iam_list_server_certificates/](https://www.paws-r-sdk.com/docs/iam_list_server_certificates/) for full documentation.
#'
#' @param PathPrefix The path prefix for filtering the results. For example:
#' `/company/servercerts` would get all server certificates for which the
#' path starts with `/company/servercerts`.
#' 
#' This parameter is optional. If it is not included, it defaults to a
#' slash (/), listing all server certificates. This parameter allows
#' (through its [regex pattern](https://en.wikipedia.org/wiki/Regex)) a
#' string of characters consisting of either a forward slash (/) by itself
#' or a string that must begin and end with forward slashes. In addition,
#' it can contain any ASCII character from the ! (``U+0021``) through the DEL
#' character (``U+007F``), including most punctuation characters, digits, and
#' upper and lowercased letters.
#' @param Marker Use this parameter only when paginating results and only after you
#' receive a response indicating that the results are truncated. Set it to
#' the value of the `Marker` element in the response that you received to
#' indicate where the next call should start.
#' @param MaxItems Use this only when paginating results to indicate the maximum number of
#' items you want in the response. If additional items exist beyond the
#' maximum you specify, the `IsTruncated` response element is `true`.
#' 
#' If you do not include this parameter, the number of items defaults to
#' 100. Note that IAM might return fewer results, even when there are more
#' results available. In that case, the `IsTruncated` response element
#' returns `true`, and `Marker` contains a value to include in the
#' subsequent call that tells the service where to continue from.
#'
#' @keywords internal
#'
#' @rdname iam_list_server_certificates
iam_list_server_certificates <- function(PathPrefix = NULL, Marker = NULL, MaxItems = NULL) {
  op <- new_operation(
    name = "ListServerCertificates",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "Marker", limit_key = "MaxItems", more_results = "IsTruncated", output_token = "Marker", result_key = "ServerCertificateMetadataList"),
    stream_api = FALSE
  )
  input <- .iam$list_server_certificates_input(PathPrefix = PathPrefix, Marker = Marker, MaxItems = MaxItems)
  output <- .iam$list_server_certificates_output()
  config <- get_config()
  svc <- .iam$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$list_server_certificates <- iam_list_server_certificates

#' Returns information about the service-specific credentials associated
#' with the specified IAM user
#'
#' @description
#' Returns information about the service-specific credentials associated with the specified IAM user. If none exists, the operation returns an empty list. The service-specific credentials returned by this operation are used only for authenticating the IAM user to a specific service. For more information about using service-specific credentials to authenticate to an Amazon Web Services service, see [Set up service-specific credentials](https://docs.aws.amazon.com/codecommit/latest/userguide/setting-up-gc.html) in the CodeCommit User Guide.
#'
#' See [https://www.paws-r-sdk.com/docs/iam_list_service_specific_credentials/](https://www.paws-r-sdk.com/docs/iam_list_service_specific_credentials/) for full documentation.
#'
#' @param UserName The name of the user whose service-specific credentials you want
#' information about. If this value is not specified, then the operation
#' assumes the user whose credentials are used to call the operation.
#' 
#' This parameter allows (through its [regex
#' pattern](https://en.wikipedia.org/wiki/Regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: _+=,.@@-
#' @param ServiceName Filters the returned results to only those for the specified Amazon Web
#' Services service. If not specified, then Amazon Web Services returns
#' service-specific credentials for all services.
#'
#' @keywords internal
#'
#' @rdname iam_list_service_specific_credentials
iam_list_service_specific_credentials <- function(UserName = NULL, ServiceName = NULL) {
  op <- new_operation(
    name = "ListServiceSpecificCredentials",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .iam$list_service_specific_credentials_input(UserName = UserName, ServiceName = ServiceName)
  output <- .iam$list_service_specific_credentials_output()
  config <- get_config()
  svc <- .iam$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$list_service_specific_credentials <- iam_list_service_specific_credentials

#' Returns information about the signing certificates associated with the
#' specified IAM user
#'
#' @description
#' Returns information about the signing certificates associated with the specified IAM user. If none exists, the operation returns an empty list.
#'
#' See [https://www.paws-r-sdk.com/docs/iam_list_signing_certificates/](https://www.paws-r-sdk.com/docs/iam_list_signing_certificates/) for full documentation.
#'
#' @param UserName The name of the IAM user whose signing certificates you want to examine.
#' 
#' This parameter allows (through its [regex
#' pattern](https://en.wikipedia.org/wiki/Regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: _+=,.@@-
#' @param Marker Use this parameter only when paginating results and only after you
#' receive a response indicating that the results are truncated. Set it to
#' the value of the `Marker` element in the response that you received to
#' indicate where the next call should start.
#' @param MaxItems Use this only when paginating results to indicate the maximum number of
#' items you want in the response. If additional items exist beyond the
#' maximum you specify, the `IsTruncated` response element is `true`.
#' 
#' If you do not include this parameter, the number of items defaults to
#' 100. Note that IAM might return fewer results, even when there are more
#' results available. In that case, the `IsTruncated` response element
#' returns `true`, and `Marker` contains a value to include in the
#' subsequent call that tells the service where to continue from.
#'
#' @keywords internal
#'
#' @rdname iam_list_signing_certificates
iam_list_signing_certificates <- function(UserName = NULL, Marker = NULL, MaxItems = NULL) {
  op <- new_operation(
    name = "ListSigningCertificates",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "Marker", limit_key = "MaxItems", more_results = "IsTruncated", output_token = "Marker", result_key = "Certificates"),
    stream_api = FALSE
  )
  input <- .iam$list_signing_certificates_input(UserName = UserName, Marker = Marker, MaxItems = MaxItems)
  output <- .iam$list_signing_certificates_output()
  config <- get_config()
  svc <- .iam$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$list_signing_certificates <- iam_list_signing_certificates

#' Lists the names of the inline policies embedded in the specified IAM
#' user
#'
#' @description
#' Lists the names of the inline policies embedded in the specified IAM user.
#'
#' See [https://www.paws-r-sdk.com/docs/iam_list_user_policies/](https://www.paws-r-sdk.com/docs/iam_list_user_policies/) for full documentation.
#'
#' @param UserName &#91;required&#93; The name of the user to list policies for.
#' 
#' This parameter allows (through its [regex
#' pattern](https://en.wikipedia.org/wiki/Regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: _+=,.@@-
#' @param Marker Use this parameter only when paginating results and only after you
#' receive a response indicating that the results are truncated. Set it to
#' the value of the `Marker` element in the response that you received to
#' indicate where the next call should start.
#' @param MaxItems Use this only when paginating results to indicate the maximum number of
#' items you want in the response. If additional items exist beyond the
#' maximum you specify, the `IsTruncated` response element is `true`.
#' 
#' If you do not include this parameter, the number of items defaults to
#' 100. Note that IAM might return fewer results, even when there are more
#' results available. In that case, the `IsTruncated` response element
#' returns `true`, and `Marker` contains a value to include in the
#' subsequent call that tells the service where to continue from.
#'
#' @keywords internal
#'
#' @rdname iam_list_user_policies
iam_list_user_policies <- function(UserName, Marker = NULL, MaxItems = NULL) {
  op <- new_operation(
    name = "ListUserPolicies",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "Marker", limit_key = "MaxItems", more_results = "IsTruncated", output_token = "Marker", result_key = "PolicyNames"),
    stream_api = FALSE
  )
  input <- .iam$list_user_policies_input(UserName = UserName, Marker = Marker, MaxItems = MaxItems)
  output <- .iam$list_user_policies_output()
  config <- get_config()
  svc <- .iam$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$list_user_policies <- iam_list_user_policies

#' Lists the tags that are attached to the specified IAM user
#'
#' @description
#' Lists the tags that are attached to the specified IAM user. The returned list of tags is sorted by tag key. For more information about tagging, see [Tagging IAM resources](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html) in the *IAM User Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/iam_list_user_tags/](https://www.paws-r-sdk.com/docs/iam_list_user_tags/) for full documentation.
#'
#' @param UserName &#91;required&#93; The name of the IAM user whose tags you want to see.
#' 
#' This parameter allows (through its [regex
#' pattern](https://en.wikipedia.org/wiki/Regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: _+=,.@@-
#' @param Marker Use this parameter only when paginating results and only after you
#' receive a response indicating that the results are truncated. Set it to
#' the value of the `Marker` element in the response that you received to
#' indicate where the next call should start.
#' @param MaxItems Use this only when paginating results to indicate the maximum number of
#' items you want in the response. If additional items exist beyond the
#' maximum you specify, the `IsTruncated` response element is `true`.
#' 
#' If you do not include this parameter, the number of items defaults to
#' 100. Note that IAM might return fewer results, even when there are more
#' results available. In that case, the `IsTruncated` response element
#' returns `true`, and `Marker` contains a value to include in the
#' subsequent call that tells the service where to continue from.
#'
#' @keywords internal
#'
#' @rdname iam_list_user_tags
iam_list_user_tags <- function(UserName, Marker = NULL, MaxItems = NULL) {
  op <- new_operation(
    name = "ListUserTags",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "Marker", limit_key = "MaxItems", more_results = "IsTruncated", output_token = "Marker", result_key = "Tags"),
    stream_api = FALSE
  )
  input <- .iam$list_user_tags_input(UserName = UserName, Marker = Marker, MaxItems = MaxItems)
  output <- .iam$list_user_tags_output()
  config <- get_config()
  svc <- .iam$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$list_user_tags <- iam_list_user_tags

#' Lists the IAM users that have the specified path prefix
#'
#' @description
#' Lists the IAM users that have the specified path prefix. If no path prefix is specified, the operation returns all users in the Amazon Web Services account. If there are none, the operation returns an empty list.
#'
#' See [https://www.paws-r-sdk.com/docs/iam_list_users/](https://www.paws-r-sdk.com/docs/iam_list_users/) for full documentation.
#'
#' @param PathPrefix The path prefix for filtering the results. For example:
#' `/division_abc/subdivision_xyz/`, which would get all user names whose
#' path starts with `/division_abc/subdivision_xyz/`.
#' 
#' This parameter is optional. If it is not included, it defaults to a
#' slash (/), listing all user names. This parameter allows (through its
#' [regex pattern](https://en.wikipedia.org/wiki/Regex)) a string of
#' characters consisting of either a forward slash (/) by itself or a
#' string that must begin and end with forward slashes. In addition, it can
#' contain any ASCII character from the ! (``U+0021``) through the DEL
#' character (``U+007F``), including most punctuation characters, digits, and
#' upper and lowercased letters.
#' @param Marker Use this parameter only when paginating results and only after you
#' receive a response indicating that the results are truncated. Set it to
#' the value of the `Marker` element in the response that you received to
#' indicate where the next call should start.
#' @param MaxItems Use this only when paginating results to indicate the maximum number of
#' items you want in the response. If additional items exist beyond the
#' maximum you specify, the `IsTruncated` response element is `true`.
#' 
#' If you do not include this parameter, the number of items defaults to
#' 100. Note that IAM might return fewer results, even when there are more
#' results available. In that case, the `IsTruncated` response element
#' returns `true`, and `Marker` contains a value to include in the
#' subsequent call that tells the service where to continue from.
#'
#' @keywords internal
#'
#' @rdname iam_list_users
iam_list_users <- function(PathPrefix = NULL, Marker = NULL, MaxItems = NULL) {
  op <- new_operation(
    name = "ListUsers",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "Marker", limit_key = "MaxItems", more_results = "IsTruncated", output_token = "Marker", result_key = "Users"),
    stream_api = FALSE
  )
  input <- .iam$list_users_input(PathPrefix = PathPrefix, Marker = Marker, MaxItems = MaxItems)
  output <- .iam$list_users_output()
  config <- get_config()
  svc <- .iam$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$list_users <- iam_list_users

#' Lists the virtual MFA devices defined in the Amazon Web Services account
#' by assignment status
#'
#' @description
#' Lists the virtual MFA devices defined in the Amazon Web Services account by assignment status. If you do not specify an assignment status, the operation returns a list of all virtual MFA devices. Assignment status can be `Assigned`, `Unassigned`, or `Any`.
#'
#' See [https://www.paws-r-sdk.com/docs/iam_list_virtual_mfa_devices/](https://www.paws-r-sdk.com/docs/iam_list_virtual_mfa_devices/) for full documentation.
#'
#' @param AssignmentStatus The status (`Unassigned` or `Assigned`) of the devices to list. If you
#' do not specify an `AssignmentStatus`, the operation defaults to `Any`,
#' which lists both assigned and unassigned virtual MFA devices.,
#' @param Marker Use this parameter only when paginating results and only after you
#' receive a response indicating that the results are truncated. Set it to
#' the value of the `Marker` element in the response that you received to
#' indicate where the next call should start.
#' @param MaxItems Use this only when paginating results to indicate the maximum number of
#' items you want in the response. If additional items exist beyond the
#' maximum you specify, the `IsTruncated` response element is `true`.
#' 
#' If you do not include this parameter, the number of items defaults to
#' 100. Note that IAM might return fewer results, even when there are more
#' results available. In that case, the `IsTruncated` response element
#' returns `true`, and `Marker` contains a value to include in the
#' subsequent call that tells the service where to continue from.
#'
#' @keywords internal
#'
#' @rdname iam_list_virtual_mfa_devices
iam_list_virtual_mfa_devices <- function(AssignmentStatus = NULL, Marker = NULL, MaxItems = NULL) {
  op <- new_operation(
    name = "ListVirtualMFADevices",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "Marker", limit_key = "MaxItems", more_results = "IsTruncated", output_token = "Marker", result_key = "VirtualMFADevices"),
    stream_api = FALSE
  )
  input <- .iam$list_virtual_mfa_devices_input(AssignmentStatus = AssignmentStatus, Marker = Marker, MaxItems = MaxItems)
  output <- .iam$list_virtual_mfa_devices_output()
  config <- get_config()
  svc <- .iam$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$list_virtual_mfa_devices <- iam_list_virtual_mfa_devices

#' Adds or updates an inline policy document that is embedded in the
#' specified IAM group
#'
#' @description
#' Adds or updates an inline policy document that is embedded in the specified IAM group.
#'
#' See [https://www.paws-r-sdk.com/docs/iam_put_group_policy/](https://www.paws-r-sdk.com/docs/iam_put_group_policy/) for full documentation.
#'
#' @param GroupName &#91;required&#93; The name of the group to associate the policy with.
#' 
#' This parameter allows (through its [regex
#' pattern](https://en.wikipedia.org/wiki/Regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: _+=,.@@-.
#' @param PolicyName &#91;required&#93; The name of the policy document.
#' 
#' This parameter allows (through its [regex
#' pattern](https://en.wikipedia.org/wiki/Regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: _+=,.@@-
#' @param PolicyDocument &#91;required&#93; The policy document.
#' 
#' You must provide policies in JSON format in IAM. However, for
#' CloudFormation templates formatted in YAML, you can provide the policy
#' in JSON or YAML format. CloudFormation always converts a YAML policy to
#' JSON format before submitting it to IAM.
#' 
#' The [regex pattern](https://en.wikipedia.org/wiki/Regex) used to
#' validate this parameter is a string of characters consisting of the
#' following:
#' 
#' -   Any printable ASCII character ranging from the space character
#'     (``U+0020``) through the end of the ASCII character range
#' 
#' -   The printable characters in the Basic Latin and Latin-1 Supplement
#'     character set (through ``U+00FF``)
#' 
#' -   The special characters tab (``U+0009``), line feed (``U+000A``), and
#'     carriage return (``U+000D``)
#'
#' @keywords internal
#'
#' @rdname iam_put_group_policy
iam_put_group_policy <- function(GroupName, PolicyName, PolicyDocument) {
  op <- new_operation(
    name = "PutGroupPolicy",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .iam$put_group_policy_input(GroupName = GroupName, PolicyName = PolicyName, PolicyDocument = PolicyDocument)
  output <- .iam$put_group_policy_output()
  config <- get_config()
  svc <- .iam$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$put_group_policy <- iam_put_group_policy

#' Adds or updates the policy that is specified as the IAM role's
#' permissions boundary
#'
#' @description
#' Adds or updates the policy that is specified as the IAM role's permissions boundary. You can use an Amazon Web Services managed policy or a customer managed policy to set the boundary for a role. Use the boundary to control the maximum permissions that the role can have. Setting a permissions boundary is an advanced feature that can affect the permissions for the role.
#'
#' See [https://www.paws-r-sdk.com/docs/iam_put_role_permissions_boundary/](https://www.paws-r-sdk.com/docs/iam_put_role_permissions_boundary/) for full documentation.
#'
#' @param RoleName &#91;required&#93; The name (friendly name, not ARN) of the IAM role for which you want to
#' set the permissions boundary.
#' @param PermissionsBoundary &#91;required&#93; The ARN of the managed policy that is used to set the permissions
#' boundary for the role.
#' 
#' A permissions boundary policy defines the maximum permissions that
#' identity-based policies can grant to an entity, but does not grant
#' permissions. Permissions boundaries do not define the maximum
#' permissions that a resource-based policy can grant to an entity. To
#' learn more, see [Permissions boundaries for IAM
#' entities](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_boundaries.html)
#' in the *IAM User Guide*.
#' 
#' For more information about policy types, see [Policy
#' types](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html#access_policy-types)
#' in the *IAM User Guide*.
#'
#' @keywords internal
#'
#' @rdname iam_put_role_permissions_boundary
iam_put_role_permissions_boundary <- function(RoleName, PermissionsBoundary) {
  op <- new_operation(
    name = "PutRolePermissionsBoundary",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .iam$put_role_permissions_boundary_input(RoleName = RoleName, PermissionsBoundary = PermissionsBoundary)
  output <- .iam$put_role_permissions_boundary_output()
  config <- get_config()
  svc <- .iam$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$put_role_permissions_boundary <- iam_put_role_permissions_boundary

#' Adds or updates an inline policy document that is embedded in the
#' specified IAM role
#'
#' @description
#' Adds or updates an inline policy document that is embedded in the specified IAM role.
#'
#' See [https://www.paws-r-sdk.com/docs/iam_put_role_policy/](https://www.paws-r-sdk.com/docs/iam_put_role_policy/) for full documentation.
#'
#' @param RoleName &#91;required&#93; The name of the role to associate the policy with.
#' 
#' This parameter allows (through its [regex
#' pattern](https://en.wikipedia.org/wiki/Regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: _+=,.@@-
#' @param PolicyName &#91;required&#93; The name of the policy document.
#' 
#' This parameter allows (through its [regex
#' pattern](https://en.wikipedia.org/wiki/Regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: _+=,.@@-
#' @param PolicyDocument &#91;required&#93; The policy document.
#' 
#' You must provide policies in JSON format in IAM. However, for
#' CloudFormation templates formatted in YAML, you can provide the policy
#' in JSON or YAML format. CloudFormation always converts a YAML policy to
#' JSON format before submitting it to IAM.
#' 
#' The [regex pattern](https://en.wikipedia.org/wiki/Regex) used to
#' validate this parameter is a string of characters consisting of the
#' following:
#' 
#' -   Any printable ASCII character ranging from the space character
#'     (``U+0020``) through the end of the ASCII character range
#' 
#' -   The printable characters in the Basic Latin and Latin-1 Supplement
#'     character set (through ``U+00FF``)
#' 
#' -   The special characters tab (``U+0009``), line feed (``U+000A``), and
#'     carriage return (``U+000D``)
#'
#' @keywords internal
#'
#' @rdname iam_put_role_policy
iam_put_role_policy <- function(RoleName, PolicyName, PolicyDocument) {
  op <- new_operation(
    name = "PutRolePolicy",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .iam$put_role_policy_input(RoleName = RoleName, PolicyName = PolicyName, PolicyDocument = PolicyDocument)
  output <- .iam$put_role_policy_output()
  config <- get_config()
  svc <- .iam$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$put_role_policy <- iam_put_role_policy

#' Adds or updates the policy that is specified as the IAM user's
#' permissions boundary
#'
#' @description
#' Adds or updates the policy that is specified as the IAM user's permissions boundary. You can use an Amazon Web Services managed policy or a customer managed policy to set the boundary for a user. Use the boundary to control the maximum permissions that the user can have. Setting a permissions boundary is an advanced feature that can affect the permissions for the user.
#'
#' See [https://www.paws-r-sdk.com/docs/iam_put_user_permissions_boundary/](https://www.paws-r-sdk.com/docs/iam_put_user_permissions_boundary/) for full documentation.
#'
#' @param UserName &#91;required&#93; The name (friendly name, not ARN) of the IAM user for which you want to
#' set the permissions boundary.
#' @param PermissionsBoundary &#91;required&#93; The ARN of the managed policy that is used to set the permissions
#' boundary for the user.
#' 
#' A permissions boundary policy defines the maximum permissions that
#' identity-based policies can grant to an entity, but does not grant
#' permissions. Permissions boundaries do not define the maximum
#' permissions that a resource-based policy can grant to an entity. To
#' learn more, see [Permissions boundaries for IAM
#' entities](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_boundaries.html)
#' in the *IAM User Guide*.
#' 
#' For more information about policy types, see [Policy
#' types](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html#access_policy-types)
#' in the *IAM User Guide*.
#'
#' @keywords internal
#'
#' @rdname iam_put_user_permissions_boundary
iam_put_user_permissions_boundary <- function(UserName, PermissionsBoundary) {
  op <- new_operation(
    name = "PutUserPermissionsBoundary",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .iam$put_user_permissions_boundary_input(UserName = UserName, PermissionsBoundary = PermissionsBoundary)
  output <- .iam$put_user_permissions_boundary_output()
  config <- get_config()
  svc <- .iam$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$put_user_permissions_boundary <- iam_put_user_permissions_boundary

#' Adds or updates an inline policy document that is embedded in the
#' specified IAM user
#'
#' @description
#' Adds or updates an inline policy document that is embedded in the specified IAM user.
#'
#' See [https://www.paws-r-sdk.com/docs/iam_put_user_policy/](https://www.paws-r-sdk.com/docs/iam_put_user_policy/) for full documentation.
#'
#' @param UserName &#91;required&#93; The name of the user to associate the policy with.
#' 
#' This parameter allows (through its [regex
#' pattern](https://en.wikipedia.org/wiki/Regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: _+=,.@@-
#' @param PolicyName &#91;required&#93; The name of the policy document.
#' 
#' This parameter allows (through its [regex
#' pattern](https://en.wikipedia.org/wiki/Regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: _+=,.@@-
#' @param PolicyDocument &#91;required&#93; The policy document.
#' 
#' You must provide policies in JSON format in IAM. However, for
#' CloudFormation templates formatted in YAML, you can provide the policy
#' in JSON or YAML format. CloudFormation always converts a YAML policy to
#' JSON format before submitting it to IAM.
#' 
#' The [regex pattern](https://en.wikipedia.org/wiki/Regex) used to
#' validate this parameter is a string of characters consisting of the
#' following:
#' 
#' -   Any printable ASCII character ranging from the space character
#'     (``U+0020``) through the end of the ASCII character range
#' 
#' -   The printable characters in the Basic Latin and Latin-1 Supplement
#'     character set (through ``U+00FF``)
#' 
#' -   The special characters tab (``U+0009``), line feed (``U+000A``), and
#'     carriage return (``U+000D``)
#'
#' @keywords internal
#'
#' @rdname iam_put_user_policy
iam_put_user_policy <- function(UserName, PolicyName, PolicyDocument) {
  op <- new_operation(
    name = "PutUserPolicy",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .iam$put_user_policy_input(UserName = UserName, PolicyName = PolicyName, PolicyDocument = PolicyDocument)
  output <- .iam$put_user_policy_output()
  config <- get_config()
  svc <- .iam$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$put_user_policy <- iam_put_user_policy

#' Removes the specified client ID (also known as audience) from the list
#' of client IDs registered for the specified IAM OpenID Connect (OIDC)
#' provider resource object
#'
#' @description
#' Removes the specified client ID (also known as audience) from the list of client IDs registered for the specified IAM OpenID Connect (OIDC) provider resource object.
#'
#' See [https://www.paws-r-sdk.com/docs/iam_remove_client_id_from_open_id_connect_provider/](https://www.paws-r-sdk.com/docs/iam_remove_client_id_from_open_id_connect_provider/) for full documentation.
#'
#' @param OpenIDConnectProviderArn &#91;required&#93; The Amazon Resource Name (ARN) of the IAM OIDC provider resource to
#' remove the client ID from. You can get a list of OIDC provider ARNs by
#' using the
#' [`list_open_id_connect_providers`][iam_list_open_id_connect_providers]
#' operation.
#' 
#' For more information about ARNs, see [Amazon Resource Names
#' (ARNs)](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html)
#' in the *Amazon Web Services General Reference*.
#' @param ClientID &#91;required&#93; The client ID (also known as audience) to remove from the IAM OIDC
#' provider resource. For more information about client IDs, see
#' [`create_open_id_connect_provider`][iam_create_open_id_connect_provider].
#'
#' @keywords internal
#'
#' @rdname iam_remove_client_id_from_open_id_connect_provider
iam_remove_client_id_from_open_id_connect_provider <- function(OpenIDConnectProviderArn, ClientID) {
  op <- new_operation(
    name = "RemoveClientIDFromOpenIDConnectProvider",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .iam$remove_client_id_from_open_id_connect_provider_input(OpenIDConnectProviderArn = OpenIDConnectProviderArn, ClientID = ClientID)
  output <- .iam$remove_client_id_from_open_id_connect_provider_output()
  config <- get_config()
  svc <- .iam$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$remove_client_id_from_open_id_connect_provider <- iam_remove_client_id_from_open_id_connect_provider

#' Removes the specified IAM role from the specified Amazon EC2 instance
#' profile
#'
#' @description
#' Removes the specified IAM role from the specified Amazon EC2 instance profile.
#'
#' See [https://www.paws-r-sdk.com/docs/iam_remove_role_from_instance_profile/](https://www.paws-r-sdk.com/docs/iam_remove_role_from_instance_profile/) for full documentation.
#'
#' @param InstanceProfileName &#91;required&#93; The name of the instance profile to update.
#' 
#' This parameter allows (through its [regex
#' pattern](https://en.wikipedia.org/wiki/Regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: _+=,.@@-
#' @param RoleName &#91;required&#93; The name of the role to remove.
#' 
#' This parameter allows (through its [regex
#' pattern](https://en.wikipedia.org/wiki/Regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: _+=,.@@-
#'
#' @keywords internal
#'
#' @rdname iam_remove_role_from_instance_profile
iam_remove_role_from_instance_profile <- function(InstanceProfileName, RoleName) {
  op <- new_operation(
    name = "RemoveRoleFromInstanceProfile",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .iam$remove_role_from_instance_profile_input(InstanceProfileName = InstanceProfileName, RoleName = RoleName)
  output <- .iam$remove_role_from_instance_profile_output()
  config <- get_config()
  svc <- .iam$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$remove_role_from_instance_profile <- iam_remove_role_from_instance_profile

#' Removes the specified user from the specified group
#'
#' @description
#' Removes the specified user from the specified group.
#'
#' See [https://www.paws-r-sdk.com/docs/iam_remove_user_from_group/](https://www.paws-r-sdk.com/docs/iam_remove_user_from_group/) for full documentation.
#'
#' @param GroupName &#91;required&#93; The name of the group to update.
#' 
#' This parameter allows (through its [regex
#' pattern](https://en.wikipedia.org/wiki/Regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: _+=,.@@-
#' @param UserName &#91;required&#93; The name of the user to remove.
#' 
#' This parameter allows (through its [regex
#' pattern](https://en.wikipedia.org/wiki/Regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: _+=,.@@-
#'
#' @keywords internal
#'
#' @rdname iam_remove_user_from_group
iam_remove_user_from_group <- function(GroupName, UserName) {
  op <- new_operation(
    name = "RemoveUserFromGroup",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .iam$remove_user_from_group_input(GroupName = GroupName, UserName = UserName)
  output <- .iam$remove_user_from_group_output()
  config <- get_config()
  svc <- .iam$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$remove_user_from_group <- iam_remove_user_from_group

#' Resets the password for a service-specific credential
#'
#' @description
#' Resets the password for a service-specific credential. The new password is Amazon Web Services generated and cryptographically strong. It cannot be configured by the user. Resetting the password immediately invalidates the previous password associated with this user.
#'
#' See [https://www.paws-r-sdk.com/docs/iam_reset_service_specific_credential/](https://www.paws-r-sdk.com/docs/iam_reset_service_specific_credential/) for full documentation.
#'
#' @param UserName The name of the IAM user associated with the service-specific
#' credential. If this value is not specified, then the operation assumes
#' the user whose credentials are used to call the operation.
#' 
#' This parameter allows (through its [regex
#' pattern](https://en.wikipedia.org/wiki/Regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: _+=,.@@-
#' @param ServiceSpecificCredentialId &#91;required&#93; The unique identifier of the service-specific credential.
#' 
#' This parameter allows (through its [regex
#' pattern](https://en.wikipedia.org/wiki/Regex)) a string of characters
#' that can consist of any upper or lowercased letter or digit.
#'
#' @keywords internal
#'
#' @rdname iam_reset_service_specific_credential
iam_reset_service_specific_credential <- function(UserName = NULL, ServiceSpecificCredentialId) {
  op <- new_operation(
    name = "ResetServiceSpecificCredential",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .iam$reset_service_specific_credential_input(UserName = UserName, ServiceSpecificCredentialId = ServiceSpecificCredentialId)
  output <- .iam$reset_service_specific_credential_output()
  config <- get_config()
  svc <- .iam$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$reset_service_specific_credential <- iam_reset_service_specific_credential

#' Synchronizes the specified MFA device with its IAM resource object on
#' the Amazon Web Services servers
#'
#' @description
#' Synchronizes the specified MFA device with its IAM resource object on the Amazon Web Services servers.
#'
#' See [https://www.paws-r-sdk.com/docs/iam_resync_mfa_device/](https://www.paws-r-sdk.com/docs/iam_resync_mfa_device/) for full documentation.
#'
#' @param UserName &#91;required&#93; The name of the user whose MFA device you want to resynchronize.
#' 
#' This parameter allows (through its [regex
#' pattern](https://en.wikipedia.org/wiki/Regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: _+=,.@@-
#' @param SerialNumber &#91;required&#93; Serial number that uniquely identifies the MFA device.
#' 
#' This parameter allows (through its [regex
#' pattern](https://en.wikipedia.org/wiki/Regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: _+=,.@@-
#' @param AuthenticationCode1 &#91;required&#93; An authentication code emitted by the device.
#' 
#' The format for this parameter is a sequence of six digits.
#' @param AuthenticationCode2 &#91;required&#93; A subsequent authentication code emitted by the device.
#' 
#' The format for this parameter is a sequence of six digits.
#'
#' @keywords internal
#'
#' @rdname iam_resync_mfa_device
iam_resync_mfa_device <- function(UserName, SerialNumber, AuthenticationCode1, AuthenticationCode2) {
  op <- new_operation(
    name = "ResyncMFADevice",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .iam$resync_mfa_device_input(UserName = UserName, SerialNumber = SerialNumber, AuthenticationCode1 = AuthenticationCode1, AuthenticationCode2 = AuthenticationCode2)
  output <- .iam$resync_mfa_device_output()
  config <- get_config()
  svc <- .iam$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$resync_mfa_device <- iam_resync_mfa_device

#' Sets the specified version of the specified policy as the policy's
#' default (operative) version
#'
#' @description
#' Sets the specified version of the specified policy as the policy's default (operative) version.
#'
#' See [https://www.paws-r-sdk.com/docs/iam_set_default_policy_version/](https://www.paws-r-sdk.com/docs/iam_set_default_policy_version/) for full documentation.
#'
#' @param PolicyArn &#91;required&#93; The Amazon Resource Name (ARN) of the IAM policy whose default version
#' you want to set.
#' 
#' For more information about ARNs, see [Amazon Resource Names
#' (ARNs)](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html)
#' in the *Amazon Web Services General Reference*.
#' @param VersionId &#91;required&#93; The version of the policy to set as the default (operative) version.
#' 
#' For more information about managed policy versions, see [Versioning for
#' managed
#' policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_managed-versioning.html)
#' in the *IAM User Guide*.
#'
#' @keywords internal
#'
#' @rdname iam_set_default_policy_version
iam_set_default_policy_version <- function(PolicyArn, VersionId) {
  op <- new_operation(
    name = "SetDefaultPolicyVersion",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .iam$set_default_policy_version_input(PolicyArn = PolicyArn, VersionId = VersionId)
  output <- .iam$set_default_policy_version_output()
  config <- get_config()
  svc <- .iam$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$set_default_policy_version <- iam_set_default_policy_version

#' Sets the specified version of the global endpoint token as the token
#' version used for the Amazon Web Services account
#'
#' @description
#' Sets the specified version of the global endpoint token as the token version used for the Amazon Web Services account.
#'
#' See [https://www.paws-r-sdk.com/docs/iam_set_security_token_service_preferences/](https://www.paws-r-sdk.com/docs/iam_set_security_token_service_preferences/) for full documentation.
#'
#' @param GlobalEndpointTokenVersion &#91;required&#93; The version of the global endpoint token. Version 1 tokens are valid
#' only in Amazon Web Services Regions that are available by default. These
#' tokens do not work in manually enabled Regions, such as Asia Pacific
#' (Hong Kong). Version 2 tokens are valid in all Regions. However, version
#' 2 tokens are longer and might affect systems where you temporarily store
#' tokens.
#' 
#' For information, see [Activating and deactivating STS in an Amazon Web
#' Services
#' Region](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_enable-regions.html)
#' in the *IAM User Guide*.
#'
#' @keywords internal
#'
#' @rdname iam_set_security_token_service_preferences
iam_set_security_token_service_preferences <- function(GlobalEndpointTokenVersion) {
  op <- new_operation(
    name = "SetSecurityTokenServicePreferences",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .iam$set_security_token_service_preferences_input(GlobalEndpointTokenVersion = GlobalEndpointTokenVersion)
  output <- .iam$set_security_token_service_preferences_output()
  config <- get_config()
  svc <- .iam$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$set_security_token_service_preferences <- iam_set_security_token_service_preferences

#' Simulate how a set of IAM policies and optionally a resource-based
#' policy works with a list of API operations and Amazon Web Services
#' resources to determine the policies' effective permissions
#'
#' @description
#' Simulate how a set of IAM policies and optionally a resource-based policy works with a list of API operations and Amazon Web Services resources to determine the policies' effective permissions. The policies are provided as strings.
#'
#' See [https://www.paws-r-sdk.com/docs/iam_simulate_custom_policy/](https://www.paws-r-sdk.com/docs/iam_simulate_custom_policy/) for full documentation.
#'
#' @param PolicyInputList &#91;required&#93; A list of policy documents to include in the simulation. Each document
#' is specified as a string containing the complete, valid JSON text of an
#' IAM policy. Do not include any resource-based policies in this
#' parameter. Any resource-based policy must be submitted with the
#' `ResourcePolicy` parameter. The policies cannot be "scope-down"
#' policies, such as you could include in a call to
#' [GetFederationToken](https://docs.aws.amazon.com/IAM/latest/APIReference/)
#' or one of the
#' [AssumeRole](https://docs.aws.amazon.com/IAM/latest/APIReference/) API
#' operations. In other words, do not use policies designed to restrict
#' what a user can do while using the temporary credentials.
#' 
#' The maximum length of the policy document that you can pass in this
#' operation, including whitespace, is listed below. To view the maximum
#' character counts of a managed policy with no whitespaces, see [IAM and
#' STS character
#' quotas](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html#reference_iam-quotas-entity-length).
#' 
#' The [regex pattern](https://en.wikipedia.org/wiki/Regex) used to
#' validate this parameter is a string of characters consisting of the
#' following:
#' 
#' -   Any printable ASCII character ranging from the space character
#'     (``U+0020``) through the end of the ASCII character range
#' 
#' -   The printable characters in the Basic Latin and Latin-1 Supplement
#'     character set (through ``U+00FF``)
#' 
#' -   The special characters tab (``U+0009``), line feed (``U+000A``), and
#'     carriage return (``U+000D``)
#' @param PermissionsBoundaryPolicyInputList The IAM permissions boundary policy to simulate. The permissions
#' boundary sets the maximum permissions that an IAM entity can have. You
#' can input only one permissions boundary when you pass a policy to this
#' operation. For more information about permissions boundaries, see
#' [Permissions boundaries for IAM
#' entities](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_boundaries.html)
#' in the *IAM User Guide*. The policy input is specified as a string that
#' contains the complete, valid JSON text of a permissions boundary policy.
#' 
#' The maximum length of the policy document that you can pass in this
#' operation, including whitespace, is listed below. To view the maximum
#' character counts of a managed policy with no whitespaces, see [IAM and
#' STS character
#' quotas](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html#reference_iam-quotas-entity-length).
#' 
#' The [regex pattern](https://en.wikipedia.org/wiki/Regex) used to
#' validate this parameter is a string of characters consisting of the
#' following:
#' 
#' -   Any printable ASCII character ranging from the space character
#'     (``U+0020``) through the end of the ASCII character range
#' 
#' -   The printable characters in the Basic Latin and Latin-1 Supplement
#'     character set (through ``U+00FF``)
#' 
#' -   The special characters tab (``U+0009``), line feed (``U+000A``), and
#'     carriage return (``U+000D``)
#' @param ActionNames &#91;required&#93; A list of names of API operations to evaluate in the simulation. Each
#' operation is evaluated against each resource. Each operation must
#' include the service identifier, such as `iam:CreateUser`. This operation
#' does not support using wildcards (*) in an action name.
#' @param ResourceArns A list of ARNs of Amazon Web Services resources to include in the
#' simulation. If this parameter is not provided, then the value defaults
#' to `*` (all resources). Each API in the `ActionNames` parameter is
#' evaluated for each resource in this list. The simulation determines the
#' access result (allowed or denied) of each combination and reports it in
#' the response. You can simulate resources that don't exist in your
#' account.
#' 
#' The simulation does not automatically retrieve policies for the
#' specified resources. If you want to include a resource policy in the
#' simulation, then you must include the policy as a string in the
#' `ResourcePolicy` parameter.
#' 
#' If you include a `ResourcePolicy`, then it must be applicable to all of
#' the resources included in the simulation or you receive an invalid input
#' error.
#' 
#' For more information about ARNs, see [Amazon Resource Names
#' (ARNs)](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html)
#' in the *Amazon Web Services General Reference*.
#' 
#' Simulation of resource-based policies isn't supported for IAM roles.
#' @param ResourcePolicy A resource-based policy to include in the simulation provided as a
#' string. Each resource in the simulation is treated as if it had this
#' policy attached. You can include only one resource-based policy in a
#' simulation.
#' 
#' The maximum length of the policy document that you can pass in this
#' operation, including whitespace, is listed below. To view the maximum
#' character counts of a managed policy with no whitespaces, see [IAM and
#' STS character
#' quotas](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html#reference_iam-quotas-entity-length).
#' 
#' The [regex pattern](https://en.wikipedia.org/wiki/Regex) used to
#' validate this parameter is a string of characters consisting of the
#' following:
#' 
#' -   Any printable ASCII character ranging from the space character
#'     (``U+0020``) through the end of the ASCII character range
#' 
#' -   The printable characters in the Basic Latin and Latin-1 Supplement
#'     character set (through ``U+00FF``)
#' 
#' -   The special characters tab (``U+0009``), line feed (``U+000A``), and
#'     carriage return (``U+000D``)
#' 
#' Simulation of resource-based policies isn't supported for IAM roles.
#' @param ResourceOwner An ARN representing the Amazon Web Services account ID that specifies
#' the owner of any simulated resource that does not identify its owner in
#' the resource ARN. Examples of resource ARNs include an S3 bucket or
#' object. If `ResourceOwner` is specified, it is also used as the account
#' owner of any `ResourcePolicy` included in the simulation. If the
#' `ResourceOwner` parameter is not specified, then the owner of the
#' resources and the resource policy defaults to the account of the
#' identity provided in `CallerArn`. This parameter is required only if you
#' specify a resource-based policy and account that owns the resource is
#' different from the account that owns the simulated calling user
#' `CallerArn`.
#' 
#' The ARN for an account uses the following syntax:
#' `arn:aws:iam::AWS-account-ID:root`. For example, to represent the
#' account with the 112233445566 ID, use the following ARN:
#' `arn:aws:iam::112233445566-ID:root`.
#' @param CallerArn The ARN of the IAM user that you want to use as the simulated caller of
#' the API operations. `CallerArn` is required if you include a
#' `ResourcePolicy` so that the policy's `Principal` element has a value to
#' use in evaluating the policy.
#' 
#' You can specify only the ARN of an IAM user. You cannot specify the ARN
#' of an assumed role, federated user, or a service principal.
#' @param ContextEntries A list of context keys and corresponding values for the simulation to
#' use. Whenever a context key is evaluated in one of the simulated IAM
#' permissions policies, the corresponding value is supplied.
#' @param ResourceHandlingOption Specifies the type of simulation to run. Different API operations that
#' support resource-based policies require different combinations of
#' resources. By specifying the type of simulation to run, you enable the
#' policy simulator to enforce the presence of the required resources to
#' ensure reliable simulation results. If your simulation does not match
#' one of the following scenarios, then you can omit this parameter. The
#' following list shows each of the supported scenario values and the
#' resources that you must define to run the simulation.
#' 
#' Each of the Amazon EC2 scenarios requires that you specify instance,
#' image, and security group resources. If your scenario includes an EBS
#' volume, then you must specify that volume as a resource. If the Amazon
#' EC2 scenario includes VPC, then you must supply the network interface
#' resource. If it includes an IP subnet, then you must specify the subnet
#' resource. For more information on the Amazon EC2 scenario options, see
#' [Supported
#' platforms](https://aws.amazon.com/blogs/aws/ec2-classic-is-retiring-heres-how-to-prepare/)
#' in the *Amazon EC2 User Guide*.
#' 
#' -   **EC2-VPC-InstanceStore**
#' 
#'     instance, image, security group, network interface
#' 
#' -   **EC2-VPC-InstanceStore-Subnet**
#' 
#'     instance, image, security group, network interface, subnet
#' 
#' -   **EC2-VPC-EBS**
#' 
#'     instance, image, security group, network interface, volume
#' 
#' -   **EC2-VPC-EBS-Subnet**
#' 
#'     instance, image, security group, network interface, subnet, volume
#' @param MaxItems Use this only when paginating results to indicate the maximum number of
#' items you want in the response. If additional items exist beyond the
#' maximum you specify, the `IsTruncated` response element is `true`.
#' 
#' If you do not include this parameter, the number of items defaults to
#' 100. Note that IAM might return fewer results, even when there are more
#' results available. In that case, the `IsTruncated` response element
#' returns `true`, and `Marker` contains a value to include in the
#' subsequent call that tells the service where to continue from.
#' @param Marker Use this parameter only when paginating results and only after you
#' receive a response indicating that the results are truncated. Set it to
#' the value of the `Marker` element in the response that you received to
#' indicate where the next call should start.
#'
#' @keywords internal
#'
#' @rdname iam_simulate_custom_policy
iam_simulate_custom_policy <- function(PolicyInputList, PermissionsBoundaryPolicyInputList = NULL, ActionNames, ResourceArns = NULL, ResourcePolicy = NULL, ResourceOwner = NULL, CallerArn = NULL, ContextEntries = NULL, ResourceHandlingOption = NULL, MaxItems = NULL, Marker = NULL) {
  op <- new_operation(
    name = "SimulateCustomPolicy",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "Marker", limit_key = "MaxItems", more_results = "IsTruncated", output_token = "Marker", result_key = "EvaluationResults"),
    stream_api = FALSE
  )
  input <- .iam$simulate_custom_policy_input(PolicyInputList = PolicyInputList, PermissionsBoundaryPolicyInputList = PermissionsBoundaryPolicyInputList, ActionNames = ActionNames, ResourceArns = ResourceArns, ResourcePolicy = ResourcePolicy, ResourceOwner = ResourceOwner, CallerArn = CallerArn, ContextEntries = ContextEntries, ResourceHandlingOption = ResourceHandlingOption, MaxItems = MaxItems, Marker = Marker)
  output <- .iam$simulate_custom_policy_output()
  config <- get_config()
  svc <- .iam$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$simulate_custom_policy <- iam_simulate_custom_policy

#' Simulate how a set of IAM policies attached to an IAM entity works with
#' a list of API operations and Amazon Web Services resources to determine
#' the policies' effective permissions
#'
#' @description
#' Simulate how a set of IAM policies attached to an IAM entity works with a list of API operations and Amazon Web Services resources to determine the policies' effective permissions. The entity can be an IAM user, group, or role. If you specify a user, then the simulation also includes all of the policies that are attached to groups that the user belongs to. You can simulate resources that don't exist in your account.
#'
#' See [https://www.paws-r-sdk.com/docs/iam_simulate_principal_policy/](https://www.paws-r-sdk.com/docs/iam_simulate_principal_policy/) for full documentation.
#'
#' @param PolicySourceArn &#91;required&#93; The Amazon Resource Name (ARN) of a user, group, or role whose policies
#' you want to include in the simulation. If you specify a user, group, or
#' role, the simulation includes all policies that are associated with that
#' entity. If you specify a user, the simulation also includes all policies
#' that are attached to any groups the user belongs to.
#' 
#' The maximum length of the policy document that you can pass in this
#' operation, including whitespace, is listed below. To view the maximum
#' character counts of a managed policy with no whitespaces, see [IAM and
#' STS character
#' quotas](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html#reference_iam-quotas-entity-length).
#' 
#' For more information about ARNs, see [Amazon Resource Names
#' (ARNs)](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html)
#' in the *Amazon Web Services General Reference*.
#' @param PolicyInputList An optional list of additional policy documents to include in the
#' simulation. Each document is specified as a string containing the
#' complete, valid JSON text of an IAM policy.
#' 
#' The [regex pattern](https://en.wikipedia.org/wiki/Regex) used to
#' validate this parameter is a string of characters consisting of the
#' following:
#' 
#' -   Any printable ASCII character ranging from the space character
#'     (``U+0020``) through the end of the ASCII character range
#' 
#' -   The printable characters in the Basic Latin and Latin-1 Supplement
#'     character set (through ``U+00FF``)
#' 
#' -   The special characters tab (``U+0009``), line feed (``U+000A``), and
#'     carriage return (``U+000D``)
#' @param PermissionsBoundaryPolicyInputList The IAM permissions boundary policy to simulate. The permissions
#' boundary sets the maximum permissions that the entity can have. You can
#' input only one permissions boundary when you pass a policy to this
#' operation. An IAM entity can only have one permissions boundary in
#' effect at a time. For example, if a permissions boundary is attached to
#' an entity and you pass in a different permissions boundary policy using
#' this parameter, then the new permissions boundary policy is used for the
#' simulation. For more information about permissions boundaries, see
#' [Permissions boundaries for IAM
#' entities](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_boundaries.html)
#' in the *IAM User Guide*. The policy input is specified as a string
#' containing the complete, valid JSON text of a permissions boundary
#' policy.
#' 
#' The maximum length of the policy document that you can pass in this
#' operation, including whitespace, is listed below. To view the maximum
#' character counts of a managed policy with no whitespaces, see [IAM and
#' STS character
#' quotas](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html#reference_iam-quotas-entity-length).
#' 
#' The [regex pattern](https://en.wikipedia.org/wiki/Regex) used to
#' validate this parameter is a string of characters consisting of the
#' following:
#' 
#' -   Any printable ASCII character ranging from the space character
#'     (``U+0020``) through the end of the ASCII character range
#' 
#' -   The printable characters in the Basic Latin and Latin-1 Supplement
#'     character set (through ``U+00FF``)
#' 
#' -   The special characters tab (``U+0009``), line feed (``U+000A``), and
#'     carriage return (``U+000D``)
#' @param ActionNames &#91;required&#93; A list of names of API operations to evaluate in the simulation. Each
#' operation is evaluated for each resource. Each operation must include
#' the service identifier, such as `iam:CreateUser`.
#' @param ResourceArns A list of ARNs of Amazon Web Services resources to include in the
#' simulation. If this parameter is not provided, then the value defaults
#' to `*` (all resources). Each API in the `ActionNames` parameter is
#' evaluated for each resource in this list. The simulation determines the
#' access result (allowed or denied) of each combination and reports it in
#' the response. You can simulate resources that don't exist in your
#' account.
#' 
#' The simulation does not automatically retrieve policies for the
#' specified resources. If you want to include a resource policy in the
#' simulation, then you must include the policy as a string in the
#' `ResourcePolicy` parameter.
#' 
#' For more information about ARNs, see [Amazon Resource Names
#' (ARNs)](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html)
#' in the *Amazon Web Services General Reference*.
#' 
#' Simulation of resource-based policies isn't supported for IAM roles.
#' @param ResourcePolicy A resource-based policy to include in the simulation provided as a
#' string. Each resource in the simulation is treated as if it had this
#' policy attached. You can include only one resource-based policy in a
#' simulation.
#' 
#' The maximum length of the policy document that you can pass in this
#' operation, including whitespace, is listed below. To view the maximum
#' character counts of a managed policy with no whitespaces, see [IAM and
#' STS character
#' quotas](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html#reference_iam-quotas-entity-length).
#' 
#' The [regex pattern](https://en.wikipedia.org/wiki/Regex) used to
#' validate this parameter is a string of characters consisting of the
#' following:
#' 
#' -   Any printable ASCII character ranging from the space character
#'     (``U+0020``) through the end of the ASCII character range
#' 
#' -   The printable characters in the Basic Latin and Latin-1 Supplement
#'     character set (through ``U+00FF``)
#' 
#' -   The special characters tab (``U+0009``), line feed (``U+000A``), and
#'     carriage return (``U+000D``)
#' 
#' Simulation of resource-based policies isn't supported for IAM roles.
#' @param ResourceOwner An Amazon Web Services account ID that specifies the owner of any
#' simulated resource that does not identify its owner in the resource ARN.
#' Examples of resource ARNs include an S3 bucket or object. If
#' `ResourceOwner` is specified, it is also used as the account owner of
#' any `ResourcePolicy` included in the simulation. If the `ResourceOwner`
#' parameter is not specified, then the owner of the resources and the
#' resource policy defaults to the account of the identity provided in
#' `CallerArn`. This parameter is required only if you specify a
#' resource-based policy and account that owns the resource is different
#' from the account that owns the simulated calling user `CallerArn`.
#' @param CallerArn The ARN of the IAM user that you want to specify as the simulated caller
#' of the API operations. If you do not specify a `CallerArn`, it defaults
#' to the ARN of the user that you specify in `PolicySourceArn`, if you
#' specified a user. If you include both a `PolicySourceArn` (for example,
#' `arn:aws:iam::123456789012:user/David`) and a `CallerArn` (for example,
#' `arn:aws:iam::123456789012:user/Bob`), the result is that you simulate
#' calling the API operations as Bob, as if Bob had David's policies.
#' 
#' You can specify only the ARN of an IAM user. You cannot specify the ARN
#' of an assumed role, federated user, or a service principal.
#' 
#' `CallerArn` is required if you include a `ResourcePolicy` and the
#' `PolicySourceArn` is not the ARN for an IAM user. This is required so
#' that the resource-based policy's `Principal` element has a value to use
#' in evaluating the policy.
#' 
#' For more information about ARNs, see [Amazon Resource Names
#' (ARNs)](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html)
#' in the *Amazon Web Services General Reference*.
#' @param ContextEntries A list of context keys and corresponding values for the simulation to
#' use. Whenever a context key is evaluated in one of the simulated IAM
#' permissions policies, the corresponding value is supplied.
#' @param ResourceHandlingOption Specifies the type of simulation to run. Different API operations that
#' support resource-based policies require different combinations of
#' resources. By specifying the type of simulation to run, you enable the
#' policy simulator to enforce the presence of the required resources to
#' ensure reliable simulation results. If your simulation does not match
#' one of the following scenarios, then you can omit this parameter. The
#' following list shows each of the supported scenario values and the
#' resources that you must define to run the simulation.
#' 
#' Each of the Amazon EC2 scenarios requires that you specify instance,
#' image, and security group resources. If your scenario includes an EBS
#' volume, then you must specify that volume as a resource. If the Amazon
#' EC2 scenario includes VPC, then you must supply the network interface
#' resource. If it includes an IP subnet, then you must specify the subnet
#' resource. For more information on the Amazon EC2 scenario options, see
#' [Supported
#' platforms](https://aws.amazon.com/blogs/aws/ec2-classic-is-retiring-heres-how-to-prepare/)
#' in the *Amazon EC2 User Guide*.
#' 
#' -   **EC2-VPC-InstanceStore**
#' 
#'     instance, image, security group, network interface
#' 
#' -   **EC2-VPC-InstanceStore-Subnet**
#' 
#'     instance, image, security group, network interface, subnet
#' 
#' -   **EC2-VPC-EBS**
#' 
#'     instance, image, security group, network interface, volume
#' 
#' -   **EC2-VPC-EBS-Subnet**
#' 
#'     instance, image, security group, network interface, subnet, volume
#' @param MaxItems Use this only when paginating results to indicate the maximum number of
#' items you want in the response. If additional items exist beyond the
#' maximum you specify, the `IsTruncated` response element is `true`.
#' 
#' If you do not include this parameter, the number of items defaults to
#' 100. Note that IAM might return fewer results, even when there are more
#' results available. In that case, the `IsTruncated` response element
#' returns `true`, and `Marker` contains a value to include in the
#' subsequent call that tells the service where to continue from.
#' @param Marker Use this parameter only when paginating results and only after you
#' receive a response indicating that the results are truncated. Set it to
#' the value of the `Marker` element in the response that you received to
#' indicate where the next call should start.
#'
#' @keywords internal
#'
#' @rdname iam_simulate_principal_policy
iam_simulate_principal_policy <- function(PolicySourceArn, PolicyInputList = NULL, PermissionsBoundaryPolicyInputList = NULL, ActionNames, ResourceArns = NULL, ResourcePolicy = NULL, ResourceOwner = NULL, CallerArn = NULL, ContextEntries = NULL, ResourceHandlingOption = NULL, MaxItems = NULL, Marker = NULL) {
  op <- new_operation(
    name = "SimulatePrincipalPolicy",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "Marker", limit_key = "MaxItems", more_results = "IsTruncated", output_token = "Marker", result_key = "EvaluationResults"),
    stream_api = FALSE
  )
  input <- .iam$simulate_principal_policy_input(PolicySourceArn = PolicySourceArn, PolicyInputList = PolicyInputList, PermissionsBoundaryPolicyInputList = PermissionsBoundaryPolicyInputList, ActionNames = ActionNames, ResourceArns = ResourceArns, ResourcePolicy = ResourcePolicy, ResourceOwner = ResourceOwner, CallerArn = CallerArn, ContextEntries = ContextEntries, ResourceHandlingOption = ResourceHandlingOption, MaxItems = MaxItems, Marker = Marker)
  output <- .iam$simulate_principal_policy_output()
  config <- get_config()
  svc <- .iam$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$simulate_principal_policy <- iam_simulate_principal_policy

#' Adds one or more tags to an IAM instance profile
#'
#' @description
#' Adds one or more tags to an IAM instance profile. If a tag with the same key name already exists, then that tag is overwritten with the new value.
#'
#' See [https://www.paws-r-sdk.com/docs/iam_tag_instance_profile/](https://www.paws-r-sdk.com/docs/iam_tag_instance_profile/) for full documentation.
#'
#' @param InstanceProfileName &#91;required&#93; The name of the IAM instance profile to which you want to add tags.
#' 
#' This parameter allows (through its [regex
#' pattern](https://en.wikipedia.org/wiki/Regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: _+=,.@@-
#' @param Tags &#91;required&#93; The list of tags that you want to attach to the IAM instance profile.
#' Each tag consists of a key name and an associated value.
#'
#' @keywords internal
#'
#' @rdname iam_tag_instance_profile
iam_tag_instance_profile <- function(InstanceProfileName, Tags) {
  op <- new_operation(
    name = "TagInstanceProfile",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .iam$tag_instance_profile_input(InstanceProfileName = InstanceProfileName, Tags = Tags)
  output <- .iam$tag_instance_profile_output()
  config <- get_config()
  svc <- .iam$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$tag_instance_profile <- iam_tag_instance_profile

#' Adds one or more tags to an IAM virtual multi-factor authentication
#' (MFA) device
#'
#' @description
#' Adds one or more tags to an IAM virtual multi-factor authentication (MFA) device. If a tag with the same key name already exists, then that tag is overwritten with the new value.
#'
#' See [https://www.paws-r-sdk.com/docs/iam_tag_mfa_device/](https://www.paws-r-sdk.com/docs/iam_tag_mfa_device/) for full documentation.
#'
#' @param SerialNumber &#91;required&#93; The unique identifier for the IAM virtual MFA device to which you want
#' to add tags. For virtual MFA devices, the serial number is the same as
#' the ARN.
#' 
#' This parameter allows (through its [regex
#' pattern](https://en.wikipedia.org/wiki/Regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: _+=,.@@-
#' @param Tags &#91;required&#93; The list of tags that you want to attach to the IAM virtual MFA device.
#' Each tag consists of a key name and an associated value.
#'
#' @keywords internal
#'
#' @rdname iam_tag_mfa_device
iam_tag_mfa_device <- function(SerialNumber, Tags) {
  op <- new_operation(
    name = "TagMFADevice",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .iam$tag_mfa_device_input(SerialNumber = SerialNumber, Tags = Tags)
  output <- .iam$tag_mfa_device_output()
  config <- get_config()
  svc <- .iam$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$tag_mfa_device <- iam_tag_mfa_device

#' Adds one or more tags to an OpenID Connect (OIDC)-compatible identity
#' provider
#'
#' @description
#' Adds one or more tags to an OpenID Connect (OIDC)-compatible identity provider. For more information about these providers, see [About web identity federation](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_oidc.html). If a tag with the same key name already exists, then that tag is overwritten with the new value.
#'
#' See [https://www.paws-r-sdk.com/docs/iam_tag_open_id_connect_provider/](https://www.paws-r-sdk.com/docs/iam_tag_open_id_connect_provider/) for full documentation.
#'
#' @param OpenIDConnectProviderArn &#91;required&#93; The ARN of the OIDC identity provider in IAM to which you want to add
#' tags.
#' 
#' This parameter allows (through its [regex
#' pattern](https://en.wikipedia.org/wiki/Regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: _+=,.@@-
#' @param Tags &#91;required&#93; The list of tags that you want to attach to the OIDC identity provider
#' in IAM. Each tag consists of a key name and an associated value.
#'
#' @keywords internal
#'
#' @rdname iam_tag_open_id_connect_provider
iam_tag_open_id_connect_provider <- function(OpenIDConnectProviderArn, Tags) {
  op <- new_operation(
    name = "TagOpenIDConnectProvider",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .iam$tag_open_id_connect_provider_input(OpenIDConnectProviderArn = OpenIDConnectProviderArn, Tags = Tags)
  output <- .iam$tag_open_id_connect_provider_output()
  config <- get_config()
  svc <- .iam$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$tag_open_id_connect_provider <- iam_tag_open_id_connect_provider

#' Adds one or more tags to an IAM customer managed policy
#'
#' @description
#' Adds one or more tags to an IAM customer managed policy. If a tag with the same key name already exists, then that tag is overwritten with the new value.
#'
#' See [https://www.paws-r-sdk.com/docs/iam_tag_policy/](https://www.paws-r-sdk.com/docs/iam_tag_policy/) for full documentation.
#'
#' @param PolicyArn &#91;required&#93; The ARN of the IAM customer managed policy to which you want to add
#' tags.
#' 
#' This parameter allows (through its [regex
#' pattern](https://en.wikipedia.org/wiki/Regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: _+=,.@@-
#' @param Tags &#91;required&#93; The list of tags that you want to attach to the IAM customer managed
#' policy. Each tag consists of a key name and an associated value.
#'
#' @keywords internal
#'
#' @rdname iam_tag_policy
iam_tag_policy <- function(PolicyArn, Tags) {
  op <- new_operation(
    name = "TagPolicy",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .iam$tag_policy_input(PolicyArn = PolicyArn, Tags = Tags)
  output <- .iam$tag_policy_output()
  config <- get_config()
  svc <- .iam$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$tag_policy <- iam_tag_policy

#' Adds one or more tags to an IAM role
#'
#' @description
#' Adds one or more tags to an IAM role. The role can be a regular role or a service-linked role. If a tag with the same key name already exists, then that tag is overwritten with the new value.
#'
#' See [https://www.paws-r-sdk.com/docs/iam_tag_role/](https://www.paws-r-sdk.com/docs/iam_tag_role/) for full documentation.
#'
#' @param RoleName &#91;required&#93; The name of the IAM role to which you want to add tags.
#' 
#' This parameter accepts (through its [regex
#' pattern](https://en.wikipedia.org/wiki/Regex)) a string of characters
#' that consist of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: _+=,.@@-
#' @param Tags &#91;required&#93; The list of tags that you want to attach to the IAM role. Each tag
#' consists of a key name and an associated value.
#'
#' @keywords internal
#'
#' @rdname iam_tag_role
iam_tag_role <- function(RoleName, Tags) {
  op <- new_operation(
    name = "TagRole",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .iam$tag_role_input(RoleName = RoleName, Tags = Tags)
  output <- .iam$tag_role_output()
  config <- get_config()
  svc <- .iam$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$tag_role <- iam_tag_role

#' Adds one or more tags to a Security Assertion Markup Language (SAML)
#' identity provider
#'
#' @description
#' Adds one or more tags to a Security Assertion Markup Language (SAML) identity provider. For more information about these providers, see [About SAML 2.0-based federation](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_saml.html) . If a tag with the same key name already exists, then that tag is overwritten with the new value.
#'
#' See [https://www.paws-r-sdk.com/docs/iam_tag_saml_provider/](https://www.paws-r-sdk.com/docs/iam_tag_saml_provider/) for full documentation.
#'
#' @param SAMLProviderArn &#91;required&#93; The ARN of the SAML identity provider in IAM to which you want to add
#' tags.
#' 
#' This parameter allows (through its [regex
#' pattern](https://en.wikipedia.org/wiki/Regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: _+=,.@@-
#' @param Tags &#91;required&#93; The list of tags that you want to attach to the SAML identity provider
#' in IAM. Each tag consists of a key name and an associated value.
#'
#' @keywords internal
#'
#' @rdname iam_tag_saml_provider
iam_tag_saml_provider <- function(SAMLProviderArn, Tags) {
  op <- new_operation(
    name = "TagSAMLProvider",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .iam$tag_saml_provider_input(SAMLProviderArn = SAMLProviderArn, Tags = Tags)
  output <- .iam$tag_saml_provider_output()
  config <- get_config()
  svc <- .iam$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$tag_saml_provider <- iam_tag_saml_provider

#' Adds one or more tags to an IAM server certificate
#'
#' @description
#' Adds one or more tags to an IAM server certificate. If a tag with the same key name already exists, then that tag is overwritten with the new value.
#'
#' See [https://www.paws-r-sdk.com/docs/iam_tag_server_certificate/](https://www.paws-r-sdk.com/docs/iam_tag_server_certificate/) for full documentation.
#'
#' @param ServerCertificateName &#91;required&#93; The name of the IAM server certificate to which you want to add tags.
#' 
#' This parameter allows (through its [regex
#' pattern](https://en.wikipedia.org/wiki/Regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: _+=,.@@-
#' @param Tags &#91;required&#93; The list of tags that you want to attach to the IAM server certificate.
#' Each tag consists of a key name and an associated value.
#'
#' @keywords internal
#'
#' @rdname iam_tag_server_certificate
iam_tag_server_certificate <- function(ServerCertificateName, Tags) {
  op <- new_operation(
    name = "TagServerCertificate",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .iam$tag_server_certificate_input(ServerCertificateName = ServerCertificateName, Tags = Tags)
  output <- .iam$tag_server_certificate_output()
  config <- get_config()
  svc <- .iam$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$tag_server_certificate <- iam_tag_server_certificate

#' Adds one or more tags to an IAM user
#'
#' @description
#' Adds one or more tags to an IAM user. If a tag with the same key name already exists, then that tag is overwritten with the new value.
#'
#' See [https://www.paws-r-sdk.com/docs/iam_tag_user/](https://www.paws-r-sdk.com/docs/iam_tag_user/) for full documentation.
#'
#' @param UserName &#91;required&#93; The name of the IAM user to which you want to add tags.
#' 
#' This parameter allows (through its [regex
#' pattern](https://en.wikipedia.org/wiki/Regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: _+=,.@@-
#' @param Tags &#91;required&#93; The list of tags that you want to attach to the IAM user. Each tag
#' consists of a key name and an associated value.
#'
#' @keywords internal
#'
#' @rdname iam_tag_user
iam_tag_user <- function(UserName, Tags) {
  op <- new_operation(
    name = "TagUser",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .iam$tag_user_input(UserName = UserName, Tags = Tags)
  output <- .iam$tag_user_output()
  config <- get_config()
  svc <- .iam$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$tag_user <- iam_tag_user

#' Removes the specified tags from the IAM instance profile
#'
#' @description
#' Removes the specified tags from the IAM instance profile. For more information about tagging, see [Tagging IAM resources](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html) in the *IAM User Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/iam_untag_instance_profile/](https://www.paws-r-sdk.com/docs/iam_untag_instance_profile/) for full documentation.
#'
#' @param InstanceProfileName &#91;required&#93; The name of the IAM instance profile from which you want to remove tags.
#' 
#' This parameter allows (through its [regex
#' pattern](https://en.wikipedia.org/wiki/Regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: _+=,.@@-
#' @param TagKeys &#91;required&#93; A list of key names as a simple array of strings. The tags with matching
#' keys are removed from the specified instance profile.
#'
#' @keywords internal
#'
#' @rdname iam_untag_instance_profile
iam_untag_instance_profile <- function(InstanceProfileName, TagKeys) {
  op <- new_operation(
    name = "UntagInstanceProfile",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .iam$untag_instance_profile_input(InstanceProfileName = InstanceProfileName, TagKeys = TagKeys)
  output <- .iam$untag_instance_profile_output()
  config <- get_config()
  svc <- .iam$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$untag_instance_profile <- iam_untag_instance_profile

#' Removes the specified tags from the IAM virtual multi-factor
#' authentication (MFA) device
#'
#' @description
#' Removes the specified tags from the IAM virtual multi-factor authentication (MFA) device. For more information about tagging, see [Tagging IAM resources](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html) in the *IAM User Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/iam_untag_mfa_device/](https://www.paws-r-sdk.com/docs/iam_untag_mfa_device/) for full documentation.
#'
#' @param SerialNumber &#91;required&#93; The unique identifier for the IAM virtual MFA device from which you want
#' to remove tags. For virtual MFA devices, the serial number is the same
#' as the ARN.
#' 
#' This parameter allows (through its [regex
#' pattern](https://en.wikipedia.org/wiki/Regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: _+=,.@@-
#' @param TagKeys &#91;required&#93; A list of key names as a simple array of strings. The tags with matching
#' keys are removed from the specified instance profile.
#'
#' @keywords internal
#'
#' @rdname iam_untag_mfa_device
iam_untag_mfa_device <- function(SerialNumber, TagKeys) {
  op <- new_operation(
    name = "UntagMFADevice",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .iam$untag_mfa_device_input(SerialNumber = SerialNumber, TagKeys = TagKeys)
  output <- .iam$untag_mfa_device_output()
  config <- get_config()
  svc <- .iam$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$untag_mfa_device <- iam_untag_mfa_device

#' Removes the specified tags from the specified OpenID Connect
#' (OIDC)-compatible identity provider in IAM
#'
#' @description
#' Removes the specified tags from the specified OpenID Connect (OIDC)-compatible identity provider in IAM. For more information about OIDC providers, see [About web identity federation](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_oidc.html). For more information about tagging, see [Tagging IAM resources](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html) in the *IAM User Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/iam_untag_open_id_connect_provider/](https://www.paws-r-sdk.com/docs/iam_untag_open_id_connect_provider/) for full documentation.
#'
#' @param OpenIDConnectProviderArn &#91;required&#93; The ARN of the OIDC provider in IAM from which you want to remove tags.
#' 
#' This parameter allows (through its [regex
#' pattern](https://en.wikipedia.org/wiki/Regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: _+=,.@@-
#' @param TagKeys &#91;required&#93; A list of key names as a simple array of strings. The tags with matching
#' keys are removed from the specified OIDC provider.
#'
#' @keywords internal
#'
#' @rdname iam_untag_open_id_connect_provider
iam_untag_open_id_connect_provider <- function(OpenIDConnectProviderArn, TagKeys) {
  op <- new_operation(
    name = "UntagOpenIDConnectProvider",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .iam$untag_open_id_connect_provider_input(OpenIDConnectProviderArn = OpenIDConnectProviderArn, TagKeys = TagKeys)
  output <- .iam$untag_open_id_connect_provider_output()
  config <- get_config()
  svc <- .iam$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$untag_open_id_connect_provider <- iam_untag_open_id_connect_provider

#' Removes the specified tags from the customer managed policy
#'
#' @description
#' Removes the specified tags from the customer managed policy. For more information about tagging, see [Tagging IAM resources](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html) in the *IAM User Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/iam_untag_policy/](https://www.paws-r-sdk.com/docs/iam_untag_policy/) for full documentation.
#'
#' @param PolicyArn &#91;required&#93; The ARN of the IAM customer managed policy from which you want to remove
#' tags.
#' 
#' This parameter allows (through its [regex
#' pattern](https://en.wikipedia.org/wiki/Regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: _+=,.@@-
#' @param TagKeys &#91;required&#93; A list of key names as a simple array of strings. The tags with matching
#' keys are removed from the specified policy.
#'
#' @keywords internal
#'
#' @rdname iam_untag_policy
iam_untag_policy <- function(PolicyArn, TagKeys) {
  op <- new_operation(
    name = "UntagPolicy",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .iam$untag_policy_input(PolicyArn = PolicyArn, TagKeys = TagKeys)
  output <- .iam$untag_policy_output()
  config <- get_config()
  svc <- .iam$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$untag_policy <- iam_untag_policy

#' Removes the specified tags from the role
#'
#' @description
#' Removes the specified tags from the role. For more information about tagging, see [Tagging IAM resources](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html) in the *IAM User Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/iam_untag_role/](https://www.paws-r-sdk.com/docs/iam_untag_role/) for full documentation.
#'
#' @param RoleName &#91;required&#93; The name of the IAM role from which you want to remove tags.
#' 
#' This parameter accepts (through its [regex
#' pattern](https://en.wikipedia.org/wiki/Regex)) a string of characters
#' that consist of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: _+=,.@@-
#' @param TagKeys &#91;required&#93; A list of key names as a simple array of strings. The tags with matching
#' keys are removed from the specified role.
#'
#' @keywords internal
#'
#' @rdname iam_untag_role
iam_untag_role <- function(RoleName, TagKeys) {
  op <- new_operation(
    name = "UntagRole",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .iam$untag_role_input(RoleName = RoleName, TagKeys = TagKeys)
  output <- .iam$untag_role_output()
  config <- get_config()
  svc <- .iam$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$untag_role <- iam_untag_role

#' Removes the specified tags from the specified Security Assertion Markup
#' Language (SAML) identity provider in IAM
#'
#' @description
#' Removes the specified tags from the specified Security Assertion Markup Language (SAML) identity provider in IAM. For more information about these providers, see [About web identity federation](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_oidc.html). For more information about tagging, see [Tagging IAM resources](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html) in the *IAM User Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/iam_untag_saml_provider/](https://www.paws-r-sdk.com/docs/iam_untag_saml_provider/) for full documentation.
#'
#' @param SAMLProviderArn &#91;required&#93; The ARN of the SAML identity provider in IAM from which you want to
#' remove tags.
#' 
#' This parameter allows (through its [regex
#' pattern](https://en.wikipedia.org/wiki/Regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: _+=,.@@-
#' @param TagKeys &#91;required&#93; A list of key names as a simple array of strings. The tags with matching
#' keys are removed from the specified SAML identity provider.
#'
#' @keywords internal
#'
#' @rdname iam_untag_saml_provider
iam_untag_saml_provider <- function(SAMLProviderArn, TagKeys) {
  op <- new_operation(
    name = "UntagSAMLProvider",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .iam$untag_saml_provider_input(SAMLProviderArn = SAMLProviderArn, TagKeys = TagKeys)
  output <- .iam$untag_saml_provider_output()
  config <- get_config()
  svc <- .iam$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$untag_saml_provider <- iam_untag_saml_provider

#' Removes the specified tags from the IAM server certificate
#'
#' @description
#' Removes the specified tags from the IAM server certificate. For more information about tagging, see [Tagging IAM resources](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html) in the *IAM User Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/iam_untag_server_certificate/](https://www.paws-r-sdk.com/docs/iam_untag_server_certificate/) for full documentation.
#'
#' @param ServerCertificateName &#91;required&#93; The name of the IAM server certificate from which you want to remove
#' tags.
#' 
#' This parameter allows (through its [regex
#' pattern](https://en.wikipedia.org/wiki/Regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: _+=,.@@-
#' @param TagKeys &#91;required&#93; A list of key names as a simple array of strings. The tags with matching
#' keys are removed from the specified IAM server certificate.
#'
#' @keywords internal
#'
#' @rdname iam_untag_server_certificate
iam_untag_server_certificate <- function(ServerCertificateName, TagKeys) {
  op <- new_operation(
    name = "UntagServerCertificate",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .iam$untag_server_certificate_input(ServerCertificateName = ServerCertificateName, TagKeys = TagKeys)
  output <- .iam$untag_server_certificate_output()
  config <- get_config()
  svc <- .iam$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$untag_server_certificate <- iam_untag_server_certificate

#' Removes the specified tags from the user
#'
#' @description
#' Removes the specified tags from the user. For more information about tagging, see [Tagging IAM resources](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html) in the *IAM User Guide*.
#'
#' See [https://www.paws-r-sdk.com/docs/iam_untag_user/](https://www.paws-r-sdk.com/docs/iam_untag_user/) for full documentation.
#'
#' @param UserName &#91;required&#93; The name of the IAM user from which you want to remove tags.
#' 
#' This parameter allows (through its [regex
#' pattern](https://en.wikipedia.org/wiki/Regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: _+=,.@@-
#' @param TagKeys &#91;required&#93; A list of key names as a simple array of strings. The tags with matching
#' keys are removed from the specified user.
#'
#' @keywords internal
#'
#' @rdname iam_untag_user
iam_untag_user <- function(UserName, TagKeys) {
  op <- new_operation(
    name = "UntagUser",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .iam$untag_user_input(UserName = UserName, TagKeys = TagKeys)
  output <- .iam$untag_user_output()
  config <- get_config()
  svc <- .iam$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$untag_user <- iam_untag_user

#' Changes the status of the specified access key from Active to Inactive,
#' or vice versa
#'
#' @description
#' Changes the status of the specified access key from Active to Inactive, or vice versa. This operation can be used to disable a user's key as part of a key rotation workflow.
#'
#' See [https://www.paws-r-sdk.com/docs/iam_update_access_key/](https://www.paws-r-sdk.com/docs/iam_update_access_key/) for full documentation.
#'
#' @param UserName The name of the user whose key you want to update.
#' 
#' This parameter allows (through its [regex
#' pattern](https://en.wikipedia.org/wiki/Regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: _+=,.@@-
#' @param AccessKeyId &#91;required&#93; The access key ID of the secret access key you want to update.
#' 
#' This parameter allows (through its [regex
#' pattern](https://en.wikipedia.org/wiki/Regex)) a string of characters
#' that can consist of any upper or lowercased letter or digit.
#' @param Status &#91;required&#93; The status you want to assign to the secret access key. `Active` means
#' that the key can be used for programmatic calls to Amazon Web Services,
#' while `Inactive` means that the key cannot be used.
#'
#' @keywords internal
#'
#' @rdname iam_update_access_key
iam_update_access_key <- function(UserName = NULL, AccessKeyId, Status) {
  op <- new_operation(
    name = "UpdateAccessKey",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .iam$update_access_key_input(UserName = UserName, AccessKeyId = AccessKeyId, Status = Status)
  output <- .iam$update_access_key_output()
  config <- get_config()
  svc <- .iam$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$update_access_key <- iam_update_access_key

#' Updates the password policy settings for the Amazon Web Services account
#'
#' @description
#' Updates the password policy settings for the Amazon Web Services account.
#'
#' See [https://www.paws-r-sdk.com/docs/iam_update_account_password_policy/](https://www.paws-r-sdk.com/docs/iam_update_account_password_policy/) for full documentation.
#'
#' @param MinimumPasswordLength The minimum number of characters allowed in an IAM user password.
#' 
#' If you do not specify a value for this parameter, then the operation
#' uses the default value of `6`.
#' @param RequireSymbols Specifies whether IAM user passwords must contain at least one of the
#' following non-alphanumeric characters:
#' 
#' ! @@ # $ % ^ & * ( ) _ + - = \[ \] \{ \} | '
#' 
#' If you do not specify a value for this parameter, then the operation
#' uses the default value of `false`. The result is that passwords do not
#' require at least one symbol character.
#' @param RequireNumbers Specifies whether IAM user passwords must contain at least one numeric
#' character (0 to 9).
#' 
#' If you do not specify a value for this parameter, then the operation
#' uses the default value of `false`. The result is that passwords do not
#' require at least one numeric character.
#' @param RequireUppercaseCharacters Specifies whether IAM user passwords must contain at least one uppercase
#' character from the ISO basic Latin alphabet (A to Z).
#' 
#' If you do not specify a value for this parameter, then the operation
#' uses the default value of `false`. The result is that passwords do not
#' require at least one uppercase character.
#' @param RequireLowercaseCharacters Specifies whether IAM user passwords must contain at least one lowercase
#' character from the ISO basic Latin alphabet (a to z).
#' 
#' If you do not specify a value for this parameter, then the operation
#' uses the default value of `false`. The result is that passwords do not
#' require at least one lowercase character.
#' @param AllowUsersToChangePassword Allows all IAM users in your account to use the Amazon Web Services
#' Management Console to change their own passwords. For more information,
#' see [Permitting IAM users to change their own
#' passwords](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_passwords_enable-user-change.html)
#' in the *IAM User Guide*.
#' 
#' If you do not specify a value for this parameter, then the operation
#' uses the default value of `false`. The result is that IAM users in the
#' account do not automatically have permissions to change their own
#' password.
#' @param MaxPasswordAge The number of days that an IAM user password is valid.
#' 
#' If you do not specify a value for this parameter, then the operation
#' uses the default value of `0`. The result is that IAM user passwords
#' never expire.
#' @param PasswordReusePrevention Specifies the number of previous passwords that IAM users are prevented
#' from reusing.
#' 
#' If you do not specify a value for this parameter, then the operation
#' uses the default value of `0`. The result is that IAM users are not
#' prevented from reusing previous passwords.
#' @param HardExpiry Prevents IAM users who are accessing the account via the Amazon Web
#' Services Management Console from setting a new console password after
#' their password has expired. The IAM user cannot access the console until
#' an administrator resets the password.
#' 
#' If you do not specify a value for this parameter, then the operation
#' uses the default value of `false`. The result is that IAM users can
#' change their passwords after they expire and continue to sign in as the
#' user.
#' 
#' In the Amazon Web Services Management Console, the custom password
#' policy option **Allow users to change their own password** gives IAM
#' users permissions to `iam:ChangePassword` for only their user and to the
#' `iam:GetAccountPasswordPolicy` action. This option does not attach a
#' permissions policy to each user, rather the permissions are applied at
#' the account-level for all users by IAM. IAM users with
#' `iam:ChangePassword` permission and active access keys can reset their
#' own expired console password using the CLI or API.
#'
#' @keywords internal
#'
#' @rdname iam_update_account_password_policy
iam_update_account_password_policy <- function(MinimumPasswordLength = NULL, RequireSymbols = NULL, RequireNumbers = NULL, RequireUppercaseCharacters = NULL, RequireLowercaseCharacters = NULL, AllowUsersToChangePassword = NULL, MaxPasswordAge = NULL, PasswordReusePrevention = NULL, HardExpiry = NULL) {
  op <- new_operation(
    name = "UpdateAccountPasswordPolicy",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .iam$update_account_password_policy_input(MinimumPasswordLength = MinimumPasswordLength, RequireSymbols = RequireSymbols, RequireNumbers = RequireNumbers, RequireUppercaseCharacters = RequireUppercaseCharacters, RequireLowercaseCharacters = RequireLowercaseCharacters, AllowUsersToChangePassword = AllowUsersToChangePassword, MaxPasswordAge = MaxPasswordAge, PasswordReusePrevention = PasswordReusePrevention, HardExpiry = HardExpiry)
  output <- .iam$update_account_password_policy_output()
  config <- get_config()
  svc <- .iam$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$update_account_password_policy <- iam_update_account_password_policy

#' Updates the policy that grants an IAM entity permission to assume a role
#'
#' @description
#' Updates the policy that grants an IAM entity permission to assume a role. This is typically referred to as the "role trust policy". For more information about roles, see [Using roles to delegate permissions and federate identities](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles.html).
#'
#' See [https://www.paws-r-sdk.com/docs/iam_update_assume_role_policy/](https://www.paws-r-sdk.com/docs/iam_update_assume_role_policy/) for full documentation.
#'
#' @param RoleName &#91;required&#93; The name of the role to update with the new policy.
#' 
#' This parameter allows (through its [regex
#' pattern](https://en.wikipedia.org/wiki/Regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: _+=,.@@-
#' @param PolicyDocument &#91;required&#93; The policy that grants an entity permission to assume the role.
#' 
#' You must provide policies in JSON format in IAM. However, for
#' CloudFormation templates formatted in YAML, you can provide the policy
#' in JSON or YAML format. CloudFormation always converts a YAML policy to
#' JSON format before submitting it to IAM.
#' 
#' The [regex pattern](https://en.wikipedia.org/wiki/Regex) used to
#' validate this parameter is a string of characters consisting of the
#' following:
#' 
#' -   Any printable ASCII character ranging from the space character
#'     (``U+0020``) through the end of the ASCII character range
#' 
#' -   The printable characters in the Basic Latin and Latin-1 Supplement
#'     character set (through ``U+00FF``)
#' 
#' -   The special characters tab (``U+0009``), line feed (``U+000A``), and
#'     carriage return (``U+000D``)
#'
#' @keywords internal
#'
#' @rdname iam_update_assume_role_policy
iam_update_assume_role_policy <- function(RoleName, PolicyDocument) {
  op <- new_operation(
    name = "UpdateAssumeRolePolicy",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .iam$update_assume_role_policy_input(RoleName = RoleName, PolicyDocument = PolicyDocument)
  output <- .iam$update_assume_role_policy_output()
  config <- get_config()
  svc <- .iam$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$update_assume_role_policy <- iam_update_assume_role_policy

#' Updates the name and/or the path of the specified IAM group
#'
#' @description
#' Updates the name and/or the path of the specified IAM group.
#'
#' See [https://www.paws-r-sdk.com/docs/iam_update_group/](https://www.paws-r-sdk.com/docs/iam_update_group/) for full documentation.
#'
#' @param GroupName &#91;required&#93; Name of the IAM group to update. If you're changing the name of the
#' group, this is the original name.
#' 
#' This parameter allows (through its [regex
#' pattern](https://en.wikipedia.org/wiki/Regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: _+=,.@@-
#' @param NewPath New path for the IAM group. Only include this if changing the group's
#' path.
#' 
#' This parameter allows (through its [regex
#' pattern](https://en.wikipedia.org/wiki/Regex)) a string of characters
#' consisting of either a forward slash (/) by itself or a string that must
#' begin and end with forward slashes. In addition, it can contain any
#' ASCII character from the ! (``U+0021``) through the DEL character
#' (``U+007F``), including most punctuation characters, digits, and upper and
#' lowercased letters.
#' @param NewGroupName New name for the IAM group. Only include this if changing the group's
#' name.
#' 
#' IAM user, group, role, and policy names must be unique within the
#' account. Names are not distinguished by case. For example, you cannot
#' create resources named both "MyResource" and "myresource".
#'
#' @keywords internal
#'
#' @rdname iam_update_group
iam_update_group <- function(GroupName, NewPath = NULL, NewGroupName = NULL) {
  op <- new_operation(
    name = "UpdateGroup",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .iam$update_group_input(GroupName = GroupName, NewPath = NewPath, NewGroupName = NewGroupName)
  output <- .iam$update_group_output()
  config <- get_config()
  svc <- .iam$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$update_group <- iam_update_group

#' Changes the password for the specified IAM user
#'
#' @description
#' Changes the password for the specified IAM user. You can use the CLI, the Amazon Web Services API, or the **Users** page in the IAM console to change the password for any IAM user. Use [`change_password`][iam_change_password] to change your own password in the **My Security Credentials** page in the Amazon Web Services Management Console.
#'
#' See [https://www.paws-r-sdk.com/docs/iam_update_login_profile/](https://www.paws-r-sdk.com/docs/iam_update_login_profile/) for full documentation.
#'
#' @param UserName &#91;required&#93; The name of the user whose password you want to update.
#' 
#' This parameter allows (through its [regex
#' pattern](https://en.wikipedia.org/wiki/Regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: _+=,.@@-
#' @param Password The new password for the specified IAM user.
#' 
#' The [regex pattern](https://en.wikipedia.org/wiki/Regex) used to
#' validate this parameter is a string of characters consisting of the
#' following:
#' 
#' -   Any printable ASCII character ranging from the space character
#'     (``U+0020``) through the end of the ASCII character range
#' 
#' -   The printable characters in the Basic Latin and Latin-1 Supplement
#'     character set (through ``U+00FF``)
#' 
#' -   The special characters tab (``U+0009``), line feed (``U+000A``), and
#'     carriage return (``U+000D``)
#' 
#' However, the format can be further restricted by the account
#' administrator by setting a password policy on the Amazon Web Services
#' account. For more information, see
#' [`update_account_password_policy`][iam_update_account_password_policy].
#' @param PasswordResetRequired Allows this new password to be used only once by requiring the specified
#' IAM user to set a new password on next sign-in.
#'
#' @keywords internal
#'
#' @rdname iam_update_login_profile
iam_update_login_profile <- function(UserName, Password = NULL, PasswordResetRequired = NULL) {
  op <- new_operation(
    name = "UpdateLoginProfile",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .iam$update_login_profile_input(UserName = UserName, Password = Password, PasswordResetRequired = PasswordResetRequired)
  output <- .iam$update_login_profile_output()
  config <- get_config()
  svc <- .iam$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$update_login_profile <- iam_update_login_profile

#' Replaces the existing list of server certificate thumbprints associated
#' with an OpenID Connect (OIDC) provider resource object with a new list
#' of thumbprints
#'
#' @description
#' Replaces the existing list of server certificate thumbprints associated with an OpenID Connect (OIDC) provider resource object with a new list of thumbprints.
#'
#' See [https://www.paws-r-sdk.com/docs/iam_update_open_id_connect_provider_thumbprint/](https://www.paws-r-sdk.com/docs/iam_update_open_id_connect_provider_thumbprint/) for full documentation.
#'
#' @param OpenIDConnectProviderArn &#91;required&#93; The Amazon Resource Name (ARN) of the IAM OIDC provider resource object
#' for which you want to update the thumbprint. You can get a list of OIDC
#' provider ARNs by using the
#' [`list_open_id_connect_providers`][iam_list_open_id_connect_providers]
#' operation.
#' 
#' For more information about ARNs, see [Amazon Resource Names
#' (ARNs)](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html)
#' in the *Amazon Web Services General Reference*.
#' @param ThumbprintList &#91;required&#93; A list of certificate thumbprints that are associated with the specified
#' IAM OpenID Connect provider. For more information, see
#' [`create_open_id_connect_provider`][iam_create_open_id_connect_provider].
#'
#' @keywords internal
#'
#' @rdname iam_update_open_id_connect_provider_thumbprint
iam_update_open_id_connect_provider_thumbprint <- function(OpenIDConnectProviderArn, ThumbprintList) {
  op <- new_operation(
    name = "UpdateOpenIDConnectProviderThumbprint",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .iam$update_open_id_connect_provider_thumbprint_input(OpenIDConnectProviderArn = OpenIDConnectProviderArn, ThumbprintList = ThumbprintList)
  output <- .iam$update_open_id_connect_provider_thumbprint_output()
  config <- get_config()
  svc <- .iam$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$update_open_id_connect_provider_thumbprint <- iam_update_open_id_connect_provider_thumbprint

#' Updates the description or maximum session duration setting of a role
#'
#' @description
#' Updates the description or maximum session duration setting of a role.
#'
#' See [https://www.paws-r-sdk.com/docs/iam_update_role/](https://www.paws-r-sdk.com/docs/iam_update_role/) for full documentation.
#'
#' @param RoleName &#91;required&#93; The name of the role that you want to modify.
#' @param Description The new description that you want to apply to the specified role.
#' @param MaxSessionDuration The maximum session duration (in seconds) that you want to set for the
#' specified role. If you do not specify a value for this setting, the
#' default value of one hour is applied. This setting can have a value from
#' 1 hour to 12 hours.
#' 
#' Anyone who assumes the role from the CLI or API can use the
#' `DurationSeconds` API parameter or the `duration-seconds` CLI parameter
#' to request a longer session. The `MaxSessionDuration` setting determines
#' the maximum duration that can be requested using the `DurationSeconds`
#' parameter. If users don't specify a value for the `DurationSeconds`
#' parameter, their security credentials are valid for one hour by default.
#' This applies when you use the `AssumeRole*` API operations or the
#' `assume-role*` CLI operations but does not apply when you use those
#' operations to create a console URL. For more information, see [Using IAM
#' roles](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_manage-assume.html)
#' in the *IAM User Guide*.
#' 
#' IAM role credentials provided by Amazon EC2 instances assigned to the
#' role are not subject to the specified maximum session duration.
#'
#' @keywords internal
#'
#' @rdname iam_update_role
iam_update_role <- function(RoleName, Description = NULL, MaxSessionDuration = NULL) {
  op <- new_operation(
    name = "UpdateRole",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .iam$update_role_input(RoleName = RoleName, Description = Description, MaxSessionDuration = MaxSessionDuration)
  output <- .iam$update_role_output()
  config <- get_config()
  svc <- .iam$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$update_role <- iam_update_role

#' Use UpdateRole instead
#'
#' @description
#' Use [`update_role`][iam_update_role] instead.
#'
#' See [https://www.paws-r-sdk.com/docs/iam_update_role_description/](https://www.paws-r-sdk.com/docs/iam_update_role_description/) for full documentation.
#'
#' @param RoleName &#91;required&#93; The name of the role that you want to modify.
#' @param Description &#91;required&#93; The new description that you want to apply to the specified role.
#'
#' @keywords internal
#'
#' @rdname iam_update_role_description
iam_update_role_description <- function(RoleName, Description) {
  op <- new_operation(
    name = "UpdateRoleDescription",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .iam$update_role_description_input(RoleName = RoleName, Description = Description)
  output <- .iam$update_role_description_output()
  config <- get_config()
  svc <- .iam$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$update_role_description <- iam_update_role_description

#' Updates the metadata document for an existing SAML provider resource
#' object
#'
#' @description
#' Updates the metadata document for an existing SAML provider resource object.
#'
#' See [https://www.paws-r-sdk.com/docs/iam_update_saml_provider/](https://www.paws-r-sdk.com/docs/iam_update_saml_provider/) for full documentation.
#'
#' @param SAMLMetadataDocument &#91;required&#93; An XML document generated by an identity provider (IdP) that supports
#' SAML 2.0. The document includes the issuer's name, expiration
#' information, and keys that can be used to validate the SAML
#' authentication response (assertions) that are received from the IdP. You
#' must generate the metadata document using the identity management
#' software that is used as your organization's IdP.
#' @param SAMLProviderArn &#91;required&#93; The Amazon Resource Name (ARN) of the SAML provider to update.
#' 
#' For more information about ARNs, see [Amazon Resource Names
#' (ARNs)](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html)
#' in the *Amazon Web Services General Reference*.
#'
#' @keywords internal
#'
#' @rdname iam_update_saml_provider
iam_update_saml_provider <- function(SAMLMetadataDocument, SAMLProviderArn) {
  op <- new_operation(
    name = "UpdateSAMLProvider",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .iam$update_saml_provider_input(SAMLMetadataDocument = SAMLMetadataDocument, SAMLProviderArn = SAMLProviderArn)
  output <- .iam$update_saml_provider_output()
  config <- get_config()
  svc <- .iam$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$update_saml_provider <- iam_update_saml_provider

#' Sets the status of an IAM user's SSH public key to active or inactive
#'
#' @description
#' Sets the status of an IAM user's SSH public key to active or inactive. SSH public keys that are inactive cannot be used for authentication. This operation can be used to disable a user's SSH public key as part of a key rotation work flow.
#'
#' See [https://www.paws-r-sdk.com/docs/iam_update_ssh_public_key/](https://www.paws-r-sdk.com/docs/iam_update_ssh_public_key/) for full documentation.
#'
#' @param UserName &#91;required&#93; The name of the IAM user associated with the SSH public key.
#' 
#' This parameter allows (through its [regex
#' pattern](https://en.wikipedia.org/wiki/Regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: _+=,.@@-
#' @param SSHPublicKeyId &#91;required&#93; The unique identifier for the SSH public key.
#' 
#' This parameter allows (through its [regex
#' pattern](https://en.wikipedia.org/wiki/Regex)) a string of characters
#' that can consist of any upper or lowercased letter or digit.
#' @param Status &#91;required&#93; The status to assign to the SSH public key. `Active` means that the key
#' can be used for authentication with an CodeCommit repository. `Inactive`
#' means that the key cannot be used.
#'
#' @keywords internal
#'
#' @rdname iam_update_ssh_public_key
iam_update_ssh_public_key <- function(UserName, SSHPublicKeyId, Status) {
  op <- new_operation(
    name = "UpdateSSHPublicKey",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .iam$update_ssh_public_key_input(UserName = UserName, SSHPublicKeyId = SSHPublicKeyId, Status = Status)
  output <- .iam$update_ssh_public_key_output()
  config <- get_config()
  svc <- .iam$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$update_ssh_public_key <- iam_update_ssh_public_key

#' Updates the name and/or the path of the specified server certificate
#' stored in IAM
#'
#' @description
#' Updates the name and/or the path of the specified server certificate stored in IAM.
#'
#' See [https://www.paws-r-sdk.com/docs/iam_update_server_certificate/](https://www.paws-r-sdk.com/docs/iam_update_server_certificate/) for full documentation.
#'
#' @param ServerCertificateName &#91;required&#93; The name of the server certificate that you want to update.
#' 
#' This parameter allows (through its [regex
#' pattern](https://en.wikipedia.org/wiki/Regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: _+=,.@@-
#' @param NewPath The new path for the server certificate. Include this only if you are
#' updating the server certificate's path.
#' 
#' This parameter allows (through its [regex
#' pattern](https://en.wikipedia.org/wiki/Regex)) a string of characters
#' consisting of either a forward slash (/) by itself or a string that must
#' begin and end with forward slashes. In addition, it can contain any
#' ASCII character from the ! (``U+0021``) through the DEL character
#' (``U+007F``), including most punctuation characters, digits, and upper and
#' lowercased letters.
#' @param NewServerCertificateName The new name for the server certificate. Include this only if you are
#' updating the server certificate's name. The name of the certificate
#' cannot contain any spaces.
#' 
#' This parameter allows (through its [regex
#' pattern](https://en.wikipedia.org/wiki/Regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: _+=,.@@-
#'
#' @keywords internal
#'
#' @rdname iam_update_server_certificate
iam_update_server_certificate <- function(ServerCertificateName, NewPath = NULL, NewServerCertificateName = NULL) {
  op <- new_operation(
    name = "UpdateServerCertificate",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .iam$update_server_certificate_input(ServerCertificateName = ServerCertificateName, NewPath = NewPath, NewServerCertificateName = NewServerCertificateName)
  output <- .iam$update_server_certificate_output()
  config <- get_config()
  svc <- .iam$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$update_server_certificate <- iam_update_server_certificate

#' Sets the status of a service-specific credential to Active or Inactive
#'
#' @description
#' Sets the status of a service-specific credential to `Active` or `Inactive`. Service-specific credentials that are inactive cannot be used for authentication to the service. This operation can be used to disable a user's service-specific credential as part of a credential rotation work flow.
#'
#' See [https://www.paws-r-sdk.com/docs/iam_update_service_specific_credential/](https://www.paws-r-sdk.com/docs/iam_update_service_specific_credential/) for full documentation.
#'
#' @param UserName The name of the IAM user associated with the service-specific
#' credential. If you do not specify this value, then the operation assumes
#' the user whose credentials are used to call the operation.
#' 
#' This parameter allows (through its [regex
#' pattern](https://en.wikipedia.org/wiki/Regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: _+=,.@@-
#' @param ServiceSpecificCredentialId &#91;required&#93; The unique identifier of the service-specific credential.
#' 
#' This parameter allows (through its [regex
#' pattern](https://en.wikipedia.org/wiki/Regex)) a string of characters
#' that can consist of any upper or lowercased letter or digit.
#' @param Status &#91;required&#93; The status to be assigned to the service-specific credential.
#'
#' @keywords internal
#'
#' @rdname iam_update_service_specific_credential
iam_update_service_specific_credential <- function(UserName = NULL, ServiceSpecificCredentialId, Status) {
  op <- new_operation(
    name = "UpdateServiceSpecificCredential",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .iam$update_service_specific_credential_input(UserName = UserName, ServiceSpecificCredentialId = ServiceSpecificCredentialId, Status = Status)
  output <- .iam$update_service_specific_credential_output()
  config <- get_config()
  svc <- .iam$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$update_service_specific_credential <- iam_update_service_specific_credential

#' Changes the status of the specified user signing certificate from active
#' to disabled, or vice versa
#'
#' @description
#' Changes the status of the specified user signing certificate from active to disabled, or vice versa. This operation can be used to disable an IAM user's signing certificate as part of a certificate rotation work flow.
#'
#' See [https://www.paws-r-sdk.com/docs/iam_update_signing_certificate/](https://www.paws-r-sdk.com/docs/iam_update_signing_certificate/) for full documentation.
#'
#' @param UserName The name of the IAM user the signing certificate belongs to.
#' 
#' This parameter allows (through its [regex
#' pattern](https://en.wikipedia.org/wiki/Regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: _+=,.@@-
#' @param CertificateId &#91;required&#93; The ID of the signing certificate you want to update.
#' 
#' This parameter allows (through its [regex
#' pattern](https://en.wikipedia.org/wiki/Regex)) a string of characters
#' that can consist of any upper or lowercased letter or digit.
#' @param Status &#91;required&#93; The status you want to assign to the certificate. `Active` means that
#' the certificate can be used for programmatic calls to Amazon Web
#' Services `Inactive` means that the certificate cannot be used.
#'
#' @keywords internal
#'
#' @rdname iam_update_signing_certificate
iam_update_signing_certificate <- function(UserName = NULL, CertificateId, Status) {
  op <- new_operation(
    name = "UpdateSigningCertificate",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .iam$update_signing_certificate_input(UserName = UserName, CertificateId = CertificateId, Status = Status)
  output <- .iam$update_signing_certificate_output()
  config <- get_config()
  svc <- .iam$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$update_signing_certificate <- iam_update_signing_certificate

#' Updates the name and/or the path of the specified IAM user
#'
#' @description
#' Updates the name and/or the path of the specified IAM user.
#'
#' See [https://www.paws-r-sdk.com/docs/iam_update_user/](https://www.paws-r-sdk.com/docs/iam_update_user/) for full documentation.
#'
#' @param UserName &#91;required&#93; Name of the user to update. If you're changing the name of the user,
#' this is the original user name.
#' 
#' This parameter allows (through its [regex
#' pattern](https://en.wikipedia.org/wiki/Regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: _+=,.@@-
#' @param NewPath New path for the IAM user. Include this parameter only if you're
#' changing the user's path.
#' 
#' This parameter allows (through its [regex
#' pattern](https://en.wikipedia.org/wiki/Regex)) a string of characters
#' consisting of either a forward slash (/) by itself or a string that must
#' begin and end with forward slashes. In addition, it can contain any
#' ASCII character from the ! (``U+0021``) through the DEL character
#' (``U+007F``), including most punctuation characters, digits, and upper and
#' lowercased letters.
#' @param NewUserName New name for the user. Include this parameter only if you're changing
#' the user's name.
#' 
#' IAM user, group, role, and policy names must be unique within the
#' account. Names are not distinguished by case. For example, you cannot
#' create resources named both "MyResource" and "myresource".
#'
#' @keywords internal
#'
#' @rdname iam_update_user
iam_update_user <- function(UserName, NewPath = NULL, NewUserName = NULL) {
  op <- new_operation(
    name = "UpdateUser",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .iam$update_user_input(UserName = UserName, NewPath = NewPath, NewUserName = NewUserName)
  output <- .iam$update_user_output()
  config <- get_config()
  svc <- .iam$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$update_user <- iam_update_user

#' Uploads an SSH public key and associates it with the specified IAM user
#'
#' @description
#' Uploads an SSH public key and associates it with the specified IAM user.
#'
#' See [https://www.paws-r-sdk.com/docs/iam_upload_ssh_public_key/](https://www.paws-r-sdk.com/docs/iam_upload_ssh_public_key/) for full documentation.
#'
#' @param UserName &#91;required&#93; The name of the IAM user to associate the SSH public key with.
#' 
#' This parameter allows (through its [regex
#' pattern](https://en.wikipedia.org/wiki/Regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: _+=,.@@-
#' @param SSHPublicKeyBody &#91;required&#93; The SSH public key. The public key must be encoded in ssh-rsa format or
#' PEM format. The minimum bit-length of the public key is 2048 bits. For
#' example, you can generate a 2048-bit key, and the resulting PEM file is
#' 1679 bytes long.
#' 
#' The [regex pattern](https://en.wikipedia.org/wiki/Regex) used to
#' validate this parameter is a string of characters consisting of the
#' following:
#' 
#' -   Any printable ASCII character ranging from the space character
#'     (``U+0020``) through the end of the ASCII character range
#' 
#' -   The printable characters in the Basic Latin and Latin-1 Supplement
#'     character set (through ``U+00FF``)
#' 
#' -   The special characters tab (``U+0009``), line feed (``U+000A``), and
#'     carriage return (``U+000D``)
#'
#' @keywords internal
#'
#' @rdname iam_upload_ssh_public_key
iam_upload_ssh_public_key <- function(UserName, SSHPublicKeyBody) {
  op <- new_operation(
    name = "UploadSSHPublicKey",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .iam$upload_ssh_public_key_input(UserName = UserName, SSHPublicKeyBody = SSHPublicKeyBody)
  output <- .iam$upload_ssh_public_key_output()
  config <- get_config()
  svc <- .iam$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$upload_ssh_public_key <- iam_upload_ssh_public_key

#' Uploads a server certificate entity for the Amazon Web Services account
#'
#' @description
#' Uploads a server certificate entity for the Amazon Web Services account. The server certificate entity includes a public key certificate, a private key, and an optional certificate chain, which should all be PEM-encoded.
#'
#' See [https://www.paws-r-sdk.com/docs/iam_upload_server_certificate/](https://www.paws-r-sdk.com/docs/iam_upload_server_certificate/) for full documentation.
#'
#' @param Path The path for the server certificate. For more information about paths,
#' see [IAM
#' identifiers](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html)
#' in the *IAM User Guide*.
#' 
#' This parameter is optional. If it is not included, it defaults to a
#' slash (/). This parameter allows (through its [regex
#' pattern](https://en.wikipedia.org/wiki/Regex)) a string of characters
#' consisting of either a forward slash (/) by itself or a string that must
#' begin and end with forward slashes. In addition, it can contain any
#' ASCII character from the ! (``U+0021``) through the DEL character
#' (``U+007F``), including most punctuation characters, digits, and upper and
#' lowercased letters.
#' 
#' If you are uploading a server certificate specifically for use with
#' Amazon CloudFront distributions, you must specify a path using the
#' `path` parameter. The path must begin with `/cloudfront` and must
#' include a trailing slash (for example, `/cloudfront/test/`).
#' @param ServerCertificateName &#91;required&#93; The name for the server certificate. Do not include the path in this
#' value. The name of the certificate cannot contain any spaces.
#' 
#' This parameter allows (through its [regex
#' pattern](https://en.wikipedia.org/wiki/Regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: _+=,.@@-
#' @param CertificateBody &#91;required&#93; The contents of the public key certificate in PEM-encoded format.
#' 
#' The [regex pattern](https://en.wikipedia.org/wiki/Regex) used to
#' validate this parameter is a string of characters consisting of the
#' following:
#' 
#' -   Any printable ASCII character ranging from the space character
#'     (``U+0020``) through the end of the ASCII character range
#' 
#' -   The printable characters in the Basic Latin and Latin-1 Supplement
#'     character set (through ``U+00FF``)
#' 
#' -   The special characters tab (``U+0009``), line feed (``U+000A``), and
#'     carriage return (``U+000D``)
#' @param PrivateKey &#91;required&#93; The contents of the private key in PEM-encoded format.
#' 
#' The [regex pattern](https://en.wikipedia.org/wiki/Regex) used to
#' validate this parameter is a string of characters consisting of the
#' following:
#' 
#' -   Any printable ASCII character ranging from the space character
#'     (``U+0020``) through the end of the ASCII character range
#' 
#' -   The printable characters in the Basic Latin and Latin-1 Supplement
#'     character set (through ``U+00FF``)
#' 
#' -   The special characters tab (``U+0009``), line feed (``U+000A``), and
#'     carriage return (``U+000D``)
#' @param CertificateChain The contents of the certificate chain. This is typically a concatenation
#' of the PEM-encoded public key certificates of the chain.
#' 
#' The [regex pattern](https://en.wikipedia.org/wiki/Regex) used to
#' validate this parameter is a string of characters consisting of the
#' following:
#' 
#' -   Any printable ASCII character ranging from the space character
#'     (``U+0020``) through the end of the ASCII character range
#' 
#' -   The printable characters in the Basic Latin and Latin-1 Supplement
#'     character set (through ``U+00FF``)
#' 
#' -   The special characters tab (``U+0009``), line feed (``U+000A``), and
#'     carriage return (``U+000D``)
#' @param Tags A list of tags that you want to attach to the new IAM server certificate
#' resource. Each tag consists of a key name and an associated value. For
#' more information about tagging, see [Tagging IAM
#' resources](https://docs.aws.amazon.com/IAM/latest/UserGuide/id_tags.html)
#' in the *IAM User Guide*.
#' 
#' If any one of the tags is invalid or if you exceed the allowed maximum
#' number of tags, then the entire request fails and the resource is not
#' created.
#'
#' @keywords internal
#'
#' @rdname iam_upload_server_certificate
iam_upload_server_certificate <- function(Path = NULL, ServerCertificateName, CertificateBody, PrivateKey, CertificateChain = NULL, Tags = NULL) {
  op <- new_operation(
    name = "UploadServerCertificate",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .iam$upload_server_certificate_input(Path = Path, ServerCertificateName = ServerCertificateName, CertificateBody = CertificateBody, PrivateKey = PrivateKey, CertificateChain = CertificateChain, Tags = Tags)
  output <- .iam$upload_server_certificate_output()
  config <- get_config()
  svc <- .iam$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$upload_server_certificate <- iam_upload_server_certificate

#' Uploads an X
#'
#' @description
#' Uploads an X.509 signing certificate and associates it with the specified IAM user. Some Amazon Web Services services require you to use certificates to validate requests that are signed with a corresponding private key. When you upload the certificate, its default status is `Active`.
#'
#' See [https://www.paws-r-sdk.com/docs/iam_upload_signing_certificate/](https://www.paws-r-sdk.com/docs/iam_upload_signing_certificate/) for full documentation.
#'
#' @param UserName The name of the user the signing certificate is for.
#' 
#' This parameter allows (through its [regex
#' pattern](https://en.wikipedia.org/wiki/Regex)) a string of characters
#' consisting of upper and lowercase alphanumeric characters with no
#' spaces. You can also include any of the following characters: _+=,.@@-
#' @param CertificateBody &#91;required&#93; The contents of the signing certificate.
#' 
#' The [regex pattern](https://en.wikipedia.org/wiki/Regex) used to
#' validate this parameter is a string of characters consisting of the
#' following:
#' 
#' -   Any printable ASCII character ranging from the space character
#'     (``U+0020``) through the end of the ASCII character range
#' 
#' -   The printable characters in the Basic Latin and Latin-1 Supplement
#'     character set (through ``U+00FF``)
#' 
#' -   The special characters tab (``U+0009``), line feed (``U+000A``), and
#'     carriage return (``U+000D``)
#'
#' @keywords internal
#'
#' @rdname iam_upload_signing_certificate
iam_upload_signing_certificate <- function(UserName = NULL, CertificateBody) {
  op <- new_operation(
    name = "UploadSigningCertificate",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .iam$upload_signing_certificate_input(UserName = UserName, CertificateBody = CertificateBody)
  output <- .iam$upload_signing_certificate_output()
  config <- get_config()
  svc <- .iam$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iam$operations$upload_signing_certificate <- iam_upload_signing_certificate
