% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accessanalyzer_operations.R
\name{accessanalyzer_check_access_not_granted}
\alias{accessanalyzer_check_access_not_granted}
\title{Checks whether the specified access isn't allowed by a policy}
\usage{
accessanalyzer_check_access_not_granted(policyDocument, access, policyType)
}
\arguments{
\item{policyDocument}{[required] The JSON policy document to use as the content for the policy.}

\item{access}{[required] An access object containing the permissions that shouldn't be granted by
the specified policy. If only actions are specified, IAM Access Analyzer
checks for access of the actions on all resources in the policy. If only
resources are specified, then IAM Access Analyzer checks which actions
have access to the specified resources. If both actions and resources
are specified, then IAM Access Analyzer checks which of the specified
actions have access to the specified resources.}

\item{policyType}{[required] The type of policy. Identity policies grant permissions to IAM
principals. Identity policies include managed and inline policies for
IAM roles, users, and groups.

Resource policies grant permissions on Amazon Web Services resources.
Resource policies include trust policies for IAM roles and bucket
policies for Amazon S3 buckets. You can provide a generic input such as
identity policy or resource policy or a specific input such as managed
policy or Amazon S3 bucket policy.}
}
\description{
Checks whether the specified access isn't allowed by a policy.

See \url{https://www.paws-r-sdk.com/docs/accessanalyzer_check_access_not_granted/} for full documentation.
}
\keyword{internal}
