% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kms_service.R
\name{kms}
\alias{kms}
\title{AWS Key Management Service}
\usage{
kms(config = list())
}
\arguments{
\item{config}{Optional configuration of credentials, endpoint, and/or region.
\itemize{
\item{\strong{access_key_id}:} {AWS access key ID}
\item{\strong{secret_access_key}:} {AWS secret access key}
\item{\strong{session_token}:} {AWS temporary session token}
\item{\strong{profile}:} {The name of a profile to use. If not given, then the default profile is used.}
\item{\strong{anonymous}:} {Set anonymous credentials.}
\item{\strong{endpoint}:} {The complete URL to use for the constructed client.}
\item{\strong{region}:} {The AWS Region used in instantiating the client.}
\item{\strong{close_connection}:} {Immediately close all HTTP connections.}
\item{\strong{timeout}:} {The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
\item{\strong{s3_force_path_style}:} {Set this to \code{true} to force the request to use path-style addressing, i.e., \verb{http://s3.amazonaws.com/BUCKET/KEY}.}
}}
}
\value{
A client for the service. You can call the service's operations using
syntax like \code{svc$operation(...)}, where \code{svc} is the name you've assigned
to the client. The available operations are listed in the
Operations section.
}
\description{
Key Management Service

Key Management Service (KMS) is an encryption and key management web
service. This guide describes the KMS operations that you can call
programmatically. For general information about KMS, see the \href{https://docs.aws.amazon.com/kms/latest/developerguide/}{\emph{Key Management Service Developer Guide}} .

KMS has replaced the term \emph{customer master key (CMK)} with \emph{KMS key} and
\emph{KMS key}. The concept has not changed. To prevent breaking changes, KMS
is keeping some variations of this term.

Amazon Web Services provides SDKs that consist of libraries and sample
code for various programming languages and platforms (Java, Ruby, .Net,
macOS, Android, etc.). The SDKs provide a convenient way to create
programmatic access to KMS and other Amazon Web Services services. For
example, the SDKs take care of tasks such as signing requests (see
below), managing errors, and retrying requests automatically. For more
information about the Amazon Web Services SDKs, including how to
download and install them, see \href{https://aws.amazon.com/developer/tools/}{Tools for Amazon Web Services}.

We recommend that you use the Amazon Web Services SDKs to make
programmatic API calls to KMS.

If you need to use FIPS 140-2 validated cryptographic modules when
communicating with Amazon Web Services, use the FIPS endpoint in your
preferred Amazon Web Services Region. For more information about the
available FIPS endpoints, see \href{https://docs.aws.amazon.com/general/latest/gr/kms.html#kms_region}{Service endpoints}
in the Key Management Service topic of the \emph{Amazon Web Services General
Reference}.

All KMS API calls must be signed and be transmitted using Transport
Layer Security (TLS). KMS recommends you always use the latest supported
TLS version. Clients must also support cipher suites with Perfect
Forward Secrecy (PFS) such as Ephemeral Diffie-Hellman (DHE) or Elliptic
Curve Ephemeral Diffie-Hellman (ECDHE). Most modern systems such as Java
7 and later support these modes.

\strong{Signing Requests}

Requests must be signed using an access key ID and a secret access key.
We strongly recommend that you do not use your Amazon Web Services
account root access key ID and secret access key for everyday work. You
can use the access key ID and secret access key for an IAM user or you
can use the Security Token Service (STS) to generate temporary security
credentials and use those to sign requests.

All KMS requests must be signed with \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html}{Signature Version 4}.

\strong{Logging API Requests}

KMS supports CloudTrail, a service that logs Amazon Web Services API
calls and related events for your Amazon Web Services account and
delivers them to an Amazon S3 bucket that you specify. By using the
information collected by CloudTrail, you can determine what requests
were made to KMS, who made the request, when it was made, and so on. To
learn more about CloudTrail, including how to turn it on and find your
log files, see the \href{https://docs.aws.amazon.com/awscloudtrail/latest/userguide/}{CloudTrail User Guide}.

\strong{Additional Resources}

For more information about credentials and request signing, see the
following:
\itemize{
\item \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/security-creds.html}{Amazon Web Services Security Credentials} -
This topic provides general information about the types of
credentials used to access Amazon Web Services.
\item \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp.html}{Temporary Security Credentials} -
This section of the \emph{IAM User Guide} describes how to create and use
temporary security credentials.
\item \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_aws-signing.html}{Signature Version 4 Signing Process} -
This set of topics walks you through the process of signing a
request using an access key ID and a secret access key.
}

\strong{Commonly Used API Operations}

Of the API operations discussed in this guide, the following will prove
the most useful for most applications. You will likely perform
operations other than these, such as creating keys and assigning
policies, by using the console.
\itemize{
\item \code{\link[=kms_encrypt]{encrypt}}
\item \code{\link[=kms_decrypt]{decrypt}}
\item \code{\link[=kms_generate_data_key]{generate_data_key}}
\item \code{\link[=kms_generate_data_key_without_plaintext]{generate_data_key_without_plaintext}}
}
}
\section{Service syntax}{


\if{html}{\out{<div class="sourceCode">}}\preformatted{svc <- kms(
  config = list(
    credentials = list(
      creds = list(
        access_key_id = "string",
        secret_access_key = "string",
        session_token = "string"
      ),
      profile = "string",
      anonymous = "logical"
    ),
    endpoint = "string",
    region = "string",
    close_connection = "logical",
    timeout = "numeric",
    s3_force_path_style = "logical"
  )
)
}\if{html}{\out{</div>}}
}

\section{Operations}{

\tabular{ll}{
\link[=kms_cancel_key_deletion]{cancel_key_deletion} \tab Cancels the deletion of a KMS key\cr
\link[=kms_connect_custom_key_store]{connect_custom_key_store} \tab Connects or reconnects a custom key store to its backing key store\cr
\link[=kms_create_alias]{create_alias} \tab Creates a friendly name for a KMS key\cr
\link[=kms_create_custom_key_store]{create_custom_key_store} \tab Creates a custom key store backed by a key store that you own and manage\cr
\link[=kms_create_grant]{create_grant} \tab Adds a grant to a KMS key\cr
\link[=kms_create_key]{create_key} \tab Creates a unique customer managed KMS key in your Amazon Web Services account and Region\cr
\link[=kms_decrypt]{decrypt} \tab Decrypts ciphertext that was encrypted by a KMS key using any of the following operations:\cr
\link[=kms_delete_alias]{delete_alias} \tab Deletes the specified alias\cr
\link[=kms_delete_custom_key_store]{delete_custom_key_store} \tab Deletes a custom key store\cr
\link[=kms_delete_imported_key_material]{delete_imported_key_material} \tab Deletes key material that was previously imported\cr
\link[=kms_describe_custom_key_stores]{describe_custom_key_stores} \tab Gets information about custom key stores in the account and Region\cr
\link[=kms_describe_key]{describe_key} \tab Provides detailed information about a KMS key\cr
\link[=kms_disable_key]{disable_key} \tab Sets the state of a KMS key to disabled\cr
\link[=kms_disable_key_rotation]{disable_key_rotation} \tab Disables automatic rotation of the key material of the specified symmetric encryption KMS key\cr
\link[=kms_disconnect_custom_key_store]{disconnect_custom_key_store} \tab Disconnects the custom key store from its backing key store\cr
\link[=kms_enable_key]{enable_key} \tab Sets the key state of a KMS key to enabled\cr
\link[=kms_enable_key_rotation]{enable_key_rotation} \tab Enables automatic rotation of the key material of the specified symmetric encryption KMS key\cr
\link[=kms_encrypt]{encrypt} \tab Encrypts plaintext of up to 4,096 bytes using a KMS key\cr
\link[=kms_generate_data_key]{generate_data_key} \tab Returns a unique symmetric data key for use outside of KMS\cr
\link[=kms_generate_data_key_pair]{generate_data_key_pair} \tab Returns a unique asymmetric data key pair for use outside of KMS\cr
\link[=kms_generate_data_key_pair_without_plaintext]{generate_data_key_pair_without_plaintext} \tab Returns a unique asymmetric data key pair for use outside of KMS\cr
\link[=kms_generate_data_key_without_plaintext]{generate_data_key_without_plaintext} \tab Returns a unique symmetric data key for use outside of KMS\cr
\link[=kms_generate_mac]{generate_mac} \tab Generates a hash-based message authentication code (HMAC) for a message using an HMAC KMS key and a MAC algorithm that the key supports\cr
\link[=kms_generate_random]{generate_random} \tab Returns a random byte string that is cryptographically secure\cr
\link[=kms_get_key_policy]{get_key_policy} \tab Gets a key policy attached to the specified KMS key\cr
\link[=kms_get_key_rotation_status]{get_key_rotation_status} \tab Gets a Boolean value that indicates whether automatic rotation of the key material is enabled for the specified KMS key\cr
\link[=kms_get_parameters_for_import]{get_parameters_for_import} \tab Returns the public key and an import token you need to import or reimport key material for a KMS key\cr
\link[=kms_get_public_key]{get_public_key} \tab Returns the public key of an asymmetric KMS key\cr
\link[=kms_import_key_material]{import_key_material} \tab Imports or reimports key material into an existing KMS key that was created without key material\cr
\link[=kms_list_aliases]{list_aliases} \tab Gets a list of aliases in the caller's Amazon Web Services account and region\cr
\link[=kms_list_grants]{list_grants} \tab Gets a list of all grants for the specified KMS key\cr
\link[=kms_list_key_policies]{list_key_policies} \tab Gets the names of the key policies that are attached to a KMS key\cr
\link[=kms_list_keys]{list_keys} \tab Gets a list of all KMS keys in the caller's Amazon Web Services account and Region\cr
\link[=kms_list_resource_tags]{list_resource_tags} \tab Returns all tags on the specified KMS key\cr
\link[=kms_list_retirable_grants]{list_retirable_grants} \tab Returns information about all grants in the Amazon Web Services account and Region that have the specified retiring principal\cr
\link[=kms_put_key_policy]{put_key_policy} \tab Attaches a key policy to the specified KMS key\cr
\link[=kms_re_encrypt]{re_encrypt} \tab Decrypts ciphertext and then reencrypts it entirely within KMS\cr
\link[=kms_replicate_key]{replicate_key} \tab Replicates a multi-Region key into the specified Region\cr
\link[=kms_retire_grant]{retire_grant} \tab Deletes a grant\cr
\link[=kms_revoke_grant]{revoke_grant} \tab Deletes the specified grant\cr
\link[=kms_schedule_key_deletion]{schedule_key_deletion} \tab Schedules the deletion of a KMS key\cr
\link[=kms_sign]{sign} \tab Creates a digital signature for a message or message digest by using the private key in an asymmetric signing KMS key\cr
\link[=kms_tag_resource]{tag_resource} \tab Adds or edits tags on a customer managed key\cr
\link[=kms_untag_resource]{untag_resource} \tab Deletes tags from a customer managed key\cr
\link[=kms_update_alias]{update_alias} \tab Associates an existing KMS alias with a different KMS key\cr
\link[=kms_update_custom_key_store]{update_custom_key_store} \tab Changes the properties of a custom key store\cr
\link[=kms_update_key_description]{update_key_description} \tab Updates the description of a KMS key\cr
\link[=kms_update_primary_region]{update_primary_region} \tab Changes the primary key of a multi-Region key\cr
\link[=kms_verify]{verify} \tab Verifies a digital signature that was generated by the Sign operation\cr
\link[=kms_verify_mac]{verify_mac} \tab Verifies the hash-based message authentication code (HMAC) for a specified message, HMAC KMS key, and MAC algorithm
}
}

\examples{
\dontrun{
svc <- kms()
# The following example cancels deletion of the specified KMS key.
svc$cancel_key_deletion(
  KeyId = "1234abcd-12ab-34cd-56ef-1234567890ab"
)
}

}
