% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wafv2_operations.R
\name{wafv2_get_sampled_requests}
\alias{wafv2_get_sampled_requests}
\title{Gets detailed information about a specified number of requests--a
sample--that WAF randomly selects from among the first 5,000 requests
that your Amazon Web Services resource received during a time range that
you choose}
\usage{
wafv2_get_sampled_requests(
  WebAclArn,
  RuleMetricName,
  Scope,
  TimeWindow,
  MaxItems
)
}
\arguments{
\item{WebAclArn}{[required] The Amazon resource name (ARN) of the \code{WebACL} for which you want a
sample of requests.}

\item{RuleMetricName}{[required] The metric name assigned to the \code{Rule} or \code{RuleGroup} for which you want
a sample of requests.}

\item{Scope}{[required] Specifies whether this is for an Amazon CloudFront distribution or for a
regional application. A regional application can be an Application Load
Balancer (ALB), an Amazon API Gateway REST API, an AppSync GraphQL API,
or an Amazon Cognito user pool.

To work with CloudFront, you must also specify the Region US East (N.
Virginia) as follows:
\itemize{
\item CLI - Specify the Region when you use the CloudFront scope:
\code{--scope=CLOUDFRONT --region=us-east-1}.
\item API and SDKs - For all calls, use the Region endpoint us-east-1.
}}

\item{TimeWindow}{[required] The start date and time and the end date and time of the range for which
you want \code{\link[=wafv2_get_sampled_requests]{get_sampled_requests}} to return
a sample of requests. You must specify the times in Coordinated
Universal Time (UTC) format. UTC format includes the special designator,
\code{Z}. For example, \code{"2016-09-27T14:50Z"}. You can specify any time range
in the previous three hours. If you specify a start time that's earlier
than three hours ago, WAF sets it to three hours ago.}

\item{MaxItems}{[required] The number of requests that you want WAF to return from among the first
5,000 requests that your Amazon Web Services resource received during
the time range. If your resource received fewer requests than the value
of \code{MaxItems}, \code{\link[=wafv2_get_sampled_requests]{get_sampled_requests}}
returns information about all of them.}
}
\description{
Gets detailed information about a specified number of requests--a sample--that WAF randomly selects from among the first 5,000 requests that your Amazon Web Services resource received during a time range that you choose. You can specify a sample size of up to 500 requests, and you can specify any time range in the previous three hours.

See \url{https://paws-r.github.io/docs/wafv2/get_sampled_requests.html} for full documentation.
}
\keyword{internal}
