% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kms_operations.R
\name{kms_update_primary_region}
\alias{kms_update_primary_region}
\title{Changes the primary key of a multi-Region key}
\usage{
kms_update_primary_region(KeyId, PrimaryRegion)
}
\arguments{
\item{KeyId}{[required] Identifies the current primary key. When the operation completes, this
KMS key will be a replica key.

Specify the key ID or key ARN of a multi-Region primary key.

For example:
\itemize{
\item Key ID: \verb{mrk-1234abcd12ab34cd56ef1234567890ab}
\item Key ARN:
\verb{arn:aws:kms:us-east-2:111122223333:key/mrk-1234abcd12ab34cd56ef1234567890ab}
}

To get the key ID and key ARN for a KMS key, use
\code{\link[=kms_list_keys]{list_keys}} or \code{\link[=kms_describe_key]{describe_key}}.}

\item{PrimaryRegion}{[required] The Amazon Web Services Region of the new primary key. Enter the Region
ID, such as \code{us-east-1} or \code{ap-southeast-2}. There must be an existing
replica key in this Region.

When the operation completes, the multi-Region key in this Region will
be the primary key.}
}
\description{
Changes the primary key of a multi-Region key.

See \url{https://paws-r.github.io/docs/kms/update_primary_region.html} for full documentation.
}
\keyword{internal}
