% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/secretsmanager_operations.R
\name{secretsmanager_cancel_rotate_secret}
\alias{secretsmanager_cancel_rotate_secret}
\title{Disables automatic scheduled rotation and cancels the rotation of a
secret if one is currently in progress}
\usage{
secretsmanager_cancel_rotate_secret(SecretId)
}
\arguments{
\item{SecretId}{[required] Specifies the secret for which you want to cancel a rotation request.
You can specify either the Amazon Resource Name (ARN) or the friendly
name of the secret.

If you specify an ARN, we generally recommend that you specify a
complete ARN. You can specify a partial ARN too---for example, if you
don't include the final hyphen and six random characters that Secrets
Manager adds at the end of the ARN when you created the secret. A
partial ARN match can work as long as it uniquely matches only one
secret. However, if your secret has a name that ends in a hyphen
followed by six characters (before Secrets Manager adds the hyphen and
six characters to the ARN) and you try to use that as a partial ARN,
then those characters cause Secrets Manager to assume that you're
specifying a complete ARN. This confusion can cause unexpected results.
To avoid this situation, we recommend that you don't create secret names
that end with a hyphen followed by six characters.}
}
\description{
Disables automatic scheduled rotation and cancels the rotation of a
secret if one is currently in progress.
}
\details{
To re-enable scheduled rotation, call RotateSecret with
\code{AutomaticallyRotateAfterDays} set to a value greater than 0. This will
immediately rotate your secret and then enable the automatic schedule.

If you cancel a rotation that is in progress, it can leave the
\code{VersionStage} labels in an unexpected state. Depending on what step of
the rotation was in progress, you might need to remove the staging label
\code{AWSPENDING} from the partially created version, specified by the
\code{VersionId} response value. You should also evaluate the partially
rotated new version to see if it should be deleted, which you can do by
removing all staging labels from the new version's \code{VersionStage}
field.

To successfully start a rotation, the staging label \code{AWSPENDING} must be
in one of the following states:
\itemize{
\item Not be attached to any version at all
\item Attached to the same version as the staging label \code{AWSCURRENT}
}

If the staging label \code{AWSPENDING} is attached to a different version
than the version with \code{AWSCURRENT} then the attempt to rotate fails.

\strong{Minimum permissions}

To run this command, you must have the following permissions:
\itemize{
\item secretsmanager:CancelRotateSecret
}

\strong{Related operations}
\itemize{
\item To configure rotation for a secret or to manually trigger a
rotation, use RotateSecret.
\item To get the rotation configuration details for a secret, use
DescribeSecret.
\item To list all of the currently available secrets, use ListSecrets.
\item To list all of the versions currently associated with a secret, use
ListSecretVersionIds.
}
}
\section{Request syntax}{
\preformatted{svc$cancel_rotate_secret(
  SecretId = "string"
)
}
}

\examples{
# The following example shows how to cancel rotation for a secret. The
# operation sets the RotationEnabled field to false and cancels all
# scheduled rotations. To resume scheduled rotations, you must re-enable
# rotation by calling the rotate-secret operation.
\donttest{svc$cancel_rotate_secret(
  SecretId = "MyTestDatabaseSecret"
)}

}
\keyword{internal}
