# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_operation new_request send_request
#' @include acmpca_service.R
NULL

#' Creates a root or subordinate private certificate authority (CA)
#'
#' Creates a root or subordinate private certificate authority (CA). You
#' must specify the CA configuration, the certificate revocation list (CRL)
#' configuration, the CA type, and an optional idempotency token to avoid
#' accidental creation of multiple CAs. The CA configuration specifies the
#' name of the algorithm and key size to be used to create the CA private
#' key, the type of signing algorithm that the CA uses, and X.500 subject
#' information. The CRL configuration specifies the CRL expiration period
#' in days (the validity period of the CRL), the Amazon S3 bucket that will
#' contain the CRL, and a CNAME alias for the S3 bucket that is included in
#' certificates issued by the CA. If successful, this action returns the
#' Amazon Resource Name (ARN) of the CA.
#'
#' @usage
#' acmpca_create_certificate_authority(CertificateAuthorityConfiguration,
#'   RevocationConfiguration, CertificateAuthorityType, IdempotencyToken,
#'   Tags)
#'
#' @param CertificateAuthorityConfiguration &#91;required&#93; Name and bit size of the private key algorithm, the name of the signing
#' algorithm, and X.500 certificate subject information.
#' @param RevocationConfiguration Contains a Boolean value that you can use to enable a certification
#' revocation list (CRL) for the CA, the name of the S3 bucket to which ACM
#' Private CA will write the CRL, and an optional CNAME alias that you can
#' use to hide the name of your bucket in the **CRL Distribution Points**
#' extension of your CA certificate. For more information, see the
#' CrlConfiguration structure.
#' @param CertificateAuthorityType &#91;required&#93; The type of the certificate authority.
#' @param IdempotencyToken Alphanumeric string that can be used to distinguish between calls to
#' **CreateCertificateAuthority**. Idempotency tokens time out after five
#' minutes. Therefore, if you call **CreateCertificateAuthority** multiple
#' times with the same idempotency token within a five minute period, ACM
#' Private CA recognizes that you are requesting only one certificate. As a
#' result, ACM Private CA issues only one. If you change the idempotency
#' token for each call, however, ACM Private CA recognizes that you are
#' requesting multiple certificates.
#' @param Tags Key-value pairs that will be attached to the new private CA. You can
#' associate up to 50 tags with a private CA. For information using tags
#' with
#' 
#' IAM to manage permissions, see [Controlling Access Using IAM
#' Tags](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_iam-tags.html).
#'
#' @section Request syntax:
#' ```
#' svc$create_certificate_authority(
#'   CertificateAuthorityConfiguration = list(
#'     KeyAlgorithm = "RSA_2048"|"RSA_4096"|"EC_prime256v1"|"EC_secp384r1",
#'     SigningAlgorithm = "SHA256WITHECDSA"|"SHA384WITHECDSA"|"SHA512WITHECDSA"|"SHA256WITHRSA"|"SHA384WITHRSA"|"SHA512WITHRSA",
#'     Subject = list(
#'       Country = "string",
#'       Organization = "string",
#'       OrganizationalUnit = "string",
#'       DistinguishedNameQualifier = "string",
#'       State = "string",
#'       CommonName = "string",
#'       SerialNumber = "string",
#'       Locality = "string",
#'       Title = "string",
#'       Surname = "string",
#'       GivenName = "string",
#'       Initials = "string",
#'       Pseudonym = "string",
#'       GenerationQualifier = "string"
#'     )
#'   ),
#'   RevocationConfiguration = list(
#'     CrlConfiguration = list(
#'       Enabled = TRUE|FALSE,
#'       ExpirationInDays = 123,
#'       CustomCname = "string",
#'       S3BucketName = "string"
#'     )
#'   ),
#'   CertificateAuthorityType = "ROOT"|"SUBORDINATE",
#'   IdempotencyToken = "string",
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname acmpca_create_certificate_authority
acmpca_create_certificate_authority <- function(CertificateAuthorityConfiguration, RevocationConfiguration = NULL, CertificateAuthorityType, IdempotencyToken = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateCertificateAuthority",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .acmpca$create_certificate_authority_input(CertificateAuthorityConfiguration = CertificateAuthorityConfiguration, RevocationConfiguration = RevocationConfiguration, CertificateAuthorityType = CertificateAuthorityType, IdempotencyToken = IdempotencyToken, Tags = Tags)
  output <- .acmpca$create_certificate_authority_output()
  svc <- .acmpca$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.acmpca$operations$create_certificate_authority <- acmpca_create_certificate_authority

#' Creates an audit report that lists every time that your CA private key
#' is used
#'
#' Creates an audit report that lists every time that your CA private key
#' is used. The report is saved in the Amazon S3 bucket that you specify on
#' input. The IssueCertificate and RevokeCertificate actions use the
#' private key.
#'
#' @usage
#' acmpca_create_certificate_authority_audit_report(
#'   CertificateAuthorityArn, S3BucketName, AuditReportResponseFormat)
#'
#' @param CertificateAuthorityArn &#91;required&#93; The Amazon Resource Name (ARN) of the CA to be audited. This is of the
#' form:
#' 
#' `arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> `.
#' @param S3BucketName &#91;required&#93; The name of the S3 bucket that will contain the audit report.
#' @param AuditReportResponseFormat &#91;required&#93; The format in which to create the report. This can be either **JSON** or
#' **CSV**.
#'
#' @section Request syntax:
#' ```
#' svc$create_certificate_authority_audit_report(
#'   CertificateAuthorityArn = "string",
#'   S3BucketName = "string",
#'   AuditReportResponseFormat = "JSON"|"CSV"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname acmpca_create_certificate_authority_audit_report
acmpca_create_certificate_authority_audit_report <- function(CertificateAuthorityArn, S3BucketName, AuditReportResponseFormat) {
  op <- new_operation(
    name = "CreateCertificateAuthorityAuditReport",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .acmpca$create_certificate_authority_audit_report_input(CertificateAuthorityArn = CertificateAuthorityArn, S3BucketName = S3BucketName, AuditReportResponseFormat = AuditReportResponseFormat)
  output <- .acmpca$create_certificate_authority_audit_report_output()
  svc <- .acmpca$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.acmpca$operations$create_certificate_authority_audit_report <- acmpca_create_certificate_authority_audit_report

#' Assigns permissions from a private CA to a designated AWS service
#'
#' Assigns permissions from a private CA to a designated AWS service.
#' Services are specified by their service principals and can be given
#' permission to create and retrieve certificates on a private CA. Services
#' can also be given permission to list the active permissions that the
#' private CA has granted. For ACM to automatically renew your private
#' CA\'s certificates, you must assign all possible permissions from the CA
#' to the ACM service principal.
#' 
#' At this time, you can only assign permissions to ACM
#' (`acm.amazonaws.com`). Permissions can be revoked with the
#' DeletePermission action and listed with the ListPermissions action.
#'
#' @usage
#' acmpca_create_permission(CertificateAuthorityArn, Principal,
#'   SourceAccount, Actions)
#'
#' @param CertificateAuthorityArn &#91;required&#93; The Amazon Resource Name (ARN) of the CA that grants the permissions.
#' You can find the ARN by calling the ListCertificateAuthorities action.
#' This must have the following form:
#' 
#' `arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> `.
#' @param Principal &#91;required&#93; The AWS service or identity that receives the permission. At this time,
#' the only valid principal is `acm.amazonaws.com`.
#' @param SourceAccount The ID of the calling account.
#' @param Actions &#91;required&#93; The actions that the specified AWS service principal can use. These
#' include `IssueCertificate`, `GetCertificate`, and `ListPermissions`.
#'
#' @section Request syntax:
#' ```
#' svc$create_permission(
#'   CertificateAuthorityArn = "string",
#'   Principal = "string",
#'   SourceAccount = "string",
#'   Actions = list(
#'     "IssueCertificate"|"GetCertificate"|"ListPermissions"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname acmpca_create_permission
acmpca_create_permission <- function(CertificateAuthorityArn, Principal, SourceAccount = NULL, Actions) {
  op <- new_operation(
    name = "CreatePermission",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .acmpca$create_permission_input(CertificateAuthorityArn = CertificateAuthorityArn, Principal = Principal, SourceAccount = SourceAccount, Actions = Actions)
  output <- .acmpca$create_permission_output()
  svc <- .acmpca$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.acmpca$operations$create_permission <- acmpca_create_permission

#' Deletes a private certificate authority (CA)
#'
#' Deletes a private certificate authority (CA). You must provide the
#' Amazon Resource Name (ARN) of the private CA that you want to delete.
#' You can find the ARN by calling the ListCertificateAuthorities action.
#' 
#' Deleting a CA will invalidate other CAs and certificates below it in
#' your CA hierarchy.
#' 
#' Before you can delete a CA that you have created and activated, you must
#' disable it. To do this, call the UpdateCertificateAuthority action and
#' set the **CertificateAuthorityStatus** parameter to `DISABLED`.
#' 
#' Additionally, you can delete a CA if you are waiting for it to be
#' created (that is, the status of the CA is `CREATING`). You can also
#' delete it if the CA has been created but you haven\'t yet imported the
#' signed certificate into ACM Private CA (that is, the status of the CA is
#' `PENDING_CERTIFICATE`).
#' 
#' When you successfully call DeleteCertificateAuthority, the CA\'s status
#' changes to `DELETED`. However, the CA won\'t be permanently deleted
#' until the restoration period has passed. By default, if you do not set
#' the `PermanentDeletionTimeInDays` parameter, the CA remains restorable
#' for 30 days. You can set the parameter from 7 to 30 days. The
#' DescribeCertificateAuthority action returns the time remaining in the
#' restoration window of a private CA in the `DELETED` state. To restore an
#' eligible CA, call the RestoreCertificateAuthority action.
#'
#' @usage
#' acmpca_delete_certificate_authority(CertificateAuthorityArn,
#'   PermanentDeletionTimeInDays)
#'
#' @param CertificateAuthorityArn &#91;required&#93; The Amazon Resource Name (ARN) that was returned when you called
#' CreateCertificateAuthority. This must have the following form:
#' 
#' `arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> `.
#' @param PermanentDeletionTimeInDays The number of days to make a CA restorable after it has been deleted.
#' This can be anywhere from 7 to 30 days, with 30 being the default.
#'
#' @section Request syntax:
#' ```
#' svc$delete_certificate_authority(
#'   CertificateAuthorityArn = "string",
#'   PermanentDeletionTimeInDays = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname acmpca_delete_certificate_authority
acmpca_delete_certificate_authority <- function(CertificateAuthorityArn, PermanentDeletionTimeInDays = NULL) {
  op <- new_operation(
    name = "DeleteCertificateAuthority",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .acmpca$delete_certificate_authority_input(CertificateAuthorityArn = CertificateAuthorityArn, PermanentDeletionTimeInDays = PermanentDeletionTimeInDays)
  output <- .acmpca$delete_certificate_authority_output()
  svc <- .acmpca$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.acmpca$operations$delete_certificate_authority <- acmpca_delete_certificate_authority

#' Revokes permissions that a private CA assigned to a designated AWS
#' service
#'
#' Revokes permissions that a private CA assigned to a designated AWS
#' service. Permissions can be created with the CreatePermission action and
#' listed with the ListPermissions action.
#'
#' @usage
#' acmpca_delete_permission(CertificateAuthorityArn, Principal,
#'   SourceAccount)
#'
#' @param CertificateAuthorityArn &#91;required&#93; The Amazon Resource Number (ARN) of the private CA that issued the
#' permissions. You can find the CA\'s ARN by calling the
#' ListCertificateAuthorities action. This must have the following form:
#' 
#' `arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> `.
#' @param Principal &#91;required&#93; The AWS service or identity that will have its CA permissions revoked.
#' At this time, the only valid service principal is `acm.amazonaws.com`
#' @param SourceAccount The AWS account that calls this action.
#'
#' @section Request syntax:
#' ```
#' svc$delete_permission(
#'   CertificateAuthorityArn = "string",
#'   Principal = "string",
#'   SourceAccount = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname acmpca_delete_permission
acmpca_delete_permission <- function(CertificateAuthorityArn, Principal, SourceAccount = NULL) {
  op <- new_operation(
    name = "DeletePermission",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .acmpca$delete_permission_input(CertificateAuthorityArn = CertificateAuthorityArn, Principal = Principal, SourceAccount = SourceAccount)
  output <- .acmpca$delete_permission_output()
  svc <- .acmpca$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.acmpca$operations$delete_permission <- acmpca_delete_permission

#' Lists information about your private certificate authority (CA)
#'
#' Lists information about your private certificate authority (CA). You
#' specify the private CA on input by its ARN (Amazon Resource Name). The
#' output contains the status of your CA. This can be any of the following:
#' 
#' -   `CREATING` - ACM Private CA is creating your private certificate
#'     authority.
#' 
#' -   `PENDING_CERTIFICATE` - The certificate is pending. You must use
#'     your ACM Private CA-hosted or on-premises root or subordinate CA to
#'     sign your private CA CSR and then import it into PCA.
#' 
#' -   `ACTIVE` - Your private CA is active.
#' 
#' -   `DISABLED` - Your private CA has been disabled.
#' 
#' -   `EXPIRED` - Your private CA certificate has expired.
#' 
#' -   `FAILED` - Your private CA has failed. Your CA can fail because of
#'     problems such a network outage or backend AWS failure or other
#'     errors. A failed CA can never return to the pending state. You must
#'     create a new CA.
#' 
#' -   `DELETED` - Your private CA is within the restoration period, after
#'     which it is permanently deleted. The length of time remaining in the
#'     CA\'s restoration period is also included in this action\'s output.
#'
#' @usage
#' acmpca_describe_certificate_authority(CertificateAuthorityArn)
#'
#' @param CertificateAuthorityArn &#91;required&#93; The Amazon Resource Name (ARN) that was returned when you called
#' CreateCertificateAuthority. This must be of the form:
#' 
#' `arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> `.
#'
#' @section Request syntax:
#' ```
#' svc$describe_certificate_authority(
#'   CertificateAuthorityArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname acmpca_describe_certificate_authority
acmpca_describe_certificate_authority <- function(CertificateAuthorityArn) {
  op <- new_operation(
    name = "DescribeCertificateAuthority",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .acmpca$describe_certificate_authority_input(CertificateAuthorityArn = CertificateAuthorityArn)
  output <- .acmpca$describe_certificate_authority_output()
  svc <- .acmpca$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.acmpca$operations$describe_certificate_authority <- acmpca_describe_certificate_authority

#' Lists information about a specific audit report created by calling the
#' CreateCertificateAuthorityAuditReport action
#'
#' Lists information about a specific audit report created by calling the
#' CreateCertificateAuthorityAuditReport action. Audit information is
#' created every time the certificate authority (CA) private key is used.
#' The private key is used when you call the IssueCertificate action or the
#' RevokeCertificate action.
#'
#' @usage
#' acmpca_describe_certificate_authority_audit_report(
#'   CertificateAuthorityArn, AuditReportId)
#'
#' @param CertificateAuthorityArn &#91;required&#93; The Amazon Resource Name (ARN) of the private CA. This must be of the
#' form:
#' 
#' `arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> `.
#' @param AuditReportId &#91;required&#93; The report ID returned by calling the
#' CreateCertificateAuthorityAuditReport action.
#'
#' @section Request syntax:
#' ```
#' svc$describe_certificate_authority_audit_report(
#'   CertificateAuthorityArn = "string",
#'   AuditReportId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname acmpca_describe_certificate_authority_audit_report
acmpca_describe_certificate_authority_audit_report <- function(CertificateAuthorityArn, AuditReportId) {
  op <- new_operation(
    name = "DescribeCertificateAuthorityAuditReport",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .acmpca$describe_certificate_authority_audit_report_input(CertificateAuthorityArn = CertificateAuthorityArn, AuditReportId = AuditReportId)
  output <- .acmpca$describe_certificate_authority_audit_report_output()
  svc <- .acmpca$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.acmpca$operations$describe_certificate_authority_audit_report <- acmpca_describe_certificate_authority_audit_report

#' Retrieves a certificate from your private CA
#'
#' Retrieves a certificate from your private CA. The ARN of the certificate
#' is returned when you call the IssueCertificate action. You must specify
#' both the ARN of your private CA and the ARN of the issued certificate
#' when calling the **GetCertificate** action. You can retrieve the
#' certificate if it is in the **ISSUED** state. You can call the
#' CreateCertificateAuthorityAuditReport action to create a report that
#' contains information about all of the certificates issued and revoked by
#' your private CA.
#'
#' @usage
#' acmpca_get_certificate(CertificateAuthorityArn, CertificateArn)
#'
#' @param CertificateAuthorityArn &#91;required&#93; The Amazon Resource Name (ARN) that was returned when you called
#' CreateCertificateAuthority. This must be of the form:
#' 
#' `arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> `.
#' @param CertificateArn &#91;required&#93; The ARN of the issued certificate. The ARN contains the certificate
#' serial number and must be in the following form:
#' 
#' `arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i>/certificate/<i>286535153982981100925020015808220737245</i> `
#'
#' @section Request syntax:
#' ```
#' svc$get_certificate(
#'   CertificateAuthorityArn = "string",
#'   CertificateArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname acmpca_get_certificate
acmpca_get_certificate <- function(CertificateAuthorityArn, CertificateArn) {
  op <- new_operation(
    name = "GetCertificate",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .acmpca$get_certificate_input(CertificateAuthorityArn = CertificateAuthorityArn, CertificateArn = CertificateArn)
  output <- .acmpca$get_certificate_output()
  svc <- .acmpca$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.acmpca$operations$get_certificate <- acmpca_get_certificate

#' Retrieves the certificate and certificate chain for your private
#' certificate authority (CA)
#'
#' Retrieves the certificate and certificate chain for your private
#' certificate authority (CA). Both the certificate and the chain are
#' base64 PEM-encoded. The chain does not include the CA certificate. Each
#' certificate in the chain signs the one before it.
#'
#' @usage
#' acmpca_get_certificate_authority_certificate(CertificateAuthorityArn)
#'
#' @param CertificateAuthorityArn &#91;required&#93; The Amazon Resource Name (ARN) of your private CA. This is of the form:
#' 
#' `arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> `.
#'
#' @section Request syntax:
#' ```
#' svc$get_certificate_authority_certificate(
#'   CertificateAuthorityArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname acmpca_get_certificate_authority_certificate
acmpca_get_certificate_authority_certificate <- function(CertificateAuthorityArn) {
  op <- new_operation(
    name = "GetCertificateAuthorityCertificate",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .acmpca$get_certificate_authority_certificate_input(CertificateAuthorityArn = CertificateAuthorityArn)
  output <- .acmpca$get_certificate_authority_certificate_output()
  svc <- .acmpca$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.acmpca$operations$get_certificate_authority_certificate <- acmpca_get_certificate_authority_certificate

#' Retrieves the certificate signing request (CSR) for your private
#' certificate authority (CA)
#'
#' Retrieves the certificate signing request (CSR) for your private
#' certificate authority (CA). The CSR is created when you call the
#' CreateCertificateAuthority action. Sign the CSR with your ACM Private
#' CA-hosted or on-premises root or subordinate CA. Then import the signed
#' certificate back into ACM Private CA by calling the
#' ImportCertificateAuthorityCertificate action. The CSR is returned as a
#' base64 PEM-encoded string.
#'
#' @usage
#' acmpca_get_certificate_authority_csr(CertificateAuthorityArn)
#'
#' @param CertificateAuthorityArn &#91;required&#93; The Amazon Resource Name (ARN) that was returned when you called the
#' CreateCertificateAuthority action. This must be of the form:
#' 
#' `arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> `
#'
#' @section Request syntax:
#' ```
#' svc$get_certificate_authority_csr(
#'   CertificateAuthorityArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname acmpca_get_certificate_authority_csr
acmpca_get_certificate_authority_csr <- function(CertificateAuthorityArn) {
  op <- new_operation(
    name = "GetCertificateAuthorityCsr",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .acmpca$get_certificate_authority_csr_input(CertificateAuthorityArn = CertificateAuthorityArn)
  output <- .acmpca$get_certificate_authority_csr_output()
  svc <- .acmpca$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.acmpca$operations$get_certificate_authority_csr <- acmpca_get_certificate_authority_csr

#' Imports a signed private CA certificate into ACM Private CA
#'
#' Imports a signed private CA certificate into ACM Private CA. This action
#' is used when you are using a chain of trust whose root is located
#' outside ACM Private CA. Before you can call this action, the following
#' preparations must in place:
#' 
#' 1.  In ACM Private CA, call the CreateCertificateAuthority action to
#'     create the private CA that that you plan to back with the imported
#'     certificate.
#' 
#' 2.  Call the GetCertificateAuthorityCsr action to generate a certificate
#'     signing request (CSR).
#' 
#' 3.  Sign the CSR using a root or intermediate CA hosted either by an
#'     on-premises PKI hierarchy or a commercial CA..
#' 
#' 4.  Create a certificate chain and copy the signed certificate and the
#'     certificate chain to your working directory.
#' 
#' The following requirements apply when you import a CA certificate.
#' 
#' -   You cannot import a non-self-signed certificate for use as a root
#'     CA.
#' 
#' -   You cannot import a self-signed certificate for use as a subordinate
#'     CA.
#' 
#' -   Your certificate chain must not include the private CA certificate
#'     that you are importing.
#' 
#' -   Your ACM Private CA-hosted or on-premises CA certificate must be the
#'     last certificate in your chain. The subordinate certificate, if any,
#'     that your root CA signed must be next to last. The subordinate
#'     certificate signed by the preceding subordinate CA must come next,
#'     and so on until your chain is built.
#' 
#' -   The chain must be PEM-encoded.
#'
#' @usage
#' acmpca_import_certificate_authority_certificate(CertificateAuthorityArn,
#'   Certificate, CertificateChain)
#'
#' @param CertificateAuthorityArn &#91;required&#93; The Amazon Resource Name (ARN) that was returned when you called
#' CreateCertificateAuthority. This must be of the form:
#' 
#' `arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> `
#' @param Certificate &#91;required&#93; The PEM-encoded certificate for a private CA. This may be a self-signed
#' certificate in the case of a root CA, or it may be signed by another CA
#' that you control.
#' @param CertificateChain A PEM-encoded file that contains all of your certificates, other than
#' the certificate you\'re importing, chaining up to your root CA. Your ACM
#' Private CA-hosted or on-premises root certificate is the last in the
#' chain, and each certificate in the chain signs the one preceding.
#' 
#' This parameter must be supplied when you import a subordinate CA. When
#' you import a root CA, there is no chain.
#'
#' @section Request syntax:
#' ```
#' svc$import_certificate_authority_certificate(
#'   CertificateAuthorityArn = "string",
#'   Certificate = raw,
#'   CertificateChain = raw
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname acmpca_import_certificate_authority_certificate
acmpca_import_certificate_authority_certificate <- function(CertificateAuthorityArn, Certificate, CertificateChain = NULL) {
  op <- new_operation(
    name = "ImportCertificateAuthorityCertificate",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .acmpca$import_certificate_authority_certificate_input(CertificateAuthorityArn = CertificateAuthorityArn, Certificate = Certificate, CertificateChain = CertificateChain)
  output <- .acmpca$import_certificate_authority_certificate_output()
  svc <- .acmpca$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.acmpca$operations$import_certificate_authority_certificate <- acmpca_import_certificate_authority_certificate

#' Uses your private certificate authority (CA) to issue a client
#' certificate
#'
#' Uses your private certificate authority (CA) to issue a client
#' certificate. This action returns the Amazon Resource Name (ARN) of the
#' certificate. You can retrieve the certificate by calling the
#' GetCertificate action and specifying the ARN.
#' 
#' You cannot use the ACM **ListCertificateAuthorities** action to retrieve
#' the ARNs of the certificates that you issue by using ACM Private CA.
#'
#' @usage
#' acmpca_issue_certificate(CertificateAuthorityArn, Csr, SigningAlgorithm,
#'   TemplateArn, Validity, IdempotencyToken)
#'
#' @param CertificateAuthorityArn &#91;required&#93; The Amazon Resource Name (ARN) that was returned when you called
#' CreateCertificateAuthority. This must be of the form:
#' 
#' `arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> `
#' @param Csr &#91;required&#93; The certificate signing request (CSR) for the certificate you want to
#' issue. You can use the following OpenSSL command to create the CSR and a
#' 2048 bit RSA private key.
#' 
#' `openssl req -new -newkey rsa:2048 -days 365 -keyout private/test_cert_priv_key.pem -out csr/test_cert_.csr`
#' 
#' If you have a configuration file, you can use the following OpenSSL
#' command. The `usr_cert` block in the configuration file contains your
#' X509 version 3 extensions.
#' 
#' `openssl req -new -config openssl_rsa.cnf -extensions usr_cert -newkey rsa:2048 -days -365 -keyout private/test_cert_priv_key.pem -out csr/test_cert_.csr`
#' @param SigningAlgorithm &#91;required&#93; The name of the algorithm that will be used to sign the certificate to
#' be issued.
#' @param TemplateArn Specifies a custom configuration template to use when issuing a
#' certificate. If this parameter is not provided, ACM Private CA defaults
#' to the `EndEntityCertificate/V1` template.
#' 
#' The following service-owned `TemplateArn` values are supported by ACM
#' Private CA:
#' 
#' -   arn:aws:acm-pca:::template/EndEntityCertificate/V1
#' 
#' -   arn:aws:acm-pca:::template/SubordinateCACertificate\\_PathLen0/V1
#' 
#' -   arn:aws:acm-pca:::template/SubordinateCACertificate\\_PathLen1/V1
#' 
#' -   arn:aws:acm-pca:::template/SubordinateCACertificate\\_PathLen2/V1
#' 
#' -   arn:aws:acm-pca:::template/SubordinateCACertificate\\_PathLen3/V1
#' 
#' -   arn:aws:acm-pca:::template/RootCACertificate/V1
#' 
#' For more information, see [Using
#' Templates](https://docs.aws.amazon.com/acm-pca/latest/userguide/UsingTemplates.html).
#' @param Validity &#91;required&#93; The type of the validity period.
#' @param IdempotencyToken Custom string that can be used to distinguish between calls to the
#' **IssueCertificate** action. Idempotency tokens time out after one hour.
#' Therefore, if you call **IssueCertificate** multiple times with the same
#' idempotency token within 5 minutes, ACM Private CA recognizes that you
#' are requesting only one certificate and will issue only one. If you
#' change the idempotency token for each call, PCA recognizes that you are
#' requesting multiple certificates.
#'
#' @section Request syntax:
#' ```
#' svc$issue_certificate(
#'   CertificateAuthorityArn = "string",
#'   Csr = raw,
#'   SigningAlgorithm = "SHA256WITHECDSA"|"SHA384WITHECDSA"|"SHA512WITHECDSA"|"SHA256WITHRSA"|"SHA384WITHRSA"|"SHA512WITHRSA",
#'   TemplateArn = "string",
#'   Validity = list(
#'     Value = 123,
#'     Type = "END_DATE"|"ABSOLUTE"|"DAYS"|"MONTHS"|"YEARS"
#'   ),
#'   IdempotencyToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname acmpca_issue_certificate
acmpca_issue_certificate <- function(CertificateAuthorityArn, Csr, SigningAlgorithm, TemplateArn = NULL, Validity, IdempotencyToken = NULL) {
  op <- new_operation(
    name = "IssueCertificate",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .acmpca$issue_certificate_input(CertificateAuthorityArn = CertificateAuthorityArn, Csr = Csr, SigningAlgorithm = SigningAlgorithm, TemplateArn = TemplateArn, Validity = Validity, IdempotencyToken = IdempotencyToken)
  output <- .acmpca$issue_certificate_output()
  svc <- .acmpca$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.acmpca$operations$issue_certificate <- acmpca_issue_certificate

#' Lists the private certificate authorities that you created by using the
#' CreateCertificateAuthority action
#'
#' Lists the private certificate authorities that you created by using the
#' CreateCertificateAuthority action.
#'
#' @usage
#' acmpca_list_certificate_authorities(NextToken, MaxResults)
#'
#' @param NextToken Use this parameter when paginating results in a subsequent request after
#' you receive a response with truncated results. Set it to the value of
#' the `NextToken` parameter from the response you just received.
#' @param MaxResults Use this parameter when paginating results to specify the maximum number
#' of items to return in the response on each page. If additional items
#' exist beyond the number you specify, the `NextToken` element is sent in
#' the response. Use this `NextToken` value in a subsequent request to
#' retrieve additional items.
#'
#' @section Request syntax:
#' ```
#' svc$list_certificate_authorities(
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname acmpca_list_certificate_authorities
acmpca_list_certificate_authorities <- function(NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListCertificateAuthorities",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .acmpca$list_certificate_authorities_input(NextToken = NextToken, MaxResults = MaxResults)
  output <- .acmpca$list_certificate_authorities_output()
  svc <- .acmpca$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.acmpca$operations$list_certificate_authorities <- acmpca_list_certificate_authorities

#' Lists all the permissions, if any, that have been assigned by a private
#' CA
#'
#' Lists all the permissions, if any, that have been assigned by a private
#' CA. Permissions can be granted with the CreatePermission action and
#' revoked with the DeletePermission action.
#'
#' @usage
#' acmpca_list_permissions(CertificateAuthorityArn, NextToken, MaxResults)
#'
#' @param CertificateAuthorityArn &#91;required&#93; The Amazon Resource Number (ARN) of the private CA to inspect. You can
#' find the ARN by calling the ListCertificateAuthorities action. This must
#' be of the form:
#' `arn:aws:acm-pca:region:account:certificate-authority/12345678-1234-1234-1234-123456789012`
#' You can get a private CA\'s ARN by running the
#' ListCertificateAuthorities action.
#' @param NextToken When paginating results, use this parameter in a subsequent request
#' after you receive a response with truncated results. Set it to the value
#' of **NextToken** from the response you just received.
#' @param MaxResults When paginating results, use this parameter to specify the maximum
#' number of items to return in the response. If additional items exist
#' beyond the number you specify, the **NextToken** element is sent in the
#' response. Use this **NextToken** value in a subsequent request to
#' retrieve additional items.
#'
#' @section Request syntax:
#' ```
#' svc$list_permissions(
#'   CertificateAuthorityArn = "string",
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname acmpca_list_permissions
acmpca_list_permissions <- function(CertificateAuthorityArn, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListPermissions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .acmpca$list_permissions_input(CertificateAuthorityArn = CertificateAuthorityArn, NextToken = NextToken, MaxResults = MaxResults)
  output <- .acmpca$list_permissions_output()
  svc <- .acmpca$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.acmpca$operations$list_permissions <- acmpca_list_permissions

#' Lists the tags, if any, that are associated with your private CA
#'
#' Lists the tags, if any, that are associated with your private CA. Tags
#' are labels that you can use to identify and organize your CAs. Each tag
#' consists of a key and an optional value. Call the
#' TagCertificateAuthority action to add one or more tags to your CA. Call
#' the UntagCertificateAuthority action to remove tags.
#'
#' @usage
#' acmpca_list_tags(CertificateAuthorityArn, NextToken, MaxResults)
#'
#' @param CertificateAuthorityArn &#91;required&#93; The Amazon Resource Name (ARN) that was returned when you called the
#' CreateCertificateAuthority action. This must be of the form:
#' 
#' `arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> `
#' @param NextToken Use this parameter when paginating results in a subsequent request after
#' you receive a response with truncated results. Set it to the value of
#' **NextToken** from the response you just received.
#' @param MaxResults Use this parameter when paginating results to specify the maximum number
#' of items to return in the response. If additional items exist beyond the
#' number you specify, the **NextToken** element is sent in the response.
#' Use this **NextToken** value in a subsequent request to retrieve
#' additional items.
#'
#' @section Request syntax:
#' ```
#' svc$list_tags(
#'   CertificateAuthorityArn = "string",
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname acmpca_list_tags
acmpca_list_tags <- function(CertificateAuthorityArn, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListTags",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .acmpca$list_tags_input(CertificateAuthorityArn = CertificateAuthorityArn, NextToken = NextToken, MaxResults = MaxResults)
  output <- .acmpca$list_tags_output()
  svc <- .acmpca$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.acmpca$operations$list_tags <- acmpca_list_tags

#' Restores a certificate authority (CA) that is in the DELETED state
#'
#' Restores a certificate authority (CA) that is in the `DELETED` state.
#' You can restore a CA during the period that you defined in the
#' **PermanentDeletionTimeInDays** parameter of the
#' DeleteCertificateAuthority action. Currently, you can specify 7 to 30
#' days. If you did not specify a **PermanentDeletionTimeInDays** value, by
#' default you can restore the CA at any time in a 30 day period. You can
#' check the time remaining in the restoration period of a private CA in
#' the `DELETED` state by calling the DescribeCertificateAuthority or
#' ListCertificateAuthorities actions. The status of a restored CA is set
#' to its pre-deletion status when the **RestoreCertificateAuthority**
#' action returns. To change its status to `ACTIVE`, call the
#' UpdateCertificateAuthority action. If the private CA was in the
#' `PENDING_CERTIFICATE` state at deletion, you must use the
#' ImportCertificateAuthorityCertificate action to import a certificate
#' authority into the private CA before it can be activated. You cannot
#' restore a CA after the restoration period has ended.
#'
#' @usage
#' acmpca_restore_certificate_authority(CertificateAuthorityArn)
#'
#' @param CertificateAuthorityArn &#91;required&#93; The Amazon Resource Name (ARN) that was returned when you called the
#' CreateCertificateAuthority action. This must be of the form:
#' 
#' `arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> `
#'
#' @section Request syntax:
#' ```
#' svc$restore_certificate_authority(
#'   CertificateAuthorityArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname acmpca_restore_certificate_authority
acmpca_restore_certificate_authority <- function(CertificateAuthorityArn) {
  op <- new_operation(
    name = "RestoreCertificateAuthority",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .acmpca$restore_certificate_authority_input(CertificateAuthorityArn = CertificateAuthorityArn)
  output <- .acmpca$restore_certificate_authority_output()
  svc <- .acmpca$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.acmpca$operations$restore_certificate_authority <- acmpca_restore_certificate_authority

#' Revokes a certificate that was issued inside ACM Private CA
#'
#' Revokes a certificate that was issued inside ACM Private CA. If you
#' enable a certificate revocation list (CRL) when you create or update
#' your private CA, information about the revoked certificates will be
#' included in the CRL. ACM Private CA writes the CRL to an S3 bucket that
#' you specify. For more information about revocation, see the
#' CrlConfiguration structure. ACM Private CA also writes revocation
#' information to the audit report. For more information, see
#' CreateCertificateAuthorityAuditReport.
#' 
#' You cannot revoke a root CA self-signed certificate.
#'
#' @usage
#' acmpca_revoke_certificate(CertificateAuthorityArn, CertificateSerial,
#'   RevocationReason)
#'
#' @param CertificateAuthorityArn &#91;required&#93; Amazon Resource Name (ARN) of the private CA that issued the certificate
#' to be revoked. This must be of the form:
#' 
#' `arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> `
#' @param CertificateSerial &#91;required&#93; Serial number of the certificate to be revoked. This must be in
#' hexadecimal format. You can retrieve the serial number by calling
#' GetCertificate with the Amazon Resource Name (ARN) of the certificate
#' you want and the ARN of your private CA. The **GetCertificate** action
#' retrieves the certificate in the PEM format. You can use the following
#' OpenSSL command to list the certificate in text format and copy the
#' hexadecimal serial number.
#' 
#' `openssl x509 -in <i>file_path</i> -text -noout`
#' 
#' You can also copy the serial number from the console or use the
#' [DescribeCertificate](https://docs.aws.amazon.com/acm/latest/APIReference/API_DescribeCertificate.html)
#' action in the *AWS Certificate Manager API Reference*.
#' @param RevocationReason &#91;required&#93; Specifies why you revoked the certificate.
#'
#' @section Request syntax:
#' ```
#' svc$revoke_certificate(
#'   CertificateAuthorityArn = "string",
#'   CertificateSerial = "string",
#'   RevocationReason = "UNSPECIFIED"|"KEY_COMPROMISE"|"CERTIFICATE_AUTHORITY_COMPROMISE"|"AFFILIATION_CHANGED"|"SUPERSEDED"|"CESSATION_OF_OPERATION"|"PRIVILEGE_WITHDRAWN"|"A_A_COMPROMISE"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname acmpca_revoke_certificate
acmpca_revoke_certificate <- function(CertificateAuthorityArn, CertificateSerial, RevocationReason) {
  op <- new_operation(
    name = "RevokeCertificate",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .acmpca$revoke_certificate_input(CertificateAuthorityArn = CertificateAuthorityArn, CertificateSerial = CertificateSerial, RevocationReason = RevocationReason)
  output <- .acmpca$revoke_certificate_output()
  svc <- .acmpca$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.acmpca$operations$revoke_certificate <- acmpca_revoke_certificate

#' Adds one or more tags to your private CA
#'
#' Adds one or more tags to your private CA. Tags are labels that you can
#' use to identify and organize your AWS resources. Each tag consists of a
#' key and an optional value. You specify the private CA on input by its
#' Amazon Resource Name (ARN). You specify the tag by using a key-value
#' pair. You can apply a tag to just one private CA if you want to identify
#' a specific characteristic of that CA, or you can apply the same tag to
#' multiple private CAs if you want to filter for a common relationship
#' among those CAs. To remove one or more tags, use the
#' UntagCertificateAuthority action. Call the ListTags action to see what
#' tags are associated with your CA.
#'
#' @usage
#' acmpca_tag_certificate_authority(CertificateAuthorityArn, Tags)
#'
#' @param CertificateAuthorityArn &#91;required&#93; The Amazon Resource Name (ARN) that was returned when you called
#' CreateCertificateAuthority. This must be of the form:
#' 
#' `arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> `
#' @param Tags &#91;required&#93; List of tags to be associated with the CA.
#'
#' @section Request syntax:
#' ```
#' svc$tag_certificate_authority(
#'   CertificateAuthorityArn = "string",
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname acmpca_tag_certificate_authority
acmpca_tag_certificate_authority <- function(CertificateAuthorityArn, Tags) {
  op <- new_operation(
    name = "TagCertificateAuthority",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .acmpca$tag_certificate_authority_input(CertificateAuthorityArn = CertificateAuthorityArn, Tags = Tags)
  output <- .acmpca$tag_certificate_authority_output()
  svc <- .acmpca$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.acmpca$operations$tag_certificate_authority <- acmpca_tag_certificate_authority

#' Remove one or more tags from your private CA
#'
#' Remove one or more tags from your private CA. A tag consists of a
#' key-value pair. If you do not specify the value portion of the tag when
#' calling this action, the tag will be removed regardless of value. If you
#' specify a value, the tag is removed only if it is associated with the
#' specified value. To add tags to a private CA, use the
#' TagCertificateAuthority. Call the ListTags action to see what tags are
#' associated with your CA.
#'
#' @usage
#' acmpca_untag_certificate_authority(CertificateAuthorityArn, Tags)
#'
#' @param CertificateAuthorityArn &#91;required&#93; The Amazon Resource Name (ARN) that was returned when you called
#' CreateCertificateAuthority. This must be of the form:
#' 
#' `arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> `
#' @param Tags &#91;required&#93; List of tags to be removed from the CA.
#'
#' @section Request syntax:
#' ```
#' svc$untag_certificate_authority(
#'   CertificateAuthorityArn = "string",
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname acmpca_untag_certificate_authority
acmpca_untag_certificate_authority <- function(CertificateAuthorityArn, Tags) {
  op <- new_operation(
    name = "UntagCertificateAuthority",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .acmpca$untag_certificate_authority_input(CertificateAuthorityArn = CertificateAuthorityArn, Tags = Tags)
  output <- .acmpca$untag_certificate_authority_output()
  svc <- .acmpca$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.acmpca$operations$untag_certificate_authority <- acmpca_untag_certificate_authority

#' Updates the status or configuration of a private certificate authority
#' (CA)
#'
#' Updates the status or configuration of a private certificate authority
#' (CA). Your private CA must be in the `ACTIVE` or `DISABLED` state before
#' you can update it. You can disable a private CA that is in the `ACTIVE`
#' state or make a CA that is in the `DISABLED` state active again.
#'
#' @usage
#' acmpca_update_certificate_authority(CertificateAuthorityArn,
#'   RevocationConfiguration, Status)
#'
#' @param CertificateAuthorityArn &#91;required&#93; Amazon Resource Name (ARN) of the private CA that issued the certificate
#' to be revoked. This must be of the form:
#' 
#' `arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> `
#' @param RevocationConfiguration Revocation information for your private CA.
#' @param Status Status of your private CA.
#'
#' @section Request syntax:
#' ```
#' svc$update_certificate_authority(
#'   CertificateAuthorityArn = "string",
#'   RevocationConfiguration = list(
#'     CrlConfiguration = list(
#'       Enabled = TRUE|FALSE,
#'       ExpirationInDays = 123,
#'       CustomCname = "string",
#'       S3BucketName = "string"
#'     )
#'   ),
#'   Status = "CREATING"|"PENDING_CERTIFICATE"|"ACTIVE"|"DELETED"|"DISABLED"|"EXPIRED"|"FAILED"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname acmpca_update_certificate_authority
acmpca_update_certificate_authority <- function(CertificateAuthorityArn, RevocationConfiguration = NULL, Status = NULL) {
  op <- new_operation(
    name = "UpdateCertificateAuthority",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .acmpca$update_certificate_authority_input(CertificateAuthorityArn = CertificateAuthorityArn, RevocationConfiguration = RevocationConfiguration, Status = Status)
  output <- .acmpca$update_certificate_authority_output()
  svc <- .acmpca$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.acmpca$operations$update_certificate_authority <- acmpca_update_certificate_authority
