% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kms_operations.R
\name{kms_delete_alias}
\alias{kms_delete_alias}
\title{Deletes the specified alias}
\usage{
kms_delete_alias(AliasName)
}
\arguments{
\item{AliasName}{[required] The alias to be deleted. The alias name must begin with \verb{alias/}
followed by the alias name, such as \code{alias/ExampleAlias}.}
}
\value{
An empty list.
}
\description{
Deletes the specified alias.

Because an alias is not a property of a CMK, you can delete and change
the aliases of a CMK without affecting the CMK. Also, aliases do not
appear in the response from the \code{\link[=kms_describe_key]{describe_key}}
operation. To get the aliases of all CMKs, use the
\code{\link[=kms_list_aliases]{list_aliases}} operation.

Each CMK can have multiple aliases. To change the alias of a CMK, use
\code{\link[=kms_delete_alias]{delete_alias}} to delete the current alias and
\code{\link[=kms_create_alias]{create_alias}} to create a new alias. To associate
an existing alias with a different customer master key (CMK), call
\code{\link[=kms_update_alias]{update_alias}}.

\strong{Cross-account use}: No. You cannot perform this operation on an alias
in a different AWS account.

\strong{Required permissions}
\itemize{
\item \href{https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html}{kms:DeleteAlias}
on the alias (IAM policy).
\item \href{https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html}{kms:DeleteAlias}
on the CMK (key policy).
}

For details, see \href{https://docs.aws.amazon.com/kms/latest/developerguide/kms-alias.html#alias-access}{Controlling access to aliases}
in the \emph{AWS Key Management Service Developer Guide}.

\strong{Related operations:}
\itemize{
\item \code{\link[=kms_create_alias]{create_alias}}
\item \code{\link[=kms_list_aliases]{list_aliases}}
\item \code{\link[=kms_update_alias]{update_alias}}
}
}
\section{Request syntax}{
\preformatted{svc$delete_alias(
  AliasName = "string"
)
}
}

\examples{
\dontrun{
# The following example deletes the specified alias.
svc$delete_alias(
  AliasName = "alias/ExampleAlias"
)
}

}
\keyword{internal}
